#!/bin/bash
#
# Copyright (c) 2011 Ericsson AB.
# All rights reserved.
#
# FILE : /etc/cdr-filecopyd.sh for all x86_64-VMs in SSR Simulation
#
# This script will be part of init.conf file for demon/programs to start
# at boot-up time.
#
# The argument $1 expected for this script, which can be RPSW or SSC-S
#
ARGCOUNT=$#
ARG1=$1

ssc_copy_file_to_xcrp_process () {
    RETRY_DELAY=30
    SOURCE_DIR=/ram0/done/
    DEST_DIR=127.3.254.1::SSC
    FILE2COPY=.file-2-copy
    RSYNC_COMMAND="rsync -apuogtxrvz --files-from=$SOURCE_DIR/$FILE2COPY $SOURCE_DIR $DEST_DIR"


    # Function to remove the list of files from file-2-copy{
    #
    ssc_remove_copied_files () {
        while read RM_FILE; do
              rm $SOURCE_DIR$RM_FILE 2>&1
        done < $SOURCE_DIR/$FILE2COPY

        rm -f $SOURCE_DIR/$FILE2COPY 2>&1
    }
    #
    # Main program
    #
    while [ "1" ]
    do
       # Check the directory is empty or not
       #
       if [ "$(ls -A "$SOURCE_DIR")" ]; then
           #
           # Change the group owner to cdr for now. More group will be added 
           # as and when needed
           #
           chmod 660 $SOURCE_DIR/* 2>&1
           #
           # Collect the list of files to be copied
           # and run rsync
           #
           ls  $SOURCE_DIR > $SOURCE_DIR/$FILE2COPY 2>&1

           chmod 777 $SOURCE_DIR/$FILE2COPY
           while read CHGRP_FILE; do
                 chgrp 10002 $SOURCE_DIR$CHGRP_FILE 2>&1
           done < $SOURCE_DIR/$FILE2COPY
           $RSYNC_COMMAND 2>&1
           if [ "$?" -eq "0" ]; then
               #
               # rsync is succuess, Now remove the files
               #
               ssc_remove_copied_files
           else
               # rsync failed, Remove the file and let it retry
               #
               rm -f $SOURCE_DIR/$FILE2COPY 2>&1
           fi
       fi
       sleep $RETRY_DELAY
    done
    echo " "
# End
}

main() {

    case $ARG1 in
         "RPSW")
             # This part will be run only on RP
  
             # SSC CPG directory where created by SFTP/AAA
             #/var/opt/services
             #/var/opt/services/epg  
             #/var/opt/services/epg/cdr
             #/var/opt/services/epg/gtppcdr 
             #/var/opt/services/epg/rfcdr 
             #/var/opt/services/epg/pmlog 
             ;;

         "SSC-S")
              # This part will be run only on SSC-S

              # SSC CPG directory
              [ ! -d /ram0/done ] && mkdir -p -m +rw /ram0/done
              [ ! -d /ram0/working ] && mkdir -p -m +rw /ram0/working

              # Start the SSC file copy script in the background
              ssc_copy_file_to_xcrp_process &    
             ;;
         *)
             echo "Error: SCC file copy: Supported arg RPSW or SSC-S"
             exit 1
    esac
    
    exit 0
}

main
exit 0
