#!/usr/bin/perl
# This script will search for a string and replace it with contents of replace string
use strict;
use Getopt::Long;

# Feed the arguments into local variables
my $file = "";
my $findstr = "";
my $replacestr = "";

GetOptions ("filename=s" => \$file,
            "findstr=s" => \$findstr,
            "replacestr=s" => \$replacestr)
or die ("Error in Command Options\n");  

if ($file eq "" || $findstr eq "" || $replacestr eq "")
{
  print "Incorrect number of arguments\n";
  print "Usage: strreplace.pl --filename='name of the file' --findstr='search string' --replacestr='new string'\n";
  exit(2);
}


# Attempt to open the file and read, or die.
open (FILE,"<$file") or  die print "Could not open the file $file for reading\n";

my @contents = <FILE>;
close FILE;

my @newcontent = ();
my $matchfound = 0;

foreach (@contents)
{
  # If a match is found, store the new string in the place of the $findstr
  # Note: This finds strings only at the beggining of the lines. If you want in random locations of a line, remove ^
  if (/^\s*$findstr\b/ && !$matchfound)
  {
    push (@newcontent,"$replacestr\n");
    $matchfound = 1;
  }
  # Else continue to stuff old strings into the new array
  else
  {
    push (@newcontent,$_); 
  }
}

# Now check if we found at-least one match. Else we need to append this at the end of the file.
push (@newcontent, "\n$replacestr\n") if (!$matchfound);

# Push all the content back into the file
open (FILE,">$file") or die "Could not open $file for writing new content\n";
print FILE @newcontent;
close FILE;
exit 0;

