#!/bin/bash
# Copyright (c) 2010-2015 Ericsson AB.
#  All rights reserved.

  
prev_port_checksum=0
prev_vlan_checksum=0
prev_mac_checksum=0

port_file=/tmp/port.meta 
vlan_file=/tmp/vlan.meta
mac_file=/tmp/mac.meta 


if [ -f "$port_file" ]
then
   prev_port_checksum=`cksum "$port_file"`
fi

if [ -f "$vlan_file" ]
then
   prev_vlan_checksum=`cksum "$vlan_file"`
fi

if [ -f "$mac_file" ]
then
   prev_mac_checksum=`cksum "$mac_file"`
fi

#execute health check command
$1 >/dev/null
if [ $? -ne 0 ]
then
    exit 1
fi

# Diff files & Change expected (Or) same file and changed not expected
new_port_checksum=0
new_vlan_checksum=0
new_mac_checksum=0

if [ -f "$port_file" ]
then
	new_port_checksum=`cksum $port_file`
fi

if [ -f "$vlan_file" ]
then
	new_vlan_checksum=`cksum $vlan_file`
fi

if [ -f "$mac_file" ]
then
	new_mac_checksum=`cksum $mac_file`
fi

exp_output=$(($3 & 1))
#echo " Prev = $prev_checksum new = $new_checksum"
if [ "$prev_port_checksum" != "$new_port_checksum" -a "$exp_output" == "0" ] || [ "$prev_port_checksum" == "$new_port_checksum" -a "$exp_output" != "0" ]
then
         exit 1
fi   

exp_output=$(($3 & 2))
#echo " Prev = $prev_checksum new = $new_checksum"
if [ "$prev_vlan_checksum" != "$new_vlan_checksum" -a "$exp_output" == "0" ] || [ "$prev_vlan_checksum" == "$new_vlan_checksum" -a "$exp_output" != "0" ]
then
         exit 1
fi   

exp_output=$(($3 & 4))
#echo " Prev = $prev_checksum new = $new_checksum"
if [ "$prev_mac_checksum" != "$new_mac_checksum" -a "$exp_output" == "0" ] || [ "$prev_mac_checksum" == "$new_mac_checksum" -a "$exp_output" != "0" ]
then
         exit 1
fi   

exit 0 
