IPTABLES=/usr/sbin/iptables
IP6TABLES=/usr/sbin/ip6tables

$IPTABLES -A INPUT -s 127.0.0.0/8                             -j ACCEPT
$IPTABLES -A INPUT -p udp --destination-port 6001             -j DROP
$IPTABLES -A INPUT -p tcp --tcp-flags ACK,FIN FIN             -j DROP
$IPTABLES -A INPUT -p tcp --tcp-flags ACK,PSH PSH             -j DROP
$IPTABLES -A INPUT -p tcp --tcp-flags ACK,URG URG             -j DROP
$IPTABLES -A INPUT -p tcp --tcp-flags FIN,RST FIN,RST         -j DROP
$IPTABLES -A INPUT -p tcp --tcp-flags SYN,FIN SYN,FIN         -j DROP
$IPTABLES -A INPUT -p tcp --tcp-flags SYN,RST SYN,RST         -j DROP
$IPTABLES -A INPUT -p tcp --tcp-flags ALL ALL                 -j DROP
$IPTABLES -A INPUT -p tcp --tcp-flags ALL NONE                -j DROP
$IPTABLES -A INPUT -p tcp --tcp-flags ALL FIN,PSH,URG         -j DROP
$IPTABLES -A INPUT -p tcp --tcp-flags ALL SYN,FIN,PSH,URG     -j DROP
$IPTABLES -A INPUT -p tcp --tcp-flags ALL SYN,RST,ACK,FIN,URG -j DROP
$IPTABLES -A INPUT -p tcp --dport 24007                       -j DROP
$IPTABLES -A INPUT -p tcp --dport 111                         -j DROP
$IPTABLES -A INPUT -p tcp --dport 6666                        -j DROP
$IPTABLES -A INPUT -p tcp --dport 6667                        -j DROP
$IPTABLES -A INPUT -p tcp --dport 6668                        -j DROP
$IPTABLES -A INPUT -p tcp --dport 7712                        -j DROP
$IPTABLES -A INPUT -p tcp --dport 20139                       -j DROP
$IPTABLES -A INPUT -p tcp --dport 30180                       -j DROP
# Discard IPv4 packets destined to rsync port (873) from all interfaces other than IPv4 loopback
$IPTABLES -A INPUT -p tcp --dport 873                         -j DROP
$IPTABLES -A INPUT -p udp --dport 111                         -j DROP
$IPTABLES -A INPUT -p udp --dport 6666                        -j DROP
$IPTABLES -A INPUT -p udp --dport 6667                        -j DROP
$IPTABLES -A INPUT -p udp --dport 6668                        -j DROP
$IPTABLES -A INPUT -p udp --dport 7712                        -j DROP
$IPTABLES -A INPUT -p udp --dport 20139                       -j DROP
$IPTABLES -A INPUT -p udp --dport 30180                       -j DROP
$IPTABLES --insert INPUT --proto tcp --dport 22 --in-interface eth0 --match state --state NEW --match recent --name ssh_max_connection --update --seconds 1 --hitcount 3 --jump DROP


# Rate Limit TCP-SYNs incoming per min to prevent TCP-SYN flood
$IPTABLES -A INPUT -p tcp -m state --state NEW -m recent --set -j ACCEPT
$IPTABLES -A INPUT -p tcp -m state --state NEW -m recent --update --seconds 60 --hitcount 20 -j DROP

#Set TCP SYN ACK retries to a max of 3
echo 3 > /proc/sys/net/ipv4/tcp_synack_retries

# Rule to set DSCP value in outgoing telnet/ssh packets to CS67 (0x30)
$IPTABLES -t mangle -A OUTPUT -p tcp --dport 22 -j DSCP --set-dscp 0x30
$IPTABLES -t mangle -A OUTPUT -p tcp --dport 23 -j DSCP --set-dscp 0x30

# Corresponding IPv6 rules for the above IPv4 rules

$IP6TABLES -A INPUT -p tcp -m tcp --tcp-flags ACK,FIN FIN             -j DROP
$IP6TABLES -A INPUT -p tcp -m tcp --tcp-flags ACK,PSH PSH             -j DROP
$IP6TABLES -A INPUT -p tcp -m tcp --tcp-flags ACK,URG URG             -j DROP
$IP6TABLES -A INPUT -p tcp -m tcp --tcp-flags FIN,RST FIN,RST         -j DROP
$IP6TABLES -A INPUT -p tcp -m tcp --tcp-flags SYN,FIN SYN,FIN         -j DROP
$IP6TABLES -A INPUT -p tcp -m tcp --tcp-flags SYN,RST SYN,RST         -j DROP
$IP6TABLES -A INPUT -p tcp -m tcp --tcp-flags ALL ALL                 -j DROP
$IP6TABLES -A INPUT -p tcp -m tcp --tcp-flags ALL NONE                -j DROP
$IP6TABLES -A INPUT -p tcp -m tcp --tcp-flags ALL FIN,PSH,URG         -j DROP
$IP6TABLES -A INPUT -p tcp -m tcp --tcp-flags ALL SYN,FIN,PSH,URG     -j DROP
$IP6TABLES -A INPUT -p tcp -m tcp --tcp-flags ALL SYN,RST,ACK,FIN,URG -j DROP


# Additional rules to discard IPV6 packets destined to Gluster server port
# 24007 from all interfaces other than gige link local interface
$IP6TABLES -A INPUT -i ethSw0 -d fe80::/64 -p tcp                     -j ACCEPT
$IP6TABLES -A INPUT -p tcp --dport 24007                              -j DROP
# Additional rules to discard IPV6 packets destined to RPCbind server port 111
$IP6TABLES -A INPUT -p tcp --dport 111                                -j DROP
# Discard IPv6 packets destined to rsync port (873) from all
# interfaces other than gige link local interface
$IP6TABLES -A INPUT -p tcp --dport 873                                -j DROP
$IP6TABLES -A INPUT -p tcp --dport 6666                               -j DROP
$IP6TABLES -A INPUT -p tcp --dport 6667                               -j DROP
$IP6TABLES -A INPUT -p tcp --dport 6668                               -j DROP
$IP6TABLES -A INPUT -p tcp --dport 7712                               -j DROP
$IP6TABLES -A INPUT -p tcp --dport 20139                              -j DROP
$IP6TABLES -A INPUT -p tcp --dport 30180                              -j DROP
# Discard IPV6 packets of UDP protocoal  destined to RPCbind server
# port 111 from all interfaces other than gige link local interface
$IP6TABLES -A INPUT -i ethSw0 -d fe80::/64 -p udp                     -j ACCEPT
$IP6TABLES -A INPUT -p udp --dport 111                                -j DROP
$IP6TABLES -A INPUT -p udp --dport 6666                               -j DROP
$IP6TABLES -A INPUT -p udp --dport 6667                               -j DROP
$IP6TABLES -A INPUT -p udp --dport 6668                               -j DROP
$IP6TABLES -A INPUT -p udp --dport 7712                               -j DROP
$IP6TABLES -A INPUT -p udp --dport 20139                              -j DROP
$IP6TABLES -A INPUT -p udp --dport 30180                              -j DROP

# Rule to set DSCP value in outgoing telnet/ssh packets to CS67 (0x30)
$IP6TABLES -t mangle -A OUTPUT -p tcp --dport 22 -j DSCP --set-dscp 0x30
$IP6TABLES -t mangle -A OUTPUT -p tcp --dport 23 -j DSCP --set-dscp 0x30
