/*!
 * Copyright (c) 2015-2016 Ericsson AB.
 * All rights reserved.

 * \page Client Simulator NG Design
 * @defgroup cli_ng Client Simulator NG
 * @{ */
<pre><code>

client_simulator_ng consists of a testcontroller controlling one or more
testapps. Testapps are started by the testcontroller, so the user should only
need to start testcontroller with the syntax:

issu_testcontroller_ng -c <config_file> -l <log_file>

testcontroller log files are separated from testapp log files by an appended
'controller' string in its name.

The individual result of PASS/FAIL of each testapp has to be communicated back
to the testcontroller for logging. So the test script can read the testcontroller
log file and get the result for a particular test case. Individual testapp execution
result can be read from testapp log file. The log names for each testapp
is constructed using the instanceID and they will be used for debugging.

Note for XML files:

  * do not use spacebars within tags in XML. A parse error will be raised if
    a value is found e.g. <timeSec> 123 </timeSec>

Description of testcontroller XML tags
======================================

For a quick example of testcontroller xml check:
 * sample_testcontroller_ng_config.xml

The root tag is <config> and it has two child tags: <common> and <testapp>.

<common>
--------
Contains settings which are common across all testapps. This tag and
its children are optional. Possible child tag is:

  <type>setTestMode</type>
    <testMode>
    ----------------------
    This tag is to set the global mode which is common to testapps. Testapps may have
    own testmodes per state in their own xml files.
    This has 1 child tag.

      * <mode>: Test mode is an integer value that will be read and passed to all testapps.
                The test mode value can be a HEX or decimal value.

<testapp>
---------
Contains settings which are dedicated to an individual testapp. This
tag is mandatory and can have multiple startTestapp child tags.

  <action>
    <type>startTestapp</type>
    <testappInfo>
    -------------------------
    This is used to provide information about testapps to be started. It has 3 child tags.

    * <instanceID>: InstanceID is a unique id for each testapp.
    * <configFile>: Relative or full path of XML config file. The configFile can be
                    same across different testapps. This is to ensure that same
                    config file can be reused by multiple testapps.
    * <fsmID>:      This tag is used to specify issu fsm id from which testapp is accepting
                    callbacks. This tag is optional and if not specified, testapp accepts
                    callbacks from any issu fsm.

Description of testapp XML tags
================================

For a quick example of testapp xml check:
 * sample_testapp_ng_config.xml

The root tag is <config> and it has two child tags: <common> and <state>.

<common>
--------
Contains settings which are common across all states. This tag and its children
are optional. Possible child tags are:

  <action>
    <type><registerStates></type>
    <regStates>
    -----------
    Register states. This tag specifies which FSM states are to be registered to
    the FSM. If this tag is omitted, testapp will register all states, but won't
    know which states are actually registered, as this is decided by the fsm
    library. If this tag is specified and a callback to an unregistered state is
    received, the callback validation fails. This has one child tag.

     * <regStateName>: This must be an FSM state. If multiple states need to be
       registered, this tag may be specified as many times as needed.

  <terminalState>
  ---------------
  This is an ISSU FSM state that will be treated as the terminal state. The
  terminal state is registered with FSM. Upon encountering a terminal state the
  testapp sends ISSU_EVT_CLNT_DONE to FSM and exits. Note that testapp
  doesn't process any actions in a terminal state. It simply exits after sending
  ISSU_EVT_CLNT_DONE.

  <errorReportEvent>
  ------------------
  If testapp ends up in an error situation, it reports an error to issu fsm by sending
  error event. This error event can be speficied using this tag. If this tag is not
  specified, testapp will send the default error event ISSU_EVT_CLNT_ERROR.

<state>
-------
Contains the actions for each state inside a <state> tag. The state
tag has two child tags:<currentState> and <callBackInstance> There can be
multiple state tags under the config tag.

  <currentState>
  --------------
  This must be an FSM state.  There can be only one of this tag
  under state tag. A set of action types can be defined like sendEvent,
  setTestMode etc. More this is explained below in detail.

  <callBackInstance>
  ------------------
  Each callbackInstance corresponds to actions performed by testapp
  each time the state is entered.  Each subsequent callback into the same state
  will enter the subsequent callbackInstance in same order as listed in the
  config. Each callbackInstance has one or multiple actions. Each action results
  in one invocation, and repeated actions should result in repeating the
  actions. Each action has a type defined and similarly named container
  containing its parameters.

Different actions:
------------------

<type>delay</type>
------------------

Waits given amount of seconds before proceeding to the next action.

  <delay>
  This has one tag.
   * <timeoutSec> How many seconds to wait.

<type><runScript></type>
------------------------

A program/script which will be executed by the testapp.  While the script
executes processing of events from issu FSM and actions is deferred. Any
executable can be executed.

 <script>
 This has one tag.
 * <path>: Relative or full path of the script

<type><procStart></type>
<type><procStop></type>
<type><procRestart></type>
--------------------------

Start/stop or restart a testapp client or a IPOS process. IPOS processes only
support the procRestart tag, so procStart and procStop should only have
"testapp" as pname value.

NOTE: procRestarting a IPOS process means killing it only as RP already
automatically starts it after its killed as pname.

 * <procInfo> : Container for the tags below
 This has 2 tags.
   * <pname>: if procStop or procStart: The tag has to contain "testapp".
              else the tag has to be "testapp" or a valid IPOS process.
   * <instanceID>: Only mandatory for testapp. This identifies the instance_id
   of a testapp on which the proc-operation should be performed on.

<type><sendEvent></type>
------------------------

Send an event to the FSM.

 * <event> Container for the tags below.
   * <eventName> This has to be the actual event name that needs to be sent to
   the FSM.

   Each sendEvent will result in one invocation into FSM.  With multiple
   sendEvent action type under each callBackInstance, there can be only one EVT
   that receives FSM callback.

   * <timeSec>: Not mandatory: Testapp should wait this amount of time in
   seconds before it can send the event mentioned in the sendEvent action type.
   * <desc>: Not mandatory: Valid for ISSU_EVT_CLNT_INFO or ISSU_EVT_CLNT_ERROR
   event. Provides a string description sent

<type>setTestmode</type>
------------------------

This is to set the mode per state.

 * <testMode>
 This has 2 tags.
   * <mode>: Test mode is an integer value that will be read and passed to FSM.
   This has to be set inside the state tag so the master can pause the FSM in
   that state. The test mode value can be a HEX or decimal value. Testapp
   is not prepared to get a 0 testmode value from config.
   * <timeoutSec>: This tag is optional. It represents the timeout in seconds for
   how long the testmode should be set. If no timeoutSec is specified, the testMode is
   persistent throughout the rest of the test or until another testMode action
   is encountered. If the timeout is specified and it expires, or a state changes,
   testapp will restore the last testMode without timeout or in absence of that,
   the one that was included in testcontroller configuration. If that does not exist
   either, it will set it back to the default testMode 0. If testapp is restarted
   when a timer is running then the test mode will persist for the whole state.
   It is not valid to have multiple setTestmode tags with timeout within
   a single state.

Note: Testmode will be set to TEST_MODE_DEFAULT when the testapp is exiting or when stopped by
another testapp.

<type>scheduleNextVerifyAction</type>
-------------------------------------

This construct can be used to verify the subsequently incoming callback from FSM
state machine towards this testapp entity against a provided set of values
(old state, new state, received event).

There can be only one schNxtVfyAct action type for each callBackInstance.

 * <schNxtVfyAct>
 This has 4 tags.

   * <oldState> : This must be an FSM state that is mostly the same as current
   state.
   * <newState> : This must be an FSM state that is the next expected state
   based on the event sent by the client.
   * <rcvdEvent>: The name of the event which is expected to be received in the
   callback message at state change.

   * <timeLeft>: Optional. Is to verify the time that is extended using
   EXT_TIMER and/or RETRY event. This is a ballpark time extended by the FSM. So
   For Eg.  <=12 or >=12 or a range(12-15) can be used. NOTE: Not implemented.

</code></pre>
 /*! @} */
