#
# 04/07/2012
#    john.bosco@ericsson.com
#    reda.haddad@ericsson.com
#
#    Copyright (c) 2012, 2016, 2017 Ericsson AB.
#    All rights reserved.
#

"""
   This package is used to handle exec CLI.
"""
import re
import string
import os
import socket
import sys
import time
import fileinput
import hashlib
import inspect
import errno
import select
import signal
import threading
import termios
import getpass

double_connect = 'User already logged in, please quit other session first'
function_leave_msg = 'function_exit'
echooff_msg = 'turn_off_echo'
echoon_msg = 'turn_on_echo'
work_loop = True
save_config = []
global g_sock

def timer_handle():
    global work_loop
    work_loop = False

def signal_handler(signal, frame):
    global work_loop
    work_loop = False

def resolve_int(signal, frame):
    data="\x03"
    global g_sock
    g_sock.sendall(bytes(data, 'UTF-8'))
    print('Interrupt is captured, notify the server to terminate the current task!')
    time.sleep(0.6)
    g_sock.close()
    sys.exit(1)

def turnoffecho():
    try:
        fd = sys.stdin.fileno()
    except:
        print('Error get stdin')
    old = termios.tcgetattr(fd)     # a copy to save
    new = old[:]
    new[3] &= ~termios.ECHO  # 3 == 'lflags'
    tcsetattr_flags = termios.TCSAFLUSH
    if hasattr(termios, 'TCSASOFT'):
        tcsetattr_flags |= termios.TCSASOFT
    try:
        termios.tcsetattr(fd, tcsetattr_flags, new)
    finally:
        return

def turnonecho():
    try:
        fd = sys.stdin.fileno()
    except:
        print('Error get stdin, error setecho')
    old = termios.tcgetattr(fd)     # a copy to save
    new = old[:]
    new[3] |= termios.ECHO  # 3 == 'lflags'
    tcsetattr_flags = termios.TCSAFLUSH
    if hasattr(termios, 'TCSASOFT'):
        tcsetattr_flags |= termios.TCSASOFT
    try:
        termios.tcsetattr(fd, tcsetattr_flags, new)
    finally:
        return

def healthd_exec_func(func_name, func_args):
    """
    Execute the function selected by the user in the CLI.

    Input:
        func_name: The function selected by the user in the CLI.
        func_args: Optional. All the required arguments have to be passed in the
         appropriate format in the double quotes as a string. Please use the help
        option provided in the CLI for details.
    Returns: BOOL (True or False)
        rc: True if no error was encountered, else False. An errors occurs if:
        the file where the function is defined does not have a CLI flag.

    Usage:
        This will be called from the CLI in healthd_cli.c
    """

    rc = False
    global  double_connect, function_leave_msg,  work_loop
    sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
    server_address = '/tmp/healthd_socket'
    inspect_func = 'hltp_inspect_function'
    exec_func = 'hltp_exec_function'
    found = False
    #sys.stdin.close()
    try:
        sock.connect(server_address)
    except socket.error:
        print (" Socket connect failed. \n")
        sys.exit(1)

    global g_sock
    g_sock = sock
    signal.signal(signal.SIGINT, resolve_int)

    try:
        sock.settimeout(0.8)
        startmsg = sock.recv(1200)
        startstr = str(startmsg.decode('ascii'))
    except socket.timeout:
        startstr =''
        print("receve timeout")
        sock.close()
        return False

    if double_connect in startstr:
        print(startstr)
        try:
            sock.sendall(bytes("exit\n", 'UTF-8'))
            time.sleep(0.5)
        #Maybe the peer socket has been closed, so do nothing here
        except:
            pass
        sock.close()
        return False

    t = threading.Timer((60*30), timer_handle)
    inspect_name = inspect_func + "(" + func_name+ ")\n"
    try:
        sock.settimeout(20)
        sock.sendall(bytes(inspect_name, 'UTF-8'))
        time.sleep(1)
        inspect_time = 5
        while inspect_time > 0:
            inspect_result = sock.recv(51200)
            inspect_data = inspect_result.decode('ascii')
            if len(inspect_data.replace("healthd>>>",'').strip()) == 0:
                --inspect_time
                continue
            break
        if inspect_time == 0:
            print("inspect function error")
            sock.close()
            return False
        sub_str = 'False'
        match_obj = re.search(sub_str, inspect_data)
        if str(match_obj) != 'None':
            strin = match_obj.group(0)
            #print("STRIN : "+ strin+". \n")
            if strin == 'False':
                print("The file does not have the CLI tag to execute the function. \n")
                found = True
                return False
        if found != 'True':
            #hltd_func = func_name + "(" + func_args + ")\n"
            hltd_func = exec_func + "(" + func_name + "," + func_args + ")\n"
            sock.sendall(bytes(hltd_func, 'UTF-8'))
            readio = [sock, sys.stdin]
            while work_loop == True:
                i, o, e = select.select(readio, [], [], 10)
                if sock in i:
                    content = sock.recv(51200)
                    ascdata =  content.decode('ascii')
                    if function_leave_msg in ascdata:
                        work_loop = False
                        ascdata = ascdata.replace(function_leave_msg, '')
                    if echooff_msg in ascdata:
                        turnoffecho()
                        ascdata = ascdata.replace(echooff_msg, '')
                    if echoon_msg in ascdata:
                        turnonecho()
                        ascdata = ascdata.replace(echoon_msg, '')
                    ascdata = ascdata.replace("healthd>>>", '')
                    print(ascdata)
                if sys.stdin in i:
                    interdata = sys.stdin.readline().strip()
                    sock.sendall(bytes((interdata + '\n'),'UTF-8'))

        data = "exit\r\n\n\n"
        sock.sendall(bytes(data, 'UTF-8'))
        time.sleep(0.5)
        rc = True
    except Exception as e:
        print("error: ", str(e))
        data = "exit\r\n\n\n"
        sock.sendall(bytes(data, 'UTF-8'))
        time.sleep(0.5)

    time.sleep(0.5)
    sock.close()
    t.cancel()
    return (rc)

if __name__ == "__main__":

    script_name = sys.argv[0]
    script_arg = sys.argv[1]

    if len(sys.argv) == 4 :
        func_args = sys.argv[3]
    else:
        func_args = ' '
    if len(sys.argv) > 2 :
        func_name = sys.argv[2]
        rc = healthd_exec_func(func_name, func_args)


