#
# Copyright (c) 2016 Ericsson AB.
# All rights reserved.
#
# Originating Author : Jerry Li
#

import os
import sys
import gzip
import signal
import logging
logging.basicConfig(level=logging.DEBUG,
                    format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                    datefmt='%a, %d %b %Y %H:%M:%S')

#from logging.handlers import RotatingFileHandler
#Rthandler = RotatingFileHandler('/tmp/pm_report.log', maxBytes=100,backupCount=3)
#Rthandler.setLevel(logging.DEBUG)
#formatter = logging.Formatter('%(name)-12s: %(levelname)-8s %(message)s')
#formatter = logging.Formatter('%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s')
#Rthandler.setFormatter(formatter)
#logging.getLogger('').addHandler(Rthandler)

#logging.getLogger('').setLevel(logging.ERROR)

env_log = os.getenv('PM_REPORT_LOG')

if env_log == 'DEBUG':
    logging.getLogger('').setLevel(logging.DEBUG)
elif env_log == 'INFO':
    logging.getLogger('').setLevel(logging.INFO)
elif env_log == 'WARNING':
    logging.getLogger('').setLevel(logging.WARNING)
elif env_log == 'ERROR':
    logging.getLogger('').setLevel(logging.ERROR)
elif env_log == 'CRITICAL':
    logging.getLogger('').setLevel(logging.CRITICAL)
else:
    logging.getLogger('').disabled = True

try:
    import xml.etree.cElementTree as ET
except:
    import xml.etree.ElementTree as ET

BufSize = 1024 * 8
def gZipFile(src, dst):
    fin = open(src, 'rb')
    fout = gzip.open(dst, 'wb')
    in2out(fin, fout)

def gunZipFile(gzFile,dst):
    fin = gzip.open(gzFile, 'rb')
    fout = open(dst, 'wb')
    in2out(fin, fout)

def in2out(fin, fout):
    while True:
        buf = fin.read(BufSize)
        if len(buf) < 1:
            break
        fout.write(buf)
    fin.close()
    fout.close()


def parse_xml_print_pretty(xml_file, filter_jobId, filter_pmgroup):
    index = 0
    context = ET.iterparse(xml_file, events = ("start", "end"))
    for event, elem in context:
        tag = elem.tag
        if event == "start" and tag.partition('}')[-1] == 'measInfo':
            elem_start = elem
        if event == "end" and tag.partition('}')[-1] == 'measInfo':
            index = index + 1
            values = elem_start[-1]
            Is_jobID_found = True
            out_buf = ""
            measInfoId = elem_start.get('measInfoId')
            if measInfoId:
                tmp_list = measInfoId.split(',')
                logging.debug("Jerry Li %s", measInfoId)
                for item in tmp_list:
                    if item.startswith('PmGroup'):
                        pm_group_id  = item.split('=')[-1]
                        break
                if filter_pmgroup == "" or filter_pmgroup == pm_group_id:
                    out_buf = "{0:<15}:{1:>64}".format("measInfoId", measInfoId)
                else:
                    logging.debug("skip some elements %s", filter_pmgroup)
                    elem.clear()
                    continue
            measObjLdn = values.get('measObjLdn')
            if measObjLdn:
                out_buf = out_buf + "\n"+ "{0:<15}:{1:>64}".format("measObjLdn", measObjLdn)
            if values[-1].tag.partition('}')[-1] == 'suspect':
                out_buf = out_buf + "\n"+ "{0:<15}:{1:>64}".format("suspect", values[-1].text)
            for child in elem_start:
                jobId  = child.get('jobId')
                if jobId:
                    if filter_jobId == "" or filter_jobId == jobId:
                        out_buf = out_buf + "\n"+ "{0:<15}:{1:>64}".format("jobId", jobId)
                    else:
                        out_buf = ""
                        Is_jobID_found = False
                        elem.clear()
                        break             # Stop iterating the child elements
                endTime = child.get('endTime')
                if endTime:
                    out_buf = out_buf + "\n"+ "{0:<15}:{1:>64}".format("endTime", endTime)
                if child.tag.partition('}')[-1] == 'repPeriod':
                    report_interval = child.get('duration')
                    if report_interval:
                        out_buf = out_buf + "\n"+ "{0:<15}:{1:>64}".format("ROP", report_interval)
                pos = child.get('p')
                if pos:
                    out_buf = out_buf + "\n" + "    {0:<40}:{1:>35}".format(child.text, values[int(pos)-1].text)
            if Is_jobID_found:
                print(out_buf)
            elem.clear()

def clean_legacy(signal,frame):
    os.remove(temp_file)
    sys.exit(1)

temp_file = r'Jerry.xml'
def output_pm_file(file_name, filter_jobId, filter_pmgroup):
    unzipErr = ""
    #Check if the file exist
    if not os.path.exists(file_name):
        print("%s doesn't exist, may be it is deleted"%(file_name))
        return
    if file_name.endswith(".gz"):
        zip_src = file_name
        unzip_dst = temp_file
        try:
            gunZipFile(zip_src, unzip_dst)
        except Exception as e:
            logging.error("gunZipFile: %s", e)
            unzipErr = str(e)
            #print("Error!", e)
    else:
        tmp_fd = open(temp_file, 'w')
        tmp_fd.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tempdata xmlns=\"http://www.3gpp.org/ftp/specs/archive/32_series/32.435#measCollec\">")
        with open(file_name, 'rb') as f_orig:
            for line in f_orig:
                tmp_fd.write(str(line))
        tmp_fd.write('</tempdata>')
        tmp_fd.close()
        unzip_dst = temp_file
        zip_src = file_name

    print("The data is got from: %s"%(zip_src))
    if unzipErr != "":
        print("Error!", unzipErr)
    else:
        try:
            parse_xml_print_pretty(unzip_dst, filter_jobId, filter_pmgroup)
        except Exception as e:
            logging.error("Error4: %s", e)
            print("Error!", e)

    if unzip_dst == temp_file:
        os.remove(temp_file)


if __name__ == '__main__':
    signal.signal(signal.SIGINT, clean_legacy)
    signal.signal(signal.SIGTERM, clean_legacy)
    signal.signal(signal.SIGPIPE, clean_legacy)
    signal.signal(signal.SIGHUP, clean_legacy)

    for i in range(len(sys.argv)):
        logging.debug("%s %s", i, sys.argv[i])
        if i == 0:
            continue
        if i == 1:
            filter_jobId = sys.argv[i]
            continue
        if i == 2:
            files = sys.argv[i].split('\n')
            continue
        if i == 3:
            filter_pmgroup = sys.argv[i]
            continue
    for file in files:
        if len(file) == 0:
            continue
        output_pm_file(file, filter_jobId, filter_pmgroup)
    print('Done!!!')
