--
-- Copyright (C) 2005 dahua Technologies, All Rights Reserved.
-- 2006-4-25 15:54 Z:\wjj\ven\152\DAHUA\Install.lua
-- 2006-9-21  modified by zhongjl for new partition
--

-- Flash ĴСΪ64K
local flashSectorSize = 0x10000;

local Installer = {};
Installer.TotalSize      = 0;    -- ܵҪдFlashеݴС
Installer.InProgressSize = 0;	 -- пƽ

-- ֪ͨϲӦóĽϢ
-- params:
--    
-- return:
--    
function Installer:notify()
	self.InProgressSize = self.InProgressSize + flashSectorSize;

	local progress = self.InProgressSize / self.TotalSize * 100;
	if(progress > 100) then
		progress = 100;
	end;
	progress = tonumber(string.format("%d", progress));

	-- ע÷ʽ,self::callback,ᵼ»ص
	self.callback(0x01, progress);
end

-- ӦóṩϢжǷ
-- params:
--    
-- return:
--    ɹTrue, ʧܷFalseԼʧܵԭ
function Installer:preInstall()
	-- ҪЩ
	-- Ӳ汾 
	-- ԭİ汾ţ
	--
	local board = Global.Hardware.board;
	local hwproduct;
	local hwchannel;
	local hwversion;
	local hwfunction;

	print(string.format("Checking hardware information,board name:%s version:%s",
		board.name, board.version));
	if(board.name ~= "DVRxx04HF-X") then
		return false, "Invalid board";
	end

	--ֱӴӲȡֵ
	--hwproductȡֵ: 2 -- LB; 3 -- LBN; 4 -- LB_ATM; 5 -- GBE; 6 -- LK; 7 -- LS
	--hwproductȡֵ: 2 -- IPC4X5; 3 -- A6; 4 -- A8; 5 -- IPVM;
	--hwchannelȡֵ: x -- x chans
	--hwfunctionȡֵ: 0 -- AUDIO; 1 -- MATRIX; 3 -- LOOP

	if(mtd.getinfo)then
		hwproduct,hwchannel,hwversion,hwfunction = mtd.getinfo();
		print(string.format("Checking hardware id info: product = %x; channel = %x; version = %x; function = %x",
			hwproduct,hwchannel,hwversion,hwfunction));
		if((hwproduct ~= 3) and (hwproduct ~= 4)) then
			print(string.format("product not match"));
			return false, "Invalid board";
		end
	end

	-- ҪУ鲻ͬ屾İӳǷͨ,
	-- ĿǰLB 1.22 LB 2.00İӾͲͨ
	-- if(board.version ~= "1.22") then
	--  print(string.format("XXXXXXXXXXXX"));
	--	return false, "Invalid board version";
	-- end

	local vendor = Global.Vendor;

	if(vendor.Name ~= 'General_N6') then
		return false, "Invalid vendor";
	end

	return true;
end

-- ɺĴ,ϵͳ
-- params:
--    
-- return:
--    
function Installer:postInstall()
end

-- Flash,ڲͬӦ,Ĵܲһ
-- params	:
-- part		: ,ʼλԼλ
-- filename	: еļ
-- return	: 
function Installer:updatePart(part, filename)
	local myfile = self.ZipArchive:open(filename);
	local write_times = 0;
	-- ļ򲻿,ҪԴ˲ֽ
	if(not myfile) then
		print(string.format("%s not exist", filename));
		return ;
	end

	local addr   = part.baseAddr;
	local endAddr= part.endAddr;
	local data;
	local fldata;
	local filesize = 0;
	local head = myfile:read(64);--64ֽڵͷ
	
	filesize = mtd.check_init(head);-- ʼ	
	
	print(string.format("Start Update : %s  filesize : %s", filename,filesize));
	-- ǰ64ֽڵͷ,µ汾вҪԴ˽У
	myfile:seek("set", 64);
	while(filesize > 0) do
		if(filesize > flashSectorSize) then
			fldata = mtd.read(addr,flashSectorSize);
			data = myfile:read(flashSectorSize); 
		else
			if(filesize > 0) then
				fldata = mtd.read(addr,filesize);
				data = myfile:read(filesize);
			end
		end

		if((not fldata) or (data and (fldata ~= data))) then
			mtd.erase(addr);
			mtd.write(addr, data);
			write_times = write_times+1;				
		end
		print(string.format("==========> filesize : %s <==========", filesize));
		filesize = filesize - flashSectorSize;
	  self:notify();
	  addr   = addr   + flashSectorSize;
	end
	print(string.format("==========> Write Times : %s <==========", write_times));
	myfile:close();
end

function Installer:InstallPlayer(filename)
	local myfile = self.ZipArchive:open(filename);

	-- ļ򲻿,ҪԴ˲ֽ
	if(not myfile) then
		return ;
	end

	--
	-- TODO:
	-- ԶݣͨIDEӿд뵽Ӳ
	--
end

--ѹimgļУ飬Уȷ1󷵻0
function Installer:crc32check( filename)
	local myfile = self.ZipArchive:open(filename);
	
	-- ļ򲻿(޴ļ),ҪԴ˲ֽ
	if(not myfile) then
		print(string.format("==>Installer:crc32check not myfile %s , no need to check", filename));
		return 1;
	end
	
	-- ӦóУӿ,У飬ֱӷسɹԼǰӦó
	if(not mtd.check_init) then
		print(string.format("==>Installer:crc32check not mtd.check_init, no need to check") );
		return 1	
	end	
	if(not mtd.crc32)then
		print(string.format("==>Installer:crc32check not mtd.crc32, no need to check"));
		return 1
	end
	
	local head = myfile:read(64);--64ֽڵͷ
	
	local filesize = 0;
	local filecrc32 = 0;
	print(string.format("==>Installermtd.check_init"));
	filesize, filecrc32 = mtd.check_init(head);-- ʼ
	print(string.format("==>Installer mtd.check_init over, filesize:%d filecrc:%x!", filesize, filecrc32));
	local checksum = 0;
	local readlen =0;
	local data;
	-- ݲּУ
	while (readlen < filesize) do
		data = myfile:read(flashSectorSize);
		--print(string.format("Installer check crc32:%x ------%x!", checksum, readlen) );
		if (filesize - readlen < flashSectorSize) then
			checksum = mtd.crc32(checksum, data, filesize - readlen)
		else
			checksum = mtd.crc32(checksum, data, flashSectorSize)
		end
		readlen = readlen + flashSectorSize;
	end

	if (checksum ~= filecrc32) then
		print(string.format("==>error: Installer check (%s)crc32 error:%x ------%x!", filename, checksum, filecrc32));
		return 0;
	end
	print(string.format("==>correct: Installer check(%s) crc32 correct:%x ------%x!", filename, checksum, filecrc32));
	return 1;
end


-- 
-- params:
--    
-- return:
--    ɹTrue,ʧܷFlaseԼԭ
function Installer:execute()
	--[[
	 Ϣ,֪ʶ "Flash 滮"
	 0x00000000  0x00040000  256K     armboot                                 u-boot
	 0x00060000  0x00460000  4096K    kernel + root                           romfs
	 0x00460000  0x00a60000  6144K    application + modules                   user
	 0x00a60000  0x00c60000  2048K    web                                     web
	 0x00c60000  0x00e60000  2048K    slave:romfs + kernel + pcidriver        slave
	 0x00e60000  0x00e80000  128K     custom                                  custom
	 0x00e80000  0x00ec0000  256K     logo                                    logo
	 0x00ec0000  0x00f40000  1024K    config                                  
	 0x00f40000  0x01000000  1024K    config1
	]]

	local flashPartions =
	{
		boot		= { baseAddr = 0x00000000  , endAddr = 0x00040000 },
		rootfs		= { baseAddr = 0x00060000  , endAddr = 0x00460000 },
		user     	= { baseAddr = 0x00460000  , endAddr = 0x00A60000 },
		web     	= { baseAddr = 0x00A60000  , endAddr = 0x00C60000 },
		slave  		= { baseAddr = 0x00C60000  , endAddr = 0x00E60000 },
		custom  	= { baseAddr = 0x00E60000  , endAddr = 0x00E80000 },
		logo		= { baseAddr = 0x00E80000  , endAddr = 0x00EC0000 },
		config		= { baseAddr = 0x00EC0000  , endAddr = 0x00f40000 },
		config1		= { baseAddr = 0x00f40000  , endAddr = 0x01000000 },
	}

	-- self.ZipArchive ⲿ,ûóӦе
	assert(self.ZipArchive);
	local zfile = self.ZipArchive;

	local ret, info = self:preInstall();
	if(not ret) then
		return false, info;
	end

	-- ҪļСԼӡļ嵥
	local TotalSize = 0;
	print("==>Files in archive");
	for file in zfile:files() do
		print(file.filename);
		TotalSize = TotalSize + file.uncompressed_size;
	end
	self.TotalSize  = TotalSize;     -- ܵļС
	mtd.init();

	if ( 1 ~= (self:crc32check( "u-boot.bin.img"))
	     or 1 ~= (self:crc32check("romfs-x.cramfs.img")) 
		or 1 ~= (self:crc32check("user-x.cramfs.img")) 
	     or 1 ~= (self:crc32check("web-x.cramfs.img")) 
	     or 1 ~= (self:crc32check("slave-x.cramfs.img")) 
	     or 1 ~= (self:crc32check("logo-x.cramfs.img")) 
	     or 1 ~= (self:crc32check( "custom-x.cramfs.img")) ) then
		print("==>Upgrade: crc32check error!");
		return false;
	end

	self:updatePart(flashPartions["boot"],	"u-boot.bin.img");
	--mtd.saveenv();
	self:updatePart(flashPartions["rootfs"],	"romfs-x.cramfs.img");
	self:updatePart(flashPartions["user"],		"user-x.cramfs.img");
	self:updatePart(flashPartions["web"],		"web-x.cramfs.img");
	self:updatePart(flashPartions["slave"],		"slave-x.cramfs.img");
	self:updatePart(flashPartions["custom"],	"custom-x.cramfs.img");
	self:updatePart(flashPartions["logo"],		"logo-x.cramfs.img");
	--self:InstallPlayer("autoplayer.bin");
	self:postInstall();
	print("==>Upgrade finished.");
	return true;
end

return Installer;
