#!/bin/sh

# SD modes :"720x576-50i", "768x576-50i", "640x480-60i".
# HD modes :"640x480-60p", "1920x1080-50i", "1920x1080-60i", "1280x720-60p".

# As we are using mod_init=NO, be sure that EVERY DRIVERS are initialized when calling this script
# (For example by STFAE), except STBLITm which will be initialized by DirectFB plugin

# Resolution for main output
# --------------------------
if [ $# -eq 0 ] || [ $1 = "PAL" ]; then
	mode0=720x576-50i
	mem0=4
	format0=ARGB1555
	ratio0="4TO3"
else if [ $1 = "HD" ]; then
	mode0=1280x720-50
	mem0=8
	format0=ARGB8888
	ratio0="4TO3"
else if [ $1 = "FULLHD" ]; then
	mode0=1920x1080-50i
	mem0=16
	format0=ARGB1555
	ratio0="4TO3"
fi
fi
fi

# Resolution for aux output
# -------------------------
mode1=720x576-50i
mem1=4
format1=ARGB1555
ratio1="4TO3"

# Insert module
# -------------
if [ $# -eq 2 ]; then
 insmod modules/stgfb_core.ko mod_init=NO g_devnum=2 layer_name="GFX_LAYER0,GFX_LAYER1" g_tvOutMode="$mode0,$mode1" g_mem="$mem0,$mem1" g_format="$format0,$format1" g_ratio="$ratio0,$ratio1"
else
 insmod modules/stgfb_core.ko mod_init=NO g_devnum=1 layer_name=GFX_LAYER0 g_tvOutMode="$mode0" g_mem="$mem0" g_format="$format0" g_ratio="$ratio0"
fi

# Set path
# --------
export PATH=/usr/X11R6/bin:/usr/X11R7/bin:$PATH
export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/usr/lib:/lib:/usr/X11R6/lib:/usr/X11R7/lib
export DISPLAY=':0.0'
export DFBARGS="module-dir=/usr/lib/directfb-stsdk"

# Change global alpha of /dev/fbX frame buffer
# --------------------------------------------
/root/modules/stgfb_control /dev/fb0 a 128
if [ $# -eq 2 ]; then
 /root/modules/stgfb_control /dev/fb1 a 128
fi

# Start X ?
# -------
#/usr/X11R6/bin/Xfbdev &
#/usr/X11R6/bin/xloadimage -onroot -center /root/fbtest/linuxlogo.tif &

