#!/bin/sh

###############################################################################
##                SETUP STAPI DEVICE NAME ENVIRONMENT VARIABLES              ##
###############################################################################

# Verify if root module is specified
# ----------------------------------
export PATH=$PATH:/sbin
if [ -z "$MODULES_INSTALL_DIR" ] ; then
 #export MODULES_INSTALL_DIR=/root/modules
 export MODULES_INSTALL_DIR=/lib/modules/2.6.23.17_stm23_A26-pdk7105
fi
source $MODULES_INSTALL_DIR/load_env.sh

# Check if we are in 32 or 29bits
# -------------------------------
if [ -f $MODULES_INSTALL_DIR/load_modules_list_29BITS.txt ]; then
 LOAD_MODULES_LIST=$MODULES_INSTALL_DIR/load_modules_list_29BITS.txt
 MODE="29BITS"
else
 MODE="32BITS"
 if [ -f $MODULES_INSTALL_DIR/load_modules_list_32BITS.txt ]; then
  LOAD_MODULES_LIST=$MODULES_INSTALL_DIR/load_modules_list_32BITS.txt
 else
  LOAD_MODULES_LIST=$MODULES_INSTALL_DIR/load_modules_list.txt
 fi
fi

###############################################################################
##                          SETUP DIRECTORY ACCESS                           ##
###############################################################################

# Verify if modules list exist
# ----------------------------
if [ ! -f $LOAD_MODULES_LIST ] ; then
 echo "$LOAD_MODULES_LIST does not exist"
 exit
fi

# Create /dev/stapi directory if not exist
# ----------------------------------------
if [ ! -e /dev/stapi ]; then mkdir -p /dev/stapi ;fi
chmod 755 /dev/stapi

###############################################################################
##                          MODULE INSERT PROCEDURE                          ##
###############################################################################

# Return chip version
# -------------------
define_chip_info()
{
 export chipset=`cat /proc/stsys_ioctl/chipset | cut -b1-7`
 export chipver=`cat /proc/stsys_ioctl/chipset | cut -b9-9`
}

# Create a node in /dev/ (Arg 1=node_name)
# ----------------------------------------
create_node()
{
 node_name="$1"
 major=`cat /proc/devices | grep "\b$node_name\b" | cut -b1-3`
 if [ ! -z "$major" ]; then
  dev="/dev/stapi/$node_name"
  cur_major=$((`stat -c %t $dev 2>/dev/null`))
#	echo "$cur_major"  "$major"
  if [ ! -c ${dev} ] || [ $major -ne $cur_major ]; then
    rm -f ${dev} 2> /dev/null
    mknod $dev c $major 0  || return 1
    chmod 0660 $dev || return 1
   fi
 fi
}

# Load firmware (Arg 1=video1 or audio1)
# --------------------------------------
load_firmware()
{
 if [ "$1" = "video1" ] ; then
  if [ "$chipset" = "STx5206" ] ; then
   cat $MODULES_INSTALL_DIR/companion_5206_video_Ax.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7100" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7100_video_BxCx.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7105" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7105_video_Ax.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7106" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7106_video_Ax.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7108" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7108_video_Ax.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7109" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7109_video_Cx.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7111" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7111_video_Ax.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7141" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7141_video_Ax.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7200" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7200_video1_Bx.bin >/dev/stapi/lxload
  fi
 fi
 if [ "$1" = "video2" ] ; then
  if [ "$chipset" = "STx7200" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7200_video2_Bx.bin >/dev/stapi/lxload
  fi
 fi
 if [ "$1" = "audio1" ] ; then
  if [ "$chipset" = "STx5206" ] ; then
   cat $MODULES_INSTALL_DIR/companion_5206_audio.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7100" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7100_audio.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7105" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7105_audio.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7106" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7106_audio.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7108" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7108_audio.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7109" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7109_audio.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7111" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7111_audio.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7141" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7141_audio.bin >/dev/stapi/lxload
  fi
  if [ "$chipset" = "STx7200" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7200_audio1.bin >/dev/stapi/lxload
  fi
 fi
 if [ "$1" = "audio2" ] ; then
  if [ "$chipset" = "STx7200" ] ; then
   cat $MODULES_INSTALL_DIR/companion_7200_audio2.bin >/dev/stapi/lxload
  fi
 fi
 rmmod lxload
}

# Insert separate STAPI modules
# -----------------------------
insert_separated_modules()
{
cat $LOAD_MODULES_LIST | grep -v "^#" | (while read mode mod_file node_name param; do
 if [ "$mode" != "-" ] ; then
  if [ "$mode" != "$MODE" ] ; then
   continue
  fi
 fi
 if [ "$param" = "-" ] ; then
  param=""
 fi
 if [ ! -f $MODULES_INSTALL_DIR/$mod_file ] ; then
  continue
 fi
 output=$(insmod $MODULES_INSTALL_DIR/$mod_file $param 2>&1 | cat)
 [ "$output" != "" ] && { echo "$output" | grep "File exists" >/dev/null && echo "Warning : $mod_file already inserted, skipping" || { echo "$output" ; exit 1 ; } ; }
 if [ ! "$node_name" = "-" ] ; then
  create_node "$node_name"
 fi
 if [ "$node_name" = "lxload" ] ; then
  define_chip_info
  if [ "$param" = "type=video1" ] ; then
   load_firmware "video1"
  fi
  if [ "$param" = "type=video2" ] ; then
   load_firmware "video2"
  fi
  if [ "$param" = "type=audio1" ] ; then
   load_firmware "audio1"
  fi
  if [ "$param" = "type=audio2" ] ; then
   load_firmware "audio2"
  fi
 fi
 done)
}

# Insert unique STAPI module
# --------------------------
insert_unified_module()
{
 # We are first inserting stsys_ioctl because we need it to know the chip and cut
 echo "* Looking for chipset model and version..."
 insmod $MODULES_INSTALL_DIR/stos_core.ko
 insmod $MODULES_INSTALL_DIR/stsys_ioctl.ko
 define_chip_info
 rmmod stsys_ioctl
 echo "  $chipset $chipver detected ($MODE)"

 # Now, we load video firmware
 echo "* Loading companions"
 insmod $MODULES_INSTALL_DIR/lxload.ko type=video1
 create_node lxload
 load_firmware "video1"
 insmod $MODULES_INSTALL_DIR/lxload.ko type=audio1
 create_node lxload
 load_firmware "audio1"
 rmmod stos_core

 # Now we load multicom
 echo "* Inserting Multicom"


 insmod $MODULES_INSTALL_DIR/embxshell.ko  || return 1
 insmod $MODULES_INSTALL_DIR/embxloopback.ko  || return 1
 insmod $MODULES_INSTALL_DIR/embxmailbox.ko mailbox0=0xFE211000:136:set2 mailbox1=0xFE212000:137:set2  || return 1
 insmod $MODULES_INSTALL_DIR/embxshm.ko mailbox0=TransportVideo0:0:3:0x00000000:0:20:20:0:256:0x40000000:0x40000000 mailbox1=TransportAudio1:0:5:0x00000000:0:20:20:0:256:0x40000000:0x40000000 || return 1

 insmod $MODULES_INSTALL_DIR/mme_host.ko transport0=TransportVideo0 transport1=TransportAudio1 || return 1

#insmod $MODULES_INSTALL_DIR/embxshell.ko  || return 1
 #insmod $MODULES_INSTALL_DIR/embxloopback.ko  || return 1
 #cat $LOAD_MODULES_LIST | grep "embxmailbox\.ko" | grep "$MODE" | while read mode mod_file node_name param; do
# insmod $MODULES_INSTALL_DIR/embxmailbox.ko "$param"; done
# cat $LOAD_MODULES_LIST | grep "embxshm\.ko"  | grep "$MODE"| while read mode mod_file node_name param; do
 #insmod $MODULES_INSTALL_DIR/embxshm.ko "$param"; done
 #cat $LOAD_MODULES_LIST | grep "mme_host\.ko" | while read mode mod_file node_name param; do
# insmod $MODULES_INSTALL_DIR/mme_host.ko "$param"; done

 # Now we load STAPI and create nodes
 echo "* Inserting STAPI Module"
 insmod $MODULES_INSTALL_DIR/stapi_core_stripped.ko || return 1
 if [ "$1" != "no_stapi_ioctl" ] ; then
  insmod $MODULES_INSTALL_DIR/stapi_ioctl_stripped.ko || return 1
 else
  insmod $MODULES_INSTALL_DIR/stpti4_ioctl.ko || return 1
 fi

 if [ "$1" != "no_stapi_ioctl" ] ; then
  echo "* Creating device nodes in /dev/stapi"
  cat $LOAD_MODULES_LIST | grep -v "^#" | grep -v lxload | (while read mode mod_file node_name param; do
  if [ ! "$node_name" = "-" ] ; then
   create_node $node_name
  fi
  done)
 fi
}

# Choose between inserting severall or unified module
# ---------------------------------------------------
if [ $# -eq 0 ] || [ "$1" != "not_unified" ]; then
 if [ -f "$MODULES_INSTALL_DIR/stapi_core_stripped.ko" ] && [ -f "$MODULES_INSTALL_DIR/stapi_ioctl_stripped.ko" ]; then
  insert_unified_module $1
 else
  insert_separated_modules
 fi
else
 insert_separated_modules
fi
