#!/bin/sh

if [ ! -d /var/log/lighttpd ]; then
	mkdir -p /var/log/lighttpd
fi

if [ ! -d /application/lighttpd ]; then
	if [ -f /application/lighttpd.tgz ]; then
		cd /application
		tar zxvf lighttpd.tgz
		sync
	fi
fi

if [ ! -L /lib/libpcre.so.1 ]; then
	if [ -f /lib/libpcre.so ]; then
		ln -s /lib/libpcre.so /lib/libpcre.so.1
		sync
	fi
fi

#mount the /tmp to 50M size         
/bin/mount -t tmpfs -o size=50m tmpfs /tmp