MSLIB_PATH=/vendor/lib
PBI_LIB=/application/shared_lib
export LD_LIBRARY_PATH=$PBI_LIB:$MSLIB_PATH:$MSLIB_PATH/dtcp:$MSLIB_PATH/ipc_svc:$MSLIB_PATH/qtwebkit:$MSLIB_PATH/directfb-1.4-0:$MSLIB_PATH/utopia:$MSLIB_PATH/directfb-1.4-0/systems:$MSLIB_PATH/directfb-1.4-0/wm:$MSLIB_PATH/directfb-1.4-0/inputdrivers:$MSLIB_PATH/directfb-1.4-0/gfxdrivers:$MSLIB_PATH/directfb-1.4-0/interfaces/IDirectFBFont:$MSLIB_PATH/directfb-1.4-0/interfaces/IDirectFBImageProvider:$MSLIB_PATH/directfb-1.4-0/interfaces/IDirectFBVideoProvider:$MSLIB_PATH/qt/plugins/gfxdrivers/:$MSLIB_PATH/gstreamer-0.10/:$MSLIB_PATH/boost/:$MSLIB_PATH/ipc_mm:$MSLIB_PATH/drmagent:$MSLIB_PATH/WVCENC
export PATH=$PATH:$TOOL_PATH
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$TOOL_PATH

#setup coredump related
mkdir -p /usb/sda1

ulimit -s 8192
ulimit -c unlimited > /dev/null 2>&1

#mount the /var to 50M size
/bin/mount -t tmpfs -o size=50m tmpfs /var
#create directory

mkdir -p /var/ftp/pub  /var/log  /var/www /var/run
chmod 777 /var/ftp/pub

mkdir -p /usr/share/empty/
chmod 777 /usr/share/empty
touch /var/password

if [ ! -d /application/shared_lib ];then
	echo "mk shared lib dir"
	mkdir /application/shared_lib
fi

if [ ! -d /application/usb ]; then
	echo "mkdir usb dir"
	mkdir /application/usb
fi

#init web pages
if [ ! -d "/application/web" ]; then	
	if [ -f "/application/web.tar.gz" ]; then
		tar xvf /application/web.tar.gz -C /application
		if [ -f /application/logo_oem.png ]; then
	  		mv /application/logo_oem.png /application/web/images/
	  		sync
		fi 
	fi	
fi

#ssh config
if [ ! -d /etc/dropbear ];then
	echo "mk ssh config dir"
	mkdir /etc/dropbear
fi
if [ ! -f /etc/dropbear/dropbear_rsa_host_key ];then
	echo "create ras key"
	dropbearkey -t rsa -f /etc/dropbear/dropbear_rsa_host_key
fi
if [ ! -f /etc/dropbear/dropbear_dss_host_key ];then
	echo "create ras key"
	dropbearkey -t dss  -f /etc/dropbear/dropbear_dss_host_key
fi

#ip address config
/sbin/ifconfig   lo 127.0.0.1

/sbin/ifconfig eth0 10.10.70.48 netmask 255.255.255.0

#service start
tcpsvd 0 21 ftpd -w /var/ftp/pub &

#ssh run
/usr/bin/dropbear

#load script
if [ ! -d /application/run.d ]; then
	echo "mkdir run.d"
	mkdir /application/run.d
fi
for file in /application/run.d/*
do
	if test -f $file; then
		$file
	fi
done

#
read -n1 -p "delay 3s, press key 'q' or 'n' to quit :" -t 3 inkey
case $inkey in
	q|n)
	echo "quit";exit;;
	*)
	;;
esac

/application/pbiapp
