
function getCellRow(eTd){
	return eTd.parentElement.parentElement;
}

function getCellRowIdx(eTd){
	return eTd.parentElement.parentElement.rowIndex;
}

function getTypeName(obj){
	return Object.prototype.toString.call(obj);
}

function isArray(obj){
	if(0)
	return (obj instanceof Array);
	else
	return (getTypeName(obj) == "[object Array]");
}

function addObjItem(obj, name, value){
	if(obj==undefined){
			return;
	}
	if(obj[name]==undefined){
		obj[name] = value;
	}else if(isArray(obj[name])){
		obj[name].push(value);
	}else{
		var tmp = obj[name];
		obj[name] = [];
		obj[name].push(tmp);
		obj[name].push(value);
	}
}

function delObjItem(obj, name){
	if(obj==undefined){
			return;
	}
	if(obj[name]==undefined){
		return;
	}else if(isArray(obj[name])){
		var attrVal = obj[name].pop;
		delete attrVal;
	}else{
		delete obj[name];
	}
}

function EditorTableCell(){
	this.eTd;
	this.row;
	this.colSpan = 1;
	this.flag = 0;
	this.type;
	this.eleQty = 1;
	
	if(arguments.length>0){
		this.type = arguments[0];
	}

	if(arguments.length>1){
		this.eleQty = arguments[1];
	}
}


EditorTableCell.ORIGINAL = 0;
EditorTableCell.TAG = 1;
EditorTableCell.TEXT = 2;
EditorTableCell.SELECT = 3;
EditorTableCell.IMAGE = 4;
EditorTableCell.BUTTON = 5;                   
EditorTableCell.RADIO = 6;                   
EditorTableCell.CHECKBOX = 7;
EditorTableCell.INLINEEDIT = 8;

EditorTableCell.InlineEditBlur = function(){
	//console.log(this.flag);
	if(this.flag == 0){
		return;
	}
	this.flag = 0;

	var eTxt = this.eTd.children[0];
	var txVal = eTxt.value;

	//console.log(txVal);
	
	this.eTd.removeChild(eTxt);
	this.eTd.innerHTML = txVal;
}

EditorTableCell.InlineEditDblclick = function(){
	//console.log(this);
	if(this.flag){
		return;
	}
	this.flag = 1;

	var eTxt = document.createElement("input");
	eTxt.type = "text";
	eTxt.value = this.eTd.innerHTML;
	eTxt.onblur = EditorTableCell.InlineEditBlur.bind(this);
	this.eTd.innerHTML = "";
	this.eTd.appendChild(eTxt);
	eTxt.focus();
}

EditorTableCell.prototype.setEtd = function(eTd){
	var etbCell = this;
	this.eTd = eTd;
	
	eTd.className = "editTable-row-cell";


}

removeString = function(stringObj, removeText, keySep, endChar){
	if(( typeof stringObj != "string") || (stringObj.length<=0)){
		return stringObj;
	}
	if(( typeof removeText != "string") || (removeText.length<=0)){
		return stringObj;
	}
	
	var keyStr;
	if(( typeof keySep != "string") || (keySep.length<=0)){
		keyStr = removeText;
	}else{
		var keyArr = removeText.split(keySep);
		//console.log(getTypeName(keyArr));
		keyStr = keyArr[0];
	}

	
	var regEx, retStr;

	//console.log(keyStr+": ----- : "+stringObj);
	var idx = stringObj.indexOf(keyStr);
	//console.log(stringObj+".indexOf("+keyStr+") : "+idx);
	if(idx>=0){
		regEx = new RegExp(keyStr+"[ \\t]*"+"["+keySep+"]?[ \\t]*\\w*["+endChar+"]?", "ig");
		retStr = stringObj.replace(regEx, "");
	}
	//console.log("===== : "+retStr);
	
	return retStr;
}

addReplaceString = function(stringObj, replaceText, keySep, endChar){
	
	//console.log(typeof stringObj);
	if(( typeof stringObj != "string") || (stringObj.length<=0)){
		return replaceText;
	}

	if(( typeof replaceText != "string") || (replaceText.length<=0)){
		return stringObj;
	}
	

	var keyStr;
	if(( typeof keySep != "string") || (keySep.length<=0)){
		keyStr = replaceText;
	}else{
		var keyArr = replaceText.split(keySep);
		//console.log(getTypeName(keyArr));
		keyStr = keyArr[0];
	}

	var regEx, retStr;
	
	//console.log(keyStr + ": ----- : "+stringObj);

	var idx = stringObj.indexOf(keyStr);
	//console.log(stringObj+".indexOf("+keyStr+") : "+idx);
	if(idx<0){
		if(stringObj.charAt[stringObj.length-1] != endChar)
			retStr = stringObj + endChar +replaceText;
		else
			retStr = stringObj + replaceText;
	}else{
		regEx = new RegExp(keyStr+"[ \\t]*"+"["+keySep+"]?[ \\t]?\\w*["+endChar+"]?", "ig");
		retStr = stringObj.replace(regEx, replaceText);
	}
	//console.log("===== : "+retStr);

	return retStr;
}

hiddenDOMElement = function(ele){
	
	//console.log("----- cssText : "+ele.style.cssText);
	ele.style.cssText = addReplaceString(ele.style.cssText, "display:none;", ":", ";");
	//console.log("===== cssText : "+ele.style.cssText);

}

showDOMElement = function(ele){
	//console.log("***** cssText : "+ele.style.cssText);
	ele.style.cssText = removeString(ele.style.cssText, "display:block;", ":", ";");
	//console.log("##### cssText : "+ele.style.cssText);

}

EditorTableCell.prototype.setEtdValue = function(data){
	if(data == undefined){
		return;
	}
	if(isArray(data)){
		var len = data.length;
		for(var i=0; i<len; i++){
			if(data[i] instanceof HTMLElement){
				this.eTd.appendChild(data[i]);
			}
		}
	}else{
		if(data instanceof HTMLElement){
			this.eTd.appendChild(data);
		}else{
			this.eTd.innerHTML = data;
		}
	}

}
EditorTableCell.prototype.show = function(){
	showDOMElement(this.eTd);
}

EditorTableCell.prototype.hidden = function(){
	hiddenDOMElement(this.eTd);
}

EditorTableCell.prototype.createEle = function (){
	var i,ele;
	switch(this.type){
		case EditorTableCell.ORIGINAL :
			break;
		case EditorTableCell.TAG :
			for(i=0; i<this.eleQty; i++){
				ele = document.createElement("span");
				this.eTd.appendChild(ele);
			}
			break;
		case EditorTableCell.TEXT :
			for(i=0; i<this.eleQty; i++){
				ele = document.createElement("input");
				ele.type = "text"
				this.eTd.appendChild(ele);
			}
			break;
		case EditorTableCell.SELECT :
			for(i=0; i<this.eleQty; i++){
				ele = document.createElement("select");
				this.eTd.appendChild(ele);
			}
			break;
		case EditorTableCell.IMAGE :
			for(i=0; i<this.eleQty; i++){
				ele = document.createElement("img");
				this.eTd.appendChild(ele);
			}
			break;
		case EditorTableCell.BUTTON :
			for(i=0; i<this.eleQty; i++){
				ele = document.createElement("button");
				this.eTd.appendChild(ele);
			}
			break;
		case EditorTableCell.RADIO :
			for(i=0; i<this.eleQty; i++){
				ele = document.createElement("input");
				ele.type = "radio";
				this.eTd.appendChild(ele);
			}
			break;
		case EditorTableCell.CHECKBOX :
			for(i=0; i<this.eleQty; i++){
				ele = document.createElement("input");
				ele.type = "checkbox";
				this.eTd.appendChild(ele);
			}
			break;
		case EditorTableCell.INLINEEDIT :
			this.eTd.ondblclick = EditorTableCell.InlineEditDblclick.bind(this);

			break;
		default :
			break;
	}
}


EditorTableCell.prototype.setTagData = function(cellObj, data){
	cellObj.innerHTML = data;
}


EditorTableCell.prototype.setTextData = function(cellObj, data){
	cellObj.value = data;
}

EditorTableCell.prototype.setSelectData = EditorTableCell.prototype.setTextData;

EditorTableCell.prototype.setImageData = function(cellObj, data){
	cellObj.src = data;
}

EditorTableCell.prototype.setButtonData = EditorTableCell.prototype.setTagData;

EditorTableCell.prototype.setRadioData = function(cellObj, data){
	//cellObj.checked = Boolean(data);
	cellObj.checked = !!data;
}
            
EditorTableCell.prototype.setCheckboxData = EditorTableCell.prototype.setRadioData;

EditorTableCell.prototype.setData = function (){

	var i, idx, data;
	var values, qty;
	var cellObjs = this.eTd.children;
	if(arguments.length<=1){
		idx = 0;
		data = arguments[0];
	}else{
		idx = arguments[0];
		data = arguments[1];
	}


	if(data == undefined){
		return;
	}

	if(isArray(data)){
		values = data;
		qty = values.length;
	}else{
		qty = 1;
		values = [];
		values[0] = data;
	}

	switch(this.type){
		case EditorTableCell.ORIGINAL :
			this.setEtdValue(values[0]);
			break;
		case EditorTableCell.TAG :
			for(i=0;i<qty; i++){
				this.setTagData(cellObjs[idx+i], values[i]);
			}
			break;
		case EditorTableCell.TEXT :
			for(i=0;i<qty; i++){
				this.setTextData(cellObjs[idx+i], values[i]);
			}
			break;
		case EditorTableCell.SELECT :
			for(i=0;i<qty; i++){
				this.setSelectData(cellObjs[idx+i], values[i]);
			}
			break;
		case EditorTableCell.IMAGE :
			for(i=0;i<qty; i++){
				this.setImageData(cellObjs[idx+i], values[i]);
			}
			break;
		case EditorTableCell.BUTTON :
			for(i=0;i<qty; i++){
				this.setButtonData(cellObjs[idx+i], values[i]);
			}
			break;
		case EditorTableCell.RADIO :
			for(i=0;i<qty; i++){
				this.setRadioData(cellObjs[idx+i], values[i]);
			}
			break;
		case EditorTableCell.CHECKBOX :
			for(i=0;i<qty; i++){
				this.setCheckboxData(cellObjs[idx+i], values[i]);
			}
			break;
		default :
			this.setEtdValue(values[0]);
			break;
	}
}


EditorTableCell.prototype.addSelectOption = function (){

}

EditorTableCell.prototype.getEtdValue = function(){
	return	this.eTd.innerHTML;
}

EditorTableCell.prototype.getTagData = function(cellObj){
	return cellObj.innerHTML;
}


EditorTableCell.prototype.getTextData = function(cellObj){
	return cellObj.value;
}

EditorTableCell.prototype.getSelectData = EditorTableCell.prototype.getTextData;

EditorTableCell.prototype.getImageData = function(cellObj){
	return cellObj.src;
}

EditorTableCell.prototype.getButtonData = EditorTableCell.prototype.getTagData;

EditorTableCell.prototype.getRadioData = function(cellObj){
	return cellObj.checked;
}
            
EditorTableCell.prototype.getCheckboxData = EditorTableCell.prototype.getRadioData;


EditorTableCell.prototype.getData = function (){

	var cellObj;
	if(arguments.length<1){
		cellObj = this.eTd.children[0];
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];
	}

	switch(this.type){
		case EditorTableCell.ORIGINAL :
			return this.getEtdValue();
		case EditorTableCell.TAG :
			return this.getTagData(cellObj);
		case EditorTableCell.TEXT :
			return this.getTextData(cellObj);
		case EditorTableCell.SELECT :
			return this.getSelectData(cellObj);
		case EditorTableCell.IMAGE :
			return this.getImageData(cellObj);
		case EditorTableCell.BUTTON :
			return this.getButtonData(cellObj);
		case EditorTableCell.RADIO :
			return this.getRadioData(cellObj);
		case EditorTableCell.CHECKBOX :
			return this.getCheckboxData(cellObj);
        case EditorTableCell.INLINEEDIT :
			return this.getTextData(cellObj);
		default :
			return this.getEtdValue();
	}
};

EditorTableCell.prototype.setClass = function (){
	var cellObj, className;
	if(arguments.length<=1){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
		className = arguments[0];
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];
		className = arguments[1];
	}
	
	if(className == undefined){
		return;
	}
	cellObj.className = className;
}

EditorTableCell.prototype.setStyle = function (){
	var cellObj, style;
	if(arguments.length<=1){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
		style = arguments[0];
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];
		style = arguments[1];
	}

	if(style == undefined){
		return;
	}

	cellObj.style.cssText = style;
}

EditorTableCell.prototype.addClass = function (){
	var cellObj, className;
	if(arguments.length<=1){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
		className = arguments[0];
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];
		className = arguments[1];
	}
//	console.log(cellObj.className);

	cellObj.className = addReplaceString(cellObj.className, className, "", " ");

}


EditorTableCell.prototype.removeClass = function (){
	var cellObj, className, regEx;
	if(arguments.length<=1){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
		className = arguments[0];
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];
		className = arguments[1];
	}

	cellObj.className = removeString(cellObj.className, className, "", " ");

}

EditorTableCell.prototype.removeStyle = function (){
	var cellObj, style, regEx;
	if(arguments.length<=1){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
		style = arguments[0];
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];
		style = arguments[1];
	}

	if(style == undefined){
		return;
	}

	cellObj.style.cssText = removeString(cellObj.style.cssText, style, ":", ";");
}


EditorTableCell.prototype.addStyle = function (){
	var cellObj, style;
	if(arguments.length<=1){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
		style = arguments[0];
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];
		style = arguments[1];
	}

	if(style == undefined){
		return;
	}

	cellObj.style.cssText = addReplaceString(cellObj.style.cssText, style, ":", ";");

}

EditorTableCell.prototype.getClass = function (){
	var cellObj;
	if(arguments.length==0){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];
	}
	
	return cellObj.className;
}

EditorTableCell.prototype.getStyle = function (){
	var cellObj;
	if(arguments.length==0){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];
	}
	return cellObj.style;
}

EditorTableCell.prototype.setEvent = function (){
	var cellObj;
	var evName, evAction;
	if(arguments.length==0){
		return;
	}
	if(arguments.length<=2){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
		evName = arguments[0];
		evAction = arguments[1];
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];
		evName = arguments[1];
		evAction = arguments[2];
	}

	cellObj[evName] = evAction;
}

EditorTableCell.prototype.addEvent = function (){
	var cellObj;
	var evName, evAction, isDoInCap;
	if(arguments.length==0){
		return;
	}
	if(arguments.length<=3){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
		evName = arguments[0];
		evAction = arguments[1];
		isDoInCap = arguments[2];
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];;
		evName = arguments[1];
		evAction = arguments[2];
		isDoInCap = arguments[3];
	}
	if(isDoInCap == undefined){
		isDoInCap = false;
	}else{
		isDoInCap = !!isDoInCap;
	}
	cellObj.addEventListener(evName, evAction, isDoInCap);
}

EditorTableCell.prototype.delEvent = function (){
	var cellObj;
	var evName, evAction, isDoInCap;
	if(arguments.length==0){
		return;
	}
	if(arguments.length<=3){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
		evName = arguments[0];
		evAction = arguments[1];
		isDoInCap = arguments[2];
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];;
		evName = arguments[1];
		evAction = arguments[2];
		isDoInCap = arguments[3];
	}

	cellObj.removeEventListener(evName, evAction, isDoInCap);
}


EditorTableCell.prototype.setAttr = function (){
	var cellObj, attName, attValue;
	if(arguments.length<=2){
		if(this.type>0){
			cellObj = this.eTd.children[0];
		}else{
			cellObj = this.eTd;
		}
		attName = arguments[0];
		attValue = arguments[1];
	}else{
		var idx = arguments[0];
		cellObj = this.eTd.children[idx];
		attName = arguments[1];
		attValue = arguments[2];
	}
	
	cellObj[attName] = attValue;

}

EditorTableCell.prototype.getRowIdx = function(){
	return this.eTd.parentElement.rowIndex;
}

EditorTableCell.prototype.free = function(){
	var i, optqty;
	
	delete this;
}

EditorTableCell.prototype.remove = function(){

	if(this.eTd instanceof HTMLTableRowElement){
		this.row.eTr.removeChild(this.eTd);
	}
	
	this.free();

}

function EditorTableRow(){
	this.table;
	this.eTr;
	this.cells = [];
}
//[object HTMLTableRowElement]

EditorTableRow.prototype.insertCell = function(idx){

	var etbCell, eTd;

	if(idx>=this.cells.length){
		return null;
	}

	if(arguments[1] instanceof EditorTableCell){

		etbCell = arguments[1];
		if(getTypeName(etbCell.eTd) != "[object HTMLTableCellElement]"){
			eTd = this.eTr.insertCell(idx);
			etbCell.setEtd(eTd);
		}else{
			this.cells[idx].eTd.insertBefore(etbCell.eTd);
		}
		
	}else{
		
		etbCell = new EditorTableCell();
		eTd = this.eTr.insertCell(idx);
		etbCell.setEtd(eTd);
	
		if(arguments.length>1){
			etbCell.type = arguments[1];
		}
		
		if(arguments.length>2){
			etbCell.eleQty = arguments[2];
		}

		if(arguments.length>3){
			etbCell.setEtdValue(arguments[3]);
		}

		if(arguments.length>4){
			etbCell.colSpan = arguments[4];
		}
		
	}
	etbCell.row = this;
	this.cells.splice(idx, 0, etbCell);

	return etbCell;
}

EditorTableRow.prototype.addCell = function(){

	var etbCell, eTd;

	if(this.cells.length>=this.table.col){
		return null;
	}

	if(arguments[0] instanceof EditorTableCell){

		etbCell = arguments[0];
		if(getTypeName(etbCell.eTd) != "[object HTMLTableCellElement]"){
			eTd = document.createElement("td");
			etbCell.setEtd(eTd);
		}
		
	}else{
		
		etbCell = new EditorTableCell();
		eTd = document.createElement("td");
		etbCell.setEtd(eTd);

//		console.log("addCell : "+eTd);

		if(arguments.length>0){
			etbCell.type = arguments[0];
		}

		if(arguments.length>1){
			etbCell.eleQty = arguments[1];
		}

		if(arguments.length>2){
			etbCell.setEtdValue(arguments[2]);
		}

		if(arguments.length>3){
			etbCell.colSpan = arguments[3];
		}
		
		
	}
	
	if((etbCell.type > 0) && (eTd.children.length == 0)){
		etbCell.createEle();
	}

	etbCell.row = this;
	this.cells.push(etbCell);
	this.eTr.appendChild(etbCell.eTd);

	return etbCell;
}

EditorTableRow.prototype.setCell = function(idx){
	var i, eTd, cellqty;
	var etbCell, newCell;

	if(idx>=this.table.col){
		return;
	}

	cellqty = this.cells.length;
	if(idx>=cellqty){
		for(i=cellqty-1; i<idx; i++){
			this.addCell();
		}
	}

	etbCell = this.cells[idx];
	
	if(!(etbCell instanceof EditorTableCell)){
		return;
	}

	if(arguments[1] instanceof EditorTableCell){
		newCell = arguments[1];
		
		if(getTypeName(newCell.eTd) == "[object HTMLTableCellElement]"){
			etbCell.eTd.replaceNode(newCell.eTd);
		}
		etbCell.free();
		this.cells[idx] = newCell;
		newCell.row = this;
		
	}else{
		if(arguments.length>1){
			etbCell.setEtdValue(arguments[1]);
		}
		if(arguments.length>2){
			etbCell.setEtdValue(arguments[2]);
		}
		if(arguments.length>3){
			etbCell.colSpan = arguments[3];
		}

	}
}

EditorTableRow.prototype.delCell = function(){

	if(arguments<=0){
		return;
	}
	var etbCell, cellqty, idx = -1;

	//alert(arguments[0]);
	if(typeof arguments[0] == "number"){
		idx = arguments[0];
		etbCell = this.cells[idx];
	}else{
		etbCell = arguments[0];
	}

	if(!(etbCell instanceof EditorTableCell)){
		return;
	}
	
	this.eTr.removeChild(etbCell.eTd);
	if(idx>=0){
		this.cells.splice(idx,1);
		etbCell.free();
	}else{
		cellqty = this.cells.length;
		for(idx=0; idx<cellqty; idx++){
			if(etbCell == this.cells[idx]){
				etbCell.free();
				this.cells.splice(idx,1);
				break;
			}
		}	
	}
}

EditorTableRow.prototype.getCell = function(col){
	return this.cells[col];
}

EditorTableRow.prototype.getCellEle = function(col){
	var cell = this.cells[col];
	if(cell.type>0){
		if(arguments.length>1){
			return cell.eTd.children[arguments[1]];
		}else{
			return cell.eTd.children[0];
		}
	}else{
		return cell.eTd;
	}
}

EditorTableRow.prototype.setCellData = function(col){
	var cell = this.cells[col];
	if(arguments.length>2){
		cell.setData(arguments[1], arguments[2]);
	}else{
		cell.setData(arguments[1]);
	}
}


EditorTableRow.prototype.getCellData = function(col){
	var cell = this.cells[col];
	if(arguments.length>1){
		return cell.getData(arguments[1]);
	}else{
		return cell.getData();
	}
}


function domTableToEditorTable(eTable){
	var eRows = eTable.rows;
	var isHead;
	var rowqty, cellqty;
	rowqty = eRows.length;
	for(var i=0; i<rowqty; i++){

		if(eRows[i].nodeName != "TR"){
			continue;
		}
		
		var eCells = eRows[i].cells;
		var etbRow = new EditorTableRow();

		etbRow.table = this;
		etbRow.eTr = eRows[i];
		isHead = false;
		cellqty = eCells.length;
		for(var j=0; j<cellqty; j++){
			
			if(eCells[j].nodeName == "TH"){
				isHead = true;
			}else if(eCells[j].nodeName != "TD"){
				continue;
			}

			var etbCell = new EditorTableCell(0);
			
			etbCell.row = etbRow;
			etbCell.eTd = eCells[j];
			if(isHead){
				etbCell.eTd.className = "editTable-row-cell editTable-hd-cell-text";
			}else{
				etbCell.eTd.className = "editTable-row-cell";
			}
			etbCell.colSpan = eCells[j].colSpan;

			etbRow.cells.push(etbCell);

		}

		if(isHead){
			this.head = etbRow;
			etbRow.eTr.className = "editTable-hd-header";
			this.col = etbRow.cells.length;
		}else{
			this.rows.push(etbRow);
			etbRow.eTr.className = "editTable-row";
		}
	}
}


function EditorTableCellModel(type){
	this.type = type;
	this.eleQty = 1;
	this.data;
	this.events;
	this.attrs;
	this.className;
	this.style;
	this.id;
	this.name;

	if(arguments.length>1){
		this.eleQty = arguments[1];
	}
	if(arguments.length>2){
		this.data = arguments[2];
	}
}

EditorTableCellModel.prototype.addEvent = function(){
	var idx, evName, evAction;

	if(arguments.length>3){
		idx = arguments[0];
		evName = arguments[1];
		evAction = arguments[2];
		if(this.events == undefined){
			this.events = [];
		}
		if(this.events[idx] == undefined){
			this.events[idx] = {};
		}
		addObjItem(this.events[idx], evName, evAction);
	}else{
		idx = 0;
		evName = arguments[0];
		evAction = arguments[1];
		if(isArray(this.events)){
			if(this.events == undefined){
				this.events = [];
			}
			if(this.events[idx] == undefined){
				this.events[idx] = {};
			}
			addObjItem(this.events[idx], evName, evAction);
		}else{
			if(this.events == undefined){
				this.events = {};
			}
			addObjItem(this.events, evName, evAction);
		}
	}
		
}

EditorTableCellModel.prototype.delEvent = function(){
	var idx, evName;

	if(arguments.length>2){
		idx = arguments[0];
		evName = arguments[1];
		delObjItem(this.events[idx], evName);
	}else{
		idx = 0;
		evName = arguments[0];
		if(isArray(this.events)){
			delObjItem(this.events[idx], evName);
		}else{
			delObjItem(this.events, evName);
		}
	}
}


EditorTableCellModel.prototype.setAttr = function(){
	var idx, attName, attVal;

	if(arguments.length>2){
		idx = arguments[0];
		attName = arguments[1];
		attVal = arguments[2];
		if(this.attrs == undefined){
			this.attrs = [];
		}
		if(this.attrs[idx] == undefined){
			this.attrs[idx] = {};
		}
		this.attrs[idx][attName] = attVal;
	}else{
		idx = 0;
		attName = arguments[0];
		attVal = arguments[1];
		if(isArray(this.attrs)){
			if(this.attrs == undefined){
				this.attrs = [];
			}
			if(this.attrs[idx] == undefined){
				this.attrs[idx] = {};
			}
			this.attrs[idx][attName] = attVal;
		}else{
			if(this.attrs == undefined){
				this.attrs = {};
			}
			this.attrs[attName] = attVal;
		}
		
	}
	
};

function setObjProperty(propName){
	var idx, value;
	if(arguments.length>2){
		idx = arguments[1];
		value = arguments[2];
		if(this[propName] == undefined){
			this[propName] = [];
		}
		this[propName][idx] = value;
	}else{
		idx = 0;
		value = arguments[1];
		if(isArray(this[propName])){
			if(this[propName] == undefined){
				this[propName] = [];
			}
			this[propName][idx] = value;
		}else{
			this[propName] = value;
		}

	}
	
}

EditorTableCellModel.prototype.setClass = function(){
	if(arguments.length>1){
		setObjProperty.call(this, "className", arguments[0], arguments[1]);
	}else{
		setObjProperty.call(this, "className", arguments[0]);
	}
}

EditorTableCellModel.prototype.setStyle = function(){
	if(arguments.length>1){
		setObjProperty.call(this, "style", arguments[0], arguments[1]);
	}else{
		setObjProperty.call(this, "style", arguments[0]);
	}
}


function EditorTable(){
	
	this.head;
	this.rows = [];
	this.col = 0;
	this.cellModel = [];

	this.cursor = 'e-resize';        
	this.isStrict = document.compatMode == 'CSS1Compat';
	this.data = { ex: 0, w: 0, elm: null, drag: false, ow: 0, oleft: 0 };
	
	this.span = 5;

	if(arguments.length>1){
		this.eId = arguments[0];
		this.col = arguments[1];
	}else if(arguments.length>0){
		this.eTable = arguments[0];	
	}

	if(getTypeName(this.eTable) != "[object HTMLTableElement]"){
		if(typeof this.eId == "undefined")
			this.eId = this.eTable;
		this.eTable = document.createElement("table");
		this.eTable.className = "editorgrid";

	}else{
		this.eId = this.eTable.id;
		domTableToEditorTable.call(this, this.eTable);
	}

}

EditorTable.prototype.setHead = function(){

	var etbRow, etbCell;
	var i, col, idx;
	if(arguments.length>0){
		
	}
	
	if(this.head){
		etbRow = this.head;
	}else{
		etbRow = new EditorTableRow();
		this.head = ethRow;
		//etbRow.eTr = document.createElement("tr");
		etbRow.eTr = this.eTable.insertRow(0);
	}

	etbRow.eTr.className = "editTable-header";

	etbRow.table = this;

	if((arguments.length>1) && (typeof arguments[0] == "number")){
		idx = arguments[0];
		etbRow.setCell(idx, 0, arguments[1]);
		return;
	}

	col = this.col;

	for(var i=0; i<arguments.length; i++){
		etbCell = etbRow.cells[i];
		if(!(etbCell instanceof EditorTableCell)){
			etbCell = new EditorTableCell(0);
			etbRow.cells[i] = etbCell;
			etbCell.eTd = document.createElement("td");
			etbCell.row = etbRow;
		}
	}

	for(; i<col; i++){
		etbRow.delCell(i);
	}
	

}

EditorTable.prototype.setRows = function(){

	//alert(getTypeName(this[fName]));
	
	document.createElement("tr");

	addObjItem(this, fName, fValue);

	//alert(this[fName]);
}

EditorTable.prototype.insertRow = function(idx){

	//alert(getTypeName(this[fName]));
	var etbRow = new EditorTableRow();
	//etbRow.eTr = document.createElement("tr");
	etbRow.eTr = this.eTable.insertRow(idx);
	etbRow.eTr.className = "editTable-row";
	etbRow.table = this;
	
	etbRow.eTr.onmouseover = EditorTableRowMouseover;
	etbRow.eTr.onmouseout = EditorTableRowMouseout;

	//this.rows[idx].insertBefore

	this.rows.splice(idx,0, etbRow);
	return etbRow;
}


EditorTable.prototype.addRow = function(){

	//alert(getTypeName(this[fName]));
	var etbRow = new EditorTableRow();
	etbRow.eTr = document.createElement("tr");
	etbRow.eTr.className = "editTable-row";
	etbRow.table = this;

	etbRow.eTr.onmouseover = EditorTableRowMouseover;
	etbRow.eTr.onmouseout = EditorTableRowMouseout;

	this.eTable.appendChild(etbRow.eTr);

	this.rows.push(etbRow);

	return etbRow;
}


EditorTable.prototype.delRow = function(idx){

	idx = Number(idx);
	//alert(idx);
	var etbRow = this.rows[idx];
	//alert(this.rows.length);
	var cells = etbRow.cells.length;
	for(var i=0; i<cells; i++){
		etbRow.delCell(0);
	}

	//alert(getTypeName(etbRow.eTr));
	//this.eTable.removeChild(etbRow.eTr);
	//alert(idx+1);
	this.eTable.deleteRow(idx+1);
	this.rows.splice(idx,1);
	delete etbRow;

}

EditorTable.prototype.getCell = function(row, col){
	return this.rows[row].cells[col];
}


EditorTable.prototype.setCell = function(row, col, type, datas){
	this.rows[row].setCell(col, type, datas);
}


EditorTable.prototype.getCellEle = function(row, col){
	var cell = this.rows[row].cells[col];
	if(cell.type>0){
		if(arguments.length>2){
			return cell.eTd.children[arguments[2]];
		}else{
			return cell.eTd.children[0];
		}
	}else{
		return cell.eTd;
	}
}

EditorTable.prototype.setCellData = function(row, col){
	var cell = this.rows[row].cells[col];
	if(arguments.length>3){
		cell.setData(arguments[2], arguments[3]);
	}else{
		cell.setData(arguments[2]);
	}
}


EditorTable.prototype.getCellData = function(row, col){
	var cell = this.rows[row].cells[col];

	if(arguments.length>2){
		return cell.getData(arguments[2]);
	}else{
		return cell.getData();
	}
}

EditorTable.prototype.hiddenColumn = function(col){
	var cell, rows = this.rows;
	var rowqty = this.rows.length;
	this.head.cells[col].hidden();
	for(var i=0; i<rowqty; i++){
		row = rows[i].cells[col].hidden();
	}
}

EditorTable.prototype.showColumn = function(col){
	var cell, rows = this.rows;
	var rowqty = this.rows.length;
	this.head.cells[col].show();
	for(var i=0; i<rowqty; i++){
		row = rows[i].cells[col].show();
	}
}


EditorTable.prototype.empty = function(){

	while(this.rows.length>0){
		this.delRow(0);
	}
}

EditorTable.prototype.destroy = function(){

	while(this.rows.length>0){
		this.delRow(0);
	}

	while(this.head.cells.length>0){
		this.head.cells[0].free();
		this.head.cells.splice(0,1);
	}
	delete this;
}

EditorTable.prototype.addRowAsModel = function addEditorTableRow(){
	var etb = this;
	var i, j, cell, cellMod, celldata, rowsqty;
	var eleQty;
	rowsqty = etb.rows.length;

	var etbRow = etb.addRow();
	//var etbRow = etb.insertRow(rowsqty+1);

	for(i=0; i<etb.col; i++){
		cellMod = etb.cellModel[i];

		if(cellMod == undefined){
			cell = etbRow.addCell(0);
			continue;
		}
		celldata = cellMod.data;

		cell = etbRow.addCell(cellMod.type, cellMod.eleQty, celldata);
		var prop, events;
		if(isArray(cellMod.events)){
			eleQty = cellMod.events.length;
			for(j=0; j<eleQty; j++){
				events = cellMod.events[j];
				if(events == undefined){
					continue;
				}
				for(prop in events){
					if(!events.hasOwnProperty(prop)){
						continue;
					}else if(prop.match(/on+/)){
						cell.setEvent(j, prop, events[prop]);
					}else{
						cell.addEvent(j, prop, events[prop]);
					}
				}
			}
		}else{
			events = cellMod.events;
			eleQty = cellMod.eleQty;
			if(events){
				for(prop in events){
					if(!events.hasOwnProperty(prop)){
						continue;
					}else if(prop.match(/on+/)){
						for(j=0; j<eleQty; j++){
							cell.setEvent(j, prop, events[prop]);
						}
					}else{
						for(j=0; j<eleQty; j++){
							cell.addEvent(j, prop, events[prop]);
						}
					}
				}
			}

		}
		if(isArray(cellMod.attrs)){
			eleQty = cellMod.attrs.length;
			for(j=0; j<eleQty; j++){
				var attrs = cellMod.attrs[j];
				if(attrs == undefined){
					continue;
				}
				for(prop in attrs){
					if(!attrs.hasOwnProperty(prop)){
						continue;
					}else{
						cell.setAttr(j, prop, attrs[prop]);
					}
				}

			}
		}else{
			var attrs = cellMod.attrs;
			eleQty = cellMod.eleQty;
			if(attrs){
				for(prop in attrs){
					if(!attrs.hasOwnProperty(prop)){
						continue;
					}else{
						for(j=0; j<eleQty; j++){
							cell.setAttr(j, prop, attrs[prop]);
						}
					}
				}
			}
		}


		if(isArray(cellMod.style)){
			eleQty = cellMod.style.length;
			for(j=0; j<eleQty; j++){
				var style = cellMod.style[j];
				if(style == undefined){
					continue;
				}
				cell.addStyle(j,style);

			}
		}else{
			var style = cellMod.style;
			eleQty = cellMod.eleQty;
			if(style){
				for(j=0; j<eleQty; j++){
					cell.addStyle(j,style);
				}
			}
		}

		if(isArray(cellMod.className)){
			eleQty = cellMod.className.length;
			for(j=0; j<eleQty; j++){
				var className = cellMod.className[j];
				if(className == undefined){
					continue;
				}
				cell.addClass(j,className);

			}
		}else{
			var className = cellMod.className;
			eleQty = cellMod.eleQty;
			if(className){
				for(j=0; j<eleQty; j++){
					cell.addClass(j,className);
				}
			}
		}

	}

	return etbRow;
}

function addEditorTableRow(etb){
	return etb.addRowAsModel();
}



function EditorTableRowMouseout(evt){
	//console.log("out : "+this);
	this.style = "";
}

function EditorTableRowMouseover(evt){
	//var sorObj = evt.srcElement?evt.srcElement:evt.target;
	//console.log("over : "+this);
	
	this.style = "background:#E0ECFF;";
}

function EditorTableMousemove(instance, e) { if (e.clientX > instance.data.oleft + instance.data.ow) instance.splitLine.style.left = e.clientX + 'px'; };
function EditorTableMouseup(instance, e) {
	instance.splitLine.style.display = 'none';
	instance.forbidSelect();
	var w = instance.data.w + e.clientX - instance.data.ex, ow = instance.data.ow;
	if (w < ow) w = ow;
	instance.data.drag = false;
	instance.data.elm.style.width = w + 'px';
	instance.DocumentUp();
	instance.DocumentMove();
}
EditorTable.prototype.$ = function (Id) { return document.getElementById(Id); };
EditorTable.prototype.$s = function (obj, tag) { return obj.getElementsByTagName(tag); };
EditorTable.prototype.position = function (o) { var p = new Object(); p.x = o.offsetLeft; p.y = o.offsetTop; while (o = o.offsetParent) { p.x += o.offsetLeft; p.y += o.offsetTop; } return p; };
EditorTable.prototype.DocumentMove = function (add) {
	if (add) {
		if (document.addEventListener) document.addEventListener('mousemove', this.mousemoveFunction, false);
		else document.attachEvent('onmousemove', this.mousemoveFunction);
	}
	else {            
		if (document.removeEventListener) document.removeEventListener('mousemove', this.mousemoveFunction, false);
		else document.detachEvent('onmousemove', this.mousemoveFunction);
	}
}
EditorTable.prototype.DocumentUp = function (add) {
	if (add) {
		if (document.addEventListener) document.addEventListener('mouseup', this.mouseupFunction, false);
		else document.attachEvent('onmouseup', this.mouseupFunction);
	}
	else {
		if (document.removeEventListener) document.removeEventListener('mouseup', this.mouseupFunction, false);
		else document.detachEvent('onmouseup', this.mouseupFunction);
	}
}
EditorTable.prototype.forbidSelect = function (forbid) {//�޸ĵ�Ԫ�񳤶�ʱ������ѡ�񣬷�������ѡ��
	if (document.all) this.eTable.onselectstart = function () { return !forbid; }
	else {
		if (forbid) this.eTable.style.cssText += '-moz-user-select:none';
		else this.eTable.style.cssText = this.eTable.style.cssText.replace(/-moz-user-select\s*:\s*none/i, '');
	}
}
EditorTable.prototype.resizableColumns = function () {
	this.mousemoveFunction = (function (me) { return function (e) { EditorTableMousemove(me, e || window.event); } })(this);
	this.mouseupFunction = (function (me) { return function (e) { EditorTableMouseup(me, e || window.event); } })(this);
	this.splitLine = document.createElement('div');
	this.splitLine.style.width = '2px';
	this.splitLine.style.overFlow = 'hidden';
	this.splitLine.style.cursor = this.cursor;
	this.splitLine.innerHTML = '&nbsp;'
	this.splitLine.style.position = 'absolute';
	this.splitLine.style.display = 'none';
	this.splitLine.style.backgroundColor = 'red';
	this.splitLine.style.height = this.eTable.offsetHeight + 'px';
	this.splitLine.style.top = this.position(this.eTable).y + 'px';
	document.body.appendChild(this.splitLine);
	var tr = this.$s(this.eTable, 'tr');
	if (tr.length > 0) { //��ʼ��ҳͷ���ƶ��¼�
		var tds = tr[0].cells;
		for (var i = 0; i < tds.length; i++) {
			tds[i].innerHTML = '<div style="width:' + tds[i].offsetWidth + 'px" ow="' + tds[i].offsetWidth + '">' + tds[i].innerHTML + '</div>';
			tds[i].onmousemove = (function (me) {
				return function (e) {
					if (me.data.drag) return false;
					e = e || window.event;
					var p = me.position(this), bodyScrollLeft = me.isStrict ? document.documentElement.scrollLeft : document.body.scrollLeft;
					
					if (Math.abs(e.clientX - p.x - this.offsetWidth) <= (me.span + bodyScrollLeft)){
						this.firstChild.style.cursor = me.cursor;
					}else{
						this.firstChild.style.cursor = 'default';
					}
				}
			})(this);
			tds[i].onmousedown = (function (me) {
				return function (e) {
					e = e || window.event;
					var o = e.srcElement || e.target;
					if (o.style.cursor == me.cursor) {
						me.forbidSelect(true);
						me.data.elm = o;
						me.data.drag = true;
						me.data.ex = e.clientX;
						me.data.w = parseInt(o.style.width);
						me.data.oleft = me.position(o.parentNode).x;
						me.data.ow = parseInt(o.getAttribute('ow'), 10);
						me.splitLine.style.left = me.data.ex + 'px';
						me.splitLine.style.display = 'block';
						me.DocumentMove(true);
						me.DocumentUp(true);
					}
				}
			})(this);
		}
	}
}

