
/*************************************************************************
 功能：合并表格
 参数：tb－需要合并的表格ID  (可以是table、tbody )
 参数：colLength－－需要对前几列的行进行合并，比如 .想合并前两列，后面的数据列忽略合并，colLength应为2
 参数：rowLength－－需要对前几行的列进行合并，比如 .想合并前行列，后面的数据行忽略合并，rowLength应为2
 缺省表示对全部列合并
 data:  lxzheng_2016/04/12
 *************************************************************************/
function uniteTable(tb,colLength,rowLength)
{
    //检查表格是否规整

    if(tb.rows.length==0) return false;
    if(tb.rows[0].cells.length==0) return false;
    /*
     for(var i=0;i<tb.rows.length;i++)
     {
     if(tb.rows[0].cells.length!=tb.rows[i].cells.length) return false;
     }
     */

    var i=0;

    var j=0;

    var rowCount=tb.rows.length; //行数

    var colCount=tb.rows[0].cells.length; //列数

    var obj1=null;

    var obj2=null;

    //为每个单元格命名
    for(i=0;i<rowCount;i++)
    {
        for(j=0;j<colCount;j++)
        {
            if(typeof(tb.rows[i].cells[j]) == "undefined")
            {
                continue;
            }
            tb.rows[i].cells[j].id="tb_" + i.toString() + "_" + j.toString();
        }
    }

    //逐列检查合并
    for(i=0;i<colCount;i++)
    {
        if(i==colLength) break;
        obj1=document.getElementById("tb_0_"+i.toString()) ;
        if(obj1 != null && typeof(obj1) != "undefined")
        {
            for(j=1;j<rowCount;j++)
            {
                obj2=document.getElementById("tb_"+j.toString()+"_"+i.toString());

                if((obj2 != null) && (typeof(obj2) != "undefined") && (obj2.firstChild.nodeName == "#text")) // only input == text ,才合并， 其他 比如 ，ＳＥＬＥＣＴ　是　不合并的，如果需要　用　这个　函数　，注意。
                {
                    if(obj1.innerText==obj2.innerText)
                    {
                        obj1.rowSpan++;
                        obj2.parentNode.removeChild(obj2);

                    }else
                    {
                        obj1=document.getElementById("tb_"+j.toString()+"_"+i.toString());
                    }
                }
            }
        }
    }

    //逐行检查合并
    for(i=0;i<rowCount;i++)
    {
        if(i==rowLength) break;
        obj1=document.getElementById("tb_"+i.toString()+"_0") ;
        if(obj1 != null && typeof(obj1) != "undefined")
        {
            for(j=1;j<colCount;j++)
            {
                obj2=document.getElementById("tb_"+i.toString()+"_"+j.toString());
                if((obj2 != null) && (typeof(obj2) != "undefined") && (obj2.firstChild.nodeName == "#text"))
                {
                    if(obj1.innerText==obj2.innerText)
                    {

                        obj1.colSpan++;
                        obj2.parentNode.removeChild(obj2);
                    }else
                    {
                        obj1=document.getElementById("tb_"+i.toString()+"_"+j.toString());
                    }
                }
            }
            //obj1.colSpan 至少 一行中 有 3个 以上相同的 才 添加 col_td 的 class
            if(obj1.colSpan > 3 && obj1.colSpan <= colCount)
            {
                $("#tb_"+i.toString()+"_0").attr("class","col_td");
            }
        }
    }
};
