var GlobalSpace = {
	json_debug: 0,
	dataurl:"/goform/mainBoard",
	page_id:4,
	
	mybusy_data:loadvalue(),
	def_ajax_para:{
		bk_fn:ajaxBk_before,
		bkrm_fn:ajaxBk_end
	}
};

var timer;

function initHardwareStatus(HardwareStatus){
	var power_status = [];
	power_status[power_status.length] = "Faulty/Not Installed";
	power_status[power_status.length] = "Normal";

	var str_temp = '';
	// head
	str_temp += '<thead>';
	str_temp += '<th>ARM Temperature(&#176;C)</th>';
	str_temp += '<th>FPGA Temperature(&#176;C)</th>';
	for(var i=0; i<HardwareStatus.fan_speed.length; i++)
		str_temp += '<th>Fan-'+ (i+1)+'Speed(r/min)</th>';
	str_temp += '</thead>';
	// body
	str_temp += '<tbody>';
	str_temp += '<tr>';
	str_temp += '<td>'+(HardwareStatus.arm_temperature*0.25)+'</td>';
	str_temp += '<td>'+(HardwareStatus.fpga_temperature*0.25)+'</td>';
	for(var i=0; i<HardwareStatus.fan_speed.length; i++)
		str_temp += '<td>'+HardwareStatus.fan_speed[i]+'</td>';
	str_temp += '</tr>';
	str_temp += "</tbody>";
	$('#status_hardware table:eq(0)').html(str_temp);
	
	str_temp = '';
	str_temp += '<thead>';
	for(var i=0; i<HardwareStatus.power_status.length; i++)
		str_temp += '<th>Power-'+ (i+1)+'Status</th>';
	str_temp += '</thead>';
	str_temp += '<tbody>';
	str_temp += '<tr>';
	for(var i=0; i<HardwareStatus.power_status.length; i++)
		str_temp += '<td>'+power_status[HardwareStatus.power_status[i]]+'</td>';
	str_temp += '</tr>';
	str_temp += '</tbody>';
	$('#status_hardware table:eq(1)').html(str_temp);
}
function initIpinStatus(IPinStatus){
	var str_temp = '';
	var ip_lock = [];
	ip_lock[ip_lock.length] = "unlocked";
	ip_lock[ip_lock.length] = "si not ready";
	ip_lock[ip_lock.length] = "locked";

	var tsRcvrMthdFlag = IPinStatus.tsRcvrMthdFlag;
	if(parseInt(tsRcvrMthdFlag) >=1 )//udp,rtp
	{
		document.getElementById("tsPkts").style.display = "table-cell";
		document.getElementById("protocol").style.display = "table-cell";
	}else{
		document.getElementById("lostPkts").style.display = "table-cell";
		document.getElementById("rcvrPkts").style.display = "table-cell";
	}
	// 0 udp, 1--RTP stamp
	var proStr = [];
	proStr[proStr.length] = "UDP";
	proStr[proStr.length] = "RTP";

	for(var i=0; i<IPinStatus.value.length; i++)
	{
		str_temp += '<tr>';
		str_temp += '<td>'+parseInt(IPinStatus.value[i].channel + 1)+'</td>';
		
		str_temp += '<td>Port '+(IPinStatus.value[i].nif_no+1)+'</td>';
		str_temp += '<td>'+IPinStatus.value[i].src_ipaddr+'</td>';
		if(parseInt(tsRcvrMthdFlag) >=1 )//udp,rtp
		{
			str_temp += '<td>'+proStr[parseInt(IPinStatus.value[i].protocol)]+'</td>';
		}
		str_temp += '<td>'+IPinStatus.value[i].target_port+'</td>';
		str_temp += '<td>'+ip_lock[IPinStatus.value[i].channel_lock]+'</td>';
		str_temp += '<td>'+parseFloat(IPinStatus.value[i].bitrate)+'</td>';
		str_temp += '<td>'+IPinStatus.value[i].udp_length+'</td>';
		if(parseInt(tsRcvrMthdFlag) >=1 )//udp,rtp
		{
			str_temp += '<td>'+IPinStatus.value[i].tsPkts+'</td>';
		}else{
			str_temp += '<td>'+IPinStatus.value[i].lost_packets+'</td>';
			str_temp += '<td>'+IPinStatus.value[i].recovery_packets+'</td>';
		}
		if(IPinStatus.value[i].enable == 0)
			str_temp += '<td>Disable</td>';
		else
			str_temp += '<td>Enable</td>';
		str_temp += '</tr>';
		
	}
	$('#status_ts_in tbody').html(str_temp);
	//$.uniteTable(ipin_status_table,2,0);
}
function initIpoutStatus(IPoutStaus){
	var str_temp = '';

	for(var i=0; i<IPoutStaus.value.length; i++){
		str_temp += '<tr>';
		str_temp += '<td>'+(i+1)+'</td>';
		str_temp += '<td>'+IPoutStaus.value[i].cfec_packets+'</td>';
		str_temp += '<td>'+IPoutStaus.value[i].rfec_packets+'</td>';
		str_temp += '<td>'+IPoutStaus.value[i].input_bitrate+'</td>';
		str_temp += '<td>'+IPoutStaus.value[i].ts_packets+'</td>';
		if(IPoutStaus.value[i].encapsul_type == 0)
			str_temp += '<td>RTP</td>';
		else
			str_temp += '<td>UDP</td>';
		str_temp += '</tr>';
	}
	$('#status_ts_out tbody').html(str_temp);
}


function dataTimer() {
	var G=GlobalSpace,
		jsonStr='',
		ajax_para={};

	ajax_para.url=GlobalSpace.dataurl+'?id='+GlobalSpace.page_id;
	ajax_para.bkrm_dis=1;
	
	$.pbi_ajaxWrap(jsonStr, ajax_para, onTimerReceived, onTimerReceived2);
}
function onTimerReceived(para) {
	if(para.LOG_MSG)
		initLog(para.LOG_MSG);
	if(para.Hardware_status)
		initHardwareStatus(para.Hardware_status.value);
	if(para.IPIN_Staus)
		initIpinStatus(para.IPIN_Staus);
	if(para.IPOUT_Staus)
		initIpoutStatus(para.IPOUT_Staus);

	timer = setTimeout(dataTimer, 5000);
}


function onInitReceived(para){
	if(!(para.INIT)){
		alert("Init web parameter is error");
		return 1;
	}
	if(para.INIT)
		parent.chTitle(para.INIT.value.device_name);
	// init_web(para);
	// alert($.toJSON(para));
	if(para.LOG_MSG)
		initLog(para.LOG_MSG);
	if(para.Hardware_status)
		initHardwareStatus(para.Hardware_status.value);
	if(para.IPIN_Staus)
		initIpinStatus(para.IPIN_Staus);
	if(para.IPOUT_Staus)
		initIpoutStatus(para.IPOUT_Staus);
	$('#clearlog').on({
		click:function(){
			clearLog();
		}
	});
	$('#savelog').on({
		click:function(){
			saveLog();
		}
	});
	
	timer = setTimeout(dataTimer, 1000);
}


$(function(){
	var i = 0,
		G = GlobalSpace,
		ajax_para = {};
	
	if (G.json_debug == 1) {
		G.dataurl = "status.json";
	}
	//page ajax init
	G.def_ajax_para.url=GlobalSpace.dataurl+'?id='+GlobalSpace.page_id;
	$.pbi_ajaxWrap('', G.def_ajax_para, onInitReceived);
	
	$('#status_p legend').pbi_accordion();

});