setObjProperty = function(obj,pName,pValue){
    obj[pName] = pValue;
}
// hDspt = new HttpDispatcher();

function HttpRequestData(){


}

function HttpFuncModule(){


}

HttpFuncModule.parseResData = function (resData) {
    
}

HttpFuncModule.prototype.toReqData = function () {
    var reqData = new HttpRequestData();



    return reqData
}

function HttpDispatcherRequest(url) {

    this.dispatcher;
    this.data = [];
    this.reqData;

    this.url = url;
    this.async = true;
    this.method = "GET";

    this.delayMs = 0;

    this.doFlag = 0;  // 0 at once, 1 delay, 2 period
}


HttpDispatcherRequest.prototype.setUrl = function (url) {
    this.url = url;
}

HttpDispatcherRequest.prototype.setMethod = function (method) {
    this.method = method;
}

HttpDispatcherRequest.prototype.setAsync = function (async) {
    this.async = async;
}

HttpDispatcherRequest.prototype.open = function (method, url, async){
    if(method != undefined){
        this.setMethod(method);
    }
    if(async != undefined) {
        this.setAsync(async);
    }
    this.setUrl(url);
}

HttpDispatcherRequest.prototype.setHeader = function(name, value){
    var xhr = this.dispatcher.xhr;
    xhr.setRequestHeader(name, value);
}


HttpDispatcherRequest.prototype.addData = function(data){
    this.data.push(data);
}

HttpDispatcherRequest.prototype.doSend = function(){
    var xhr = this.dispatcher.xhr;
    /*
     open(method, url [, async = true [, username = null [, password = null]]])
     */
    xhr.open(this.method,this.url,this.async);
    xhr.send(this.reqData);
}

HttpDispatcherRequest.prototype.send = function(data){
    if(data != undefined){
        this.reqData = this.data.toJSON();
    }
    this.doSend();
}

HttpDispatcherRequest.prototype.delaySend = function(delay,data){
    this.doFlag = HttpDispatcher.DoDelaySendReq;
    setTimeout(function () {
        this.send(data);
    }.bind(this), delay);
}

HttpDispatcherRequest.prototype.periodSend = function(period,data){
    this.delayMs = period;
    this.doFlag = HttpDispatcher.DoPeriodSendReq;
    this.send(data);
}

/*
 // states
 const unsigned short UNSENT = 0;
 const unsigned short OPENED = 1;
 const unsigned short HEADERS_RECEIVED = 2;
 const unsigned short LOADING = 3;
 const unsigned short DONE = 4;
 */
function HttpDispatcherResponse() {
    this.dispatcher;
    this.data;
    this.status;
}



HttpDispatcherResponse.prototype.getHeader = function(name){
    var xhr = this.dispatcher.xhr;
    return xhr.getResponseHeader(name);
}

HttpDispatcherResponse.prototype.getAllHeaders = function(){
    var xhr = this.dispatcher.xhr;
    return xhr.getAllResponseHeaders();
}

HttpDispatcherResponse.prototype.setTimeout = function (timeout,handler) {
    var xhr = this.dispatcher.xhr;
    xhr.timeout = timeout;
    if ("function" == typeof handler) {
        this.ontimeout = handler;
    }
}


/*
 enum XMLHttpRequestResponseType {
 "",
 "arraybuffer",
 "blob",
 "document",
 "json",
 "text"
 };
 */
HttpDispatcherResponse.prototype.setDataType = function(dataType){
    var xhr = this.dispatcher.xhr;
    xhr.responseType  = dataType;
}

HttpDispatcherResponse.prototype.onprogress = function (xhr, evt) {
    if(evt.lengthComputable) {
        var howmuch = (evt.loaded / evt.total) * 100;
        console.log(Math.ceil(howmuch));
    } else {
        console.log("Can't determine the size of the file.");
    }
}

HttpDispatcherResponse.prototype.addEventListener = function(eName, eHandler){
    /*
     eHandler = function (xhr, evt) {
     }
     */
    if ("function" == typeof eHandler) {
        eName = "on" + eName.toLowerCase();
        this[eName] = eHandler;
    }
}

HttpDispatcherResponse.prototype.removeEventListener = function(eName){
    eName = "on" + eName.toLowerCase();
    this[eName] = undefined;
}

HttpDispatcherResponse.prototype.setEventListener = function(eName, eHandler){
    if ("function" == typeof eHandler) {
        this.addEventListener(eName, eHandler);
    }else{
        this.removeEventListener(eName);
    }
}


/*
 parameter:event;
 attribute EventHandler onloadstart;
 attribute EventHandler onprogress; // 传输进度。
 attribute EventHandler onabort;  //  ：传输被用户取消。
 attribute EventHandler onerror;
 attribute EventHandler onload; // ：传输成功完成。
 attribute EventHandler ontimeout;
 attribute EventHandler onloadend;  // ：传输结束，但是不知道成功还是失败。
 */
HttpDispatcher.prototype.initXhr = function(){
    this.xhr = new XMLHttpRequest();
    var hDspt = this;
    var res = this.res;
    var req = this.req;
    var xhr = this.xhr;

    xhr.onload = function(evt){
        if ("function" == typeof res.onload) {
            res.onload(this, evt);
            if(req.doFlag == HttpDispatcher.DoPeriodSendReq){
                setTimeout( hDspt.reDoReq.bind(hDspt), req.delayMs);
            }
        }
    }
    xhr.onloadstart = function(evt) {
        if ("function" == typeof res.onloadstart) {
            res.onloadstart(this, evt);
        }
    }
    xhr.onloadend = function(evt){
        if("function" == typeof res.onloadend){
            res.onloadend(this, evt);
        }
    }
    xhr.onprogres = function(evt){
        if("function" == typeof res.onprogres) {
            res.onprogres(this, evt);
        }
    }
    xhr.onerror = function(evt){
        if("function" == typeof res.onerror) {
            res.onerror(this, evt);
        }
    }
    xhr.onabort = function(evt){
        if("function" == typeof res.onabort) {
            res.onabort(this, evt);
        }
    }
    xhr.ontimeout = function(evt){
        if("function" == typeof res.ontimeout) {
            res.ontimeout(this, evt);
        }
    }
}

HttpDispatcher.prototype.initReq = function() {
    //this.req = new HttpDispatcherRequest();
    this.req.dispatcher = this;
}

HttpDispatcher.prototype.initRes = function() {
    //this.res = new HttpDispatcherRequest();
    this.res.dispatcher = this;
}

function HttpDispatcher(){

    this.req = new HttpDispatcherRequest();
    this.res = new HttpDispatcherResponse();
    //this.xhr = new XMLHttpRequest();

    this.funcMods = {};

    this.initReq();
    this.initRes();
    this.initXhr();

}

HttpDispatcher.prototype.addFuncMod = function(fKey,fMod){
    this.funcMods[fKey] = fMod;
}

HttpDispatcher.prototype.makeReqData = function(){
    for(var fKey in  this.funcMods){
        var fMod = this.funcMods[fKey];
        this.addReqData(fMod.toReqData());
    }
}

HttpDispatcher.prototype.addEventListener = function(eName, eHandler){
    this.res.addEventListener.apply(this.res,arguments);
}

HttpDispatcher.prototype.removeEventListener = function(eName, eHandler){
    this.res.removeEventListener.apply(this.res,arguments);
}

HttpDispatcher.prototype.setEventListener = function(eName, eHandler){
    this.res.setEventListener.apply(this.res,arguments);
}

HttpDispatcher.prototype.setTimeout = function(timeout,handler){
    this.res.setTimeout.apply(this.res,arguments);
}

HttpDispatcher.prototype.getResHead = function(name){
    return this.res.getHeader.apply(this.res,arguments);
}

HttpDispatcher.prototype.getAllResHeads = function(){
    return this.res.getAllHeaders.apply(this.res,arguments);
}

HttpDispatcher.prototype.setResType = function(resType){
    this.res.setDataType.apply(this.res,arguments);
}

HttpDispatcher.prototype.openReq = function(method, url, async){
    this.req.open.apply(this.req,arguments);
}

HttpDispatcher.prototype.setReqHead = function(name, value){
    this.req.setHeader.apply(this.req,arguments);
}

HttpDispatcher.prototype.addReqData = function(data){
    this.req.addData.apply(this.req, arguments);
}


HttpDispatcher.DoAtOnceSendReq = 0;
HttpDispatcher.DoDelaySendReq = 1;
HttpDispatcher.DoPeriodSendReq = 2;

HttpDispatcher.prototype.doReq = function(data){
    this.req.send.apply(this.req, arguments);
}

HttpDispatcher.prototype.reDoReq = function(){
    this.req.doSend();
}

HttpDispatcher.prototype.doDelayReq = function(delay,data){
    this.req.delaySend.apply(this.req, arguments);
}

HttpDispatcher.prototype.doPeriodReq = function(period,data){
    this.req.periodSend.apply(this.req, arguments);
}