﻿/*
 *processBar.js
 *Date & Authors:2016/10/12 lxzheng
 *Aim:The progress bar plug-in
 */

/*
 * custBasicInfos && custBarStyle
 * Aim：自定义参数，如果用户没有指定参数 将会用自定义的参数
 */
var custBasicInfos={
    siteID:"body",
    url:"",
    rTime:1000,
    modeStyle:"rectangle",
    isAjaxGetTime:false,
    isModal:false
};
var custBarStyle={
    rGeoPostion:"relative",
    rGeoLocation:["0px","0px","0px","0px"],
    //span
    procColor:"red",
    procFontSize:"13px",
    procBgColor:"#555"
};

/*
 *Aim :在样式表中追加样式（并不会覆盖原来的样式）
 * Arguments:样式表，选择器string，CSSText，插入的位置（即index）
 */
/*
 *Aim :在样式表中追加样式（并不会覆盖原来的样式）
 * Arguments:
 * sheet 样式表，selectorText string 选择器，cssText CSSText，position 插入的位置（即index）
 */
function insertRule(sheet, selectorText, cssText, position) {
    if (sheet.insertRule) {
        sheet.insertRule(selectorText + "{" + cssText + "}", parseInt(position));
    } else if (sheet.addRule) {
        sheet.addRule(selectorText, cssText, parseInt(position));
    }
}

/* Aim :进度条的一些总设置初始化 */
function BasicInfos(basicInfos) {
    this.siteID = (basicInfos.siteID)?basicInfos.siteID:custBasicInfos.siteID;
    this.url = (basicInfos.url)?basicInfos.url:custBasicInfos.url;
    this.rTime = (basicInfos.rTime)?basicInfos.rTime:custBasicInfos.rTime;
    this.isAjaxGetTime = (basicInfos.isAjaxGetTime)?basicInfos.isAjaxGetTime:custBasicInfos.isAjaxGetTime;
    this.modeStyle = (basicInfos.modeStyle)?basicInfos.modeStyle:custBasicInfos.modeStyle;
    this.isModal = (basicInfos.isModal)?basicInfos.isModal:custBasicInfos.isModal;
}
function TimeDate(timeData) {
    console.log(timeData);
    this.bgTotalTime = (timeData.bgToalTime)?timeData.bgToalTime:0;
    this.webTotalTime ;
    var myDate = new Date();
    this.webStartTime = [myDate.getMinutes(),myDate.getSeconds()];
}
/* Aim :ajax 返回的数据 计算 percent 并 update */
function ProcessBar(basicInfos,timeData){
    this.basicInfos = new BasicInfos(basicInfos);
    this.bar;
    this.timeData  = new TimeDate(timeData);
}

/* Aim :创建了ProcessBar ，并分为了2部分{basic set信息，bar 信息} */
//var ProcRadio = 0;
ProcessBar.prototype.ajaxCallback=function() {
    //1.计算进度条进度
    var procPercentage;
    if(arguments.length > 0)    //ajax sucess
    {
        procPercentage =  arguments[0].bgRealTime/arguments[0].bgTotalTime; //need attention !!
    }else                       //ajax error
    {

    }
    console.log(this.bar.nameInterval);
    if(procPercentage >= 100) {
        this.stopSetInterval(this.bar.nameInterval);
        procPercentage = 100;
		//document.getElementById(barInfo.basicInfos.siteID).children.
    }
    console.log(procPercentage);
    this.bar.procPercentage = (procPercentage != undefined)?procPercentage:0;
    this.bar.updateProc();
    /*//  自测试
    ProcRadio++;
    if(ProcRadio >= 100) {
        this.stopSetInterval(this.bar.nameInterval);
        ProcRadio = 100;
    }
    this.bar.procPercentage = ProcRadio ;
    this.bar.updateProc();
    */


};
/* Aim :启动 自动轮询 */
ProcessBar.prototype.onSetInterval = function()
{
    var url = this.basicInfos.url;
    var thisbar = this;
    var restTime = this.basicInfos.rTime;

    var ajaxWrap = function(){
        var myDate = new Date();
        var currentMinutes = myDate.getMinutes();
        var currentSeconds = myDate.getSeconds();
        var realTime = ((parseInt(currentMinutes)-parseInt(thisbar.timeData.webStartTime[0]))*60 + parseInt(currentSeconds))-parseInt(thisbar.timeData.webStartTime[1])
        console.log(realTime);
        console.log(thisbar.timeData.bgTotalTime);

        var procPercentage = Math.round((realTime*10000)/parseInt(thisbar.timeData.bgTotalTime));
        if(procPercentage >= 100) {
            thisbar.stopSetInterval(thisbar.bar.nameInterval);
            procPercentage = 100;
        }
        console.log(procPercentage);
        thisbar.bar.procPercentage = (procPercentage != undefined)?procPercentage:0;
        thisbar.bar.updateProc();
    };
    thisbar.bar.nameInterval = setInterval(ajaxWrap, restTime);
};
/* Aim :启动 自动轮询 */
ProcessBar.prototype.onSetIntervalAjax = function()
{
    var url = this.basicInfos.url;
    var thisbar = this;
    var restTime = this.basicInfos.rTime;
    var ajaxWrap = function(){
        $.ajax({
            dataType: "json",
            type: 'POST',
            url:url,
            data:{json:''},
            success: function(data){
                thisbar.ajaxCallback(data);
            },
            error: function(data){
                thisbar.ajaxCallback();
            }
        });
    };
    thisbar.bar.nameInterval = setInterval(ajaxWrap, restTime);
};

/* Aim :停止 自动轮询 */
ProcessBar.prototype.stopSetInterval = function(nameInterval) {
    clearInterval(nameInterval);
};

/* Aim :初始化 进度条布局 */
ProcessBar.prototype.initBarLayout = function () {
    this.bar.rDiv = document.createElement("div");
    this.bar.procSpan = document.createElement("span");
    this.bar.rDiv.appendChild(this.bar.procSpan);

  //  document[this.basicInfos.siteID]
    if(this.basicInfos.siteID && document.getElementById(this.basicInfos.siteID))
        document.getElementById(this.basicInfos.siteID).appendChild(this.bar.rDiv);
    else
        document.getElementsByTagName("body")[0].appendChild(this.bar.rDiv);
};

ProcessBar.prototype.createRectBarData = function(styleInfos){
    this.bar = new RectSonbar(styleInfos);
};

ProcessBar.prototype.createCirBarData = function(styleInfos){
    this.bar = new CirSonbar(styleInfos);
};


/* Aim :页面布局的信息值 赋值  r means real ，proc mean 进度*/
function Barlayout(){
    /*div*/
    this.rDiv;
    this.rGeoPostion= (arguments.length>0 && arguments[0].rGeoPostion)?arguments[0].rGeoPostion:custBarStyle.rGeoPostion;
    this.rGeoLocation=(arguments.length>0 && arguments[0].rGeoLocation)?arguments[0].rGeoLocation:custBarStyle.rGeoLocation;

    /*span*/
    this.procSpan;
    this.procColor = (arguments.length>0 && arguments[0].procColor)?arguments[0].procColor:custBarStyle.procColor;
    this.procFontSize = (arguments.length>0 && arguments[0].procFontSize)?arguments[0].procFontSize:custBarStyle.procFontSize;
    this.procBgColor = (arguments.length>0 && arguments[0].procBgColor)?arguments[0].procBgColor:custBarStyle.procBgColor;

    this.nameInterval;
    this.procPercentage=0;
    this.averInterval;

}
/* subType 继承 superType */
function inheritPrototype(subType, superType){
    function F(){}
    F.prototype = superType.prototype;
    var prototype = new F();
    prototype.constructor = subType;
    subType.prototype = prototype;
}

/* 设置 矩形进度条 {1.共有部分Barlayout 2.私有部分 custRectStyle}*/
inheritPrototype(RectSonbar, Barlayout);
function RectSonbar(){
    Barlayout.apply(this, arguments);
    var custRectStyle={
        rWidth:"250px",
        rHeight:"20px",
        rlineHeight:"18px",
        rBorderRadius:"10px"
    };

    this.rWidth= (arguments.length>0 && arguments[0].rWidth)?arguments[0].rWidth:custRectStyle.rWidth;
    this.rHeight= (arguments.length>0 && arguments[0].rHeight)?arguments[0].rHeight:custRectStyle.rHeight;
    this.rBorderRadius= (arguments.length>0 && arguments[0].rBorderRadius)?arguments[0].rBorderRadius:custRectStyle.rBorderRadius;
    this.rlineHeight = (parseInt(this.rHeight)-2 > 0)?parseInt(this.rHeight)-2+"px":custRectStyle.rlineHeight;
}

/* 数据信息获取完毕后，通过CSS 画矩形进度条*/
RectSonbar.prototype.drawBar = function() {
    this.rDiv.className = "initRectWrapper";
    this.procSpan.className = "initBarRectLayout";

    var preSetRectangleStyle={
        "position":this.rGeoPostion,
        "top":this.rGeoLocation[0],
        "right":this.rGeoLocation[1],
        "bottom":this.rGeoLocation[2],
        "left":this.rGeoLocation[3],
        "width":this.rWidth,
        "height": this.rHeight,
        "line-height":this.rlineHeight,
        "border-radius":this.rBorderRadius
    };
    $(this.rDiv).css(preSetRectangleStyle);

    var preSetBarRectStyle={
        "border-radius":this.rBorderRadius,
        "color":this.procColor,
        "fontSize":this.procFontSize,
        "backgroundColor":this.procBgColor
    };
    $(this.procSpan).css(preSetBarRectStyle);

    this.updateProc(0);
};

/* 更新矩形进度条 进度*/
RectSonbar.prototype.updateProc=function() {
    this.procSpan.style.width = this.procPercentage+"%";
    this.procSpan.innerHTML = this.procPercentage+"%";
};

/* 设置 圆形进度条 {1.共有部分Barlayout 2.私有部分 custCirStyle}*/
inheritPrototype(CirSonbar, Barlayout);
function CirSonbar(){
    Barlayout.apply(this, arguments);
    var custCirStyle={
        rWidth:"120px",
        rBorderRadius:"50%",
        proclineHeight:"84px"
    };

    this.rlineHeight = this.rHeight = this.rWidth= (arguments.length>0 && arguments[0].rWidth)?arguments[0].rWidth:custCirStyle.rWidth;
    this.rBorderRadius= (arguments.length>0 && arguments[0].rBorderRadius)?arguments[0].rBorderRadius:custCirStyle.rBorderRadius;
    this.rBGcolor = "#e7e7e7";

    this.proclineHeight = (parseInt(this.rHeight) > 0)?Math.floor(parseInt(this.rHeight)*0.7)+"px":custCirStyle.rlineHeight;

}

/* 创建 新的样式表*/
CirSonbar.prototype.creatSheet = function() {
    var style = document.createElement("style");
    style.appendChild(document.createTextNode(""));
  //  this.rDiv.appendChild(style);
    document.head.appendChild(style);
    return style.sheet;
};

/* 数据信息获取完毕后，通过CSS 画 Circle 进度条*/
CirSonbar.prototype.drawBar = function() {
    this.rDiv.className = "initCirWrapper";
    this.procSpan.className = "initBarCirLayout";

    //DIV
    var preSetCircleStyle={
        "position":this.rGeoPostion,
        "top":this.rGeoLocation[0],
        "right":this.rGeoLocation[1],
        "bottom":this.rGeoLocation[2],
        "left":this.rGeoLocation[3],
        "width":this.rWidth,
        "height": this.rHeight,
        "line-height":this.rlineHeight,
        "border-radius":this.rBorderRadius,
        "background-color":this.rBGcolor,
        "z-index":5
    };
    $(this.rDiv).css(preSetCircleStyle);

    //DIV Before
    var styleBefore=document.createElement('style');
    styleBefore.innerText = '.initCirWrapper::before{' +
        'content:"";' +
        'display:block;' +
        'position:absolute;' +
        'width: '+this.rWidth+';' +
        'height:'+this.rHeight+';' +
        'border-radius: '+this.rBorderRadius+';' +
        'line-height:'+this.rlineHeight+';' +
        'background-color: '+this.procBgColor+';' +
        'z-index: 1;' ;
    this.rDiv.appendChild(styleBefore);

    //DIV After
    var styleAfter=document.createElement('style');
    styleAfter.innerText = '.initCirWrapper::after{' +
        'content:"";' +
        'display:block;' +
        'position: absolute;' +
        'top: 50%;' +
        'left: 50%;' +
        'width: 60%;' +
        'height: 60%;' +
        'transform-origin: 0 0;' +
        'pointer-events: none;' +
        'background-color: '+this.procBgColor+';'+
        'z-index: 1;' ;
        this.rDiv.appendChild(styleAfter);

    //SPAN
    var preSetBarCirStyle={
        "border-radius":this.rBorderRadius,
        "color":this.procColor,
        "fontSize":this.procFontSize,
        "line-height":this.proclineHeight,
        "z-index":10
    };
    $(this.procSpan).css(preSetBarCirStyle);
    this.newSheet = this.creatSheet();
    this.updateProc(0);
};

/*
*更新circle形进度条 进度（主要是更改伪类的样式，改伪类的样式通过设置create 的样式表更改）
*/
CirSonbar.prototype.updateProc=function() {
    var divide = parseInt(this.procPercentage/25);               //取整
    var remainder = this.procPercentage%25*3.6;                 //取余
    var skewDeg = Math.floor(90 - remainder) + "deg";           //3.6 deg/%= 90deg/25% 向下取整数
    var rotateDeg = (divide*90-90)+ "deg";                       //-90 0 90 180
    var rWidthpx = parseInt(this.rWidth)+'px';
    var upHalfWidthpx = /*Math.ceil*/(parseInt(rWidthpx)/2)+'px';    //向上取整数
    var downHalfWidthpx = /*Math.floor*/(parseInt(rWidthpx)/2)-1+'px';  //向下取整数

    while(this.newSheet.cssRules.length) {
        this.newSheet.deleteRule(this.newSheet.cssRules.length-1);
    }
    insertRule(this.newSheet, ".initCirWrapper::after", "transform: rotate("+rotateDeg+") skew("+skewDeg+")", this.newSheet.length);
    switch(divide)
    {
        case 0:
            insertRule(this.newSheet, ".initCirWrapper::before", "clip: rect(0,0,0,0)", this.newSheet.length);
            break;
        case 1:
            insertRule(this.newSheet, ".initCirWrapper::before", "clip:rect(auto, auto, "+upHalfWidthpx+", "+upHalfWidthpx+")", this.newSheet.length);
            break;
        case 2:
            insertRule(this.newSheet, ".initCirWrapper::before", "clip: rect("+downHalfWidthpx+",auto,auto,"+downHalfWidthpx+")", this.newSheet.length);
            insertRule(this.newSheet, ".initCirWrapper", "background-image:-webkit-linear-gradient(left,#e7e7e7 "+upHalfWidthpx+","+this.procBgColor+" "+upHalfWidthpx+")",this.newSheet.length);
            break;
        case 3:
            insertRule(this.newSheet, ".initCirWrapper::before", "clip: rect("+downHalfWidthpx+", "+rWidthpx+", auto, auto)", this.newSheet.length);
            insertRule(this.newSheet, ".initCirWrapper", "background-image:-webkit-linear-gradient(left,#e7e7e7 "+upHalfWidthpx+","+this.procBgColor+" "+upHalfWidthpx+")",this.newSheet.length);
            break;
        case 4:
            insertRule(this.newSheet, ".initCirWrapper::before", "clip: rect(0,0,0,0)", this.newSheet.length);
            insertRule(this.newSheet, ".initCirWrapper", "background-image:-webkit-linear-gradient(left,"+this.procBgColor+" "+upHalfWidthpx+","+this.procBgColor+" "+upHalfWidthpx+")",this.newSheet.length);
            break;
        default:
            insertRule(this.newSheet, ".initCirWrapper::before", "clip: rect(0,0,0,0)", this.newSheet.length);
            insertRule(this.newSheet, ".initCirWrapper", "background-image:-webkit-linear-gradient(left,e7e7e7 "+upHalfWidthpx+",e7e7e7"+upHalfWidthpx+")",this.newSheet.length);
            break;
    }
    this.procSpan.innerHTML = this.procPercentage+"%";
};

ProcessBar.creat = function (barInfo) {
    var barTemp;
    if (!barInfo)
        return;
    if(barInfo.timeData && parseInt(barInfo.timeData.bgToalTime) <= 0 )
        return;

     //1.creat and set basicInfos
    barTemp = new ProcessBar(barInfo.basicInfos,barInfo.timeData);
    if (barTemp.basicInfos.modeStyle == "rectangle") {
        console.log("--rectangle--");
        barTemp.createRectBarData(barInfo.styleInfos);

    } else if (barTemp.basicInfos.modeStyle == "circle") {
        console.log("--circle--");
        barTemp.createCirBarData(barInfo.styleInfos);
    }

    barTemp.initBarLayout();
    barTemp.bar.drawBar();
    if(barTemp.basicInfos.isAjaxGetTime == true)
    {
        barTemp.onSetIntervalAjax();
    }else
    {
        barTemp.onSetInterval();
    }

    return barTemp;
};

/* barInfos : 用户自定义的进度条属性值 */
ProcessBar.init = function (barInfos) {
        var arr = [];
        var barTemp;
        for (var i = 0; i < barInfos.length; i++) {
            if (!barInfos[i])
                return;
            if(barInfos[i].timeData && parseInt(barInfos[i].timeData.bgToalTime) <= 0 )
                return;

            //1.creat and set basicInfos
            barTemp = new ProcessBar(barInfos[i].basicInfos,barInfo.timeData);
            if (barTemp.basicInfos.modeStyle == "rectangle") {
                barTemp.createRectBarData(barInfos[i].styleInfos);

            } else if (barTemp.basicInfos.modeStyle == "circle") {
                barTemp.createCirBarData(barInfos[i].styleInfos);
            }

            barTemp.initBarLayout();
            barTemp.bar.drawBar();
		
            if(barTemp.basicInfos.isAjaxGetTime == true)
            {
                barTemp.onSetIntervalAjax();
            }else
            {
                barTemp.onSetInterval();
            }
            arr.push(barTemp);
        }
        return arr;
};