var GlobalSpace = {
    json_debug: 0,
    dataurl:"/goform/mainBoard",
    page_id:2,
    DEF_MAN_NET:8,
    DEF_LOGIN_SET:10,
    MAN_NET:{},
    IPArr:[],
    mybusy_data:loadvalue(),
    def_ajax_para:{
        bk_fn:ajaxBk_before,
        bkrm_fn:ajaxBk_end
    }
};

var DEF={
    SEND_TYPE:{
        GIVE:0,
        GET:1
    },
    MACS:{
        MAC0:0,
        MAC1:1,
        MAC2:2,
        MAC3:3,
        MAC4:4,
        MAC5:5,

        LEN:6
    },
    AJAX_BK:{
        DEFAULT:0,
        LOAD:1,

        REMOVE2:255
    },
    IPS:{
        IP0:0,
        IP1:1,
        IP2:2,
        IP3:3,
        PORT:4,

        LEN:5
    }
};
function ajaxBk_before(bk_type){
    var G = GlobalSpace;
    switch(bk_type){
        case DEF.AJAX_BK.DEFAULT:
            G.mybusy_data.settext();
            break;
        case DEF.AJAX_BK.LOAD:
            G.mybusy_data.loadsth();
            break;
        default:
            G.mybusy_data.settext();
            break;
    }
}
function ajaxBk_end(bk_type){
    var G = GlobalSpace;
    switch(bk_type){
        case DEF.AJAX_BK.REMOVE2:
            G.mybusy_data.remove2();
            break;
        default:
            G.mybusy_data.remove();
            break;
    }
}
function ajaxWrap_login(jsonStr, fn, ajax_para){
    $.ajax({
        dataType: "json",
        type: 'POST',
        url:'/goform/WebLogin'+'?id='+GlobalSpace.page_id,
        data:{json:jsonStr},
        beforeSend:function(XMLHttpRequest){
            mybusy = loadvalue();
            mybusy.settext();
        },
        success: function(data){
            mybusy.remove();
             /* ajax_func_handler(data, fn, ajax_para);*/
        },
        error: function(data){
            /*alert('Error, please check your Username or Password!');*/
            mybusy.remove();
        }
    });
}

function ajax_func_handler(data, fn, ajax_para){
    switch(ajax_para.type){
        case DEF.SEND_TYPE.GIVE:
            fn(ajax_para.form_id,data);
            break;
    }
}
function ajaxWrap(jsonStr, fn, ajax_para){
    $.ajax({
        dataType: "json",
        type: 'POST',
        url:GlobalSpace.dataurl+'?id='+GlobalSpace.page_id,
        data:{json:jsonStr},
        beforeSend:function(XMLHttpRequest){
            mybusy = loadvalue();
            mybusy.settext();
        },
        success: function(data){
            mybusy.remove();
            ajax_func_handler(data, fn, ajax_para);
        },
        error: function(data){
            mybusy.remove();
        }
    });
}

function apply_callback(type,data){
    switch(type){
        case GlobalSpace.DEF_MAN_NET:
            initIPArr(data.MAN_NET.value.localIP);
            alert('Save Management Network setting!');
            break;
        case GlobalSpace.DEF_LOGIN_SET:
            alert('Save WEB Login setting!');
            break;


    }
}
function isArguVaild()
{
    if($("#ip_addr").find("input").hasClass("noexpect-data-bg") == true)
    {
        alert("Set parameter error, please check!");
        return true;
    }
    return false;
}
function isNetSegmentConflict()
{
    var G = GlobalSpace;
    var sysIP={},last = {},k;
    var temp_arr=[];
    $.extend(temp_arr, G.IPArr);

    sysIP.ipAddr  = parseInt(G.MAN_NET.value.ip_addr[0])<<24;
    sysIP.ipAddr |= parseInt(G.MAN_NET.value.ip_addr[1])<<16;
    sysIP.ipAddr |= parseInt(G.MAN_NET.value.ip_addr[2])<<8;
    sysIP.ipAddr |= parseInt(G.MAN_NET.value.ip_addr[3]);

    sysIP.netMask  = parseInt(G.MAN_NET.value.net_mask[0])<<24;
    sysIP.netMask |= parseInt(G.MAN_NET.value.net_mask[1])<<16;
    sysIP.netMask |= parseInt(G.MAN_NET.value.net_mask[2])<<8;
    sysIP.netMask |= parseInt(G.MAN_NET.value.net_mask[3]);
    sysIP.segment = sysIP.ipAddr & sysIP.netMask;
    sysIP.name = "";

    temp_arr.push(sysIP);

    //IPArr's Segment 互不相等
    while(temp_arr.length>0)
    {
        last = temp_arr.pop();
        for(k in temp_arr)
        {
            if(last.segment == temp_arr[k].segment)
            {
                alert("The "+last.name+" IP address and the"+temp_arr[k].name+" IP address can not be in the same network segment,please modify!");
                return false;
            }
        }
        delete last;
    }
    return true;
}

function isNetParamsVaild()
{
    var G = GlobalSpace;
    var ipParam = {};

    ipParam.ipAddr  = parseInt(G.MAN_NET.value.ip_addr[0])<<24;
    ipParam.ipAddr |= parseInt(G.MAN_NET.value.ip_addr[1])<<16;
    ipParam.ipAddr |= parseInt(G.MAN_NET.value.ip_addr[2])<<8;
    ipParam.ipAddr |= parseInt(G.MAN_NET.value.ip_addr[3]);

    ipParam.netMask  = parseInt(G.MAN_NET.value.net_mask[0])<<24;
    ipParam.netMask |= parseInt(G.MAN_NET.value.net_mask[1])<<16;
    ipParam.netMask |= parseInt(G.MAN_NET.value.net_mask[2])<<8;
    ipParam.netMask |= parseInt(G.MAN_NET.value.net_mask[3]);
    ipParam.segment = ipParam.ipAddr & ipParam.netMask;
    ipParam.name = "";
    ipParam.gateWay  = parseInt(G.MAN_NET.value.gw_addr[0])<<24;
    ipParam.gateWay |= parseInt(G.MAN_NET.value.gw_addr[1])<<16;
    ipParam.gateWay |= parseInt(G.MAN_NET.value.gw_addr[2])<<8;
    ipParam.gateWay |= parseInt(G.MAN_NET.value.gw_addr[3]);
    //console.log(ipParam);

    if((~ipParam.netMask & ipParam.ipAddr) == 0)
    {
        alert("The IP address can not be a network address,please modify!");
        return false;
    }
    if((~ipParam.netMask & ipParam.ipAddr) == ~ipParam.netMask)
    {
        alert("The IP address cannot be equal to a broadcast address,please modify!");
        return false;
    }

    if((ipParam.gateWay & ipParam.netMask) != (ipParam.ipAddr & ipParam.netMask))
    {
        alert("The gateway and the IP address need to be in the same segment,please modify!");
        return false;
    }
    if(ipParam.gateWay == ipParam.ipAddr)
    {
        alert("The gateway and the IP address can not be the same, please modify!");
        return false;
    }

    return true;
}
function initIPArr(localIP)
{
    var G = GlobalSpace;
    for(var i=0;i<localIP.length;i++)
    {
        G.IPArr[i] = {};

        G.IPArr[i].ipAddr = parseInt(localIP[i].ip_addr[0])<<24;
        G.IPArr[i].ipAddr |= parseInt(localIP[i].ip_addr[1])<<16;
        G.IPArr[i].ipAddr |= parseInt(localIP[i].ip_addr[2])<<8;
        G.IPArr[i].ipAddr |= parseInt(localIP[i].ip_addr[3]);

        G.IPArr[i].netMask = parseInt(localIP[i].net_mask[0])<<24;
        G.IPArr[i].netMask |= parseInt(localIP[i].net_mask[1])<<16;
        G.IPArr[i].netMask |= parseInt(localIP[i].net_mask[2])<<8;
        G.IPArr[i].netMask |= parseInt(localIP[i].net_mask[3]);

        G.IPArr[i].segment = G.IPArr[i].ipAddr & G.IPArr[i].netMask;
        G.IPArr[i].name = "SFP-"+parseInt(i+1);
    }
}
function setup_ip(){
    var json_obj = {MAN_NET:{}},
        jsonStr = "",
        ajax_para={},
        temp_arr = [];

    temp_arr = GlobalSpace.MAN_NET.value.ip_addr;
    temp_arr[DEF.IPS.IP0] = parseInt($('#ip_addr .ip0').val());
    temp_arr[DEF.IPS.IP1] = parseInt($('#ip_addr .ip1').val());
    temp_arr[DEF.IPS.IP2] = parseInt($('#ip_addr .ip2').val());
    temp_arr[DEF.IPS.IP3] = parseInt($('#ip_addr .ip3').val());

    temp_arr = GlobalSpace.MAN_NET.value.net_mask;
    temp_arr[DEF.IPS.IP0] = parseInt($('#ip_mask .ip0').val());
    temp_arr[DEF.IPS.IP1] = parseInt($('#ip_mask .ip1').val());
    temp_arr[DEF.IPS.IP2] = parseInt($('#ip_mask .ip2').val());
    temp_arr[DEF.IPS.IP3] = parseInt($('#ip_mask .ip3').val());


    temp_arr = GlobalSpace.MAN_NET.value.gw_addr;
    temp_arr[DEF.IPS.IP0] = parseInt($('#ip_gateway .ip0').val());
    temp_arr[DEF.IPS.IP1] = parseInt($('#ip_gateway .ip1').val());
    temp_arr[DEF.IPS.IP2] = parseInt($('#ip_gateway .ip2').val());
    temp_arr[DEF.IPS.IP3] = parseInt($('#ip_gateway .ip3').val());

    if(!( !isArguVaild() && isNetSegmentConflict() && isNetParamsVaild() ))
        return false;

    if(!confirm('Save Management Network Setting?')){
        return false;
    }

    json_obj.MAN_NET = GlobalSpace.MAN_NET;
    jsonStr = $.toJSON(json_obj);
    console.log(jsonStr);

    ajax_para.type = DEF.SEND_TYPE.GIVE;
    ajax_para.form_id = GlobalSpace.DEF_MAN_NET;
    ajaxWrap(jsonStr, apply_callback, ajax_para);
}
function setup_login(){
    var G = GlobalSpace,
        json_obj = {LOGIN_SET:{
            form_id:10,
            value:{}
        }},
        jsonStr = "",
        ajax_para={};

    if(!confirm('Change WEB Login Username and Password?')){
        return 0;
    }

    json_obj.LOGIN_SET.value.old_usename = $('#login_id_old').val();
    json_obj.LOGIN_SET.value.old_passwd = $('#login_pswd_old').val();
    json_obj.LOGIN_SET.value.usename = $('#login_id').val();
    json_obj.LOGIN_SET.value.passwd = $('#login_pswd').val();

    jsonStr= $.toJSON(json_obj);

    ajax_para.type = DEF.SEND_TYPE.GIVE;
    ajax_para.form_id = GlobalSpace.DEF_LOGIN_SET;
    ajaxWrap_login(jsonStr, apply_callback, ajax_para);
}
function pad(num, n){
    // return Array(n>num?(n-(''+num).length+1):0).join(0)+num;
    return n>num.length?(Array(n).join('0') + num).slice(-n):num;
}
function onblurTargetIP()
{
    var min_ip=0,
        max_ip=0,
        i=0;
    if(this.className.indexOf("ip") != -1)
    {
        var IPIdx = this.className.split("ip")[1];
        switch(parseInt(IPIdx))
        {
            case 0:
                min_ip=1;
                max_ip=223;
                break;
            case 1:
            case 2:
            case 3:
                min_ip=0;
                max_ip=255;
                break;
            default:
                min_ip=0;
                max_ip=255;
                break;
        }
        $(this).toggleClass("noexpect-data-bg",(parseInt(this.value) < min_ip || parseInt(this.value) > max_ip || isNaN(parseInt(this.value)) )?true:false);
    }
}
function onInitReceived(para){
    var G=GlobalSpace,
        str_temp = "",
        i = 0;

    GlobalSpace.MAN_NET = para.MAN_NET;
//ip
    net_value = para.MAN_NET.value;
    $('#ip_addr .ip0').val(net_value.ip_addr[0]);
    $('#ip_addr .ip1').val(net_value.ip_addr[1]);
    $('#ip_addr .ip2').val(net_value.ip_addr[2]);
    $('#ip_addr .ip3').val(net_value.ip_addr[3]);

    str_temp = "";
    for(i=0; i<net_value.mac_addr.length; i++){
        str_temp += pad(net_value.mac_addr[i].toString(16), 2);
        if(i<5){
            str_temp += ':';
        }
    }
    $('#ip_mac').html(str_temp);

    $('#ip_mask .ip0').val(net_value.net_mask[DEF.IPS.IP0]);
    $('#ip_mask .ip1').val(net_value.net_mask[DEF.IPS.IP1]);
    $('#ip_mask .ip2').val(net_value.net_mask[DEF.IPS.IP2]);
    $('#ip_mask .ip3').val(net_value.net_mask[DEF.IPS.IP3]);

    $('#ip_gateway .ip0').val(net_value.gw_addr[DEF.IPS.IP0]);
    $('#ip_gateway .ip1').val(net_value.gw_addr[DEF.IPS.IP1]);
    $('#ip_gateway .ip2').val(net_value.gw_addr[DEF.IPS.IP2]);
    $('#ip_gateway .ip3').val(net_value.gw_addr[DEF.IPS.IP3]);
    initIPArr(G.MAN_NET.value.localIP);

    $('#login_id_old').val('');
    $('#login_pswd_old').val('');
    $('#login_id').val('');
    $('#login_pswd').val('');
}
function init_network(){
    var G = GlobalSpace;

    if (GlobalSpace.json_debug == 1)
        GlobalSpace.dataurl = "network.json";

    G.def_ajax_para.url=G.dataurl+'?id='+G.page_id +"&time="+ new Date().getTime();
    $.pbi_ajaxWrap('', G.def_ajax_para, onInitReceived);
}

$(function(){
    $("#network_frame").ligerPanel({
        title : 'Management Network setting',
        height: 200
    });
    $("#login_frame").ligerPanel({
        title : 'WEB Login',
        height: 200
    });
    init_board_title();
    init_network();

    $("#ip_addr").find("input").blur(onblurTargetIP);
    $('legend').pbi_accordion();
});

