
function getHelpTxt(){
    var helpsObj = top.window.helpsObj;
    showImg(helpsObj);
    imgsClick(helpsObj);
    showNote(helpsObj);
}

function showImg(obj){
    var imgs = getClassNames("help-img","img");
    for(var i = 0; i < imgs.length; i++){
        var imgId = imgs[i].id;
        for(var item in obj){
            if(item == imgId){
                imgs[i].style.display = "inline-block";
            }
        }
    }
}

function showNote(obj){
    var noteId = getClassNames("note-wrap","div")[0].id;
    for(var item in obj){
        if(item == noteId){
            var content = getClassNames("content", "div")[0] || getClassNames("long_content", "div")[0];
            var left = content.getBoundingClientRect().right;
            var noteWrap = getClassNames("note-wrap", "div")[0];
            var langCookie = new xCookie();
            var lang = langCookie.getCookie("CUR_LANG");

            var helpObj = obj[item];
            if(helpObj[lang] != null && helpObj[lang].length != 0){
                var conObj = helpObj[lang];
            }else{
                var conObj = helpObj["en"];
            }

            noteWrap.style.left = left + 50 + "px";
            noteWrap.style.display = "block";
            builtNote(conObj);
        }
    }

}
function imgsClick(helpsObj){
    var imgs = getClassNames("help-img","img");
    var helpBox = document.getElementById("helpBox");

    for(var i = 0; i < imgs.length; i++){
        imgs[i].onclick = function(e){
            var imgID = this.id;
            var xOffset = this.getBoundingClientRect().left;
            var yOffset = this.getBoundingClientRect().top;
            var scrollTop = document.body.scrollTop || document.documentElement.scrollTop || (window.pageYOffset ? window.pageYOffset : 0);
            var scrollLeft = document.body.scrollLeft || document.documentElement.scrollLeft || (window.pageXOffset ? window.pageXOffset : 0);
            var imgTop = yOffset + scrollTop;
            var imgLeft = xOffset + scrollLeft;

            for(var item in helpsObj){
                if(item == imgID){
                    var lang = top.window.frames["title_top"].document.getElementById("langSelect").value;
                    var httpObj = helpsObj[item];
                    if(httpObj[lang] != null && httpObj[lang].length != 0){
                        var helpObj = httpObj[lang];
                    }else{
                        var helpObj = httpObj["en"];
                    }

                    builtHelpBox(helpObj, imgLeft, imgTop);
                }
            }

            e=e||window.event;
            if (e.stopPropagation)
                e.stopPropagation();
            else
                e.cancelBubble = true;
        }
    }
    document.body.onclick = function(){
        helpBox.style.display = "none";
    }
    helpBox.onclick = function(e){
        e=e||window.event;
        if (e.stopPropagation)
            e.stopPropagation();
        else
            e.cancelBubble = true;
    }
}

function builtHelpBox(obj, imgLeft, imgTop){
    var helpBox = document.getElementById("helpBox");
    helpBox.innerHTML = "";

    for(var item in obj){
        builtBody(item, obj[item], "help", helpBox);
    }

    helpBox.style.left = imgLeft + 30 + "px";
    helpBox.style.top = imgTop + 10 + "px";
    helpBox.style.display = "block";
}

function builtNote(obj){
    var noteBox = document.getElementById("noteContent");
    var content = getClassNames("content", "div")[0] || getClassNames("long_content", "div")[0];
    var height = content.getBoundingClientRect().bottom;

    noteBox.innerHTML = "";
    noteBox.style.minHeight = height - 50 + "px";

    for(var item in obj){
        builtBody(item, obj[item], "note", noteBox);
    }
}

function builtBody(tit, con, mode, box){
    var title = document.createElement("p");
    title.innerHTML = tit + ":";
    title.className = mode + "-title";
    var content = document.createElement("p");
    content.innerHTML = con;
    content.className = mode + "-content";
    box.appendChild(title);
    box.appendChild(content);
}

function getClassNames(classStr,tagName){
    if (document.getElementsByClassName) {
        return document.getElementsByClassName(classStr)
    }else {
        var nodes = document.getElementsByTagName(tagName),ret = [];
        for(i = 0; i < nodes.length; i++) {
            if(hasClass(nodes[i],classStr)){
                ret.push(nodes[i])
            }
        }
        return ret;
    }
}
function hasClass(tagStr,classStr){
    var arr=tagStr.className.split(/\s+/ );
    for (var i=0;i<arr.length;i++){
        if (arr[i]==classStr){
            return true ;
        }
    }
    return false ;
}