  
#ifndef _LIBRDUSR_H_

#define _LIBRDUSR_H_

#pragma pack(push)  /* push current alignment to stack */
#pragma pack(1)     /* set alignment to 1 byte boundary */ 

enum rdi_conf {
    RDI_INIT=1,
    RDI_CLEAR, 
    RDI_CLEAR_GROUP, 
    RDI_SET_CFG,
    RDI_SET_DROP,
    RDI_SET_DIR,
    RDI_SET_MIR,
    RDI_GET_CFG,
    RDI_INSTALL,
    RDI_INSTALL_GROUP,
    RDI_GET_CNT,
    RDI_ENTRY_REMOVE,
    RDI_ENTRY_QUERY,
    RDI_ENTRY_QUERY_LIST,
    RDI_GET_DEV_NUM,
    RDI_SET_PORT_MASK,
    RDI_GET_PORT_MASK,
    RDI_SET_PERMIT,
    RDI_SET_MOD0=49,
    RDI_SET_MOD1=50,
    RDI_SET_MOD2,
    RDI_SET_L2_HASH,
    RDI_SET_L3_HASH,
    RDI_ADD_RULE,

    RDI_LBG_QUERY_LIST,
    RDI_LBG_PORT_QUERY_LIST,
    RDI_LBG_REMOVE,
    RDI_LBG_ADD,
    RDI_LBG_PORT_REMOVE,
    RDI_LBG_PORT_ADD,

    RDI_GET_L2_HASH,
    RDI_GET_L3_HASH,

	RDI_GET_PORT_LINK,
	RDI_GET_TEMP,

    RDI_MIR_QUERY_LIST,
    RDI_MIR_PORT_QUERY_LIST,
    RDI_MIR_REMOVE,
    RDI_MIR_ADD,
    RDI_MIR_PORT_REMOVE,
    RDI_MIR_PORT_ADD,
	RDI_SET_PRIO,
	RDI_MIR_VLAN_ADD,
	RDI_ADD_VLAN_PROMISC,
	RDI_DEL_VLAN_PROMISC,
    RDI_GET_PORT_SPEED,
    RDI_GET_PORT_ETH_MODE,

    RDI_MCG_CREATE,
    RDI_MCG_GET_PORT,
    RDI_MCG_ADD_LISTENER,
    RDI_MCG_REMOVE,

    RDI_SET_PORT_PARSER,
    RDI_GET_PORT_PARSER,
    RDI_SET_RFRAME_UPDATE,
    RDI_GET_RFRAME_UPDATE,
    RDI_SET_TTL_UPDATE,
    RDI_GET_TTL_UPDATE,

    RDI_SET_SW_REMAIN,
    RDI_GET_SW_REMAIN,

    RDI_READ_PHY=100,
    RDI_WRITE_PHY,
    RDI_CPLD_READ,
    RDI_CPLD_WRITE,
    RDI_BP_READ,
    RDI_BP_WRITE,
	RDI_GET_GPIO_DIR,
	RDI_SET_GPIO_DIR,
	RDI_GET_GPIO,
	RDI_SET_GPIO,
	RDI_GET_REG,
	RDI_SET_REG,
    
	RDI_TEMP_READ,
	RDI_TEMP_WRITE,

	RDI_SET_PRBS,
	RDI_GET_PORT_STATE,

	RDI_SET_LOOPBACK,

	RDI_TEMP1_READ,
	RDI_TEMP1_WRITE,

    RDI_FCI_READ,
    RDI_FCI_WRITE,

    RDI_FCI_RX_READ,
    RDI_FCI_RX_WRITE,

    RDI_GET_VLAN_STAT=200,
    RDI_GET_STAT,
	RDI_GET_PRIO_STAT,
	RDI_RESET_STAT,
    RDI_GET_POWER,

} ;

enum rdi_action {
    RDI_ACT_PERMIT=0,
    RDI_ACT_DROP=1,
    RDI_ACT_TRAP, //2
    RDI_ACT_MIRROR, //3
    RDI_ACT_LOG, //4
    RDI_ACT_COUNT, //5
    RDI_ACT_NOTIFY, //6
    RDI_ACT_POLICE, //7
    RDI_ACT_SET_VLAN, //8
    RDI_ACT_SET_VLAN_PRI, //9
    RDI_ACT_SET_SWITCH_PRI, //10
    RDI_ACT_SET_DSCP, //11
    RDI_ACT_SET_USER, //12
    RDI_ACT_LOAD_BALANCE, //13
    RDI_ACT_TRAP_ALWAYS, //14
    RDI_ACT_REDIRECT, //15
    RDI_ACT_NOROUTE, //16
    RDI_ACT_ROUTE, //17
} ;




typedef struct rdi_udf_s {
    short flag; 
    unsigned int offset;
    unsigned int data;
    unsigned int mask;
} rdi_udf_t;


typedef struct rdi_mac_s {
    short flag;
    unsigned char mac[6];
} rdi_mac_t;

typedef struct rdi_ip6_s {
    short flag;
    unsigned char ip[16];
} rdi_ip6_t;



typedef struct rdi_mem {
    int group;
    int rule_id;
    int rule_act;
    int port;
    int redir_port;
    int src_port;
    int dst_port;
    unsigned int src_ip;
    unsigned int dst_ip;
    unsigned int src_ip_mask;
    unsigned int dst_ip_mask;
    int src_port_mask;
    int dst_port_mask;
    int src_port_max;
    int dst_port_max;
    int ip_protocol;
    int vlan;
    int vlan_mask;
    int vlan_max;
    int mirror_port;

    int mpls_type;

	uint64_t mpls_header;
	uint64_t mpls_header_mask;

    int ether_type;
    rdi_udf_t rdi_udf;
    rdi_mac_t src_mac;
    rdi_mac_t dst_mac;
    rdi_ip6_t src_ip6;
    rdi_ip6_t dst_ip6;
    rdi_ip6_t src_ip6_mask;
    rdi_ip6_t dst_ip6_mask;
    int vlan_act;
    int vlan_pri_act;
    int vlan_tag;
    int usr_act;
} rdi_mem_t;


typedef struct rdi_query_rule {
    rdi_mem_t rdi_mem;
    int ret;
} rdi_query_rule_t;

typedef struct rdi_id_list {
    unsigned int rule_num;
    unsigned short id_list[4096];
} rdi_id_list_t;


typedef struct rdi_query_list {
    rdi_id_list_t rdi_id_list;
    int ret;
}rdi_query_list_t; 

typedef struct rdi_vlan_stat_cnt {
    unsigned long long vland;
    unsigned long long tvlan;
    unsigned long long tvland;
}rdi_vlan_stat_cnt_t; 

typedef struct rdib_stat_cnt {
    unsigned long long total;
    unsigned long long txnoerror;
    unsigned long long rxnoerror;
    unsigned long long rxdrop;
    unsigned long long txdrop;
}rdib_stat_cnt_t; 


typedef struct rdif_stat_cnt {
    unsigned long long  cntRxUcstPkts;
    unsigned long long  cntRxUcstPktsNonIP;
    unsigned long long  cntRxUcstPktsIPv4;
    unsigned long long  cntRxUcstPktsIPv6;
    unsigned long long  cntRxBcstPkts;
    unsigned long long  cntRxBcstPktsNonIP;  
    unsigned long long  cntRxBcstPktsIPv4; 
    unsigned long long  cntRxBcstPktsIPv6;
    unsigned long long  cntRxMcstPkts;
    unsigned long long  cntRxMcstPktsNonIP;
    unsigned long long  cntRxMcstPktsIPv4;
    unsigned long long  cntRxMcstPktsIPv6;
    unsigned long long  cntRxPausePkts;
    unsigned long long  cntRxCBPausePkts;
    unsigned long long  cntRxFCSErrors;
    unsigned long long  cntRxSymbolErrors;
    unsigned long long  cntRxFrameSizeErrors;
    unsigned long long  cntRxMinTo63Pkts;
    unsigned long long  cntRx64Pkts;
    unsigned long long  cntRx65to127Pkts;
    unsigned long long  cntRx128to255Pkts;
    unsigned long long  cntRx256to511Pkts;
    unsigned long long  cntRx512to1023Pkts;
    unsigned long long  cntRx1024to1522Pkts;
    unsigned long long  cntRx1523to2047Pkts;
    unsigned long long  cntRx2048to4095Pkts;
    unsigned long long  cntRx4096to8191Pkts;
    unsigned long long  cntRx8192to10239Pkts;
    unsigned long long  cntRx10240toMaxPkts;
    unsigned long long  cntRxFragmentPkts;
    unsigned long long  cntRxUndersizedPkts;
    unsigned long long  cntRxJabberPkts;
    unsigned long long  cntRxOversizedPkts;
    unsigned long long  cntRxGoodOctets;
    unsigned long long  cntRxOctetsNonIp;
    unsigned long long  cntRxOctetsIPv4;
    unsigned long long  cntRxOctetsIPv6;
    unsigned long long  cntRxBadOctets;
    unsigned long long  cntRxPriorityPkts;
    unsigned long long  cntRxPriorityOctets;
    unsigned long long  cntTxUcstPkts;
    unsigned long long  cntTxBcstPkts;
    unsigned long long  cntTxMcstPkts;
    unsigned long long  cntTxPausePkts;
    unsigned long long  cntTxFCSErroredPkts;
    unsigned long long  cntTxErrorDropPkts;
    unsigned long long  cntTxTimeOutPkts;
    unsigned long long  cntTxLoopbackPkts;
    unsigned long long  cntTxMinTo63Pkts;
    unsigned long long  cntTx64Pkts;
    unsigned long long  cntTx65to127Pkts;
    unsigned long long  cntTx128to255Pkts;
    unsigned long long  cntTx256to511Pkts;
    unsigned long long  cntTx512to1023Pkts;
    unsigned long long  cntTx1024to1522Pkts;
    unsigned long long  cntTx1523to2047Pkts;
    unsigned long long  cntTx2048to4095Pkts;
    unsigned long long  cntTx4096to8191Pkts;
    unsigned long long  cntTx8192to10239Pkts;
    unsigned long long  cntTx10240toMaxPkts;
    unsigned long long  cntTxOctets;
    unsigned long long  cntTxErrorOctets;
    unsigned long long  cntTxCMDropPkts;
    unsigned long long  cntFIDForwardedPkts;
    unsigned long long  cntFloodForwardedPkts;
    unsigned long long  cntSpeciallyHandledPkts;
    unsigned long long  cntParseErrDropPkts;
    unsigned long long  cntParityErrorPkts;
    unsigned long long  cntTrappedPkts;
    unsigned long long  cntPauseDropPkts;
    unsigned long long  cntSTPDropPkts;
    unsigned long long  cntReservedTrapPkts;
    unsigned long long  cntSecurityViolationPkts;
    unsigned long long  cntVLANTagDropPkts;
    unsigned long long  cntVLANIngressBVPkts;
    unsigned long long  cntVLANEgressBVPkts;
    unsigned long long  cntGlortMissDropPkts;
    unsigned long long  cntFFUDropPkts;
    unsigned long long  cntPolicerDropPkts;
    unsigned long long  cntTTLDropPkts;
    unsigned long long  cntCmPrivDropPkts;
    unsigned long long  cntSmp0DropPkts;
    unsigned long long  cntSmp1DropPkts;
    unsigned long long  cntRxHog0DropPkts;
    unsigned long long  cntRxHog1DropPkts;
    unsigned long long  cntTxHog0DropPkts;
    unsigned long long  cntTxHog1DropPkts;
    unsigned long long  cntRateLimit0DropPkts;
    unsigned long long  cntRateLimit1DropPkts;
    unsigned long long  cntBadSmpDropPkts;
    unsigned long long  cntTriggerDropRedirPkts;
    unsigned long long  cntTriggerDropPkts;
    unsigned long long  cntTriggerRedirPkts;
    unsigned long long  cntTriggerMirroredPkts;
    unsigned long long  cntBroadcastDropPkts;
    unsigned long long  cntDLFDropPkts;
    unsigned long long  cntRxCMDropPkts;
    unsigned long long  cntUnderrunPkts;
    unsigned long long  cntOverrunPkts;
    unsigned long long  cntCorruptedPkts;
    unsigned long long  cntStatsDropCountTx;
    unsigned long long  cntStatsDropCountRx;
} rdif_stat_cnt_t;

typedef struct rdif_prio_stat_cnt {
    unsigned long long  cntRxPriorityPkts[16];
} rdif_prio_stat_cnt_t;


typedef struct _rdi_hashRotationValue {
    /** The shift amount in the operation is one plus this value. */
    unsigned char   exponent;

    /** The amount the input hash value is multiplied by before shifting. */
    unsigned short mantissa;

} rdi_hashRotationValue;

#define RDI_L2_HASH_SMAC        1<<0
#define RDI_L2_HASH_DMAC        1<<1
#define RDI_L2_HASH_ETHER_TYPE  1<<2
#define RDI_L2_HASH_VLAN_ID     1<<3
#define RDI_L2_HASH_VLAN_PRI    1<<4
#define RDI_L2_HASH_SYM_MAC      1<<5
#define RDI_L2_HASH_VLAN2_ID  1<<6
#define RDI_L2_HASH_VLAN2_PRI     1<<7
#define RDI_L2_HASH_PROFILE_IDX     1<<24

typedef struct rdi_l2_hash {

    unsigned int l2_hash_set;
    /** Indicates the inclusion bit mask for the SMAC field.  
     *  The valid range is 0 (disable) to 0xffffffffffff (all bits
     *  included).  The default is 0xffffffffffff.
     *                                                                  
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     *   */
	unsigned int profile_index;
    unsigned char src_mac_mask[6];
    /** Indicates the inclusion bit mask for the DMAC field.  
     *  The valid range is 0 (disable) to 0xffffffffffff (all bits
     *  included).  The default is 0xffffffffffff.
     *                                                                  
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     */ 
    unsigned char dst_mac_mask[6];

    /** Indicates the inclusion bit mask for the EtherType field.  
     *  The valid range is 0 (disable) to 0xffff (all bits
     *  included).  The default is 0xffff.
     *                                                                  
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     *  */
    unsigned int ether_type_mask;

    /** Indicates the inclusion bit mask for the VLAN ID 1 field.  
     *  The valid range is 0 (disable) to 0xfff (all bits
     *  included).  The default is 0xfff.
     *                                                                  
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     */  
    unsigned int vlan_id_mask;

    /** Indicates the inclusion bit mask for the VLAN Priority 1 field.  
     *  The valid range is 0 (disable) to 0xf. The default is 0xf (all
     *  bits included).
     *                                                                  
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     */  
    unsigned int  vlan_pri;

	    /** Indicates the inclusion bit mask for the VLAN ID 1 field.  
     *  The valid range is 0 (disable) to 0xfff (all bits
     *  included).  The default is 0xfff.
     *                                                                  
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     */  
    unsigned int vlan2_id_mask;

    /** Indicates the inclusion bit mask for the VLAN Priority 1 field.  
     *  The valid range is 0 (disable) to 0xf. The default is 0xf (all
     *  bits included).
     *                                                                  
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     */  
    unsigned int  vlan2_pri;



    /** Enable symmetrizing of the source and destination MAC fields.
     *  The default is FALSE.
     *  
     *   */
    unsigned int  sym_mac;











} rdi_l2_hash_t;


#define RDI_L3_HASH_SIP        1<<0
#define RDI_L3_HASH_DIP        1<<1
#define RDI_L3_HASH_SPORT  1<<2
#define RDI_L3_HASH_DPORT     1<<3
#define RDI_L3_HASH_DSCP      1<<4
#define RDI_L3_HASH_ISL_USR  1<<5
#define RDI_L3_HASH_PROTO     1<<6
#define RDI_L3_HASH_FLOW     1<<7
#define RDI_L3_HASH_SYM_L3_FIELDS     1<<8
#define RDI_L3_HASH_SYM_L4_FIELDS     1<<9
#define RDI_L3_HASH_CUSTOM     1<<10
#define RDI_L3_HASH_RND_NEXT_HOP     1<<11
#define RDI_L3_HASH_RND_OTHER     1<<12

#define RDI_L3_HASH_RND_ONLY     1<<13


typedef struct rdi_l3_hash {

    unsigned int l3_hash_set;

	unsigned int profile_index;

    /** Indicates the inclusion byte mask for the SIP field. Each bit of this
     *  mask indicates a full byte of the SIP with bit 0 corresponding to 
     *  byte 0, bit 1 to byte 1, etc. The valid range is 0 (disable) to 
     *  0xffff (all bytes included). The default is 0xffff.
     *                                                                  \lb\lb
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     *  
     *   */
    unsigned int  src_ip_mask;

    /** Indicates the inclusion byte mask for the DIP field. Each bit of this
     *  mask indicates a full byte of the SIP with bit 0 corresponding to 
     *  byte 0, bit 1 to byte 1, etc. The valid range is 0 (disable) to 
     *  0xffff (all bytes included). The default is 0xffff.
     *                                                                  \lb\lb
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     *  
     *   */
    unsigned int  dst_ip_mask;

    /** Indicates the inclusion bit mask for the layer 4 source port.
     *  The valid range is 0 (disable) to 0xffff (all bits included).
     *  The default is 0xffff.
     *                                                                  \lb\lb
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     *  
     *   */
    unsigned int  src_port_mask;

    /** Indicates the inclusion bit mask for the layer 4 destination port.
     *  The valid range is 0 (disable) to 0xffff (all bits included).
     *  The default is 0xffff.
     *                                                                  \lb\lb
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     *  
     *   */
    unsigned int  dst_port_mask;

    /** Indicates the inclusion bit mask for the DSCP field value.
     *  The valid range is 0 (disable) to 0xff (all bits included).
     *  The default is 0xff.
     * 
     *   */
    unsigned int dscp_mask;

    /** Indicates the inclusion bit mask for the ISL_USER field value.
     *  The valid range is 0 (disable) to 0xff (all bits included).
     *  The default is 0.
     * 
     *  */
    unsigned int isl_usr_mask;

    /** Indicates the inclusion bit mask for the layer 3 protocol field
     *  value. The valid range is 0 (disable) to 0xff (all bits included).
     *  The default is 0xff.
     *                                                                  \lb\lb
     *  Acts as a boolean
     *  and any value different then 0 will enable this specific key.
     *  
     *   */
    unsigned int  proto_mask;

    /** Indicates the inclusion byte mask for the custom parser field value.
     *  This value is dependent on the parser microcode and FFU rules. Each 
     *  bit of this mask indicates a full byte of the custome parser field 
     *  with bit 0 corresponding to byte 0, bit 1 to byte 1, etc. The valid 
     *  range is 0 (disable) to 0xff (all bytes included). The default is 0.
     * 
     *  \chips  FM6000 */
    unsigned int  custom_mask;



    /** Indicates the inclusion bit mask for the IPv6 flow field value.
     *  The valid range is 0 (disabled) to 0xfffff (all bits included).
     *  The default is 0xfffff.
     * 
     *   */
    unsigned int  flow_mask;

    /** Enable symmetrizing of the SIP & DIP fields. This ensures that frames
     *  with opposite SIP & DIP fields will hash the same with respect to
     *  those fields. The default is FALSE.
     * 
     *   */
    unsigned char  sym_l3_fields;

    /** Enable symmetrizing of the layer 4 source and destination port fields. 
     *  This ensures that frames with opposite source & destination port fields
     *  will hash the same with respect to those fields. The default is FALSE.
     * 
     *   */
    unsigned char    sym_l4_fields;


    /** Enable use of the hardware PTable to facilitate improved hash results.
     *  Note that this will require configuring the PTable (register
     *  HASH_LAYER3_PTABLE). The default 
     *  is FALSE.
     * 
     *  \chips  FM6000 */
    unsigned char    use_ptable;

    /** Enable producing a random value to the next-hop evaluation stage.
     *  Default is FALSE.
     *  
     *  \chips  FM6000 */
    unsigned char    random_next_hop;

    /** Enable producing a random value to other stages downstream of the
     *  hash calculation. Default is FALSE.
     *  
     *  \chips  FM6000 */
    unsigned char    random_other;

    /** If set to true, disable all hash computation except for the random 
     *  outputs, if they are enabled. Default is FALSE.
     *  
     *  \chips  FM6000 */
    unsigned char    random_only;

} rdi_l3_hash_t;



typedef union rdi_stat_cnt {
    rdib_stat_cnt_t rdib;
    rdif_stat_cnt_t rdif;
	rdif_prio_stat_cnt_t prio_rdif;
}rdi_stat_cnt_t; 





typedef struct rdi_rule_stat_cnt {
    unsigned long long counter;
}rdi_rule_stat_cnt_t; 


typedef struct rdi_rule_stat {
    rdi_rule_stat_cnt_t rdi_rule_stat_cnt;
    int ret_val;  
}rdi_rule_stat_t; 

typedef struct rdi_stat {
    rdi_stat_cnt_t rdi_stat_cnt;
    int ret_val;  
}rdi_stat_t; 

typedef struct rdi_vlan_stat {
    rdi_vlan_stat_cnt_t rdi_vlan_stat_cnt;
    int ret_val;  
}rdi_vlan_stat_t; 



typedef struct rdi_sfi_diag {
    unsigned short tx_power;
    unsigned short rx_power;
    unsigned int rsv[3];
} rdi_sfi_diag_t;

typedef enum rdi_type_s {
    RDI_BCM_DEV=1,
    RDI_FLCM_DEV
}rdi_type_t;




typedef struct if_rdi {
    int rdi_cmd;
    int unit;
    int cfg;
    rdi_mem_t rdi_mem;

    int if_index; /* network device index of management interface */

    int rule_id;
    int group;
    int port;
    unsigned int mask;
    rdi_query_list_t rdi_query_list;
    rdi_rule_stat_t rdi_rule_stat;
    rdi_vlan_stat_t rdi_vlan_stat;
    rdi_stat_t rdi_stat;
    rdi_l2_hash_t l2_hash;
    rdi_l3_hash_t l3_hash;
    int action;

    /* diagnostic fieds */
    int phy_addr;
    int addr;
    int dev;
    int val;

} if_rdi_t; 



typedef struct rdi_lbg_list {
    int num;
    int list[32];
} rdi_lbg_list_t;


typedef struct rdi_lbg_query_list {
    rdi_lbg_list_t rdi_lbg_list;
    int ret;
}rdi_lbg_query_list_t;


typedef struct if_rdi_lbg {
    int rdi_cmd;
    int unit;
    rdi_lbg_query_list_t rdi_query_list;
    int lbg;
    int port;

} if_rdi_lbg_t;


typedef struct rdi_bp_data_list {
    unsigned int num;
    unsigned char list[4096];
} rdi_bp_data_t;

typedef struct rdi_bp_query_data {
    rdi_bp_data_t data;
    int ret;
}rdi_bp_query_data_t; 
 
typedef struct if_rdi_bp {
    int rdi_cmd;
    int unit;
    rdi_bp_query_data_t bp_query_data;
    int dev;
    int addr;
} if_rdi_bp_t; 

typedef struct rdi_mask {
	unsigned char ingress[16];
	unsigned char egress[16];
	int ret_val;
} rdi_mask_t; 

typedef struct if_rdi_mask {
    unsigned int rdi_cmd;
    unsigned int unit;
    rdi_mask_t mask;
} if_rdi_mask_t;

#define RDI_ETH_MODE_ENABLED_BIT_MASK     0x010000
#define RDI_ETH_MODE_4_LANE_BIT_MASK      0x020000
#define RDI_ETH_MODE_40G_BIT_MASK         0x040000
#define RDI_ETH_MODE_100G_BIT_MASK        0x080000
#define RDI_ETH_MODE_LR_BIT_MASK          0x100000
#define RDI_ETH_MODE_MULTI_LANE_MASK      ( RDI_ETH_MODE_4_LANE_BIT_MASK )

enum  rdi_eth_mode
{
    /** Port is disabled on the specified MAC. No lanes will be used.
     *  A port must be put in this state when another port sharing the
     *  same MAC is using a 4-lane mode. This is the default value 
     *  for the ''RDI_PORT_ETHERNET_INTERFACE_MODE'' attribute. */
    RDI_ETH_MODE_DISABLED = 0,

    /**************************************************
     * Non-40G, 1-lane modes
     **************************************************/
     
    /** SGMII: 1G, 1 lane, 8b/10b encoding. */
    RDI_ETH_MODE_SGMII = RDI_ETH_MODE_ENABLED_BIT_MASK,

    /** 1000BASE-X: 1G, 1 lane, 8b/10b encoding. */
    RDI_ETH_MODE_1000BASE_X,

    /** 1000BASE-KX: 1G, 1 lane, 8b/10b encoding. */
    RDI_ETH_MODE_1000BASE_KX,

    /** 2500BASE-X: 1G, 1 lane, 8b/10b encoding.
     *  This is experimental and to be used for internal purposes only. */
    RDI_ETH_MODE_2500BASE_X,

    /** 6GBASE-KR: 6G, 1 lane, 64b/66b encoding.
     *  This is experimental and to be used for internal purposes only. */
    RDI_ETH_MODE_6GBASE_KR,

    /** 6GBASE-CR: 6G, 1 lane, 64b/66b encoding. 
     *  This is experimental and to be used for internal purposes only. */
    RDI_ETH_MODE_6GBASE_CR,

    /** 10GBASE-KR: 10G, 1 lane, 64b/66b encoding.
     *  This mode is read-only, i.e., it can be set only through Clause-73
     *  autonegotiation. */
    RDI_ETH_MODE_10GBASE_KR,

    /** 10GBASE-CR (SFP+): 10G, 1 lane, 64b/66b encoding. */
    RDI_ETH_MODE_10GBASE_CR,
    
    /** 10GBASE-SR (SFP+, SFI): 10G, 1 lane, 64b/66b encoding. */
    RDI_ETH_MODE_10GBASE_SR,

    /** 25GBASE-SR (SFP+, SFI): 25G, 1 lane, 64/66b encoding. */
    RDI_ETH_MODE_25GBASE_SR,

    /** 25GBASE-KR: 25G, 1 lane, 64/66b encoding.
     *  This mode is read-only, i.e., it can be set only through Clause-73
     *  autonegotiation. */
    RDI_ETH_MODE_25GBASE_KR
,
    /** 25GBASE-CR: 25G, 1 lane, 64/66b encoding.
     *  This mode is read-only, i.e., it can be set only through Clause-73
     *  autonegotiation. */
    RDI_ETH_MODE_25GBASE_CR,

    /** AN-73: Auto-negotiation Clause 73. */
    RDI_ETH_MODE_AN_73,


    /**************************************************
     * Non-40G, 4-lane modes
     **************************************************/
    
    /** XAUI: 10G, 4 lanes, 8b/10b encoding.
     *                                                                  \lb\lb
     *  Note: After configuring this mode on the second port (P1) of the
     *  set of four ports sharing a MAC, before setting the port to another 
     *  mode, you must first set the mode to ''RDI_ETH_MODE_DISABLED''. */
    RDI_ETH_MODE_XAUI = (RDI_ETH_MODE_4_LANE_BIT_MASK |
                        RDI_ETH_MODE_ENABLED_BIT_MASK),

    /** 10GBASE-KX4: 10G, 4 lanes, 8b/10b encoding. */
    RDI_ETH_MODE_10GBASE_KX4,

    /** 10GBASE-CX4: 10G, 4 lanes, 8b/10b encoding. */
    RDI_ETH_MODE_10GBASE_CX4,

    /**************************************************
     * 40G, 4-lane modes (treat 24GBASE as 40G)
     **************************************************/

    /** 24GBASE-KR4: 24G, 4 lanes, 64b/66b encoding.
     * This is experimental and to be used for internal purposes only. */
    RDI_ETH_MODE_24GBASE_KR4 = (RDI_ETH_MODE_40G_BIT_MASK    |
                               RDI_ETH_MODE_4_LANE_BIT_MASK |
                               RDI_ETH_MODE_ENABLED_BIT_MASK), 
    
    /** 24GBASE-CR4: 24G, 4 lanes, 64b/66b encoding.
     * This is experimental and to be used for internal purposes only. */
    RDI_ETH_MODE_24GBASE_CR4,

    /** 40GBASE-KR4: 40G, 4 lane, 64b/66b encoding.
     *  This mode is read-only, i.e., it can be set only through Clause-73
     *  autonegotiation. */
    RDI_ETH_MODE_40GBASE_KR4,

    /** XLAUI: 40G, 4 lane, 64b/66b encoding. */
    RDI_ETH_MODE_XLAUI,

    /** 40GBASE-CR4 (QSFP 5M Direct Attach): 40G, 4 lane, 64b/66b encoding.
     *  This mode is read-only, i.e., it can be set only through Clause-73
     *  autonegotiation. */
    RDI_ETH_MODE_40GBASE_CR4,

    /** 40GBASE-SR4 (QSFP PMD Service Interface): 40G, 4 lane, 64b/66b 
     *  encoding. */
    RDI_ETH_MODE_40GBASE_SR4,

    /** 100GBASE-SR4 (QSFP PMD Service Interface): 100G, 4 lane, 64b/66b
     *  encoding. */
    RDI_ETH_MODE_100GBASE_SR4 = ( RDI_ETH_MODE_100G_BIT_MASK    |
                                 RDI_ETH_MODE_4_LANE_BIT_MASK  |
                                 RDI_ETH_MODE_ENABLED_BIT_MASK ), 

    /** 40GBASE-CR4: 100G, 4 lanes, 64b/66b encoding. This mode is read-only,
     *  i.e., it can be set only through Clause-73 autonegotiation. */
    RDI_ETH_MODE_100GBASE_CR4,


    /** 40GBASE-KR4: 100G, 4 lanes, 64b/66b encoding. This mode is read-only,
     *  i.e., it can be set only through Clause-73 autonegotiation. */
    RDI_ETH_MODE_100GBASE_KR4,

    RDI_ETH_MODE_40GBASE_LR4 = (RDI_ETH_MODE_40GBASE_SR4 | RDI_ETH_MODE_LR_BIT_MASK),

    RDI_ETH_MODE_100GBASE_LR4 = (RDI_ETH_MODE_100GBASE_SR4 | RDI_ETH_MODE_LR_BIT_MASK),

};
 



int rdi_get_dev_num(rdi_type_t rdi_type);

int rdi_init(int unit, int if_index, rdi_type_t rdi_type);
int rdi_set_mod0(int unit, rdi_type_t rdi_type);

int rdi_set_mod1(int unit, rdi_type_t rdi_type);
int rdi_set_mod2(int unit, rdi_type_t rdi_type);


int rdi_set_cfg(int unit, int cfg, rdi_type_t rdi_type);
int rdi_entry_remove(int unit, int rule_id, int group, rdi_type_t rdi_type);
int rdi_get_cfg(int unit, rdi_type_t rdi_type);
int rdi_get_temp(int unit, rdi_type_t rdi_type);
int rdi_add_rule_drop(int unit, rdi_mem_t *rdi_mem, rdi_type_t rdi_type);
int rdi_add_rule_permit(int unit, rdi_mem_t *rdi_mem, rdi_type_t rdi_type);
int rdi_add_rule(int unit, rdi_mem_t *rdi_mem, int action, rdi_type_t rdi_type);


int rdi_add_rule_dir(int unit, rdi_mem_t *rdi_mem, rdi_type_t rdi_type);
int rdi_add_rule_mir(int unit, rdi_mem_t *rdi_mem, rdi_type_t rdi_type);
int rdi_install_rules(int unit, rdi_type_t rdi_type);
int rdi_clear_rules(int unit, rdi_type_t rdi_type);
int rdi_install_rules_group(int unit, int group, rdi_type_t rdi_type);
int rdi_clear_rules_group(int unit, int group, rdi_type_t rdi_type);
int rdi_entry_query(int unit, rdi_mem_t *rdi_mem, rdi_type_t rdi_type);

int rdi_get_rule_counters(int unit, int rule_id, int group, void *val, rdi_type_t rdi_type);
int rdi_entry_query_list(int unit, int group, rdi_query_list_t *rdi_query_list, rdi_type_t rdi_type);
int rdi_get_vlan_stat(int unit, int port, rdi_vlan_stat_cnt_t *rdi_vlan_stat_cnt, rdi_type_t rdi_type);
int rdi_get_stat(int unit, int port, rdi_stat_cnt_t *val, rdi_type_t rdi_type);
int rdi_get_prio_stat(int unit, int port, rdi_stat_cnt_t *val, rdi_type_t rdi_type);
int rdi_reset_stat(int unit, int port, rdi_type_t rdi_type);
int rdi_get_rule_stat(int unit, int rule_id, int group, rdi_rule_stat_cnt_t *rdi_rule_stat_cnt, rdi_type_t rdi_type);
int rdi_read_phy(int unit, int phy_addr, int dev, int addr, rdi_type_t rdi_type);
int rdi_write_phy(int unit, int phy_addr, int dev, int addr, int val, rdi_type_t rdi_type);

int rdi_get_gpio_dir(int unit, int gpio, rdi_type_t rdi_type);
int rdi_set_gpio_dir(int unit, int gpio, int dir, int val, rdi_type_t rdi_type);

int rdi_set_prbs(int unit, int prbs, int dir, int port, rdi_type_t rdi_type);


int rdi_get_gpio(int unit, int gpio, rdi_type_t rdi_type);
int rdi_set_gpio(int unit, int gpio, int val, rdi_type_t rdi_type);

int rdi_set_loopback(int unit, int val, int port, rdi_type_t rdi_type);


int rdi_get_reg(int unit, unsigned int addr, unsigned int *val, rdi_type_t rdi_type);
int rdi_set_reg(int unit, unsigned int addr, unsigned int val, rdi_type_t rdi_type);

int rdi_get_power(int unit, int port, rdi_sfi_diag_t *sfi_diag, rdi_type_t rdi_type);

int rdi_set_port_mask(int unit, int port, unsigned int mask, rdi_type_t rdi_type);
int rdi_get_port_mask(int unit, int port, unsigned char *mask, rdi_type_t rdi_type);

int rdi_set_mask(int unit, rdi_mask_t *mask, rdi_type_t rdi_type);
int rdi_get_mask(int unit, rdi_mask_t *mask, rdi_type_t rdi_type);
 

int rdi_cpld_write(int unit, int addr, unsigned int val, rdi_type_t rdi_type);
int rdi_cpld_read(int unit, int addr, unsigned char *val, rdi_type_t rdi_type);



int rdi_set_l2_hash(int unit, rdi_l2_hash_t *l2_hash, rdi_type_t rdi_type);
int rdi_set_l3_hash(int unit, rdi_l3_hash_t *l3_hash, rdi_type_t rdi_type);

int rdi_get_l2_hash(int unit, rdi_l2_hash_t *l2_hash, rdi_type_t rdi_type);
int rdi_get_l3_hash(int unit, rdi_l3_hash_t *l3_hash, rdi_type_t rdi_type);


int rdi_lbg_query_entry_list(int unit, struct rdi_lbg_query_list *rdi_lbg_query_list, rdi_type_t rdi_type);
int rdi_lbg_port_query_entry_list(int unit, int lbg, rdi_lbg_query_list_t *rdi_lbg_query_list, rdi_type_t rdi_type);
int rdi_lbg_remove(int unit, int lbg, rdi_type_t rdi_type);
int rdi_lbg_add_fn(int unit, int *lbg, rdi_lbg_list_t *rdi_lbg_list, rdi_type_t rdi_type);
int rdi_lbg_port_remove(int unit, int lbg, int port, rdi_type_t rdi_type);
int rdi_lbg_port_add(int unit, int lbg, int port, rdi_type_t rdi_type);

int rdi_mir_query_entry_list(int unit, struct rdi_lbg_query_list *rdi_lbg_query_list, rdi_type_t rdi_type);
int rdi_mir_port_query_entry_list(int unit, int lbg, rdi_lbg_query_list_t *rdi_lbg_query_list, rdi_type_t rdi_type);
int rdi_mir_remove(int unit, int lbg, rdi_type_t rdi_type);
int rdi_mir_add_fn(int unit, int lbg, rdi_lbg_list_t *rdi_lbg_list, rdi_type_t rdi_type);
int rdi_mir_port_remove(int unit, int lbg, int port, rdi_type_t rdi_type);
int rdi_mir_port_add(int unit, int lbg, int port, rdi_type_t rdi_type);
int rdi_mir_vlan_add(int unit, int lbg, int vlan_id, rdi_type_t rdi_type);
int rdi_add_vlan_promisc(int unit, int port, rdi_type_t rdi_type);
int rdi_del_vlan_promisc(int unit, int port, rdi_type_t rdi_type);

int rdi_mcg_create(int unit, rdi_type_t rdi_type);
int rdi_mcg_get_port(int unit, int mcg, rdi_type_t rdi_type);
int rdi_mcg_add_listener(int unit, int mcg, int port, int vlan, rdi_type_t type);
int rdi_mcg_remove(int unit, int mcg, rdi_type_t rdi_type);

int rdi_get_rframe_update(int unit, int port, rdi_type_t rdi_type);
int rdi_set_rframe_update(int unit, int port, int val, rdi_type_t rdi_type);

int rdi_get_ttl_update(int unit, int port, rdi_type_t rdi_type);
int rdi_set_ttl_update(int unit, int port, int val, rdi_type_t rdi_type);

int rdi_get_port_parser(int unit, int port, rdi_type_t rdi_type);
int rdi_set_port_parser(int unit, int port, int val, rdi_type_t rdi_type);

int rdi_get_port_link(int unit, int port, rdi_type_t rdi_type);
int rdi_get_port_speed(int unit, int port, rdi_type_t rdi_type);

int rdi_get_eth_mode(int unit, int port, rdi_type_t rdi_type);

int rdi_get_port_state(int unit, int port, int *mode, int *state, int *info, rdi_type_t rdi_type);


int rdi_bp_read(int unit,int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type);
int rdi_bp_write(int unit,int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type);

int rdi_fci_read(int unit, int fci_num, int offset, int page, rdi_bp_query_data_t *rdi_bp_query_data,
				  rdi_type_t rdi_type);
int rdi_fci_write(int unit, int fci_num, int offset, int page, rdi_bp_query_data_t *rdi_bp_query_data,
				   rdi_type_t rdi_type);

int rdi_fci_rx_read(int unit, int fci_num, int offset, int page, rdi_bp_query_data_t *rdi_bp_query_data,
				  rdi_type_t rdi_type);
int rdi_fci_rx_write(int unit, int fci_num, int offset, int page, rdi_bp_query_data_t *rdi_bp_query_data,
				   rdi_type_t rdi_type);

int rdi_temp_read(int unit,int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type);
int rdi_temp_write(int unit,int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type);

int rdi_temp1_read(int unit,int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type);
int rdi_temp1_write(int unit,int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type);

int rdi_get_sw_remain(rdi_type_t rdi_type);
int rdi_set_sw_remain(int val, rdi_type_t rdi_type);


#endif /* _RDD_LIB_H_ */
