/******************************************************************************/
/*                                                                            */
/* bypass library, Copyright (c) 2004 Silicom, Ltd                            */
/* Corporation.                                                               */
/*                                                                            */
/* This program is free software; you can redistribute it and/or modify       */
/* it under the terms of the GNU General Public License as published by       */
/* the Free Software Foundation, located in the file LICENSE.                 */
/*                                                                            */
/* Ver 1.0.0                                                                  */
/*                                                                            */
/* librdi.c                                                                   */
/*                                                                            */
/******************************************************************************/
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#include <byteswap.h>

#include <time.h>
#include <sys/syslog.h>
#include <signal.h>
#include <net/if.h>

#include <sys/socket.h>

#include "../include/librdi.h"


#define RDI_SOCK_PATH "/var/run/rdictl.sock"
#define RDIF_SOCK_PATH "/var/run/rdifctl.sock"

#if 0

static void dumpBytes(unsigned char *bytes, unsigned int len)
{
    unsigned int cnt;

    for (cnt = 0 ; cnt < len ; cnt++) {
        printf("%02x", bytes[cnt]);

        if (cnt % 4 == 3) {

            printf(" ");
        }

        if (cnt % 32 == 31) {

            printf("\n");
        }
    }

    printf("\n");
}
#endif 




static int send_cmd(if_rdi_t *if_rdi, void * ret, int n, rdi_type_t rdi_type){
    int s, t, len;
    struct sockaddr_un remote;


    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
        perror("librdi socket");
        return -1;
    }
    remote.sun_family = AF_UNIX;
    if (rdi_type==RDI_FLCM_DEV)
        strcpy(remote.sun_path, RDIF_SOCK_PATH);
    else
        strcpy(remote.sun_path, RDI_SOCK_PATH);
    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("librdi connect");
        close(s);
        return -1;
    }

    if (send(s, if_rdi, sizeof(if_rdi_t), 0) == -1) {
        perror("librdi send");
        close(s);
        return -1;

    }
    if ((t=recv(s, ret, n, 0)) < 0) {
        perror("librdi recv");
        close(s);
        return -1;
    }
    close(s);
    return 0;

}

int rdi_get_dev_num(rdi_type_t rdi_type){

    if_rdi_t if_rdi;
    int ret=0; 

    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_GET_DEV_NUM;


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

static int send_cmd_query_rule(if_rdi_t *if_rdi, struct rdi_query_rule *rdi_query_rule,rdi_type_t rdi_type){
    int s, t, len;
    struct sockaddr_un remote;


    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
        perror("librdi socket");
        return -1;
    }
    remote.sun_family = AF_UNIX;
    if (rdi_type==RDI_FLCM_DEV)
        strcpy(remote.sun_path, RDIF_SOCK_PATH);
    else
        strcpy(remote.sun_path, RDI_SOCK_PATH);

    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("librdi connect");
        close(s);
        return -1;
    }

    if (send(s, if_rdi, sizeof(if_rdi_t), 0) == -1) {
        perror("librdi send");
        close(s);
        return -1;

    }
    if ((t=recv(s, rdi_query_rule, sizeof(rdi_query_rule_t), 0)) < 0) {
        perror("librdi recv");
        close(s);
        return -1;
    }
    close(s);
    return 0;

}

static int send_cmd_query_list(if_rdi_t *if_rdi, struct rdi_query_list *rdi_query_list,rdi_type_t rdi_type){
    int s, t, len;
    struct sockaddr_un remote;


    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
        perror("librdi socket");
        return -1;
    }
    remote.sun_family = AF_UNIX;
    if (rdi_type==RDI_FLCM_DEV)
        strcpy(remote.sun_path, RDIF_SOCK_PATH);
    else
        strcpy(remote.sun_path, RDI_SOCK_PATH);
    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("librdi connect");
        close(s);
        return -1;
    }


    if (send(s, if_rdi, sizeof(if_rdi_t), 0) == -1) {
        perror("librdi send");
        close(s);
        return -1;

    }
    if ((t=recv(s, rdi_query_list, sizeof(rdi_query_list_t), 0)) < 0) {
        perror("librdi recv");
        close(s);
        return -1;
    }
    close(s);
    return 0;

}


static int send_cmd_query_data(if_rdi_t *if_rdi, rdi_bp_query_data_t *rdi_query_list,rdi_type_t rdi_type){
    int s, t, len;
    struct sockaddr_un remote;


    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
        perror("librdi socket");
        return -1;
    }
    remote.sun_family = AF_UNIX;
    if (rdi_type==RDI_FLCM_DEV)
        strcpy(remote.sun_path, RDIF_SOCK_PATH);
    else
        strcpy(remote.sun_path, RDI_SOCK_PATH);
    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("librdi connect");
        close(s);
        return -1;
    }


    if (send(s, if_rdi, sizeof(if_rdi_t), 0) == -1) {
        perror("librdi send");
        close(s);
        return -1;

    }
    if ((t=recv(s, rdi_query_list, sizeof(rdi_bp_query_data_t), 0)) < 0) {
        perror("librdi recv");
        close(s);
        return -1;
    }
    close(s);
    return 0;

}

static int send_cmd_lbg_query_list(if_rdi_t *if_rdi, struct rdi_lbg_query_list *rdi_lbg_query_list,rdi_type_t rdi_type){
    int s, t, len;
    struct sockaddr_un remote;


    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
        perror("librdi socket");
        return -1;
    }
    remote.sun_family = AF_UNIX;
    if (rdi_type==RDI_FLCM_DEV)
        strcpy(remote.sun_path, RDIF_SOCK_PATH);
    else
        strcpy(remote.sun_path, RDI_SOCK_PATH);
    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("librdi connect");
        close(s);
        return -1;
    }

    if (send(s, if_rdi, sizeof(if_rdi_t), 0) == -1) {
        perror("librdi send");
        close(s);
        return -1;

    }
    if ((t=recv(s, rdi_lbg_query_list, sizeof(rdi_lbg_query_list_t), 0)) < 0) {
        perror("librdi recv");
        close(s);
        return -1;
    }
    close(s);
    return 0;

}





int rdi_init(int unit, int if_index, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_INIT;
    if_rdi.unit=unit;

    if (rdi_type==RDI_FLCM_DEV)
        if_rdi.if_index=if_index;

    if (!send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type))
        return ret;

    return -1;
}

int rdi_get_cfg(int unit, rdi_type_t rdi_type){

    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_GET_CFG;
    if_rdi.unit=unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret) , rdi_type)))
        return ret;
    return -1;

}

int rdi_get_temp(int unit, rdi_type_t rdi_type){
    int ret=0;
	unsigned int val;
    unsigned int subdevice;
	unsigned int dev_addr=0;
	rdi_bp_query_data_t rdi_bp_query_data;

	return -1;

	memset(&rdi_bp_query_data, 0, sizeof(rdi_bp_query_data_t));

	if ((ret = rdi_get_reg(unit, 0x12000b, (unsigned int *)&val, RDI_FLCM_DEV))<0) {
        return -1;
    }
	subdevice = (val >> 16) & 0xffff; 
	if(((subdevice & 0xff0) == 0x01B0) || 
	   (subdevice == 0))
		dev_addr = 0x2c;
	else
		dev_addr = 0x2e; 
		
    if (!rdi_type)
		rdi_type=RDI_FLCM_DEV;

	rdi_bp_query_data.data.num = 1;

	if ((rdi_temp_read(unit, dev_addr, &rdi_bp_query_data, rdi_type))<0) 
            return -1;
      else 
			return rdi_bp_query_data.data.list[0];

}


int rdi_get_port_link(int unit, int port, rdi_type_t rdi_type){

    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_GET_PORT_LINK;
    if_rdi.unit=unit;
	if_rdi.port=port;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret) , rdi_type)))
        return ret;
    return -1;

}

int rdi_get_port_speed(int unit, int port, rdi_type_t rdi_type){

    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_GET_PORT_SPEED;
    if_rdi.unit=unit;
	if_rdi.port=port;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret) , rdi_type)))
        return ret;
    return -1;

}

int rdi_get_eth_mode(int unit, int port, rdi_type_t rdi_type){

    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_GET_PORT_ETH_MODE;
    if_rdi.unit=unit;
	if_rdi.port=port;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret) , rdi_type)))
        return ret;
    return -1;

}


int rdi_add_vlan_promisc(int unit, int port, rdi_type_t rdi_type){

    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_ADD_VLAN_PROMISC;
    if_rdi.unit=unit;
	if_rdi.port=port;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret) , rdi_type)))
        return ret;
    return -1;

}

int rdi_del_vlan_promisc(int unit, int port, rdi_type_t rdi_type){

    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_DEL_VLAN_PROMISC;
    if_rdi.unit=unit;
	if_rdi.port=port;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret) , rdi_type)))
        return ret;
    return -1;

}


int rdi_install_rules(int unit, rdi_type_t rdi_type){

    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd=RDI_INSTALL;
    if_rdi.unit=unit;


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_install_rules_group(int unit, int group, rdi_type_t rdi_type){

    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd=RDI_INSTALL_GROUP;
    if_rdi.unit=unit;
    if_rdi.group=group;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}


int rdi_clear_rules(int unit, rdi_type_t rdi_type){

    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_CLEAR;
    if_rdi.unit=unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_clear_rules_group(int unit, int group, rdi_type_t rdi_type){

    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_CLEAR_GROUP;
    if_rdi.unit=unit;
    if_rdi.group=group;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_set_cfg(int unit, int cfg, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0;   
    memset(&if_rdi,0,sizeof(if_rdi_t));


    if_rdi.rdi_cmd=RDI_SET_CFG;
    if_rdi.cfg=cfg;
    if_rdi.unit=unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_set_mod0(int unit, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0;   
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_SET_MOD0;
    if_rdi.unit=unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_set_mod1(int unit, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0;   
    memset(&if_rdi,0,sizeof(if_rdi_t));


    if_rdi.rdi_cmd=RDI_SET_MOD1;
    if_rdi.unit=unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_set_mod2(int unit, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0;   
    memset(&if_rdi,0,sizeof(if_rdi_t));


    if_rdi.rdi_cmd=RDI_SET_MOD2;
    if_rdi.unit=unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}



int rdi_entry_remove(int unit, int rule_id, int group, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));


    if_rdi.rdi_cmd=RDI_ENTRY_REMOVE;
    if_rdi.rule_id=rule_id;
    if_rdi.unit=unit;
    if (rdi_type==RDI_FLCM_DEV) {

        if_rdi.group=group;

    }


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}


int rdi_entry_query(int unit, rdi_mem_t *rdi_mem, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    rdi_query_rule_t rdi_query_rule;
    memset(&if_rdi,0,sizeof(if_rdi_t));


    if_rdi.rdi_cmd=RDI_ENTRY_QUERY;
    if_rdi.unit=unit;

    if (!rdi_mem)
        return -1;
    memcpy(&if_rdi.rdi_mem, rdi_mem, sizeof(rdi_mem_t));


    if (!(send_cmd_query_rule(&if_rdi, &rdi_query_rule,rdi_type))) {
        memcpy(rdi_mem, &rdi_query_rule.rdi_mem, sizeof(rdi_mem_t));
        return rdi_query_rule.ret;
    } else return -1;



} 


/*typedef struct rdi_id_list{
    unsigned int rule_num;
    int id_list[120];
} rdi_id_list_t;


typedef struct rdi_query_list {
    rdi_id_list_t rdi_id_list[4];

    int ret;
}rdi_query_list_t; */

int rdi_entry_query_list(int unit, int group, rdi_query_list_t *rdi_query_list, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    memset(&if_rdi,0,sizeof(if_rdi_t));


    if_rdi.rdi_cmd=RDI_ENTRY_QUERY_LIST;
    if_rdi.unit=unit;
    if (rdi_type==RDI_FLCM_DEV)
        if_rdi.group=group;

    if (!rdi_query_list)
        return -1;

    if (!(send_cmd_query_list(&if_rdi, rdi_query_list, rdi_type))) {

        return rdi_query_list->ret;
    } else return -1;

}

int rdi_lbg_query_entry_list(int unit, rdi_lbg_query_list_t *rdi_lbg_query_list, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    if_rdi_lbg_t *if_rdi_lbg;
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi_lbg=(if_rdi_lbg_t *)&if_rdi;


    if_rdi.rdi_cmd=RDI_LBG_QUERY_LIST;
    if_rdi_lbg->unit=unit;

    if (!rdi_lbg_query_list)
        return -1;

    if (!(send_cmd_lbg_query_list(&if_rdi, rdi_lbg_query_list, rdi_type))) {

        return rdi_lbg_query_list->ret;
    } else return -1;

}

int rdi_mir_query_entry_list(int unit, rdi_lbg_query_list_t *rdi_lbg_query_list, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    if_rdi_lbg_t *if_rdi_lbg;
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi_lbg=(if_rdi_lbg_t *)&if_rdi;


    if_rdi.rdi_cmd=RDI_MIR_QUERY_LIST;
    if_rdi_lbg->unit=unit;

    if (!rdi_lbg_query_list)
        return -1;

    if (!(send_cmd_lbg_query_list(&if_rdi, rdi_lbg_query_list, rdi_type))) {

        return rdi_lbg_query_list->ret;
    } else return -1;

}

int rdi_get_port_state(int unit, int port, int *mode, int *state, int *info, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    if_rdi_lbg_t *if_rdi_lbg;
	rdi_lbg_query_list_t rdi_lbg_query_list;

    memset(&if_rdi,0,sizeof(if_rdi_t));
	memset(&rdi_lbg_query_list,0,sizeof(rdi_lbg_query_list_t));
    if_rdi_lbg = (if_rdi_lbg_t *)&if_rdi;

    if_rdi.rdi_cmd = RDI_GET_PORT_STATE;
    if_rdi_lbg->unit = unit;
    if_rdi_lbg->lbg = port;

    if (!(send_cmd_lbg_query_list(&if_rdi, &rdi_lbg_query_list, rdi_type))) {

		*mode = rdi_lbg_query_list.rdi_lbg_list.list[0];
		*state = rdi_lbg_query_list.rdi_lbg_list.list[1];
		*info = rdi_lbg_query_list.rdi_lbg_list.list[2];
		*(info+1) = rdi_lbg_query_list.rdi_lbg_list.list[3];
		*(info+2) = rdi_lbg_query_list.rdi_lbg_list.list[4];
		*(info+3) = rdi_lbg_query_list.rdi_lbg_list.list[5];
        return rdi_lbg_query_list.ret;
    } else return -1;

}



int rdi_bp_read(int unit, int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type){
    if_rdi_t if_rdi;

    memset(&if_rdi,0,sizeof(if_rdi_t));
                           
    if_rdi.rdi_cmd=RDI_BP_READ;
    if_rdi.unit=unit;
	if_rdi.dev=dev;


    if (!rdi_bp_query_data)
        return -1;
	

	
	memcpy(&if_rdi.rdi_query_list, rdi_bp_query_data, sizeof(rdi_bp_query_data_t));

    if (!(send_cmd_query_data(&if_rdi,  rdi_bp_query_data, rdi_type))) {

        return rdi_bp_query_data->ret;
    } else return -1;

}


int rdi_bp_write(int unit,int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type){
    if_rdi_t if_rdi;

    memset(&if_rdi,0,sizeof(if_rdi_t));
                            
    if_rdi.rdi_cmd=RDI_BP_WRITE;
    if_rdi.unit=unit;
	if_rdi.dev=dev;

    if (!rdi_bp_query_data)
        return -1;

	memcpy(&if_rdi.rdi_query_list, rdi_bp_query_data, sizeof(rdi_bp_query_data_t));
    if (!(send_cmd_query_data(&if_rdi,  rdi_bp_query_data, rdi_type))) {

        return rdi_bp_query_data->ret;
    } else return -1;

}

int rdi_fci_read(int unit, int dev, int offset, int page, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type){
    if_rdi_t if_rdi;

    memset(&if_rdi,0,sizeof(if_rdi_t));
                           
    if_rdi.rdi_cmd = RDI_FCI_READ;
    if_rdi.unit = unit;
	if_rdi.phy_addr = dev;
	if_rdi.addr = offset;
	if_rdi.dev = page;

    if (!rdi_bp_query_data)
        return -1;
	
	memcpy(&if_rdi.rdi_query_list, rdi_bp_query_data, sizeof(rdi_bp_query_data_t));

    if (!(send_cmd_query_data(&if_rdi,  rdi_bp_query_data, rdi_type))) {

        return rdi_bp_query_data->ret;
    } else return -1;

}


int rdi_fci_write(int unit, int dev, int offset, int page, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type){
    if_rdi_t if_rdi;

    memset(&if_rdi,0,sizeof(if_rdi_t));
                            
    if_rdi.rdi_cmd = RDI_FCI_WRITE;
    if_rdi.unit = unit;
	if_rdi.phy_addr = dev;
	if_rdi.addr = offset;
	if_rdi.dev = page;

    if (!rdi_bp_query_data)
        return -1;

	memcpy(&if_rdi.rdi_query_list, rdi_bp_query_data, sizeof(rdi_bp_query_data_t));
    if (!(send_cmd_query_data(&if_rdi,  rdi_bp_query_data, rdi_type))) {

        return rdi_bp_query_data->ret;
    } else return -1;

}

int rdi_fci_rx_read(int unit, int dev, int offset, int page, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type){
    if_rdi_t if_rdi;

    memset(&if_rdi,0,sizeof(if_rdi_t));
                           
    if_rdi.rdi_cmd = RDI_FCI_RX_READ;
    if_rdi.unit = unit;
	if_rdi.phy_addr = dev;
	if_rdi.addr = offset;
	if_rdi.dev = page;

    if (!rdi_bp_query_data)
        return -1;
	
	memcpy(&if_rdi.rdi_query_list, rdi_bp_query_data, sizeof(rdi_bp_query_data_t));

    if (!(send_cmd_query_data(&if_rdi,  rdi_bp_query_data, rdi_type))) {

        return rdi_bp_query_data->ret;
    } else return -1;

}


int rdi_fci_rx_write(int unit, int dev, int offset, int page, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type){
    if_rdi_t if_rdi;

    memset(&if_rdi,0,sizeof(if_rdi_t));
                            
    if_rdi.rdi_cmd = RDI_FCI_RX_WRITE;
    if_rdi.unit = unit;
	if_rdi.phy_addr = dev;
	if_rdi.addr = offset;
	if_rdi.dev = page;

    if (!rdi_bp_query_data)
        return -1;

	memcpy(&if_rdi.rdi_query_list, rdi_bp_query_data, sizeof(rdi_bp_query_data_t));
    if (!(send_cmd_query_data(&if_rdi,  rdi_bp_query_data, rdi_type))) {

        return rdi_bp_query_data->ret;
    } else return -1;

}



int rdi_temp_read(int unit, int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type){
    if_rdi_t if_rdi;

    memset(&if_rdi,0,sizeof(if_rdi_t));
                           
    if_rdi.rdi_cmd=RDI_TEMP_READ;
    if_rdi.unit=unit;
	if_rdi.dev=dev;

    if (!rdi_bp_query_data)
        return -1;
	
	memcpy(&if_rdi.rdi_query_list, rdi_bp_query_data, sizeof(rdi_bp_query_data_t));

    if (!(send_cmd_query_data(&if_rdi,  rdi_bp_query_data, rdi_type)))
        return rdi_bp_query_data->ret;
    else 
		return -1;
}


int rdi_temp_write(int unit,int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type){
    if_rdi_t if_rdi;

    memset(&if_rdi,0,sizeof(if_rdi_t));
                            
    if_rdi.rdi_cmd=RDI_TEMP_WRITE;
    if_rdi.unit=unit;
	if_rdi.dev=dev;

    if (!rdi_bp_query_data)
        return -1;
	memcpy(&if_rdi.rdi_query_list, rdi_bp_query_data, sizeof(rdi_bp_query_data_t));
    if (!(send_cmd_query_data(&if_rdi,  rdi_bp_query_data, rdi_type))) {

        return rdi_bp_query_data->ret;
    } else return -1;

}

int rdi_temp1_read(int unit, int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type){
    if_rdi_t if_rdi;

    memset(&if_rdi,0,sizeof(if_rdi_t));
                           
    if_rdi.rdi_cmd=RDI_TEMP1_READ;
    if_rdi.unit=unit;
	if_rdi.dev=dev;

    if (!rdi_bp_query_data)
        return -1;
	
	memcpy(&if_rdi.rdi_query_list, rdi_bp_query_data, sizeof(rdi_bp_query_data_t));

    if (!(send_cmd_query_data(&if_rdi,  rdi_bp_query_data, rdi_type)))
        return rdi_bp_query_data->ret;
    else 
		return -1;
}


int rdi_temp1_write(int unit,int dev, rdi_bp_query_data_t *rdi_bp_query_data, rdi_type_t rdi_type){
    if_rdi_t if_rdi;

    memset(&if_rdi,0,sizeof(if_rdi_t));
                            
    if_rdi.rdi_cmd=RDI_TEMP1_WRITE;
    if_rdi.unit=unit;
	if_rdi.dev=dev;

    if (!rdi_bp_query_data)
        return -1;
	memcpy(&if_rdi.rdi_query_list, rdi_bp_query_data, sizeof(rdi_bp_query_data_t));
    if (!(send_cmd_query_data(&if_rdi,  rdi_bp_query_data, rdi_type))) {

        return rdi_bp_query_data->ret;
    } else return -1;

}


int rdi_lbg_port_query_entry_list(int unit, int lbg, rdi_lbg_query_list_t *rdi_lbg_query_list, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    if_rdi_lbg_t *if_rdi_lbg;
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi_lbg=(if_rdi_lbg_t *)&if_rdi;


    if_rdi.rdi_cmd=RDI_LBG_PORT_QUERY_LIST;
    if_rdi_lbg->unit=unit;
    if_rdi_lbg->lbg=lbg;

    if (!rdi_lbg_query_list)
        return -1;

    if (!(send_cmd_lbg_query_list(&if_rdi, rdi_lbg_query_list, rdi_type))) {

        return rdi_lbg_query_list->ret;
    } else return -1;

}

int rdi_lbg_remove(int unit, int lbg, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret=0; 
    if_rdi_lbg_t *if_rdi_lbg;
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi_lbg=(if_rdi_lbg_t *)&if_rdi;
    if_rdi.rdi_cmd=RDI_LBG_REMOVE;
    if_rdi_lbg->lbg=lbg;
	if_rdi_lbg->unit = unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}
int rdi_lbg_add_fn(int unit, int *lbg, rdi_lbg_list_t *rdi_lbg_list, rdi_type_t rdi_type)
{
    int ret=0;
	if_rdi_lbg_t if_rdi_lbg;
	if_rdi_t *if_rdi = (if_rdi_t *)&if_rdi_lbg;
	memset(&if_rdi_lbg, 0, sizeof(if_rdi_lbg_t));

	if_rdi_lbg.rdi_cmd = RDI_LBG_ADD;
	if_rdi_lbg.unit = unit;
	memcpy(&if_rdi_lbg.rdi_query_list.rdi_lbg_list, rdi_lbg_list, sizeof(rdi_lbg_list_t));

	if (!(send_cmd(if_rdi, &ret, sizeof(ret), rdi_type))) {
		
        if (ret < 0)
            return -1;
		*lbg = ret;
        return 0;
    } else return -1;
}


int rdi_lbg_port_remove(int unit, int lbg, int port, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret=0; 
    if_rdi_lbg_t *if_rdi_lbg;
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi_lbg=(if_rdi_lbg_t *)&if_rdi;
    if_rdi.rdi_cmd=RDI_LBG_PORT_REMOVE;
    if_rdi_lbg->lbg=lbg;
    if_rdi_lbg->port=port;
	if_rdi_lbg->unit=unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_lbg_port_add(int unit, int lbg, int port, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret=0; 
    if_rdi_lbg_t *if_rdi_lbg;

    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi_lbg=(if_rdi_lbg_t *)&if_rdi;
    if_rdi.rdi_cmd=RDI_LBG_PORT_ADD;
    if_rdi_lbg->lbg=lbg;
    if_rdi_lbg->port=port;
	if_rdi_lbg->unit=unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type))) {
        return ret;
    } else return -1;

}

int rdi_mir_port_query_entry_list(int unit, int lbg, rdi_lbg_query_list_t *rdi_lbg_query_list, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    if_rdi_lbg_t *if_rdi_lbg;

    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi_lbg=(if_rdi_lbg_t *)&if_rdi;

    if_rdi.rdi_cmd = RDI_MIR_PORT_QUERY_LIST;
    if_rdi_lbg->unit = unit;
    if_rdi_lbg->lbg = lbg;

    if (!rdi_lbg_query_list)
        return -1;

    if (!(send_cmd_lbg_query_list(&if_rdi, rdi_lbg_query_list, rdi_type))) {

        return rdi_lbg_query_list->ret;
    } else return -1;

}

int rdi_mir_remove(int unit, int lbg, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret = 0; 
    if_rdi_lbg_t *if_rdi_lbg;
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi_lbg = (if_rdi_lbg_t *)&if_rdi;
    if_rdi.rdi_cmd = RDI_MIR_REMOVE;
    if_rdi_lbg->lbg = lbg;
	if_rdi_lbg->unit = unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}


int rdi_mir_add_fn(int unit, int lbg, rdi_lbg_list_t *rdi_lbg_list, rdi_type_t rdi_type)
{
    int ret=0;
	if_rdi_lbg_t if_rdi_lbg;
	if_rdi_t *if_rdi = (if_rdi_t *)&if_rdi_lbg;
	memset(&if_rdi_lbg, 0, sizeof(if_rdi_lbg_t));

	if_rdi_lbg.rdi_cmd = RDI_MIR_ADD;
	if_rdi_lbg.unit = unit;
	if_rdi_lbg.lbg = lbg;

	memcpy(&if_rdi_lbg.rdi_query_list.rdi_lbg_list, rdi_lbg_list, sizeof(rdi_lbg_list_t));

	if (!(send_cmd(if_rdi, &ret, sizeof(ret), rdi_type))) {
		
        if (ret < 0)
            return -1;
        return 0;
    } else return -1;
}


int rdi_mir_port_remove(int unit, int lbg, int port, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret=0; 
    if_rdi_lbg_t *if_rdi_lbg;
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi_lbg=(if_rdi_lbg_t *)&if_rdi;
    if_rdi.rdi_cmd=RDI_MIR_PORT_REMOVE;
    if_rdi_lbg->lbg=lbg;
    if_rdi_lbg->port=port;
	if_rdi_lbg->unit=unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_mir_port_add(int unit, int lbg, int port, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret=0; 
    if_rdi_lbg_t *if_rdi_lbg;

    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi_lbg=(if_rdi_lbg_t *)&if_rdi;
    if_rdi.rdi_cmd=RDI_MIR_PORT_ADD;
    if_rdi_lbg->lbg=lbg;
    if_rdi_lbg->port=port;
	if_rdi_lbg->unit=unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type))) {
        return ret;
    } else return -1;

}

int rdi_mir_vlan_add(int unit, int lbg, int vlan, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret=0; 

    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd=RDI_MIR_VLAN_ADD;
	if_rdi.unit=unit;
	if_rdi.port=lbg;
	if_rdi.group=vlan;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type))) {
        return ret;
    } else return -1;

}

int rdi_mcg_create(int unit, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_MCG_CREATE;
	if_rdi.unit = unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}


int rdi_mcg_get_port(int unit, int mcg, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_MCG_GET_PORT;
    if_rdi.group = mcg;
	if_rdi.unit = unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_mcg_add_listener(int unit, int mcg, int port, int vlan, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_MCG_ADD_LISTENER;
    if_rdi.group = mcg;
    if_rdi.port = port;
    if_rdi.val = vlan;
	if_rdi.unit = unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_mcg_remove(int unit, int mcg, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_MIR_REMOVE;
    if_rdi.group = mcg;
	if_rdi.unit = unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_set_port_parser(int unit, int port, int val, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_SET_PORT_PARSER;
    if_rdi.port = port;
    if_rdi.val = val;
	if_rdi.unit = unit;
    
    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1; 
}

int rdi_get_port_parser(int unit, int port, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_GET_PORT_PARSER;
    if_rdi.port = port;
	if_rdi.unit = unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1; 
}

int rdi_set_rframe_update(int unit, int port, int val, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_SET_RFRAME_UPDATE;
    if_rdi.port = port;
    if_rdi.val = val;
	if_rdi.unit = unit;
    
    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1; 
}

int rdi_get_rframe_update(int unit, int port, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_GET_RFRAME_UPDATE;
    if_rdi.port = port;
	if_rdi.unit = unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1; 
}

int rdi_set_ttl_update(int unit, int port, int val, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_SET_TTL_UPDATE;
    if_rdi.port = port;
    if_rdi.val = val;
	if_rdi.unit = unit;
    
    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1; 
}

int rdi_get_ttl_update(int unit, int port, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret = 0;

    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_GET_TTL_UPDATE;
    if_rdi.port = port;
	if_rdi.unit = unit;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1; 
}

int rdi_set_sw_remain(int val, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret = 0; 

    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_SET_SW_REMAIN;
    if_rdi.val = val;
    
    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1; 
}

int rdi_get_sw_remain(rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret = 0;

    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_GET_SW_REMAIN;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1; 
}



int rdi_set_port_mask(int unit, int port, unsigned int mask,  rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_SET_PORT_MASK;
    if_rdi.unit=unit;
    if_rdi.port=port;
    if_rdi.mask=mask;


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_get_port_mask(int unit, int port, unsigned char *mask,  rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_GET_PORT_MASK;
    if_rdi.unit=unit;
    if_rdi.port=port;


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type))) {
        *mask=  ret&0xff;
        return 0;
    } else return -1;

}



int rdi_set_mask(int unit, rdi_mask_t *mask, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
	if_rdi_mask_t *if_rdi_mask = (if_rdi_mask_t *)&if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_mask_t));

    if_rdi_mask->rdi_cmd=RDI_SET_PORT_MASK;
    if_rdi_mask->unit=unit;
	memcpy(&if_rdi_mask->mask, mask, sizeof(rdi_mask_t)); 


    if (!(send_cmd((if_rdi_t *)&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_get_mask(int unit, rdi_mask_t *mask, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
	if_rdi_mask_t *if_rdi_mask = (if_rdi_mask_t *)&if_rdi;

    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi_mask->rdi_cmd=RDI_GET_PORT_MASK;
    if_rdi_mask->unit=unit;
	memcpy(&if_rdi_mask->mask, mask, sizeof(rdi_mask_t));

    if (!(send_cmd(&if_rdi, mask, sizeof(rdi_mask_t), rdi_type))) { 
        return mask->ret_val;
    } else return -1;

}


int rdi_cpld_write(int unit, int addr, unsigned int val,  rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_CPLD_WRITE;
    if_rdi.unit=unit;
    if_rdi.port=addr;
    if_rdi.mask=val;


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_cpld_read(int unit, int addr, unsigned char *val,  rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_CPLD_READ;
    if_rdi.unit=unit;
    if_rdi.port=addr;


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type))) {
        *val=  ret&0xff;
        return 0;
    } else return -1;

}


int rdi_add_rule(int unit, rdi_mem_t *rdi_mem, int action, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0;
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_ADD_RULE;
    if_rdi.unit=unit;
    if_rdi.action=action;
    if (!rdi_mem)
        return -1;
    memcpy(&if_rdi.rdi_mem, rdi_mem, sizeof(rdi_mem_t));


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}


int rdi_add_rule_drop(int unit, rdi_mem_t *rdi_mem, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0;
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_SET_DROP;
    if_rdi.unit=unit;
    if (!rdi_mem)
        return -1;
    memcpy(&if_rdi.rdi_mem, rdi_mem, sizeof(rdi_mem_t));


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_add_rule_permit(int unit, rdi_mem_t *rdi_mem, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0;
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_SET_PERMIT;
    if_rdi.unit=unit;
    if (!rdi_mem)
        return -1;
    memcpy(&if_rdi.rdi_mem, rdi_mem, sizeof(rdi_mem_t));


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}


int rdi_add_rule_dir(int unit, rdi_mem_t *rdi_mem, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_SET_DIR;
    if_rdi.unit=unit;

    if (!rdi_mem)
        return -1;
    memcpy(&if_rdi.rdi_mem, rdi_mem, sizeof(rdi_mem_t));


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_add_rule_mir(int unit, rdi_mem_t *rdi_mem, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_SET_MIR;
    if_rdi.unit=unit;

    if (!rdi_mem)
        return -1;
    memcpy(&if_rdi.rdi_mem, rdi_mem, sizeof(rdi_mem_t));


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_set_l2_hash(int unit, rdi_l2_hash_t *l2_hash, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_SET_L2_HASH;
    if_rdi.unit=unit;

    if (!l2_hash)
        return -1;
    memcpy(&if_rdi.l2_hash, l2_hash, sizeof(rdi_l2_hash_t));


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_get_l2_hash(int unit, rdi_l2_hash_t *l2_hash, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_GET_L2_HASH;
    if_rdi.unit=unit;

    if (!l2_hash)
        return -1;


    if (!(send_cmd(&if_rdi, l2_hash, sizeof(rdi_l2_hash_t), rdi_type))) {
        return ret;

    }

    else return -1;

}


int rdi_set_l3_hash(int unit, rdi_l3_hash_t *l3_hash, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_SET_L3_HASH;
    if_rdi.unit=unit;
    if (!l3_hash)
        return -1;
    memcpy(&if_rdi.l3_hash, l3_hash, sizeof(rdi_l3_hash_t));


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}     

int rdi_get_l3_hash(int unit, rdi_l3_hash_t *l3_hash, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.rdi_cmd=RDI_GET_L3_HASH;
    if_rdi.unit=unit;

    if (!l3_hash)
        return -1;


    if (!(send_cmd(&if_rdi, l3_hash, sizeof(rdi_l3_hash_t), rdi_type)))
        return ret;
    else return -1;

}     


int rdi_get_power(int unit, int port, rdi_sfi_diag_t *sfi_diag, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_GET_POWER;
    if_rdi.unit=unit;
    if_rdi.rdi_mem.port=port;


    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type))) {
        if (ret!=-1) {
            sfi_diag->rx_power= (ret>>16);
            sfi_diag->tx_power= ret&0xffff;
            return 0;
        }

    }
    return -1;

}


int rdi_get_rule_counters(int unit, int rule_id, int group, void *counter, rdi_type_t rdi_type){

    /*  if_rdi_t if_rdi;
      int ret=0,dev_num=rdi_get_dev_num();
      memset(&if_rdi,0,sizeof(if_rdi_t)); 
      
      if((dev_num<0)||(unit>=dev_num))
      return -1;
      
      if_rdi.rdi_cmd=RDI_GET_CNT;
      if_rdi.rule_id=rule_id;
      if_rdi.counters=val;
      if_rdi.unit=unit;
  
  
      if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
          return ret;
      else return -1;
      */
    return -1;

}

int rdi_get_vlan_stat(int unit, int port, rdi_vlan_stat_cnt_t *rdi_vlan_stat_cnt, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int s, t, len, ret=0;
    struct sockaddr_un remote;
    rdi_vlan_stat_t rdi_vlan_stat;
    memset(&if_rdi,0,sizeof(if_rdi_t));
    memset(&rdi_vlan_stat,0,sizeof(rdi_vlan_stat_t));


    if_rdi.rdi_cmd=RDI_GET_VLAN_STAT;
    if_rdi.unit=unit;
    if_rdi.rdi_mem.port=port;



    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
        perror("librdi socket");
        return -1;
    }
    remote.sun_family = AF_UNIX;
    if (rdi_type==RDI_FLCM_DEV)
        strcpy(remote.sun_path, RDIF_SOCK_PATH);
    else
        strcpy(remote.sun_path, RDI_SOCK_PATH);

    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("librdi connect");
        close(s);
        return -1;
    }

    if (send(s, &if_rdi, sizeof(if_rdi_t), 0) == -1) {
        perror("librdi send");
        close(s);
        return -1;

    }
    if ((t=recv(s, &rdi_vlan_stat, sizeof(rdi_vlan_stat_t), 0)) < 0) {
        perror("librdi recv");
        close(s);
        return -1;
    }
    ret= rdi_vlan_stat.ret_val;
    memcpy(rdi_vlan_stat_cnt, &rdi_vlan_stat.rdi_vlan_stat_cnt, sizeof(rdi_vlan_stat_cnt_t));  
    close(s);
    return ret;
}

int rdi_get_stat(int unit, int port, rdi_stat_cnt_t *rdi_stat_cnt, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int s, t, len, ret=0;
    struct sockaddr_un remote;
    int dev_num=rdi_get_dev_num(rdi_type); 
    rdi_stat_t rdi_stat;


    if ((dev_num<0)||(unit>=dev_num))
        return -1;

    memset(&if_rdi,0,sizeof(if_rdi_t));
    memset(&rdi_stat,0,sizeof(rdi_stat_t));

    if_rdi.rdi_cmd=RDI_GET_STAT;
    if_rdi.unit=unit;
    if_rdi.rdi_mem.port=port;


    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
        perror("librdi socket");
        return -1;
    }
    remote.sun_family = AF_UNIX;
    if (rdi_type==RDI_FLCM_DEV)
        strcpy(remote.sun_path, RDIF_SOCK_PATH);
    else
        strcpy(remote.sun_path, RDI_SOCK_PATH);
    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("librdi connect");
        close(s);
        return -1;
    }

    if (send(s, &if_rdi, sizeof(if_rdi_t), 0) == -1) {
        perror("librdi send");
        close(s);
        return -1;

    }
    if ((t=recv(s, &rdi_stat, sizeof(rdi_stat_t), 0)) < 0) {
        perror("librdi recv");
        close(s);
        return -1;
    }
    ret= rdi_stat.ret_val;
    memcpy(rdi_stat_cnt, &rdi_stat.rdi_stat_cnt, sizeof(rdi_stat_cnt_t));  
    close(s);
    return ret; 
}

int rdi_reset_stat(int unit, int port, rdi_type_t rdi_type){


    if_rdi_t if_rdi;
    int ret=0;
	int dev_num=rdi_get_dev_num(rdi_type);

	if ((dev_num < 0)||(unit >= dev_num))
        return -1;
	memset(&if_rdi, 0, sizeof(if_rdi_t));
    if_rdi.rdi_cmd = RDI_RESET_STAT;
	if_rdi.rdi_mem.port = port;
	if_rdi.unit = unit;
    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;

}

int rdi_get_prio_stat(int unit, int port, rdi_stat_cnt_t *rdi_stat_cnt, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int s, t, len, ret=0;
    struct sockaddr_un remote;
    int dev_num=rdi_get_dev_num(rdi_type); 
    rdi_stat_t rdi_stat;


    if ((dev_num<0)||(unit>=dev_num))
        return -1;

    memset(&if_rdi,0,sizeof(if_rdi_t));
    memset(&rdi_stat,0,sizeof(rdi_stat_t));

    if_rdi.rdi_cmd=RDI_GET_PRIO_STAT;
    if_rdi.unit=unit;
    if_rdi.rdi_mem.port=port;


    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
        perror("librdi socket");
        return -1;
    }
    remote.sun_family = AF_UNIX;
    if (rdi_type==RDI_FLCM_DEV)
        strcpy(remote.sun_path, RDIF_SOCK_PATH);
    else
        strcpy(remote.sun_path, RDI_SOCK_PATH);
    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("librdi connect");
        close(s);
        return -1;
    }

    if (send(s, &if_rdi, sizeof(if_rdi_t), 0) == -1) {
        perror("librdi send");
        close(s);
        return -1;

    }
    if ((t=recv(s, &rdi_stat, sizeof(rdi_stat_t), 0)) < 0) {
        perror("librdi recv");
        close(s);
        return -1;
    }
    ret= rdi_stat.ret_val;
    memcpy(rdi_stat_cnt, &rdi_stat.rdi_stat_cnt, sizeof(rdi_stat_cnt_t));  
    close(s);
    return ret; 
}



int rdi_get_rule_stat(int unit, int rule_id, int group, rdi_rule_stat_cnt_t *rdi_rule_stat_cnt, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int s, t, len;
    struct sockaddr_un remote;
    int dev_num=rdi_get_dev_num(rdi_type); 
    rdi_rule_stat_t rdi_rule_stat;
    memset(&if_rdi,0,sizeof(if_rdi_t));
    memset(&rdi_rule_stat,0,sizeof(rdi_rule_stat_t));



    if ((dev_num<0)||(unit>=dev_num))
        return -1;
    bzero(&if_rdi, sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_GET_CNT;
    if_rdi.unit=unit;
    if_rdi.rule_id=rule_id;
    if (rdi_type==RDI_FLCM_DEV)
        if_rdi.group=group;




    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
        perror("librdi socket");
        return -1;
    }
    remote.sun_family = AF_UNIX;
    if (rdi_type==RDI_FLCM_DEV)
        strcpy(remote.sun_path, RDIF_SOCK_PATH);
    else
        strcpy(remote.sun_path, RDI_SOCK_PATH);
    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("librdi connect");
        close(s);
        return -1;
    }
    if (send(s, &if_rdi, sizeof(if_rdi_t), 0) == -1) {
        perror("librdi send");
        close(s);
        return -1;

    }
    if ((t=recv(s, &rdi_rule_stat, sizeof(rdi_rule_stat_t), 0)) < 0) {
        perror("librdi recv");
        close(s);
        return -1;
    }
    close(s);
    memcpy(rdi_rule_stat_cnt, &rdi_rule_stat.rdi_rule_stat_cnt, sizeof(rdi_rule_stat_cnt_t)); 
    return rdi_rule_stat.ret_val; 
}



int rdi_read_phy(int unit, int phy_addr, int dev, int addr, rdi_type_t  rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    /*if_rdi.unit=unit;*/
    if_rdi.rdi_cmd=RDI_READ_PHY;
    if_rdi.addr=addr;
    if_rdi.dev=dev;
    if_rdi.phy_addr=phy_addr;
    //printf("lib: if_rdi.addr=%x,if_rdi.dev=%d, if_rdi.phy_addr=%x\n",if_rdi.addr,if_rdi.dev, if_rdi.phy_addr);

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;


}

int rdi_write_phy(int unit, int phy_addr, int dev, int addr, int val, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    /*if_rdi.unit=unit;*/
    if_rdi.rdi_cmd=RDI_WRITE_PHY;
    if_rdi.addr=addr;
    if_rdi.dev=dev;
    if_rdi.val=val;
    if_rdi.phy_addr=phy_addr;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;


}

int rdi_get_gpio_dir(int unit, int gpio, rdi_type_t  rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.unit = unit;
    if_rdi.rdi_cmd = RDI_GET_GPIO_DIR;
    if_rdi.dev = gpio;
    //printf("lib: if_rdi.addr=%x,if_rdi.dev=%d, if_rdi.phy_addr=%x\n",if_rdi.addr,if_rdi.dev, if_rdi.phy_addr);

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;
}

int rdi_set_gpio_dir(int unit, int gpio, int dir, int val, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.unit = unit;
    if_rdi.rdi_cmd = RDI_SET_GPIO_DIR;
    if_rdi.addr = dir;
    if_rdi.dev = gpio;
    if_rdi.val = val;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;
}

int rdi_set_prbs(int unit, int prbs, int dir, int port, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.unit = unit;
    if_rdi.rdi_cmd = RDI_SET_PRBS;
    if_rdi.addr = dir;
    if_rdi.dev = prbs;
    if_rdi.val = port;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;
}


int rdi_get_gpio(int unit, int gpio, rdi_type_t  rdi_type){
    if_rdi_t if_rdi;
    int ret=0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));
    if_rdi.unit = unit;
    if_rdi.rdi_cmd = RDI_GET_GPIO;
    if_rdi.dev = gpio;
    //printf("lib: if_rdi.addr=%x,if_rdi.dev=%d, if_rdi.phy_addr=%x\n",if_rdi.addr,if_rdi.dev, if_rdi.phy_addr);

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type))) {
		if(ret >0)
			ret = 1;
        return ret;
	}
    else return -1;
}


int rdi_set_gpio(int unit, int gpio, int val, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.unit = unit;
    if_rdi.rdi_cmd = RDI_SET_GPIO;
    if_rdi.dev = gpio;
    if_rdi.val = val;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;
}


int rdi_set_loopback(int unit, int val, int port, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.unit = unit;
    if_rdi.rdi_cmd = RDI_SET_LOOPBACK;
    if_rdi.dev = port;
    if_rdi.val = val;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;
}




int rdi_get_reg(int unit, unsigned int addr, unsigned int *val, rdi_type_t  rdi_type){
    if_rdi_t if_rdi;
    int s, t, len;
	unsigned int ret_val = 0;
    struct sockaddr_un remote;
    int dev_num=rdi_get_dev_num(rdi_type); 
    rdi_rule_stat_t rdi_rule_stat;
    memset(&if_rdi,0,sizeof(if_rdi_t));
    memset(&rdi_rule_stat,0,sizeof(rdi_rule_stat_t));



    if ((dev_num<0)||(unit>=dev_num))
        return -1;
    bzero(&if_rdi, sizeof(if_rdi_t));

    if_rdi.rdi_cmd=RDI_GET_REG;
    if_rdi.unit=unit;
    if_rdi.addr = (int)addr;


    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
        perror("librdi socket");
        return -1;
    }
    remote.sun_family = AF_UNIX;
    if (rdi_type==RDI_FLCM_DEV)
        strcpy(remote.sun_path, RDIF_SOCK_PATH);
    else
        strcpy(remote.sun_path, RDI_SOCK_PATH);
    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("librdi connect");
        close(s);
        return -1;
    }
    if (send(s, &if_rdi, sizeof(if_rdi_t), 0) == -1) {
        perror("librdi send");
        close(s);
        return -1;

    }
    if ((t=recv(s, &rdi_rule_stat, sizeof(rdi_rule_stat_t), 0)) < 0) {
        perror("librdi recv");
        close(s);
        return -1;
    }
    close(s);
    ret_val = (unsigned int) rdi_rule_stat.rdi_rule_stat_cnt.counter;
	*val = ret_val;
    return rdi_rule_stat.ret_val; 
}

int rdi_set_reg(int unit, unsigned int addr, unsigned int val, rdi_type_t rdi_type){
    if_rdi_t if_rdi;
    int ret = 0; 
    memset(&if_rdi,0,sizeof(if_rdi_t));

    if_rdi.unit = unit;
    if_rdi.rdi_cmd = RDI_SET_REG;
    if_rdi.addr = (int) addr;
    if_rdi.val = (int) val;

    if (!(send_cmd(&if_rdi, &ret, sizeof(ret), rdi_type)))
        return ret;
    else return -1;
}

























