/**************************************************************************

Copyright (c) 2006-2013, Silicom
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

 3. Neither the name of the Silicom nor the names of its
    contributors may be used to endorse or promote products derived from
    this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

***************************************************************************/

#ifndef BPRD_MOD_H
#define BPRD_MOD_H
#include "bits.h"

#ifndef KERNEL_VERSION
    #define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))
#endif


#if ( LINUX_VERSION_CODE < KERNEL_VERSION(2,6,8) )
    #define msleep(x)	do { if(in_interrupt()) { \
				/* Don't mdelay in interrupt context! */ \
	                	BUG(); \
			} else { \
				set_current_state(TASK_UNINTERRUPTIBLE); \
				schedule_timeout((x * HZ)/1000 + 2); \
			} } while(0)
#endif

#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,6,10))
    #define EXPORT_SYMBOL_NOVERS EXPORT_SYMBOL
#endif

#define BP_PROC_DIR "bypass"


#define PULSE_SET_ENTRY_RD            "pulse_set"
#define ZERO_SET_ENTRY_RD            "zero_set"
#define PULSE_GET1_ENTRY_RD            "pulse_get1"
#define PULSE_GET2_ENTRY_RD            "pulse_get2"

#define CMND_ON_ENTRY_RD              "cmnd_on"
#define CMND_OFF_ENTRY_RD             "cmnd_off"
#define RESET_CONT_ENTRY_RD           "reset_cont"

/*COMMANDS*/
#define BYPASS_INFO_ENTRY_RD     "bypass_info"

#define BYPASS_SLAVE_ENTRY_RD    "bypass_slave"
#define BYPASS_CAPS_ENTRY_RD     "bypass_caps"
#define WD_SET_CAPS_ENTRY_RD     "wd_set_caps"
#define BYPASS_ENTRY_RD          "bypass"
#define BYPASS_CHANGE_ENTRY_RD   "bypass_change"
#define BYPASS_WD_ENTRY_RD       "bypass_wd"
#define WD_EXPIRE_TIME_ENTRY_RD  "wd_expire_time"
#define RESET_BYPASS_WD_ENTRY_RD "reset_bypass_wd"
#define DIS_BYPASS_ENTRY_RD      "dis_bypass"
#define BYPASS_PWUP_ENTRY_RD     "bypass_pwup"
#define BYPASS_PWOFF_ENTRY_RD     "bypass_pwoff"
#define STD_NIC_ENTRY_RD         "std_nic"
#define STD_NIC_ENTRY_RD         "std_nic"
#define TAP_ENTRY_RD             "tap"
#define TAP_CHANGE_ENTRY_RD      "tap_change"
#define DIS_TAP_ENTRY_RD         "dis_tap"
#define TAP_PWUP_ENTRY_RD        "tap_pwup"
#define TWO_PORT_LINK_ENTRY_RD   "two_port_link"
#define WD_EXP_MODE_ENTRY_RD     "wd_exp_mode"
#define WD_AUTORESET_ENTRY_RD    "wd_autoreset"
#define TPL_ENTRY_RD             "tpl"
#define WAIT_AT_PWUP_ENTRY_RD    "wait_at_pwup"
#define HW_RESET_ENTRY_RD        "hw_reset"
#define DISC_ENTRY_RD             "disc"
#define DISC_CHANGE_ENTRY_RD      "disc_change"
#define DIS_DISC_ENTRY_RD         "dis_disc"
#define DISC_PWUP_ENTRY_RD        "disc_pwup"





#ifndef jiffies_to_msecs
    #define jiffies_to_msecs(x) _kc_jiffies_to_msecs(x)
static inline unsigned int jiffies_to_msecs(const unsigned long j)
{
#if HZ <= 1000 && !(1000 % HZ)
    return(1000 / HZ) * j;
#elif HZ > 1000 && !(HZ % 1000)
    return(j + (HZ / 1000) - 1)/(HZ / 1000);
#else
    return(j * 1000) / HZ;
#endif
}
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,10))

    #define pci_get_class pci_find_class
    #define pci_get_subsys pci_find_subsys
    #define pci_get_device pci_find_device

#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,4))
    #define MODULE_VERSION(_version)
#endif



#endif
