#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <unistd.h> 
#include <string.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <net/if.h>

#include <netinet/in.h>
#include <arpa/inet.h>
#include <linux/stat.h>

#include <linux/fs.h> 

#include <linux/kdev_t.h>



#include "bpctl.h"





static void bp_usage(void);


static void bp_usage(void){
    printf("Usage: "PROG_NAME" <dev <dev number, min 0> port <port_num, min 1> <command> [parameters]\n");
    printf("       "PROG_NAME" <info|help>\n");
    printf("<command>    - bypass control command (see Commands List).\n");
    printf("[parameters] - set_bypass_wd command:\n"); 
    printf("                   WDT timeout interval, msec (0 for disabling WDT).\n");
    printf("               blink_test command:\n"); 
    printf("                   LED blinking timeout interval, sec.\n");
    printf("               set_bypass/set_bypass_pwoff/set_bypass_pwup/set_dis_bypass commands:\n");
    printf("                   on/off for enable/disable Bypass\n");
    printf("               set_std_nic command:\n");
    printf("                   on/off for enable/disable Standard NIC mode\n");
    printf("               set_tx command:\n");
    printf("                   on/off for enable/disable transmit\n");
    printf("               set_tpl command:\n");
    printf("                   on/off for enable/disable TPL\n");
#ifdef PMC_FIX_FLAG
    printf("               set_wait_at_pwup command:\n");
    printf("                   on/off for enable/disable wait_at_pwup\n");
#endif    
    printf("               set_hw_reset command:\n");
    printf("                   on/off for enable/disable hw_reset\n");
    printf("               set_tap/set_tap_pwup/set_dis_tap commands:\n");
    printf("                   on/off for enable/disable TAP\n");
    printf("               set_disc/set_disc_pwup/set_dis_disc commands:\n");
    printf("                   on/off for enable/disable Disc\n");
    printf("               set_wd_exp_mode command:\n");
    printf("                   bypass/tap/disc for bypass/tap/disc mode\n");
    printf("info         - print Program Information.\n");
    printf("help         - print this message.\n");
    printf("   Commands List:\n");
	printf("set_bp_manuf     - set factory settings\n");
    printf("is_bypass        - check if device is a Bypass/TAP controlling device\n");
    printf("get_bypass_slave - get the second port participate in the Bypass/TAP pair\n");
    printf("get_bypass_caps  - obtain Bypass/TAP capabilities information\n");
    printf("get_wd_set_caps  - obtain watchdog timer settings capabilities\n");
    printf("get_bypass_info  - get bypass/TAP info\n");
	printf("set_bypass       - set Bypass mode state\n");
    printf("get_bypass       - get Bypass mode state\n");
    printf("get_bypass_change - get change of Bypass mode state from last status check\n");
    printf("set_dis_bypass   - set Disable Bypass mode\n");
    printf("get_dis_bypass   - get Disable Bypass mode state\n");
    printf("set_bypass_pwoff - set Bypass mode at power-off state\n");
    printf("get_bypass_pwoff - get Bypass mode at power-off state\n");
    printf("set_bypass_pwup  - set Bypass mode at power-up state\n");
    printf("get_bypass_pwup  - get Bypass mode at power-up state\n");
    printf("set_std_nic      - set Standard NIC mode of operation\n"); 
    printf("get_std_nic      - get Standard NIC mode settings\n");
    printf("set_bypass_wd    - set watchdog state\n");
    printf("get_bypass_wd    - get watchdog state\n");
    printf("get_wd_time_expire - get watchdog expired time\n");
	printf("get_wd_expire - get watchdog expired status\n"); 
    printf("reset_bypass_wd - reset watchdog timer\n");
    printf("set_tx      - set transmit enable / disable\n"); 
    printf("get_tx      - get transmitter state (enabled / disabled)\n");
    printf("set_tpl      - set TPL enable / disable\n"); 
    printf("get_tpl      - get TPL state (enabled / disabled)\n");
#ifdef PMC_FIX_FLAG
    printf("set_wait_at_pwup      - set wait_at_pwup enable / disable\n"); 
    printf("get_wait_at_pwup      - get wait_at_pwup (enabled / disabled)\n");
#endif    
    printf("set_hw_reset          - set hw_reset enable / disable\n"); 
    printf("get_hw_reset          - get hw_reset (enabled / disabled)\n");
    printf("set_tap       - set TAP mode state\n");
    printf("get_tap       - get TAP mode state\n");
    printf("get_tap_change - get change of TAP mode state from last status check\n");
    printf("set_dis_tap   - set Disable TAP mode\n");
    printf("get_dis_tap   - get Disable TAP mode state\n");
    printf("set_tap_pwup  - set TAP mode at power-up state\n");
    printf("get_tap_pwup  - get TAP mode at power-up state\n");
    printf("set_disc       - set Disc mode state\n");
    printf("get_disc       - get Disc mode state\n");
    printf("get_disc_change - get change of Disc mode state from last status check\n");
    printf("set_dis_disc   - set Disable Disc mode\n");
    printf("get_dis_disc   - get Disable Disc mode state\n");
    printf("set_disc_pwup  - set Disc mode at power-up state\n");
    printf("get_disc_pwup  - get Disc mode at power-up state\n");
#if 0
    printf("get_disc_port  - get Disc Port mode state\n");
    printf("set_disc_port_pwup  - set Disc Port mode at power-up state\n");
    printf("get_disc_port_pwup  - get Disc Port mode at power-up state\n"); 
#endif

    printf("set_wd_exp_mode - set adapter state when WDT expired\n");
    printf("get_wd_exp_mode - get adapter state when WDT expired\n");


#ifdef BP_SELF_TEST
    printf("set_bst - set Bypass Self Test mode\n");
    printf("get_bst - get Bypass Self Test mode\n");

#endif


    printf("\nExample: "PROG_NAME" dev 0 port 1 set_bypass_wd 5000\n");

} 

static int parse_bypass_mode(char *param)
{
    int bypass_mode=-1;

    if (!strcmp(param, BYPASS_ENABLE))
        bypass_mode=1;
    else if (!strcmp(param, BYPASS_DISABLE))
        bypass_mode=0;
    return bypass_mode;
}

static int parse_wd_exp_mode(char *param)
{
    int mode=-1;

    if (!strcmp(param, TAP_MODE))
        mode=1;
    else if (!strcmp(param, BYPASS_MODE))
        mode=0;
    else if (!strcmp(param, DISC_MODE))
        mode=2;
    else if (!strcmp(param, DISC_MODE))
        mode=2;
    else if (!strcmp(param, NORMAL_MODE))
        mode=3;


    return mode;
}



static void get_bypass_caps_cmd(int dev, int port){
    int ret=0;
    int i=0;

    ret= get_bypass_caps_rd_fn(dev, port);
    printf("bypass_caps: 0x%x\n",ret);
    if (ret==-1)
        printf(NOT_SUPP_BPT_SLAVE_MSG);

    else {
        for (;bp_cap_array[i].flag;i++) {
            if (ret & bp_cap_array[i].flag)
                printf(bp_cap_array[i].desc);
        }
    }
}

static void get_wd_set_caps_cmd(int dev, int port){
    int ret=0;

    ret= get_wd_set_caps_rd_fn(dev, port);
    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else {
        printf(WD_MIN_TIME_MSG,WD_MIN_TIME_GET(ret)*100);
        printf(WD_STEP_TIME_MSG,((ret & WDT_STEP_TIME)?1:0));
        printf(WD_STEP_COUNT_MSG,WD_STEP_COUNT_GET(ret));
    }

}

static void set_bypass_cmd(int dev, int port,int bypass_mode){
    int ret=0;

    ret= set_bypass_rd_fn(dev, port, bypass_mode);



    if (ret<0)
        printf(NOT_SUPP_BP_SLAVE_MSG);
    else printf(SET_BYPASS_ENTRY" "SUCCESS_MSG);

}

static void set_tpl_cmd(int dev, int port,int tpl_mode){
    int ret=0;

    ret= set_tpl_rd_fn(dev, port, tpl_mode);



    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else printf(SET_TPL_ENTRY" "SUCCESS_MSG);

}

static void set_tx_cmd(int dev, int port,int tx_mode){
    int ret=0;

    ret= set_tx_rd_fn(dev, port, tx_mode);



    if (ret<0)
        printf(NOT_SUPP_TPL_EN_MSG);
    else printf(SET_TX_ENTRY" "SUCCESS_MSG);

}


static void set_hw_reset_cmd(int dev, int port,int time){
    int ret=0;

    ret= set_bp_hw_reset_rd_fn(dev, port, time);

    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else printf(SET_HW_RESET_ENTRY" "SUCCESS_MSG);

}

static void set_wait_at_pwup_cmd(int dev, int port,int time){
    int ret=0;

    ret= set_bp_wait_at_pwup_rd_fn(dev, port, time);

    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else printf(SET_WAIT_AT_PWUP_ENTRY" "SUCCESS_MSG);

}

static void set_disc_cmd(int dev, int port,int disc_mode){
    int ret=0;

    ret= set_disc_rd_fn(dev, port, disc_mode);



    if (ret<0)
        printf(NOT_SUPP_DISC_SLAVE_MSG);
    else printf(SET_DISC_ENTRY" "SUCCESS_MSG);

}



static void get_bypass_cmd(int dev, int port){
    int ret=0;
    ret= get_bypass_rd_fn(dev, port);


    if (ret<0)
        printf(NOT_SUPP_BP_SLAVE_UN_MSG);
    else if (!ret)
        printf(NON_BP_MODE_MSG);
    else printf(BP_MODE_MSG);

}


static void get_tpl_cmd(int dev, int port){
    int ret=0;
    ret= get_tpl_rd_fn(dev, port);


    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else if (!ret)
        printf(NON_TPL_MODE_MSG);
    else printf(TPL_MODE_MSG);

}

static void get_tx_cmd(int dev, int port){
    int ret=0;
    ret= get_tx_rd_fn(dev, port);


    if (ret<0)
        printf(NOT_SUPP_MSG);
    else if (!ret)
        printf(TX_DIS_MSG);
    else printf(TX_EN_MSG);

}


static void get_hw_reset_cmd(int dev, int port){
    int ret=0;
    ret= get_bp_hw_reset_rd_fn(dev, port);  

    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else if (!ret)
        printf(BP_HW_RESET_DIS_MSG);
    else printf(BP_HW_RESET_EN_MSG);


}

static void get_wait_at_pwup_cmd(int dev, int port){
    int ret=0;
    ret= get_bp_wait_at_pwup_rd_fn(dev, port);  

    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else if (!ret)
        printf(BP_WAIT_AT_PWUP_DIS_MSG);
    else printf(BP_WAIT_AT_PWUP_EN_MSG);


}

static void is_bypass_cmd(int dev, int port){
    int ret=0;

    ret=is_bypass_rd_fn(dev, port);
    if (ret<0)
        printf(NOT_SUPP_BPT_MSG);
    if (ret==0)
        printf(SLAVE_IF_MSG);
    else if (ret==1)
        printf(MASTER_IF_MSG);
    else if (ret==2)
        printf(MNG_IF_MSG);
    else printf("Error!\n");        
}


static void get_disc_cmd(int dev, int port){
    int ret=0;
    ret= get_disc_rd_fn(dev, port);


    if (ret<0)
        printf(NOT_SUPP_DISC_SLAVE_MSG);
    else if (!ret)
        printf(NON_DISC_MODE_MSG);
    else printf(DISC_MODE_MSG);

}

void get_bypass_slave_cmd(int dev, int port){
    int ret=0, s_port;

    ret= get_bypass_slave_rd_fn(dev, port, &s_port);
    if (ret<0)
        printf(NOT_SUPP_BPT_SLAVE_MSG);
	else if (!ret)
		printf(SLAVE_IF_MSG);
    else {
        printf(BP_PAIR_MSG, s_port);
    }

} 


static void get_bypass_change_cmd(int dev, int port){
    int ret=0;

    ret= get_bypass_change_rd_fn(dev, port);

    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else if (!ret)
        printf(NONBYPASS_MODE_LAST_MSG);
    else if (ret>0)
        printf(BP_MODE_LAST_MSG);

}

static void get_disc_change_cmd(int dev, int port){
    int ret=0;

    ret= get_disc_change_rd_fn(dev, port);

    if (ret<0)
        printf(NOT_SUPP_DISC_SLAVE_MSG);
    else if (!ret)
        printf(NONDISC_MODE_LAST_MSG);
    else if (ret>0)
        printf(DISC_MODE_LAST_MSG);

}


static void set_dis_bypass_cmd(int dev, int port,int bypass_mode){
    int ret=0;

    ret= set_dis_bypass_rd_fn(dev, port,bypass_mode);



    if (ret<0) {
        printf(NOT_SUPP_SLAVE_MSG);
    } else printf(SET_DIS_BYPASS_ENTRY" "SUCCESS_MSG);

}

static void set_dis_disc_cmd(int dev, int port,int disc_mode){
    int ret=0;

    ret= set_dis_disc_rd_fn(dev, port,disc_mode);



    if (ret<0) {
        printf(NOT_SUPP_DISC_SLAVE_MSG);
    } else printf(SET_DIS_DISC_ENTRY" "SUCCESS_MSG);

}


void get_dis_bypass_cmd(int dev, int port){
    int ret=0;       

    ret= get_dis_bypass_rd_fn(dev, port);



    if (ret<0) {
        printf(NOT_SUPP_SLAVE_MSG);
    } else if (!ret)
        printf(BP_MODE_EN_MSG);
    else if (ret>0)
        printf(BP_MODE_DIS_MSG);

}

void get_dis_disc_cmd(int dev, int port){
    int ret=0;       

    ret= get_dis_disc_rd_fn(dev, port);



    if (ret<0) {
        printf(NOT_SUPP_DISC_SLAVE_MSG);
    } else if (!ret)
        printf(DISC_MODE_EN_MSG);
    else if (ret>0)
        printf(DISC_MODE_DIS_MSG);

}




static void set_bypass_pwoff_cmd(int dev, int port,int bypass_mode){
    int ret=0;

    ret= set_bypass_pwoff_rd_fn(dev, port, bypass_mode);

    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else printf(SET_BYPASS_PWOFF_ENTRY" "SUCCESS_MSG);


}

static void get_bypass_pwoff_cmd(int dev, int port){
    int ret=0;

    ret= get_bypass_pwoff_rd_fn(dev, port);


    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else if (!ret)
        printf(BP_DIS_PWOFF_MSG);
    else if (ret>0)
        printf(BP_EN_PWOFF_MSG);
}



static void set_bypass_pwup_cmd(int dev, int port,int bypass_mode){
    int ret=0;

    ret= set_bypass_pwup_rd_fn(dev, port, bypass_mode);

    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else printf(SET_BYPASS_PWUP_ENTRY" "SUCCESS_MSG);


}

static void set_disc_pwup_cmd(int dev, int port,int disc_mode){
    int ret=0;

    ret= set_disc_pwup_rd_fn(dev, port, disc_mode);

    if (ret<0)
        printf(NOT_SUPP_DISC_SLAVE_MSG);
    else printf(SET_DISC_PWUP_ENTRY" "SUCCESS_MSG);


}



static void get_bypass_pwup_cmd(int dev, int port){
    int ret=0;

    ret= get_bypass_pwup_rd_fn(dev, port);


    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else if (!ret)
        printf(BP_DIS_PWUP_MSG);
    else if (ret>0)
        printf(BP_EN_PWUP_MSG);
}

static void get_disc_pwup_cmd(int dev, int port){
    int ret=0;

    ret= get_disc_pwup_rd_fn(dev, port);


    if (ret<0)
        printf(NOT_SUPP_DISC_SLAVE_MSG);
    else if (!ret)
        printf(DISC_DIS_PWUP_MSG);
    else if (ret>0)
        printf(DISC_EN_PWUP_MSG);
}



static void set_bypass_wd_cmd(int dev, int port,int timeout){
    int ret=0;
    ret= set_bypass_wd_rd_fn(dev, port,timeout);


    if (ret<0)
        printf(NOT_SUPP_MSG);
    else if (!ret)
        printf(WD_DIS_MSG);
    else if (ret>0)
        printf(WDT_STATE_MSG,ret);

}
#if 0
static void set_bp_blink_cmd(int dev, int port,int timeout){
    int ret=-1;


    if (ret<0)
        printf(NOT_SUPP_MSG);
    else 
        printf("Ok\n");

}
#endif


static void get_bypass_wd_cmd(int dev, int port){
    int ret=0;
    int timeout=0;

    ret= get_bypass_wd_rd_fn(dev, port,&timeout);



    if (ret<0)
        printf(NOT_SUPP_BP_SLAVE_MSG);
    else if (!timeout)
        printf(WD_DIS_MSG);
    else if (timeout>0)
        printf(WD_STATE_EXT_MSG, timeout);
    else printf(WD_STATE_UNKNOWN_MSG);

}

static void get_wd_expire_time_cmd(int dev, int port){
    int ret=0;
    int time_left=0;

    ret= get_wd_expire_time_rd_fn(dev, port,&time_left);




    if (ret<0)
        printf(NOT_WDT_SLAVE_MSG);
    else if (!ret)
        printf(WD_DIS_MSG);
    else if (time_left>0)
        printf(WD_TIME_LEFT_MSG, time_left);
    else
        printf(WDT_EXP_MSG);

}


static void get_wd_expire_cmd(int dev, int port){
    int ret=0;

    ret= get_wd_expire_rd_fn(dev, port);


    if (ret<0)
        printf(NOT_WDT_SLAVE_MSG);
    else if (!ret)
        printf(WDT_EXP_MSG);
    else
        printf(WDT_NOT_EXP_MSG);

}


static void reset_bypass_wd_timer_cmd(int dev, int port){
    int ret=0;

    ret= reset_bypass_wd_timer_rd_fn(dev, port);

    if (ret<0)
        printf(NOT_WDT_SLAVE_MSG);
    else if (!ret)
        printf(WD_DIS_MSG);
    else if (ret>0)
        printf(RESET_BYPASS_WD_TIMER_ENTRY" "SUCCESS_MSG);

}

static void set_manuf_cmd(int dev, int port){
    int ret=0;



    ret= set_bp_manuf_rd_fn(dev, port);
    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else if (ret==0)
        printf("Ok\n");

}


static void set_std_nic_cmd(int dev, int port, int nic_mode){
    int ret=0;



    ret= set_std_nic_rd_fn(dev, port, nic_mode);
    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else
        printf(SET_STD_NIC_ENTRY" "SUCCESS_MSG);

}

static void get_std_nic_cmd(int dev, int port){
    int ret=0;



    ret= get_std_nic_rd_fn(dev, port);
    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else if (!ret)
        printf(NON_STD_NIC_MODE_MSG);
    else
        printf(STD_NIC_MODE_MSG);
}



static void set_tap_cmd(int dev, int port,int tap_mode){
    int ret=-1;

    if (ret<0)
        printf(NOT_SUPP_TAP_SLAVE_MSG);
    else printf(SET_TAP_ENTRY" "SUCCESS_MSG);

}

static void get_tap_cmd(int dev, int port){
    int ret=-1;

    if (ret<0)
        printf(NOT_SUPP_TAP_SLAVE_MSG);
    else if (!ret)
        printf(NON_TAP_MODE_MSG);
    else printf(TAP_MODE_MSG);
}

static void get_tap_change_cmd(int dev, int port){
    int ret=-1;

    if (ret<0)
        printf(NOT_SUPP_TAP_SLAVE_MSG);
    else if (!ret)
        printf(NONTAP_MODE_LAST_MSG);
    else if (ret>0)
        printf(TAP_MODE_LAST_MSG);

}


static void set_tap_pwup_cmd(int dev, int port,int tap_mode){
    int ret=-1;

    if (ret<0)
        printf(NOT_SUPP_TAP_SLAVE_MSG);
    else printf(SET_TAP_PWUP_ENTRY" "SUCCESS_MSG);

}

static void get_tap_pwup_cmd(int dev, int port){
    int ret=-1;

    if (ret<0)
        printf(NOT_SUPP_TAP_SLAVE_MSG);
    else if (!ret)
        printf(TAP_DIS_PWUP_MSG);
    else if (ret>0)
        printf(TAP_EN_PWUP_MSG);
}

static void set_wd_exp_mode_cmd(int dev, int port,int mode){
    int ret=0;

    ret= set_wd_exp_mode_rd_fn(dev, port,mode);


    if (ret<0)
        printf(NOT_SUPP_SLAVE_MSG);
    else printf(SET_WD_EXP_MODE_ENTRY" "SUCCESS_MSG);

}

static void get_wd_exp_mode_cmd(int dev, int port){
    int ret=0;

    ret= get_wd_exp_mode_rd_fn(dev, port);


    if (ret==0)
        printf(BYPASS_WD_EXP_MODE_MSG);
    else if (ret==1)
        printf(TAP_WD_EXP_MODE_MSG);
    else if (ret==2)
        printf(DISC_WD_EXP_MODE_MSG);
    else if (ret==3)
        printf(NORMAL_WD_EXP_MODE_MSG);
    else  printf(NOT_SUPP_SLAVE_MSG);   
}


static void get_bypass_info_cmd(int dev, int port){
    int ret;
	char dev_name[128];  
	unsigned char add_param = 0;

    memset(dev_name, 0, sizeof(dev_name));
    ret=get_bypass_info_rd_fn(dev, port, dev_name, &add_param);

    if (ret<0) {
        printf(NOT_SUPP_SLAVE_MSG);
        return;
    }
    printf("Name\t\t\t%s\n", dev_name);
    printf("Firmware version\t0x%x\n", add_param);
}



static int parse_cmdline(int argc, char **argp){
    int i=0, dev = 0, port = 0;

	if (argc==2) {
        i=1;
        if (!strcmp(argp[i], INFO_ENTRY)) {
            printf(APP_NAME);
            printf(COPYRT_MSG);
            return OK;
        } else if (!strcmp(argp[i], HELP_ENTRY)) {
            bp_usage();
            return OK;
        };
    }




    for (i=1;i <argc;i++) {

        if (!strcmp(argp[i], GET_BYPASS_CAPS_ENTRY)) {
            get_bypass_caps_cmd(dev, port);
            return OK;
        } else if (!strcasecmp(argp[i], "dev")) {
            if (argp[++i]) {
                dev=atoi(argp[i]);
            }
			continue;

        } else if (!strcasecmp(argp[i], "port")) {
            if (argp[++i]) {
                port=atoi(argp[i]);
                if (!port) {
                    printf("Error: Invalid port (minimum is 1).\n");
                    return ERROR;

                }
            }
			continue;

        }  else if (!strcmp(argp[i], GET_WD_SET_CAPS_ENTRY)) {
            get_wd_set_caps_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], SET_BYPASS_ENTRY)) {
            int bypass_mode=0;
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_bypass_cmd(dev, port, bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], SET_TPL_ENTRY)) {
            int bypass_mode=0;
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_tpl_cmd(dev, port, bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], SET_TX_ENTRY)) {
            int bypass_mode=0;
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_tx_cmd(dev, port, bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], SET_HW_RESET_ENTRY)) {
            int bypass_mode=0;
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_hw_reset_cmd(dev, port, bypass_mode);
            return OK;
        }else if (!strcmp(argp[i], SET_WAIT_AT_PWUP_ENTRY)) {
            int bypass_mode=0;
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_wait_at_pwup_cmd(dev, port, bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], SET_DISC_ENTRY)) {
            int bypass_mode=0;
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_disc_cmd(dev, port, bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], GET_BYPASS_ENTRY)) {
            get_bypass_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_TPL_ENTRY)) {
            get_tpl_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_TX_ENTRY)) {
            get_tx_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_HW_RESET_ENTRY)) {
            get_hw_reset_cmd(dev, port);
            return OK;
        }else if (!strcmp(argp[i], GET_WAIT_AT_PWUP_ENTRY)) {
            get_wait_at_pwup_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_BYPASS_SLAVE_ENTRY)) {
            get_bypass_slave_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], IS_BYPASS_ENTRY)) {
            is_bypass_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_DISC_ENTRY)) {
            get_disc_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_BYPASS_CHANGE_ENTRY)) {
            get_bypass_change_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_DISC_CHANGE_ENTRY)) {
            get_disc_change_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], SET_DIS_BYPASS_ENTRY)) {
            int bypass_mode=0; 
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_dis_bypass_cmd(dev, port,bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], SET_DIS_DISC_ENTRY)) {
            int bypass_mode=0; 
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_dis_disc_cmd(dev, port,bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], GET_DIS_BYPASS_ENTRY)) {
            get_dis_bypass_cmd(dev, port);
            return OK;  
        } else if (!strcmp(argp[i], GET_DIS_DISC_ENTRY)) {
            get_dis_disc_cmd(dev, port);
            return OK;  
        } else if (!strcmp(argp[i], SET_BYPASS_PWOFF_ENTRY)) {
            int bypass_mode=0;
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_bypass_pwoff_cmd(dev, port,bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], GET_BYPASS_PWOFF_ENTRY)) {
            get_bypass_pwoff_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], SET_BYPASS_PWUP_ENTRY)) {
            int bypass_mode=0;
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_bypass_pwup_cmd(dev, port,bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], SET_DISC_PWUP_ENTRY)) {
            int bypass_mode=0;
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_disc_pwup_cmd(dev, port,bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], GET_BYPASS_PWUP_ENTRY)) {
            get_bypass_pwup_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_DISC_PWUP_ENTRY)) {
            get_disc_pwup_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], SET_STD_NIC_ENTRY)) {
            int nic_mode=0;
            if ((argc<(i+2))||((nic_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_std_nic_cmd(dev, port,nic_mode);
            return OK;
        } else if (!strcmp(argp[i], GET_STD_NIC_ENTRY)) {
            get_std_nic_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], SET_BYPASS_WD_ENTRY)) {
            int timeout=0;
            if (argc<(i+2))
                goto cmd_err;
            timeout=atoi(argp[i+1]);
            set_bypass_wd_cmd(dev, port,timeout);
            return OK;
        } else if (!strcmp(argp[i], GET_BYPASS_WD_ENTRY)) {
            get_bypass_wd_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_WD_EXPIRE_TIME_ENTRY)) {
            get_wd_expire_time_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_WD_EXPIRE_ENTRY)) {
            get_wd_expire_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], RESET_BYPASS_WD_TIMER_ENTRY)) {
            reset_bypass_wd_timer_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], SET_MANUF_ENTRY)) {
            set_manuf_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], SET_TAP_ENTRY)) {
            int bypass_mode=0;
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_tap_cmd(dev, port,bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], GET_TAP_ENTRY)) {
            get_tap_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_TAP_CHANGE_ENTRY)) {
            get_tap_change_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], SET_TAP_PWUP_ENTRY)) {
            int bypass_mode=0;
            if ((argc<(i+2))||((bypass_mode=parse_bypass_mode(argp[i+1]))<0))
                goto cmd_err;
            set_tap_pwup_cmd(dev, port,bypass_mode);
            return OK;
        } else if (!strcmp(argp[i], GET_TAP_PWUP_ENTRY)) {
            get_tap_pwup_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], SET_WD_EXP_MODE_ENTRY)) {
            int mode=0;
            if ((argc<(i+2))||((mode=parse_wd_exp_mode(argp[i+1]))<0))
                goto cmd_err;
            set_wd_exp_mode_cmd(dev, port,mode);
            return OK;
        } else if (!strcmp(argp[i], GET_WD_EXP_MODE_ENTRY)) {
            get_wd_exp_mode_cmd(dev, port);
            return OK;
        } else if (!strcmp(argp[i], GET_BYPASS_INFO_ENTRY)) {
            get_bypass_info_cmd(dev, port);
            return OK;
        } 
    }

    cmd_err:
    printf("Command line error!\n");
    bp_usage();
    return ERROR;
}



int main(int argc, char **argp, char **envp){
    return parse_cmdline(argc, argp);
}












