//type value
var CARD_CONFIG = 1;
var PORT_VIDEO = 2;
var PORT_AUDIO = 3;
var PORT_TS = 4;
var PORT_VBI = 5;
var PORT_MONITOR = 6;
var DEBUG_AUTO_REFRESH = 7;
var UPDATE = 8;
var DEBUG = 9;
var CARD_AUTO_REFRESH = 10;

var C130_AS = 0;
var C130_DS = 1;
var UPGRADING = 1;

var progressTimer;
var progressbar = $("#progressbar");
var progressDialog = $("#progressDialog");
var progressTitle = ["Progress Dialog", "进度条窗口"];

var upgradeDesc = "";
var errorEn = [""
			   ,"The parameter value is illegal!"
			   ,"Updating!"
			   ,"Upgrade Files were not found in the FTP!"
			   ,"Video bitrate overflow! The sum of two mpeg-2 encoding video bitrates is more than 26Mbps! Please reduce the video bitrate!"
			   ,"Video bitrate overflow! The sum of two h.264 encoding video bitrates is more than 8Mbps! Please reduce the video bitrate!"
			   ,"Video bitrate overflow! The sum of h.264 and mpeg-2 encoding video bitrates is more than 18Mbps! Please reduce the video bitrate!"
			   ,"Video bitrate overflow! H.264 encoding video bitrate is more than 6Mbps! Please reduce the video bitrate!"
			   ,"Video bitrate overflow! MPEG-2 encoding video bitrate is more than 11Mbps! Please reduce the video bitrate!"
			   ,"PID Parameter values conflict"
			   ,"Service ID values conflict"];

var errorCn = [""
			   ,"非法参数值！"
			   ,"正在升级中！"
			   ,"FTP中未找到升级文件！"
			   ,"视频码率之和溢出！2路MPEG-2编码视频码率之和超过26Mbps！请降低视频码率！"
			   ,"视频码率之和溢出！2路H.264编码视频码率之和超过8Mbps！请降低视频码率！"
			   ,"视频码率之和溢出！MPEG-2和H.264混合编码视频码率之和超过18Mbps！请降低视频码率！"
			   ,"视频码率溢出！H.264编码视频码率超过6Mbps！请降低视频码率！"
			   ,"视频码率溢出！MPEG-2编码视频码率超过11Mbps！请降低视频码率！"
			   ,"PID参数冲突"
			   ,"节目号冲突"];
			   
var returnError = [errorEn, errorCn];

var portMenuCn = ["视频", "音频", "码流", "VBI", "监测"];
var portMenuEn = ["Video", "Audio", "TS", "VBI", "Monitor"];
var portMenuArray = [portMenuEn, portMenuCn];
var PORT_VIDEO_MENU = 0;
var PORT_AUDIO_MENU = 1;
var PORT_TS_MENU = 2;
var PORT_VBI_MENU = 3;
var PORT_MONITOR_MENU = 4;
var portPageType = [PORT_VIDEO, PORT_AUDIO, PORT_TS, PORT_VBI, PORT_MONITOR];

function initDialog()
{
	progressDialog = $("#progressDialog").dialog(
	{
		autoOpen : false,
		dialogClass: "no-close",
		title : progressTitle[language],
		modal : true,
		closeOnEscape : false,
		resizable : false,
		height: 130,
		minHeight: 100,
		position : ["center", "center"],
		open : function()
		{
			progressTimer = setTimeout(progress, 6000);
		}
	});
}
function initProgress()
{	
	progressbar = $("#progressbar").progressbar(
	{
		value: 0,
		change : function()
		{
			$("#progressLabel").html(upgradeDesc);
		},
		complete : function()
		{
			$("#progressLabel").html(upgradeDesc);
			setTimeout(function()
			{
				progressDialog.dialog("close");
			}, 2000);
		}
	});
}
function progress()
{
	var response;
	var data;
	var xmlHttp = GetHTTPObject();
	data = "type=" + UPDATE + "&cmd=" + GET + "&language=" + language + "&slotNo=" + slotNo;
	xmlHttp.open("POST", "/goform/formEMR30", true);
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			responseData = response.split(FIRST_DELIMITER);
			var curProgress = parseInt(responseData[0], 10);
			upgradeDesc =  responseData[1];
			if(curProgress == -1)
			{
				if(language == ENGLISH)
				{
					$("#progressLabel").html("Update failed!");
				}
				else if(language == CHINESE)
				{
					$("#progressLabel").html("升级失败!");
				}
				return;
			}
			progressbar.progressbar("option", "value", curProgress);
			if(curProgress < 100)
			{
				progressTimer = setTimeout(progress, 12000);
			}
		}
	}
	xmlHttp.send(data);
}

function update()
{
	var response;
	$.ajax(
	 {
		 url : "/goform/formEMR30?type=" + UPDATE + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=" + $("#fileUpdate").val(),
		 cache : false,
		 async : false,
		 type : "GET",
		 contentType : "application/json; charset=utf-8",
		 success : function(responseData)
		 {
			 response = parseInt(AjaxStrDeal(responseData), 10);
			 if(response == RETURN_OK)
			 {
				if(language == ENGLISH)
				{
					$("#progressLabel").html("Start Update!");
				}
				else if(language == CHINESE)
				{
					$("#progressLabel").html("开始升级");
				}
				progressbar.progressbar("option", "value", 0);
				progressDialog.dialog("open");
			 }
			 else
			 {
				alert(returnError[language][response]);
			 }
		 },
		 error : function()
		 {}
	 });
}

/*************************************************
Function: 		pageJump
Description: 	端口页面横向跳转的函数
Input: 			index: 2-PORT_VIDEO; 3-PORT_AUDIO; 4-PORT_TS
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function pageJump(index)
{
	if(index == PORT_VIDEO)
	{
		window.location.href = "port_video" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo;
 	}
	else if(index == PORT_AUDIO)
 	{
		window.location.href = "port_audio" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo;
	}
 	else if(index == PORT_TS)
 	{
		window.location.href = "port_ts" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo;
	}
 	else if(index == PORT_VBI)
 	{
		window.location.href = "port_vbi" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo;
	}
	else if(index == PORT_MONITOR)
 	{
		window.location.href = "port" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo;
	}
}