﻿var objSetIdArray = ["fileUpdate", "workModeLicense", "programLicense"];
var SET_OBJ_NUM = 3;
var LICENSE_ROW_NUM = 4;
var MAX_LICENSE_NUM = 8;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	setInterval("autoRefresh();", 5000);
});

function funcUpdateDisplay()
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var sectionData;
	var response;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + CARD_CONFIG + "&cmd=" + GET + "&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);			
			if(response != "")
			{
				$("#workModeLicense").val(DISPLAY_STRING);
				$("#programLicense").val(DISPLAY_STRING);
				$("#fileUpdate").val(response);
				autoRefresh();
			}
		}
	}
	xmlHttp.send(null);
}

function autoRefresh()
{
	var data;
	var sectionData;
	var response;
	var xmlHttp = GetHTTPObject();
	var workWellStr = ["Working Well", "运行正常"];
	var loadFileStr = ["Loading upgrade file, Please hold on:", "升级文件传输中："];
	var writeFileStr = ["Writing upgrade file, Please don't power off:", "升级文件写入中，请不要断电："];
	var rebootStr = ["Rebooting system:", "编码器重启中："];
	var dataErrStr = ["Parameter sync loss:", "数据通信错误："];
	var secondStr = ["s", "秒"];
	var licenseLineNum;
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + CARD_AUTO_REFRESH + "&cmd=" + GET + "&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);			
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				$("#temperature").html(data[0]);
				
				if(data[1] == "0")
				{	
					if(data[2] == "0")
					{
						$("#workStatus").html(workWellStr[language]);
					}
					else
					{
						$("#workStatus").html(workWellStr[language] + "(" + data[2] + ")");
					}
				}
				else if(data[1] == "1")
				{
					$("#workStatus").html(loadFileStr[language] + data[2] + "%");
				}
				else if(data[1] == "2")
				{
					$("#workStatus").html(writeFileStr[language] + data[2] + secondStr[language]);
				}
				else if(data[1] == "3")
				{
					$("#workStatus").html(rebootStr[language] + data[2] + secondStr[language]);
				}
				else if(data[1] == "4")
				{
					$("#workStatus").html(dataErrStr[language] + data[2] + secondStr[language]);
				}
				
				$("#cardLicenseStatus").html(data[3]);
				
				licenseLineNum = parseInt(data[LICENSE_ROW_NUM], 10);
				
				for(var i = 0; i < licenseLineNum; i++)
				{
					$("#licenseStatusTr" + (i + 1)).css("display", "");
				}
				 
				for(var i = licenseLineNum; i < MAX_LICENSE_NUM; i++)
				{
					$("#licenseStatusTr" + (i + 1)).css("display", "none");
				}
				
				for(var i = 0; i < licenseLineNum; i++)
				{
					sectionData = data[LICENSE_ROW_NUM + (i + 1)].split(SECOND_DELIMITER);
					$("#itemName" + (i + 1)).html(sectionData[0]);
					$("#licenseStatus" + (i + 1)).html(sectionData[1]);
				}
						
				refreshFlag = true;  //刷新标识符设为true表示刷新成功
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + CARD_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
	var returnFlag;
	
	returnFlag = ValidateAuthCode($("#workModeLicense"), language);
	if(returnFlag == false)
	{
		return false;
	}
	
	returnFlag = ValidateAuthCode($("#programLicense"), language);
	if(returnFlag == false)
	{
		return false;
	}
	
	return true;
}

function generateData()
{
	var data;
	
	for(var i = 0; i < SET_OBJ_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objSetIdArray[i]).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objSetIdArray[i]).val();
		}
	}
	
	return data;
}