var groupIdArray = ["groupMinBitrate", "groupMaxBitrate", "sysBitrate", "switch"];
var GROUP_COL_NUM = 4;
var groupRowNum;
var paramIdArray = ["index", "minBitrate", "maxBitrate", "bitrate", "weight", "paramSwitch"];
var PARAM_COL_NUM = 6;
var paramRowNum;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	DisableButton("modifyBtn");	
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
	$("input[type=checkbox]").prop("checked", false);
}

function checkAll()
{
	var flag = $("#checkAll").prop("checked");
	for(var i = 0; i < paramRowNum; i++)
	{
		$("#check" + (i + 1)).prop("checked", flag);
	}
	
	if(parent.groupAccess != USER)
	{
		EnableButton("modifyBtn");
	}
}

function changeRowChecked()
{
	if(parent.groupAccess != USER)
	{
		EnableButton("modifyBtn");
	}
		
}

function displayParam()
{
	var data;
	var groupData;
	var paramData;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();
	var infoData;

	xmlHttp.open("GET", "/goform/formEMR30?type=" + CARD_STATMUX + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			data = response.split(FIRST_DELIMITER);

			if(data[0] == "")
			{
				groupRowNum = 0;
			}
			else
			{
				groupData = data[0].split(SECOND_DELIMITER);
				groupRowNum = groupData.length;
			}
			DrawTableRow("groupDataTable", "groupDataRow", "GroupCaseRow", groupRowNum);
			if(groupRowNum != 0)
			{
				updateGroupTableData(groupData);
			}
			if(data[1] == "")
			{
				paramRowNum = 0;
			}
			else
			{
				paramData = data[1].split(SECOND_DELIMITER);
				paramRowNum = paramData.length;
			}
			DrawTableRow("dataTable", "dataRow", "CaseRow", paramRowNum);
			if(paramRowNum != 0)
			{
				updateParamTableData(paramData);
			}
			refreshFlag = true;
		}
	}
	xmlHttp.send(null);
}

function updateGroupTableData(data)
{
	var rowData;
	var index;
	
	for(var i = 0; i < groupRowNum; i++)
	{
		index = i + 1;
		rowData = data[i].split(THIRD_DELIMITER);
		for(var j = 0; j < GROUP_COL_NUM; j++)
		{
			$("#" + groupIdArray[j] + index).val(rowData[j]);
		}
	}
}

function updateParamTableData(data)
{
	var rowData;
	var index;
	
	for(var i = 0; i < paramRowNum; i++)
	{
		index = i + 1;
		rowData = data[i].split(THIRD_DELIMITER);
		for(var j = 0; j < PARAM_COL_NUM; j++)
		{
			if(j == 0)
			{
				$("#" + paramIdArray[j] + index).html(rowData[j]);
			}
			else
			{
				$("#" + paramIdArray[j] + index).val(rowData[j]);
			}
		}
	}
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + CARD_STATMUX + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateGroupData() + FIRST_DELIMITER;
	data += generateParamData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateGroupData()
{
	var data;
	var index;
	for(var i = 0; i < groupRowNum; i++)
	{
		index = i + 1;
		for(var j = 0; j < GROUP_COL_NUM; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + groupIdArray[j] + index).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += SECOND_DELIMITER + $("#" + groupIdArray[j] + index).val();
			}
			else
			{
				data += THIRD_DELIMITER + $("#" + groupIdArray[j] + index).val();
			}
		}		
	}
	return data;
}

function generateParamData()
{
	var data;
	var index;
	for(var i = 0; i < paramRowNum; i++)
	{
		index = i + 1;
		for(var j = 0; j < PARAM_COL_NUM; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + paramIdArray[j] + index).html();
			}
			else if((i != 0) && (j == 0))
			{
				data += SECOND_DELIMITER + $("#" + paramIdArray[j] + index).html();
			}
			else
			{
				data += THIRD_DELIMITER + $("#" + paramIdArray[j] + index).val();
			}
		}		
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;
	
	for(var i = 0; i < groupRowNum; i++)
	{
		returnFlag = ValidateParam($("#groupMinBitrate" + (i + 1)), "INT_DEC", 600000, 10000000, "<Statmux Min Bitrate(bps)>", "<统计复用最小码率(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#groupMaxBitrate" + (i + 1)), "INT_DEC", 600000, 10000000, "<Statmux Max Bitrate(bps)>", "<统计复用最大码率(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
		if(parseInt($("#groupMaxBitrate" + (i + 1)).val(), 10) < parseInt($("#groupMinBitrate" + (i + 1)).val(), 10))
		{
			if(language == ENGLISH)
			{
				alert("<Statmux Max Bitrate(bps)> should be bigger than <Statmux Min Bitrate(bps)>!");
			}
			else if(language == CHINESE)
			{
				alert("<统计复用最大码率(bps)>应该大于<统计复用最小码率(bps)>！");
			}
			return false;
		}
		returnFlag = ValidateParam($("#sysBitrate" + (i + 1)), "INT_DEC", 600000, 40000000, "<System Bitrate(bps)>", "<系统码率(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
		if(parseInt($("#sysBitrate" + (i + 1)).val(), 10) < parseInt($("#groupMinBitrate" + (i + 1)).val(), 10))
		{
			if(language == ENGLISH)
			{
				alert("<Statmux System Bitrate(bps)> should be bigger than <Statmux Min Bitrate(bps)>!");
			}
			else if(language == CHINESE)
			{
				alert("<统计复用系统码率(bps)>应该大于<统计复用最小码率(bps)>！");
			}
			return false;
		}
	}
	for(var i = 0; i < paramRowNum; i++)
	{
		/*
		returnFlag = ValidateParam($("#minBitrate" + (i + 1)), "INT_DEC", 300000, 60000000, "<Min Bitrate(bps)>", "<最小码率(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#maxBitrate" + (i + 1)), "INT_DEC", 300000, 60000000, "<Max Bitrate(bps)>", "<最大码率(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
		if(parseInt($("#maxBitrate" + (i + 1)).val(), 10) < parseInt($("#minBitrate" + (i + 1)).val(), 10))
		{
			if(language == ENGLISH)
			{
				alert("<Max Bitrate(bps)> should be bigger than <Min Bitrate(bps)>!");
			}
			else if(language == CHINESE)
			{
				alert("<最大码率(bps)>应该大于<最小码率(bps)>！");
			}
			return false;
		}
		returnFlag = ValidateParam($("#bitrate" + (i + 1)), "INT_DEC", 300000, 60000000, "<Bitrate(bps)>", "<目标码率(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
		*/
		returnFlag = ValidateParam($("#weight" + (i + 1)), "FLOATING", 0.5, 3.5, "<Weight>", "<权重>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}

function modifyBulk()
{
	$("#modifyMinBitrate").val("600000");
	$("#modifyMinBitrateCheck").prop("checked", false);
	$("#modifyMaxBitrate").val("2000000");
	$("#modifyMaxBitrateCheck").prop("checked", false);
	$("#modifyBitrate").val("1000000");
	$("#modifyBitrateCheck").prop("checked", false);
	$("#modifyWeight").val("1");
	$("#modifyWeightCheck").prop("checked", false);
	$("#modifyParamSwitch").val("0");
	$("#modifyParamSwitchCheck").prop("checked", false);
	$("#modifyDiv").modal();
}

function modifyApply()
{
	if(validateBeforeModifyApply() == false)
	{
		return;
	}
	
	var modifyMinBitrate = $("#modifyMinBitrate").val();
	var modifyMinBitrateCheck = $("#modifyMinBitrateCheck").prop("checked");
	var modifyMaxBitrate = $("#modifyMaxBitrate").val();
	var modifyMaxBitrateCheck = $("#modifyMaxBitrateCheck").prop("checked");
	var modifyBitrate = $("#modifyBitrate").val();
	var modifyBitrateCheck = $("#modifyBitrateCheck").prop("checked");
	var modifyWeight = $("#modifyWeight").val();
	var modifyWeightCheck = $("#modifyWeightCheck").prop("checked");
	var modifyParamSwitch = $("#modifyParamSwitch").val();
	var modifyParamSwitchCheck = $("#modifyParamSwitchCheck").prop("checked");
	
	for(var i = 0; i < paramRowNum; i++)
	{
		if($("#check" + (i + 1)).prop("checked"))
		{
			if(modifyBitrateCheck)
			{
				$("#bitrate" + (i + 1)).val(modifyBitrate);
			}
			if(modifyMaxBitrateCheck)
			{
				$("#maxBitrate" + (i + 1)).val(modifyMaxBitrate);
			}
			if(modifyMinBitrateCheck)
			{
				$("#minBitrate" + (i + 1)).val(modifyMinBitrate);
			}
			if(modifyWeightCheck)
			{
				$("#weight" + (i + 1)).val(modifyWeight);
			}
			if(modifyParamSwitchCheck)
			{
				$("#paramSwitch" + (i + 1)).val(modifyParamSwitch);
			}
		}
	}
	$.modal.close();
	EnableButton("applyBtn");
}

function validateBeforeModifyApply()
{
 	var returnFlag;
	var modifyMinBitrateCheck = $("#modifyMinBitrateCheck").prop("checked");
	var modifyMaxBitrateCheck = $("#modifyMaxBitrateCheck").prop("checked");
	var modifyBitrateCheck = $("#modifyBitrateCheck").prop("checked");
	var modifyWeightCheck = $("#modifyWeightCheck").prop("checked");
	
	if(modifyMinBitrateCheck)
	{
		returnFlag = ValidateParam($("#modifyMinBitrate"), "INT_DEC", 300000, 60000000, "<Min Bitrate(bps)>", "<最小码率(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	if(modifyMaxBitrateCheck)
	{
		returnFlag = ValidateParam($("#modifyMaxBitrate"), "INT_DEC", 300000, 60000000, "<Max Bitrate(bps)>", "<最大码率(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	if(parseInt($("#modifyMaxBitrate").val(), 10) < parseInt($("#modifyMinBitrate").val(), 10))
	{
		if(language == ENGLISH)
		{
			alert("<Max Bitrate(bps)> should be bigger than <Min Bitrate(bps)>!");
		}
		else if(language == CHINESE)
		{
			alert("<最大码率(bps)>应该大于<最小码率(bps)>！");
		}
		return false;
	}
	if(modifyBitrateCheck)
	{
		returnFlag = ValidateParam($("#modifyBitrate"), "INT_DEC", 300000, 60000000, "<Bitrate(bps)>", "<目标码率(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	if(modifyWeightCheck)
	{
		returnFlag = ValidateParam($("#modifyWeight"), "FLOATING", 0.5, 3.5, "<Weight>", "<权重>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}

function cancelModify()
{
	$.modal.close();
}