var objIdArray = ["resolution", "width", "height", "bitrate", "entropyCoding","profile","level","gopStructure", "frameFieldMode"];
var VIDEO_COL_NUM = 9;
var RESOLUTION = 0;
var psiObjIdArray = ["serviceId", "serviceName", "serviceProvider", "pmtPid", "pcrPid","videoPid","audio1Pid","audio2Pid"];
var PSI_COL_NUM = 8;
var PCR_PID = 4;
var AUDIO1_PID = 6;
var AUDIO2_PID = 7;
var rowNum;
var CUSTOM = 0;
var multiScreenMode;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_BOTTOM_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	$(".resolution_sel").change(function()
	{
		var curTrNum = $(this).attr("id").slice(10);
		if($(this).val() != CUSTOM)
		{
			$("#width" + curTrNum).attr("disabled", true);
			$("#height" + curTrNum).attr("disabled", true);
		}
		else
		{
			$("#width" + curTrNum).attr("disabled", false);
			$("#height" + curTrNum).attr("disabled", false);
		}
	});
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var data;
	var videoData;
	var psiData;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();
	var infoData;

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_MULTI_SCREEN + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response == "")
			{
				rowNum = 0;
			}
			else
			{
				data = response.split(FIRST_DELIMITER);
				$("#multiScreenMode").val(data[0]);
				if(data[1] != "")
				{
					videoData = data[1].split(SECOND_DELIMITER);
					rowNum = videoData.length;				
				}
				else
				{
					rowNum = 0;
				}				
			}
			DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
			DrawTableRow("psiDataTable", "psiDataRow", "psiCaseRow", rowNum);
			if(rowNum != 0)
			{
				updateTableData(data);
			}
			refreshFlag = true;
		}
	}
	xmlHttp.send(null);
}

function updateTableData(data)
{
	var rowData;
	var index;
	
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		$("#index" + index).html(index);
		rowData = data[1].split(SECOND_DELIMITER)[i].split(THIRD_DELIMITER);
		for(var j = 0; j < VIDEO_COL_NUM; j++)
		{
			$("#" + objIdArray[j] + index).val(rowData[j]);
			if(j == RESOLUTION)
			{
				if(rowData[j] != CUSTOM)
				{
					$("#width" + index).attr("disabled", true);
					$("#height" + index).attr("disabled", true);
				}
				else
				{
					$("#width" + index).attr("disabled", false);
					$("#height" + index).attr("disabled", false);
				}
			}
		}
		$("#psiIndex" + index).html(index);
		rowData = data[2].split(SECOND_DELIMITER)[i].split(THIRD_DELIMITER);
		for(var j = 0; j < PSI_COL_NUM; j++)
		{
			$("#" + psiObjIdArray[j] + index).val(rowData[j]);
			if(i != 0)
			{
				if((j == PCR_PID) || (j == AUDIO1_PID) || (j == AUDIO2_PID))
				{
					$("#" + psiObjIdArray[j] + index).attr("disabled", true);
				}
			}
		}
	}
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_MULTI_SCREEN + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	var videoData;
	var psiData;
	var index;
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		for(var j = 0; j < VIDEO_COL_NUM; j++)
		{
			if((i == 0) && (j == 0))
			{
				videoData = $("#" + objIdArray[j] + index).val();
			}
			else if((i != 0) && (j == 0))
			{
				videoData += SECOND_DELIMITER + $("#" + objIdArray[j] + index).val();
			}
			else
			{
				videoData += THIRD_DELIMITER + $("#" + objIdArray[j] + index).val();
			}
		}
		for(var j = 0; j < PSI_COL_NUM; j++)
		{
			if((i == 0) && (j == 0))
			{
				psiData = $("#" + psiObjIdArray[j] + index).val();
			}
			else if((i != 0) && (j == 0))
			{
				psiData += SECOND_DELIMITER + $("#" + psiObjIdArray[j] + index).val();
			}
			else
			{
				psiData += THIRD_DELIMITER + $("#" + psiObjIdArray[j] + index).val();
			}
		}	
	}
	data = $("#multiScreenMode").val() + FIRST_DELIMITER + videoData + FIRST_DELIMITER + psiData;
	return data;
}

function paramCheck()
{
 	var returnFlag;
	var char;
	for(var i = 0; i < rowNum; i++)
	{
		if(parseInt($("#resolution" + (i + 1)).val(), 10) == CUSTOM)
		{
			returnFlag = ValidateParam($("#width" + (i + 1)), "INT_DEC", 96, 1920, "<Width>", "<宽度>", language);
			if(returnFlag == false)
			{
				return false;
			}
			if(parseInt($("#width" + (i + 1)).val(), 10)%16 != 0)
			{
				if(language == ENGLISH)
				{
					alert("The value of the width must be an integer multiple of 16!");
				}
				else
				{
					alert("宽度值必须是16的整数倍!");
				}
				return false;
			}
			returnFlag = ValidateParam($("#height" + (i + 1)), "INT_DEC", 96, 1080, "<Height>", "<高度>", language);
			if(returnFlag == false)
			{
				return false;
			}
			if(parseInt($("#height" + (i + 1)).val(), 10)%16 != 0)
			{
				if(language == ENGLISH)
				{
					alert("The value of the height must be an integer multiple of 16!");
				}
				else
				{
					alert("高度值必须是16的整数倍!");
				}
				return false;
			}
		}
		returnFlag = ValidateParam($("#bitrate" + (i + 1)), "INT_DEC", 300000, 10000000, "<Bitrate (bps)>", "<码率 (bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#serviceId" + (i + 1)), "INT_DEC_HEX", 1, 65535, "<SID>", "<节目号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#serviceName" + (i + 1)), "LENGTH", 0, 31, "<Service Name>", "<业务名称>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#serviceName" + (i + 1)), language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#serviceProvider" + (i + 1)), "LENGTH", 0, 31, "<Service Provider>", "<业务提供商>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#serviceProvider" + (i + 1)), language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#pmtPid" + (i + 1)), "INT_DEC_HEX", 32, 8190, "<PMT PID>", "<PMT PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		
		returnFlag = ValidateParam($("#videoPid" + (i + 1)), "INT_DEC_HEX", 32, 8190, "<Video PID>", "<视频PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		if(i == 0)
		{
			returnFlag = ValidateParam($("#pcrPid" + (i + 1)), "INT_DEC_HEX", 32, 8190, "<PCR PID>", "<PCR PID>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#audio1Pid" + (i + 1)), "INT_DEC_HEX", 32, 8190, "<Audio 1 PID>", "<音频1 PID>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#audio2Pid" + (i + 1)), "INT_DEC_HEX", 32, 8190, "<Audio 2 PID>", "<音频2 PID>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
	}
	return true;
}
