var objIdArray = ["rfSwitch", "outputLevel", "outputFrequency", "qamMode", "symbolRate"];
var ROW_NUM = 5;
var identifyData;
var channelCoding;
var channelBw;
var ANNEX_A = 0;
var ANNEX_B = 1;
var BW_6MHZ = 6;
var BW_8MHZ = 8;
var QAM_64 = 5;
var QAM_256 = 7;
var OUTPUT_LEVEL = 1;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var response;
	var rowData;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_CONFIG + "&cmd=" + GET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				identifyData = data[data.length - 1].split(SECOND_DELIMITER);
				channelCoding = identifyData[0];
				channelBw = identifyData[1];
				for(var i = 0; i < ROW_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				changeParam();
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
		}
		else if(i == OUTPUT_LEVEL)
		{
			data += FIRST_DELIMITER + parseFloat($("#" + objIdArray[i]).val()).toFixed(1);
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	return data;
}

function changeParam()
{
	if(portNo == 0)
	{
		for(var i = 1; i < ROW_NUM; i++)
		{
			$("#" + objIdArray[i]).attr("disabled", false);
		}
	}
	else
	{
		for(var i = 1; i < ROW_NUM; i++)
		{
			$("#" + objIdArray[i]).attr("disabled", true);
		}
	}
	var obj = $("#qamMode");
	if(channelCoding == ANNEX_B)
	{
		if(obj.get(0).length == 3)
		{
			$("#qamMode option[value='6']").remove();
		}
	}
	else
	{
		if(obj.get(0).length == 2)
		{
			obj.append("<option value='6'>128QAM</option>");
		}
	}
}

function paramCheck()
{
 	var returnFlag;
	var maxSymbolRate;
	var obj = $("#outputLevel");
	returnFlag = ValidateParam($("#outputLevel"), "FLOATING", 95.0, 120.0, "<Output Level(dBuV)>", "<输出电平(dBuV)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	if((obj.val())%0.5 != 0)
	{
		if(language == ENGLISH)
		{
			alert("<Output Level(dBuV)> Please input a valid number!");
		}
		else if(language == CHINESE)
		{
			alert("<输出电平(dBuV)>请输入合法的数字！");
		}
		setTimeout(function () {obj.focus()}, 0);
		setTimeout(function () {obj.select()}, 0);
		return false;
	}
	returnFlag = ValidateParam($("#outputFrequency"), "INT_DEC", 52000, 940000, "<Output Frequency(KHz)>", "<输出频率(KHz)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	if(channelCoding == ANNEX_A)
	{
		if(channelBw == BW_6MHZ)
		{
			maxSymbolRate = 5250;
		}
		else if(channelBw == BW_8MHZ)
		{
			maxSymbolRate = 7000;
		}		
	}
	else
	{
		if(parseInt($("#qamMode").val(), 10) == QAM_64)
		{
			maxSymbolRate = 5085;
		}
		else if(parseInt($("#qamMode").val(), 10) == QAM_256)
		{
			maxSymbolRate = 5360;
		}
	}
	returnFlag = ValidateParam($("#symbolRate"), "INT_DEC", 5000, maxSymbolRate, "<Symbol Rate(Ksps)>", "<符号率(Ksps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;
}