﻿var addObjIdArray = ["addNum", "addCard", "addPort", "addPid", "addSwitch", "addBitrate", "addFileName"];
var ADD_ROW_NUM = 7;
var objIdArray = ["", "", "dstCard", "dstPort", "pid", "switch", "bitrate", "fileName", "status"];
var COL_NUM = 9;
var INFO = 0;
var INDEX = 1;
var CARD = 2;
var PORT = 3;
var PID = 4;
var SWITCH = 5;
var BITRATE = 6;
var FILE_NAME = 7;
var STATUS = 8;

var dataArray = [];

var CHECK = 0;
var CHANGE = 1;

var NORMAL_STRING = "N";
var CHECK_STRING = "C";
var CHANGE_STRING = "M";

var curRespRowNum;
var rowNum = 0;
var initRow = true;
var rowIndex;
							
var optionArray;
var fileArray;

var TABLE_FILE = 1;
var ADD_FILE = 2;
var MODIFY_FILE = 3;

var PROCESS_FLAG = 1;
var lockFlag = false;  //页面是否处于锁定状态的标识符，false为初始状态，锁定页面时设为true，页面解锁后重新恢复初始

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	startProcessMonitor();
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	DisableButton("addBtn");
	DisableButton("deleteBtn");
	DisableButton("deleteAllBtn");
	DisableButton("modifyBtn");
	$("input[type=checkbox]").attr("disabled", true);
	PageLoadStatus(true);
	dataArray = [];
	
	generateFileOption();
	generateCardOption();
	
	ResetColor();
	PageLoadStatus(false);
	
	$("input[type=checkbox]").prop("checked", false);
}

function changeRowChecked(obj)
{
	var rowIndex;
	var flag;
	
	if(parent.groupAccess != USER)
	{
		EnableButton("deleteBtn");
		EnableButton("modifyBtn");
		EnableButton("applyBtn");
	}
		
	rowIndex = GetIndexFromId(obj, 12) - 1;
	flag = obj.prop("checked");
	changeRowInfo(rowIndex, flag);
}

function changeRowInfo(rowIndex, flag)
{
	var rowData = dataArray[rowIndex].split(SECOND_DELIMITER);
	var rowInfo = rowData[INFO].split(",");
	var newRowInfo;
	var newString;
	
	if(flag == true)
	{
		rowInfo[CHECK] = CHECK_STRING;
	}
	else
	{
		rowInfo[CHECK] = NORMAL_STRING;
	}
	newRowInfo = rowInfo[CHECK] + "," + rowInfo[CHANGE];
	newString = newRowInfo;
	for(var i = INDEX; i < COL_NUM; i++)
	{
		newString += SECOND_DELIMITER + rowData[i];
	}
	dataArray[rowIndex] = newString;
}

function checkAll()
{
	var flag = $("#basicCheckAll").prop("checked");
	for(var i = 0; i < rowNum; i++)
	{
		$("#basicCheck" + (i + 1)).prop("checked", flag);
		changeRowInfo(i, flag);
	}

	if(parent.groupAccess != USER)
	{
		EnableButton("deleteBtn");
		EnableButton("modifyBtn");
		EnableButton("applyBtn");
	}
}

function generateFileOption()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + FILE_LIST + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			fileArray = response.split(FIRST_DELIMITER);
		}
	}
	xmlHttp.send(null);
}

function generateCardOption()
{
	var data;
	var response;
	var cardArray;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PID_MAP_LIST + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + 0xff + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			cardArray = response.split(FIRST_DELIMITER);
			optionArray = cardArray[1].split(SECOND_DELIMITER);
			displayParam();
		}
	}
	xmlHttp.send(null);
}

function displayParam()
{
	var data;
	var i;
	var response;
	var indexInfo;
	var curRowNum;
	var rowData;
	var xmlHttp = GetHTTPObject();

	if(initRow)
	{
		rowIndex = 0;
	}
	xmlHttp.open("GET", "/goform/formEMR30?type=" + CARD_DATA + "&cmd=" + GET + "&rowIndex=" + rowIndex +  
		"&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				var timeObj = new Date();
				startRefreshTime = timeObj.getTime();
				initRow = false;
				data = response.split(FIRST_DELIMITER);
				curRespRowNum = data.length - 1;
				indexInfo = data[curRespRowNum].split(SECOND_DELIMITER);
				rowIndex = parseInt(indexInfo[0], 10);
				rowNum = parseInt(indexInfo[1], 10);
				curRowNum = $("#basicTable" + " tr").filter(".basicCaseRow").length;
				if((curRowNum < rowNum) && (curRowNum < rowIndex))
				{
					DrawTableRow("basicTable", "basicDataRow", "basicCaseRow", rowIndex);
				}
				else if(curRowNum > rowNum)
				{					
					DrawTableRow("basicTable", "basicDataRow", "basicCaseRow", rowNum);
				}
				if(curRespRowNum != 0)
				{
					var saveString = "";
					for(i = 0; i < curRespRowNum; i++)
					{
						saveString = NORMAL_STRING + "," + NORMAL_STRING + SECOND_DELIMITER + data[i];
						dataArray.push(saveString);
					}
					for(i = (rowIndex - curRespRowNum); i < rowIndex; i++)
					{
						populateCard($("#dstCard" + (i + 1)));
						populateFile("fileNameList" + (i + 1), TABLE_FILE);
						rowData = dataArray[i].split(SECOND_DELIMITER);
						for(var j = INDEX; j < COL_NUM; j++)
						{
							if(j == INDEX)
							{
								$("#basicIndex" + (i + 1)).html(rowData[j]);
							}
							else if(j == PORT)
							{
								populatePort($("#dstCard" + (i + 1)));
								$("#" + objIdArray[j] + (i + 1)).val(rowData[j]);
							}
							else if(j == STATUS)
							{
								$("#" + objIdArray[j] + (i + 1)).html(rowData[j]);
							}
							else
							{
								$("#" + objIdArray[j] + (i + 1)).val(rowData[j]);
							}
						}
					}
				}
				if(rowIndex < rowNum)
				{
					setTimeout("displayParam()", 5);
				}
				else if(rowIndex == rowNum)
				{
					EnableButton("refreshBtn");
					if(parent.groupAccess != USER)
					{
						EnableButton("addBtn");
						EnableButton("deleteAllBtn");
					}
					$("input[type=checkbox]").attr("disabled", false);
					initRow = true;
					refreshFlag = true;
				}
			}
		}
	}
	xmlHttp.send(null);
}

function populateFile(id, type)
{
	var option;
	var fileNum = fileArray.length;
	var obj = $("#" + id);
	
	obj.parent().children().remove("div"); 
	obj.empty();
	obj.removeClass();
	for(var i = 0; i < fileNum; i++)
	{
		option = $("<option>").text(fileArray[i]).val(fileArray[i]);
		obj.append(option);
	}
	obj.addClass("chzn-select");
	obj.chosen();
	$("#" + id + "_chzn").css("width", "20px");
	$("#" + id + "_chzn").find('a.chzn-single').attr("title", "Select a File");
	
	if(type == TABLE_FILE)
	{
		obj.parent().children().find('div.chzn-drop').css("margin-left", "-147px");
	}
	else if(type == ADD_FILE)
	{
		obj.parent().children().find('div.chzn-drop').css("margin-left", "-303px");
	}
	else if(type == MODIFY_FILE)
	{
		obj.parent().children().find('div.chzn-drop').css("margin-left", "-249px");
	}
}

function populateCard(obj)
{
	var cardInfo;
	var option;
	var cardNum = optionArray.length;
	
	obj.empty();
	
	if(optionArray[0] == "")
	{
		option = $("<option>").text(noCardList[language]).val(NO_CARD);
		obj.append(option);
	}
	else
	{
		for(var i = 0; i < cardNum; i++) 
		{
			cardInfo = optionArray[i].split(THIRD_DELIMITER);
			option = $("<option>").text(cardInfo[0]).val(cardInfo[1]);
			obj.append(option);
		}
	}
}

function populatePort(obj)
{
	var option;
	var cardNo = parseInt(obj.val(), 10);
	var rowIndex = GetIndexFromId(obj, 12) - 1;
	var index = rowIndex + 1;
	var dstPort = $("#dstPort" + index);
	
	dstPort.empty();
	if(cardNo == NO_CARD)
	{
		option = $("<option>").text(noPortList[language]).val(NO_PORT);
		dstPort.append(option);
	}
	else
	{
		var selectIndex = parseInt(obj.get(0).selectedIndex, 10);
		var portInfo = optionArray[selectIndex].split(THIRD_DELIMITER);
		var portNum = portInfo.length - 2;	
		var displayStr;
			
		for(var i = 0; i < portNum; i++)
		{
			displayStr = getPortDisplayStr(cardNo, parseInt(portInfo[2 + i], 10), language);
			option = $("<option>").text(displayStr).val(parseInt(portInfo[2 + i], 10) - 1);
			dstPort.append(option);
		}
	}
}

function populateEditPort(obj, portId)
{
	var option;
	var cardNo = parseInt(obj.val(), 10);
	var editPort = $("#" + portId);
	
	editPort.empty();
	if(cardNo == NO_CARD)
	{
		option = $("<option>").text(noPortList[language]).val(NO_PORT);
		editPort.append(option);
	}
	else
	{
		var selectIndex = parseInt(obj.get(0).selectedIndex, 10);
		var portInfo = optionArray[selectIndex].split(THIRD_DELIMITER);
		var portNum = portInfo.length - 2;	
		var displayStr;
			
		for(var i = 0; i < portNum; i++)
		{
			displayStr = getPortDisplayStr(cardNo, parseInt(portInfo[2 + i], 10), language);
			option = $("<option>").text(displayStr).val(parseInt(portInfo[2 + i], 10) - 1);
			editPort.append(option);
		}
	}
}

function updateTableData()
{
	var rowData;
	
	for(var i = 0; i < rowNum; i++)
	{
		populateCard($("#dstCard" + (i + 1)));
		populateFile("fileNameList" + (i + 1), TABLE_FILE);
		rowData = dataArray[i].split(SECOND_DELIMITER);
		for(var j = INDEX; j < COL_NUM; j++)
		{
			if(j == INDEX)
			{
				$("#basicIndex" + (i + 1)).html(rowData[j]);
			}
			else if(j == PORT)
			{
				populatePort($("#dstCard" + (i + 1)));
				$("#" + objIdArray[j] + (i + 1)).val(rowData[j]);
			}
			else if(j == STATUS)
			{
				$("#" + objIdArray[j] + (i + 1)).html(rowData[j]);
			}		
			else
			{
				$("#" + objIdArray[j] + (i + 1)).val(rowData[j]);
			}
		}
	}
}

function pageApply()
{
	var data = "type=" + CARD_DATA + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	var editNum = 0;
	var rowData;
	var newString;
	var rowInfo;
	var xmlHttp = GetHTTPObject();
	var response;
	
	for(var i = 0; i < rowNum; i++)
	{
		rowData = dataArray[i].split(SECOND_DELIMITER);
		rowInfo = rowData[INFO].split(",");
		if((rowInfo[CHECK] == CHECK_STRING) || (rowInfo[CHANGE] == CHANGE_STRING))
		{
			if(validateBeforeApply(i) == false)
			{
				return;
			}
			for(var j = INDEX; j < COL_NUM; j++)
			{
				if(j == INDEX)
				{
					newString = rowData[j];
				}
				else
				{
					newString += SECOND_DELIMITER + rowData[j];
				}
			}
			if(editNum == 0)
			{
				data += newString;
			}
			else
			{
				data += FIRST_DELIMITER + newString;
			}
			editNum++;
		}
	}
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function changeFileName(obj, type)
{
	var oldFileName;
	
	if(type == TABLE_FILE)
	{
		var rowIndex = GetIndexFromId(obj, 12) - 1;
		var index = rowIndex + 1;
		oldFileName = $("#fileName" + index).val();
		$("#fileName" + index).val(obj.val());
		changeCellValue($("#fileName" + index));
		if(obj.val() != oldFileName)
		{
			$("#fileName" + index).css("backgroundColor", "#feffe0");
		}
	}
	else if(type == ADD_FILE)
	{
		oldFileName = $("#addFileName").val();
		$("#addFileName").val(obj.val());
		if(obj.val() != oldFileName)
		{
			$("#addFileName").css("backgroundColor", "#feffe0");
		}		
	}
	else if(type == MODIFY_FILE)
	{
		oldFileName = $("#modifyFileName").val();
		$("#modifyFileName").val(obj.val());
		if(obj.val() != oldFileName)
		{
			$("#modifyFileName").css("backgroundColor", "#feffe0");
		}
	}
}

function changeCellValue(obj)
{
	var id = obj.attr("id");
	var rowIndex = GetIndexFromId(obj, 12) - 1;
	var fieldIndex;
	var rowData = dataArray[rowIndex].split(SECOND_DELIMITER);
	var rowInfo = rowData[INFO].split(",");
	var newRowInfo;
	var newString;

	for(var i = CARD; i < COL_NUM; i++)
	{
		if(id.indexOf(objIdArray[i]) != -1)
		{
			fieldIndex = i;
			break;
		}
	}
	rowData[fieldIndex] = obj.val();
	rowInfo[CHANGE] = CHANGE_STRING;
	newRowInfo = rowInfo[CHECK] + "," + rowInfo[CHANGE];
	newString = newRowInfo;
	for(var i = INDEX; i < COL_NUM; i++)
	{
		newString += SECOND_DELIMITER + rowData[i];
	}
	dataArray[rowIndex] = newString;
}

function validateBeforeApply(rowIndex)
{
 	var returnFlag;
	var index = rowIndex + 1;
	
	returnFlag = ValidateParam($("#" + objIdArray[PID] + index), "INT_DEC_HEX", 0, 8191, "<PID>", "<PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#" + objIdArray[BITRATE] + index), "INT_DEC", 0, 213000000, "<Bitrate(bps)>", "<码率(bps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#" + objIdArray[FILE_NAME] + index), "LENGTH", 0, 31, "<File Name>", "<文件名>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateName($("#" + objIdArray[FILE_NAME] + index), language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;
}

function deleteInfo()
{
	var data;
	var rowData;
	var rowInfo;
	var confirmPrompt;
	var xmlHttp = GetHTTPObject();
	var response;
	var deleteInfo = "";
	var deleteNum = 0;
	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete the selected program information?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除选中节目信息吗？";
	}
	
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + CARD_DATA + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
		
		for(var i = 0; i < rowNum; i++)
		{
			rowData = dataArray[i].split(SECOND_DELIMITER);
			rowInfo = rowData[INFO].split(",");
			if(rowInfo[CHECK] == CHECK_STRING)
			{
				if(deleteNum == 0)
				{
					deleteInfo = rowData[INDEX];
				}
				else
				{
					deleteInfo += FIRST_DELIMITER + rowData[INDEX];
				}
				deleteNum++;
			}
		}
		if(deleteNum == 0)
		{
			if(language == ENGLISH)
			{
				alert("Please select one program information at least!");
			}
			else
			{
				alert("请至少选中一个节目信息！");
			}
			return;
		}
		data += deleteInfo;
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("The checked program information is deleted successfully.");
					}
					else if(language == CHINESE)
					{
						alert("选中的节目信息删除成功！")
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function deleteAll()
{
	var confirmPrompt;
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(rowNum == 0)
	{
		if(language == ENGLISH)
		{
			alert("The number of program information is 0!");
		}
		else if(language == CHINESE)
		{
			alert("节目信息个数是0！");
		}
		return;
	}
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete all the program information?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除全部节目信息吗？";
	}
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + CARD_DATA + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&setString=0xffff";
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("All the program information is deleted successfully!");
					}
					else if(language == CHINESE)
					{
						alert("所有节目信息删除成功！")
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function addInfo()
{
	populateCard($("#addCard"));
	populateFile("addFileNameList", ADD_FILE);
	var addCard = $("#addCard").get(0);
	var addPort = $("#addPort").get(0);
	var addCardValue = addCard.options[0].value;
	var addPortValue;
	
	$("#addNum").val("1");
	$("#addCard").val(addCardValue);
	populateEditPort($("#addCard"), "addPort");
	addPortValue = addPort.options[0].value;
	$("#addPort").val(addPortValue);
	$("#addPid").val("0");
	$("#addSwitch").val("1");
	$("#addBitrate").val("0");
	
	$("#addInfo").modal();
}

function modifyInfo()
{
	populateCard($("#modifyCard"));
	populateFile("modifyFileNameList", MODIFY_FILE);
	var modifyCard = $("#modifyCard").get(0);
	var modifyPort = $("#modifyPort").get(0);
	var modifyCardValue = modifyCard.options[0].value;
	var modifyPortValue;
	
	$("#modifyCard").val(modifyCardValue);
	populateEditPort($("#modifyCard"), "modifyPort");
	modifyPortValue = modifyPort.options[0].value;
	$("#modifyPort").val(modifyPortValue);
	$("#modifyPid").val("");
	$("#modifySwitch").val("1");
	$("#modifyBitrate").val("");
	$("#modifyFileName").val("");
	
	$("#modifyCardCheck").prop("checked", false);
	$("#modifyPortCheck").prop("checked", false);
	$("#modifyPidCheck").prop("checked", false);
	$("#modifySwitchCheck").prop("checked", false);
	$("#modifyBitrateCheck").prop("checked", false);
	$("#modifyFileNameCheck").prop("checked", false);
	
	$("#modifyInfo").modal();
}

function addInfoApply()
{
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(validateBeforeAddApply() == false)
	{
		return;
	}
	
	data = "type=" + CARD_DATA + "&cmd=" + ADD + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			$.modal.close();
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(language == ENGLISH)
				{
					alert("The data information is added successfully!");
				}
				else if(language == CHINESE)
				{
					alert("数据信息添加成功！")
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}
function generateData()
{
	var data;
	for(var i = 0; i < ADD_ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + addObjIdArray[i]).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + addObjIdArray[i]).val();
		}
	}
	return data;
}

function validateBeforeAddApply()
{
 	var returnFlag;
	var addNum = parseInt($("#addNum").val(), 10);
	var addServiceId = parseInt($("#addServiceId").val(), 10);
	var addServiceIdStep = parseInt($("#addServiceIdStep").val(), 10);
	var maxServiceId = addServiceId + addServiceIdStep * (addNum - 1);
	
	if(rowNum == 256)
	{
		if(language == ENGLISH)
		{
			alert("The number of program information is 256, can't add new information!");
		}
		else if(language == CHINESE)
		{
			alert("节目信息个数已经是最大值256，不能再添加新的节目信息！");
		}
		return false;
	}
	else
	{
		returnFlag = ValidateParam($("#addNum"), "INT_DEC", 1, (256 - rowNum), "<Add Number>", "<添加个数>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	
	returnFlag = ValidateParam($("#addPid"), "INT_DEC_HEX", 0, 8191, "<PID>", "<PID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#addBitrate"), "INT_DEC", 0, 213000000, "<Bitrate(bps)>", "<码率(bps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#addFileName"), "LENGTH", 0, 31, "<File Name>", "<文件名>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateName($("#addFileName"), language);
	if(returnFlag == false)
	{
		return false;
	}
	
	return true;
}

function cancelAdd()
{
	$.modal.close();
}

function modifyInfoApply()
{
 	var returnFlag;
	var rowData;
	var rowInfo;

	var modifyCard = parseInt($("#modifyCard").val(), 10);
	var modifyCardCheck = $("#modifyCardCheck").prop("checked");
	
	var modifyPort = parseInt($("#modifyPort").val(), 10);
	var modifyPortCheck = $("#modifyPortCheck").prop("checked");
	
	var modifyPid = parseInt($("#modifyPid").val(), 10);
	var modifyPidCheck = $("#modifyPidCheck").prop("checked");
	
	var modifySwitch = parseInt($("#modifySwitch").val(), 10);
	var modifySwitchCheck = $("#modifySwitchCheck").prop("checked");
	
	var modifyBitrate =  parseInt($("#modifyBitrate").val(), 10);
	var modifyBitrateCheck = $("#modifyBitrateCheck").prop("checked");
	
	var modifyFileName = $("#modifyFileName").val();
	var modifyFileNameCheck = $("#modifyFileNameCheck").prop("checked");
	
	var checkedIndex = 0;
	var checkedRowNum = 0;
	
	var i;
	var index;
	
	for(i = 0; i < rowNum; i++)
	{
		rowData = dataArray[i].split(SECOND_DELIMITER);
		rowInfo = rowData[INFO].split(",");
		if(rowInfo[CHECK] == CHECK_STRING)
		{
			checkedRowNum++;
		}
	}	
	if(modifyPidCheck)
	{
		returnFlag = ValidateParam($("#modifyPid"), "INT_DEC_HEX", 0, 8191, "<PID>", "<PID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	if(modifyBitrateCheck)
	{
		returnFlag = ValidateParam($("#modifyBitrate"), "INT_DEC", 0, 213000000, "<Bitrate(bps)>", "<码率(bps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	if(modifyFileNameCheck)
	{
		returnFlag = ValidateParam($("#modifyFileName"), "LENGTH", 0, 31, "<File Name>", "<文件名>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#modifyFileName"), language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	
	for(i = 0; i < rowNum; i++)
	{
		rowData = dataArray[i].split(SECOND_DELIMITER);
		rowInfo = rowData[INFO].split(",");
		if(rowInfo[CHECK] == CHECK_STRING)
		{
			checkedIndex++;			
			if(modifyCardCheck)
			{
				rowData[CARD] = modifyCard;
			}
			if(modifyPortCheck)
			{
				rowData[PORT] = modifyPort;
			}
			if(modifyPidCheck)
			{
				rowData[TS_ID] = modifyPid;
			}			
			if(modifySwitchCheck)
			{
				rowData[SWITCH] = modifySwitch;
			}
			if(modifyBitrateCheck)
			{
				rowData[BITRATE] = modifyBitrate;
			}
			if(modifyFileNameCheck)
			{
				rowData[FILE_NAME] = modifyFileName;
			}
			rowInfo[CHANGE] = CHANGE_STRING;
			newRowInfo = rowInfo[CHECK] + "," + rowInfo[CHANGE];
			newString = newRowInfo;
			for(var j = INDEX; j < COL_NUM; j++)
			{
				newString += SECOND_DELIMITER + rowData[j];
			}
			dataArray[i] = newString;
		}
	}
	
	$.modal.close();
	updateTableData();
	EnableButton("applyBtn");
	return true;
}

function cancelModify()
{
	$.modal.close();
}

function lockUI(percent)
{	
	$("#lockPrompt").modal();
	
	if(language == ENGLISH)
	{
		$("#lockInfo").html("Processing...");
	}
	else
	{
		$("#lockInfo").html("处理中...");
	}
	$("#loading" + " > div").css("width", parseInt(percent) + "%");  //控制#loading div宽度 
	$("#loading" + " > div").html(percent + "%");  //显示百分比 
}

function startProcessMonitor()
{
	getCardStatus();
	setInterval(function(){getCardStatus()}, 2000);
}
			
//监测EPG卡是否处于处理状态
function getCardStatus()
{
	var response;
	var data;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + CARD_STATUS + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			data = response.split(FIRST_DELIMITER);
			if((data[0] == PROCESS_FLAG))
			{
				lockUI(data[1]);
				lockFlag = true;
			}
			else if((data[0] != PROCESS_FLAG) && (lockFlag == true)) //处理完解锁
			{
				$.modal.close();
				lockFlag = false;
			}
		}
	}
	xmlHttp.send(null);
}