--
-- Copyright (C) 2005 dahua Technologies, All Rights Reserved.
-- 2006-4-25 15:54 Z:\wjj\ven\152\DAHUA\Install.lua
-- 2006-9-21  modified by zhongjl for new partition
--

-- Flash ĴСΪ64K
local flashSectorSize = 0x20000;

local Installer = {};
Installer.TotalSize      = 0;    -- ܵҪдFlashеݴС
Installer.InProgressSize = 0;	 -- пƽ

-- ֪ͨϲӦóĽϢ
-- params:
--    
-- return:
--    
function Installer:notify()
	self.InProgressSize = self.InProgressSize + flashSectorSize;

	local progress = self.InProgressSize / self.TotalSize * 100;
	if(progress > 100) then
		progress = 100;
	end;
	progress = tonumber(string.format("%d", progress));

	-- ע÷ʽ,self::callback,ᵼ»ص
	self.callback(0x01, progress);
end

-- ӦóṩϢжǷ
-- params:
--    
-- return:
--    ɹTrue, ʧܷFalseԼʧܵԭ
function Installer:preInstall()
	-- ҪЩ
	-- Ӳ汾 
	-- ԭİ汾ţ
	--
	local board = Global.Hardware.board;
	local hwproduct;
	local hwchannel;
	local hwversion;
	local hwfunction;

	print(string.format("Checking hardware information,board name:%s version:%s",
		board.name, board.version));
	--if(board.name ~= "DVRxx04LE-A") then
	--	return false, "Invalid board";
	--end

	--ֱӴӲȡֵ
	--hwproductȡֵ: 2 -- LB; 3 -- LBN; 4 -- LB_ATM; 5 -- GBE; 6 -- LK; 7 -- LS
	--hwproductȡֵ: 2 -- IPC4X5; 3 -- A6; 4 -- A8; 5 -- IPVM;
	--hwchannelȡֵ: x -- x chans
	--hwfunctionȡֵ: 0 -- AUDIO; 1 -- MATRIX; 3 -- LOOP

	if(mtd.getinfo)then
		hwproduct,hwchannel,hwversion,hwfunction = mtd.getinfo();
		print(string.format("Checking hardware id info: product = %x; channel = %x; version = %x; function = %x",
			hwproduct,hwchannel,hwversion,hwfunction));
		if((hwproduct ~= 3) and (hwproduct ~= 4)) then
			print(string.format("product not match"));
			return false, "Invalid board";
		end
	end

	-- ҪУ鲻ͬ屾İӳǷͨ,
	-- ĿǰLB 1.22 LB 2.00İӾͲͨ
	-- if(board.version ~= "1.22") then
	--  print(string.format("XXXXXXXXXXXX"));
	--	return false, "Invalid board version";
	-- end

	local vendor = Global.Vendor;

	if(vendor.Name ~= 'General' and vendor.Name ~= 'DAHUA') then
		return false, "Invalid vendor";
	end

	return true;
end

-- ɺĴ,ϵͳ
-- params:
--    
-- return:
--    
function Installer:postInstall()
end

-- Flash,ڲͬӦ,Ĵܲһ
-- params	:
-- part		: ,ʼλԼλ
-- filename	: еļ
-- return	: 
function Installer:updatePart(part, filename)
	local myfile = self.ZipArchive:open(filename);
	-- ļ򲻿,ҪԴ˲ֽ
	if(not myfile) then
		print(string.format("%s not exist", filename));
		return ;
	end

	local addr   = part.baseAddr;
	local endAddr= part.endAddr;
	local data;
	local fldata;

	-- ǰ64ֽڵͷ,µ汾вҪԴ˽У
	myfile:seek("set", 64);
	while(addr < endAddr) do
		fldata = mtd.read(addr,flashSectorSize);
		data = myfile:read(flashSectorSize);    -- һFlashС

		-- if (fldata and data and (fldata ~= data)) then
		-- fldataΪյʱΪϵĳֱӲ

		if(data) then
			if((not fldata) or (data and (fldata ~= data))) then
				mtd.erase(addr);
				mtd.write(addr, data);
			end
		  self:notify();
		  addr   = addr   + flashSectorSize;
		else
		  addr = endAddr;
		end
	end

	myfile:close();
end

function Installer:InstallPlayer(filename)
	local myfile = self.ZipArchive:open(filename);

	-- ļ򲻿,ҪԴ˲ֽ
	if(not myfile) then
		return ;
	end

	--
	-- TODO:
	-- ԶݣͨIDEӿд뵽Ӳ
	--
end

-- 
-- params:
--    
-- return:
--    ɹTrue,ʧܷFlaseԼԭ
function Installer:execute()
	--[[
	 Ϣ,֪ʶ "Flash 滮"
	 0xa0000000  0xa0040000  256K     armboot                                 u-boot
	 0xa0060000  0xa0460000  4096K    kernel + root                           romfs
	 0xa0460000  0xa0a60000  6144K    application + modules                   user
	 0xa0a60000  0xa0c60000  1536K    web                                     web
	 0xa0c60000  0xa0e60000  2560K    slave:romfs + kernel + pcidriver        slave
	 0xa0e60000  0xa0e80000  128K     custom                                  custom
	 0xa0e80000  0xa0ec0000  256K     logo                                    logo
	 0xa0ec0000  0xa0f40000  1024K    config                                  
	 0xa0f40000  0xa1000000  1024K    config1
	]]

	local flashPartions =
	{
		boot		= { baseAddr = 0xa0000000  , endAddr = 0xa0040000 },
		rootfs		= { baseAddr = 0xa0060000  , endAddr = 0xa0460000 },
		user     	= { baseAddr = 0xa0460000  , endAddr = 0xa0A60000 },
		web     	= { baseAddr = 0xa0A60000  , endAddr = 0xa0BE0000 },
		slave  		= { baseAddr = 0xa0BE0000  , endAddr = 0xa0E60000 },
		custom  	= { baseAddr = 0xa0E60000  , endAddr = 0xa0E80000 },
		logo		= { baseAddr = 0xa0E80000  , endAddr = 0xa0EC0000 },
		config		= { baseAddr = 0xa0EC0000  , endAddr = 0xa0f40000 },
		config1		= { baseAddr = 0xa0f40000  , endAddr = 0xa1000000 },
	}

	-- self.ZipArchive ⲿ,ûóӦе
	assert(self.ZipArchive);
	local zfile = self.ZipArchive;

	local ret, info = self:preInstall();
	if(not ret) then
		return false, info;
	end

	-- ҪļСԼӡļ嵥
	local TotalSize = 0;
	print("==>Files in archive");
	for file in zfile:files() do
		print(file.filename);
		TotalSize = TotalSize + file.uncompressed_size;
	end
	self.TotalSize  = TotalSize;     -- ܵļС
	print(">>>>>>>>>>init.");
	mtd.init();
	print(">>>>>>>>>>updatePart.");
	self:updatePart(flashPartions["boot"],	"u-boot.bin.img");
	--mtd.saveenv();
	print(">>>>>>>>>>updatePart	rootfs.");
	self:updatePart(flashPartions["rootfs"],	"romfs-x.cramfs.img");
	print(">>>>>>>>>>updatePart	user.");
	self:updatePart(flashPartions["user"],		"user-x.cramfs.img");
	print(">>>>>>>>>>updatePart	web.");
	self:updatePart(flashPartions["web"],		"web-x.cramfs.img");
	print(">>>>>>>>>>updatePart	slave.");
	self:updatePart(flashPartions["slave"],		"slave-x.cramfs.img");
	print(">>>>>>>>>>updatePart	custom.");
	self:updatePart(flashPartions["custom"],	"custom-x.cramfs.img");
	print(">>>>>>>>>>updatePart	logo.");
	self:updatePart(flashPartions["logo"],		"logo-x.cramfs.img");
	--self:InstallPlayer("autoplayer.bin");
		print(">>>>>>>>>>updatePart	postInstall.");
	self:postInstall();
	print("==>Upgrade finished.");
	return true;
end

return Installer;
