//	createDialog function need three parameter (title, flag, infos)
//	-title is the title of dialog
//	-flag  is identify label
//	-infos is a entry(JSON) of information need from external

var gSipLineNum = -1;
var gFlag 		 = -1;
var WEBDIAL 	 = 0;
var REBOOT 		 = 1;
var CLEARCONF 	 = 2;
var CTCDIALOG    = 3;
var ADDBLACKLIST = 4;
var ADDGROUP 	 = 5;
var OUTCALLLIMIT = 6;
var IMGCORRUPT	 = 7;
var WARN = 13;
var SECURITY = 14;
var UPGRADE = 15;
var CLIENT_CERT = 16;
var BMP_WARN = 17;
var AUTO_PROVISION = 18;

var dialogWidth  = 0;
var dialogHeight = 0;

var phb_idx      = 0;
var phb_groups   = null;
var phb_groupIds = null;
var phb_isModify = false;

function setPHBIdx(val) 	 { phb_idx = val; }
function getPHBIdx()    	 { return phb_idx; }

function setPHBGroups(grps)  { phb_groups = grps; }
function getPHBGroups()      { return phb_groups; }

function setPHBGrpIds(gIds)  { phb_groupIds = gIds; }
function getPHBGrpIds()      { return phb_groupIds; }

function setPHBIsModify(val) { phb_isModify = val; }
function getPHBIsModify()    { return phb_isModify; }

function createDialog(title, flag, infos, dw, dh, dLine, filename) {
	gFlag  		  = flag;
	dialogWidth   = dw;
	dialogHeight  = dh;
	gSipLineNum   = dLine;
	
	if (gFlag == WEBDIAL) {
		buildFactory(title);

		var dialNum = document.getElementById("num");
		var lines   = document.getElementsByName("lineGrp");
		
		dialNum.focus();
		dialNum.select();
		
		if (infos.callNum) 		 dialNum.value = infos.callNum; 
		for (var i=0; i<lines.length; i++) {
			lines[i].checked = false;
			if (!infos.callLine) {
				lines[0].checked = true;
			} else if ((i + 1) == infos.callLine) {
				lines[i].checked = true;
			}
		}
	} else if (gFlag == CTCDIALOG) {
		setPHBIsModify(false);
		setPHBGroups(infos.grps);
		setPHBGrpIds(infos.grpIds);
		if (infos.cId) {
			setPHBIdx(infos.cId);
			setPHBIsModify(true);
		}

		buildFactory(title);
		
		var ctcName = document.getElementById("addContact_Name");
		ctcName.value = infos.cName;
		ctcName.focus();
		ctcName.select();
		document.getElementById("addContact_Tel1").value = infos.tel1;
		document.getElementById("addContact_Tel2").value = infos.tel2;
		document.getElementById("addContact_Tel3").value = infos.tel3;
		
		var obj = document.getElementById("addContact_Ring");
		for(i=0;i<obj.length;i++){
			if(obj[i].value == infos.ring)
			obj[i].selected = true;
		}

		if (infos.selGrp) {
			var selGrp  = infos.selGrp.split(",");
			var grpList = document.getElementsByName("grpboxs");
			
			for (var i=0; i<grpList.length; i++) {
				for (var j=0; j<selGrp.length; j++) {
					if (grpList[i].value == selGrp[j]) grpList[i].checked = true;
				}
			}
		}
	} else {
		buildFactory(title,filename);
		switch(gFlag) {
			case ADDGROUP:
				document.getElementById("addGroup_Name").focus();
				break;
			case ADDBLACKLIST:
				document.getElementById("addBlackList_Num").focus();
				break;
			case OUTCALLLIMIT:
				document.getElementById("outgoing_number").focus();
				break;
			case IMGCORRUPT:
				document.getElementById("btnOK").style.display = "none";
				break;
		}
	}
	
	document.onkeyup = keyUpEvent;
	translate();
}

//=====================dialog build===============================
function buildFactory(title, filename) {
	var frame   = createFrame();
	var bg      = createFrameBG();
	var content = createContent(filename);
	var head    = createHead(title);
	var buts    = createButton();
	var dialog  = document.createElement("div");

	dialog.style.width           = dialogWidth  + "px";
	dialog.style.height          = dialogHeight + "px";
	dialog.style.backgroundColor = "#EEF6F8";
	dialog.style.border          = "1px solid #000";
	dialog.style.boxShadow       = "0 0 2px #f00";
	dialog.style.zIndex     	 = "999";
	dialog.style.position		 = "fixed";
	dialog.style.marginLeft 	 = "40%";
	dialog.style.marginTop  	 = "140px";
	dialog.setAttribute("class","upbox");
	
	dialog.appendChild(head);
	dialog.appendChild(content);
	dialog.appendChild(buts);
	
	frame.appendChild(dialog);
	document.body.appendChild(frame);
	document.body.appendChild(bg);

	unShowFrame();
}

function createFrame() {
	var frame = document.createElement("div");
	
	frame.setAttribute("id", "dFrame");
	frame.style.width    = document.body.clientWidth  + "px";
	frame.style.height   = document.body.clientHeight + 150 + "px";
	frame.style.margin   = "0 auto";
	frame.style.top      = "0px";
	frame.style.left     = "0px";
	frame.style.position = "absolute";
	frame.style.zIndex   = "200";
	frame.style.overflow = "hidden";
	
	return frame;
}

function createFrameBG() {
	var bg = document.createElement("div");
	
	bg.setAttribute("id", "dBg");
	bg.style.width  		 = document.body.clientWidth  + "px";
	bg.style.height 		 = document.body.clientHeight + 150 + "px";
	bg.style.margin 		 = "0 auto";
	bg.style.top 			 = "0px";
	bg.style.left 			 = "0px";
	bg.style.position 	 	 = "absolute";
	bg.style.backgroundColor = "#EEF6F8";
	bg.style.zIndex 		 = "100";
	bg.style.filter 		 = "alpha(opacity=60)";
	bg.style.opacity 		 = 0.6;
	
	return bg;
}

function createHead(title) {
	var head = document.createElement("h1");
	
	head.style.margin     = "0 auto";
	head.style.width 	  = dialogWidth  + "px";
	head.style.height 	  = "30px";
	head.style.paddingTop = "5px";
	head.style.textAlign  = "center";
	head.style.background = "#dcdcdc";
	head.style.color      = "#f00";
	head.style.fontSize   = "16px";
	head.innerHTML        = title;
	
	return head;
}

function createButton() {
	var buts = document.createElement("div");
	
	buts.style.width      = (dialogWidth - 20) + "px";
	buts.style.height     = "30px";
	buts.style.marginTop  = "10px";
	buts.style.marginLeft = "10px";
	buts.setAttribute("class","btn_wrap");
	buts.innerHTML = "<div style='float:right; width:200px;' class='box_btn'>"
				   + "	<input type='button' id='btnOK' lang='XSTR_LBL_GEN_OK' value='OK' style='float:left; width:80px;' onclick='clickListener()'/>"
				   + "	<input type='button' lang='XSTR_LBL_GEN_CANCEL' value='Cancel' style='float:right; margin-right:20px; width:80px;' onclick='hiddenDialog()'/>"
				   + "</div>";
	
	return buts;	
}

function createContent(filename) {
	var content    = document.createElement("div");
	var contentTxt = "";
	
	switch(gFlag) {
		case WEBDIAL:
			contentTxt = "<div style='width:100%; text-align:center;'>"
					   + "	<span id='XSTR_LBL_GEN_NUMBER'>Number</span>:"
					   + "	<input type='text' id='num' style='width:120px; text-align:center;'/>"
					   + "</div>";
			for (var i=1; i<=gSipLineNum; i++) {
				contentTxt += "<br/>"
						   + "<div style='width:100%; text-align:center;'>"
						   + "	<input type='radio' id='line" + i + "' name='lineGrp' value='" + i + "'/>"
						   + "	<span>L" + i + "</span>"
						   + "</div>"
			}
			break;
		case REBOOT:
			contentTxt = "<div style='width:100%; text-align:center;'>"
					   + "	<span id='XSTR_MSG_REBOOT_CFM'>Do you want to reboot ?</span>"
					   + "</div>";
			break;
		case IMGCORRUPT:
			contentTxt = "<div style='width:100%; text-align:center;'>"
					   + "	<span id='XSTR_MSG_IMG_CORRUPT'>Image Corrupt! Please upgrade a new software before next operation.</span>"
					   + "</div>";
			break;
		case CLEARCONF:	
			contentTxt = "<div style='width:100%; text-align:left; font-size:14px;'>"
					   + "	<span id='XSTR_MSG_FACTORY_RST'>This factory data reset will erase all data from your phone's internal storage,including: accounts settings, call history and contacts. Continue?</span>"
					   + "</div>";
			break;
		case CTCDIALOG:
			contentTxt = "<div style='width:100%; text-align:center;'>"
					   + "	<table style='margin-left:30px;'>"
					   + "		<tr>"
					   + "			<td align='right' colspan='1' style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_GEN_NAME'>Name</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   
					   + "				<input type='text' id='addContact_Name' style='width:120px; text-align:center; margin-left:15px;'/>"
					   + "			</td>"
					   + "		</tr>"
					   + "		<tr>"
					   + "			<td style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_PB_PHONE'>Tel 1</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + "				<input type='text' id='addContact_Tel1' style='width:120px; text-align:center; margin-left:15px;'/>"
					   + "			</td>"
					   + "		</tr>"
					   + "		<tr>"
					   + "			<td style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_PB_PHONE2'>Tel 2</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + "				<input type='text' id='addContact_Tel2' style='width:120px; text-align:center; margin-left:15px;'/>"
					   + "			</td>"
					   + "		</tr>"
					   + "		<tr>"
					   + "			<td style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_PB_PHONE3'>Tel 3</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + "				<input type='text' id='addContact_Tel3' style='width:120px; text-align:center; margin-left:15px;'/>"
					   + "			</td>"
					   + "		</tr>"
					   + "		<tr>"
					   + "			<td style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_GEN_RING'>Ring</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + '				<select id="addContact_Ring" style="width:125px; margin-left:15px;">'
					   + '					<option id="XSTR_LBL_RING_DEFALUT" value="0">Default</option><option id="XSTR_LBL_RING_T1" value="1">Type 1</option>'
					   + '					<option id="XSTR_LBL_RING_T2" value="2">Type 2</option><option id="XSTR_LBL_RING_T3" value="3">Type 3</option>'
					   + '					<option id="XSTR_LBL_RING_T4" value="4">Type 4</option><option id="XSTR_LBL_RING_T5" value="5">Type 5</option>'
					   + '					<option id="XSTR_LBL_RING_T6" value="6">Type 6</option><option id="XSTR_LBL_RING_T7" value="7">Type 7</option>'
					   + '					<option id="XSTR_LBL_RING_T8" value="8">Type 8</option><option id="XSTR_LBL_RING_T9" value="9">Type 9</option>'
					   + '                  <option id="XSTR_LBL_RING_M1" value="101">Music 1</option>'
					   + '				</select>'
					   + "			</td>"
					   + "		</tr>"
					   + "		<tr style='height:70px;'>"
					   + "			<td style='text-align:right;' class='width50'>"
					   + "				<span style='margin-top:0px;' id='XSTR_LBL_GROUP'>group</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + "				<div style='border:1 solid #000; width:130px; max-height:75px; overflow:auto; margin-left:15px; background-color:#ffffff;'>"
					   + 					getGrpsStr()
					   + "				</div>"
					   + "			</td>"
					   + "		</tr>"
					   + "	</table>"
					   + "</div>";
			break;
		case ADDBLACKLIST:
			contentTxt = "<div style='width:100%; text-align:center;'>"
					   + "	<table>"
					   + "		<tr>"
					   + "			<td align='right' style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_GEN_CID'>Caller ID</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + "				<input type='text' id='addBlackList_Num' style='width:120px; text-align:center; margin-left:15px;'/>"
					   + "			</td>"
					   + "		</tr>"
					   + "		<tr>"
					   + "			<td style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_GEN_TYPE'>Type</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + "				<select id='addBlackList_Type' style='width:125px; margin-left:15px;'>"
					   + "					<option id='XSTR_LBL_GEN_NUMBER' value='0'>Number</option>"
					   + "					<option id='XSTR_LBL_GEN_PREFIX' value='1'>Prefix</option>"
					   + "				</select>"
					   + "			</td>"
					   + "		</tr>"
					   + "		<tr>"
					   + "			<td style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_GEN_BOL'>Block on Line</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + "				<select id='addBlackList_Line' style='width:125px; margin-left:15px;'>"
					   + "					<option value='0'>Auto</option>"
					   for (var i=1; i<=gSipLineNum; i++) 
						{
							contentTxt += "<br/>"
									   + "	<option value='" + i + "'>SIP" + i + "</option>"
						}
					   + "				</select>"
					   + "			</td>"
					   + "		</tr>"
					   + "	</table>"
					   + "</div>";
			break;
		case ADDGROUP:
			contentTxt = "<div style='width:100%; text-align:center;'>"
					   + "	<table>"
					   + "		<tr>"
					   + "			<td style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_GEN_GRP_NAME'>New Group Name</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + "				<input type='text' id='addGroup_Name' style='width:110px; text-align:center; margin-left:10px;'/>"
					   + "			</td>"
					   + "		</tr>"
					   + "		<tr>"
					   + "			<td style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_RING_TYPE'>Ring Type</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + '				<select id="addGroup_Ring" style="width:110px;text-align:center; margin-left:10px;">'
					   + '					<option id="XSTR_LBL_RING_DEFALUT" value="0">Default</option><option id="XSTR_LBL_RING_T1" value="1">Type 1</option>'
					   + '					<option id="XSTR_LBL_RING_T2" value="2">Type 2</option><option id="XSTR_LBL_RING_T3" value="3">Type 3</option>'
					   + '					<option id="XSTR_LBL_RING_T4" value="4">Type 4</option><option id="XSTR_LBL_RING_T5" value="5">Type 5</option>'
					   + '					<option id="XSTR_LBL_RING_T6" value="6">Type 6</option><option id="XSTR_LBL_RING_T7" value="7">Type 7</option>'
					   + '					<option id="XSTR_LBL_RING_T8" value="8">Type 8</option><option id="XSTR_LBL_RING_T9" value="9">Type 9</option>'
					   + '                  <option id="XSTR_LBL_RING_M1" value="101">Music 1</option>'
					   + '				</select>'
					   + "			</td>"
					   + "		</tr>"
					   + "	</table>"
					   + "</div>";
			break;
		case OUTCALLLIMIT:
			contentTxt = "<div style='width:100%; text-align:center;'>"
					   + "	<table>"
					   + "		<tr>"
					   + "			<td align='right' style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_GEN_CID'>Caller ID</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + "				<input type='text' id='outgoing_number' style='width:120px; text-align:center; margin-left:15px;'/>"
					   + "			</td>"
					   + "		</tr>"
					   + "		<tr>"
					   + "			<td style='text-align:right;' class='width50'>"
					   + "				<span id='XSTR_LBL_GEN_TYPE'>Type</span>:"
					   + "			</td>"
					   + "			<td class='width50'>"
					   + "				<select id='outgoing_type' style='width:125px; margin-left:15px;'>"
					   + "					<option id='XSTR_LBL_GEN_NUMBER' value='0'>Number</option>"
					   + "					<option id='XSTR_LBL_GEN_PREFIX' value='1'>Prefix</option>"
					   + "				</select>"
					   + "			</td>"
					   + "		</tr>"
					   + "	</table>"
					   + "</div>";
			break;
		case WARN:
		    contentTxt = "<div style='width:100%; text-align:center;'>"
    				   + "<span id='XSTR_LBL_UPDATE_CERT_WARNING'>Please select </span>"+ filename+"!"
    				   + "</div>";
		    break;
		case SECURITY:
			contentTxt = "<div style='width:100%; text-align:center;'>"
					   + "<span id='XSTR_LBL_UPDATE_CLIENT_ERROR_HEAD'>The selected file is </span>"+ filename +"<span id='XSTR_LBL_UPDATE_CLIENT_WARN_TAIL'> Certificate,Are you sure Upgrade?</span>"
					   + "</div>";
			break;
		case UPGRADE:
    			contentTxt = "<div style='width:100%; text-align:center;'>"
    					   + "	<span id='XSTR_LBL_UPDATE_NEWVERSION'>Do you want to upgrade to the new version?</span>"
    					   + "</div>";
    		break;
		case CLIENT_CERT:
		    	contentTxt = "<div style='width:100%; text-align:center;'>"
						   + "	<span id='XSTR_LBL_UPDATE_CLIENT_ERROR_HEAD'>The selected file is </span>"+ filename +"<span id='XSTR_LBL_UPDATE_CLIENT_ERROR_TAIL'> Certificate,Please choose other file and try again!</span>"
						   + "</div>";
            break;
		case BMP_WARN:
		    	contentTxt = "<div style='width:100%; text-align:center;'>"
						   + "	<span id='XSTR_LBL_UPDATE_CLIENT_ERROR_HEAD'>The selected file is </span>"+ filename +"<span id='XSTR_LBL_UPDATE_BMP_ERROR_TAIL'> file,Please choose other file(bmp,.tar.gz) and try again!</span>"
						   + "</div>";
            break;
		case AUTO_PROVISION:
         	    contentTxt = "<div style='width:100%; text-align:center;'>"
               			   + "  <span id=''>Do you want to auto provision now?</span>"
                		   + "</div>";
            break;
	}
	
	content.style.width      = (dialogWidth  - 20) + "px";
	content.style.height 	 = (dialogHeight - 90) + "px";
	content.style.marginLeft = "10px";
	content.style.marginTop  = "10px";
	content.innerHTML 		 = contentTxt;
	content.setAttribute("class","box_con");
	
	return content;
}

function hiddenDialog() {
	document.body.removeChild(document.getElementById("dFrame"));
	document.body.removeChild(document.getElementById("dBg"));
	ShowFrame();
}

function getGrpsStr() {
	var grpArr = getPHBGroups().split(",");
	var gIdArr = getPHBGrpIds().split(",");
	var strs   = "";
	
	for (var i=0; i<grpArr.length; i++) {  
		if (grpArr[i]) {
			strs += "<div >"
				 + "	<div style='margin-left:1px; margin-right:1px; background-color:white; text-align:left;'>"
				 + "		<input type='checkbox' name='grpboxs' value='" + grpArr[i] + "' class='"+gIdArr[i]+"'/>"
				 + "		<label>" + grpArr[i] + "</label>"
				 + "	</div>"
				 + "</div>";
		}
	}  
	return strs;
}
//=====================end of dialog build========================

//=====================keyboard event=============================
function keyUpEvent() {
	if (13 == event.keyCode) {	/* Key: Enter */
		switch (gFlag) {
			case WEBDIAL:
				webcall();
				break;
			case REBOOT:
				document.getElementById("DefaultReboot").click();
				break;
			case CLEARCONF:
				document.getElementById("DefaultClear").click();
				break;
			case CTCDIALOG:
				addNewContacts();
				break;
			case ADDBLACKLIST:
				AddToBlackList();
				break;
			case ADDGROUP:
				AddNewGroup();
				break;
			case UPGRADE:
				document.getElementById("WebUpdate").click();
				break;
		}
		ShowFrame();
	} else if (27 == event.keyCode) {	/* Key: ESC */
		hiddenDialog();
	} else if (38 == event.keyCode) {	/* Key: Up */
		if (WEBDIAL == gFlag) lineChange(-2);
		
	} else if (40 == event.keyCode) { 	/*  Key: Down */
		if (WEBDIAL == gFlag) lineChange(0);
	}
}

function lineChange(num) {
	var objs = document.getElementsByName("lineGrp");
	var len  = objs.length;
	var next = 0;
	
	for (var i=0; i<len; i++) {
		if (objs[i].checked) {
			if ((num == 0 && i == len-1) || (num < 0 && i == 0)) next = i;
			else 												 next = parseInt(objs[i].value) + num;
			continue;
		}
	}
	for (var j=0; j<len; j++) {
		objs[j].checked = false;
		if (j == next) objs[j].checked = true;
	}
}
//=====================end of keyboard event======================

function clickListener() {
	switch (gFlag) {
		case WEBDIAL:
			webcall();
			break;
		case REBOOT:
			document.getElementById("DefaultReboot").click();
			break;
		case CLEARCONF:
			document.getElementById("DefaultClear").click();
			break;
		case CTCDIALOG:
			addNewContacts();
			break;
		case ADDBLACKLIST:
			AddToBlackList();
			break;
		case ADDGROUP:
			AddNewGroup();
			break;
		case OUTCALLLIMIT:
			AddRestricteOutgoingCall();
			break;
		case WARN:
			hiddenDialog();
			break;
		case SECURITY:
			hiddenDialog();
			break;
		case UPGRADE:
			document.getElementById("WebUpdate").click();
			break;
		case CLIENT_CERT:
			hiddenDialog();
			break;
		case BMP_WARN:
			hiddenDialog();
			break;
		case AUTO_PROVISION:
			autoProvisionNow();
     		break;
	}
	ShowFrame();
}

function AddRestricteOutgoingCall()
{
	var form = document.createElement("form");
	form.method = "post";
	form.action = "";
	document.body.appendChild(form);
	
	var inp_Name = document.createElement("input");
	var number = document.getElementById("outgoing_number").value; 
	if(document.getElementById("outgoing_type").value == 1)
		number += ".";
	inp_Name.type = "hidden";
	inp_Name.name = "CSE_LimitPhone";
	inp_Name.value = number;
	form.appendChild(inp_Name);
	
	var inp_page = document.createElement("input");
	inp_page.type = "hidden";
	inp_page.name = "ReturnPage";
	inp_page.value = location.pathname.replace(/(.+)[\\/]/,"");
	form.appendChild(inp_page);
	
	var inp_Submit = document.createElement("input");
	inp_Submit.type = "submit";
	inp_Submit.name = "DefaultAdd";
	inp_Submit.value = "Add";
	form.appendChild(inp_Submit);
	
	inp_Submit.click();
}

function AddNewGroup()
{
	var form = document.createElement("form");
	form.method = "post";
	form.action = "";
	document.body.appendChild(form);
	
	var inp_Name = document.createElement("input");
	inp_Name.type = "hidden";
	inp_Name.name = "PHB_NewGroupName";
	inp_Name.value = document.getElementById("addGroup_Name").value;
	form.appendChild(inp_Name);
	
	var inp_Ring = document.createElement("input");
	inp_Ring.type = "hidden";
	inp_Ring.name = "PHB_GroupRing_RW";
	inp_Ring.value = document.getElementById("addGroup_Ring").value;
	form.appendChild(inp_Ring);

	var inp_page = document.createElement("input");
	inp_page.type = "hidden";
	inp_page.name = "ReturnPage";
	inp_page.value = location.pathname.replace(/(.+)[\\/]/,"");
	form.appendChild(inp_page);
	
	var inp_Submit = document.createElement("input");
	inp_Submit.type = "submit";
	inp_Submit.name = "DefaultAdd";
	inp_Submit.value = "Add";
	form.appendChild(inp_Submit);
	
	inp_Submit.click();
}

function AddToBlackList()
{
	var form = document.createElement("form");
	form.method = "post";
	form.action = "";
	document.body.appendChild(form);
	
	var inp_Num = document.createElement("input");
	inp_Num.type = "hidden";
	inp_Num.name = "CSE_BlackPhone";
	inp_Num.value = document.getElementById("addBlackList_Num").value;
	form.appendChild(inp_Num);
	
	var inp_Type = document.createElement("input");
	inp_Type.type = "hidden";
	inp_Type.name = "CSE_BlackPhone_Type";
	inp_Type.value = document.getElementById("addBlackList_Type").value;
	form.appendChild(inp_Type);
	
	var inp_Line = document.createElement("input");
	inp_Line.type = "hidden";
	inp_Line.name = "CSE_BlackPhoneLine_RW";
	inp_Line.value = document.getElementById("addBlackList_Line").value;
	form.appendChild(inp_Line);
	
	var inp_page = document.createElement("input");
	inp_page.type = "hidden";
	inp_page.name = "ReturnPage";
	inp_page.value = location.pathname.replace(/(.+)[\\/]/,"");
	form.appendChild(inp_page);
	
	var inp_Submit = document.createElement("input");
	inp_Submit.type = "submit";
	inp_Submit.name = "DefaultAdd";
	inp_Submit.value = "Add";
	form.appendChild(inp_Submit);
	
	inp_Submit.click();
}

function addNewContacts()
{
	var name = document.getElementById("addContact_Name").value;
	var tel1 = document.getElementById("addContact_Tel1").value;
	var tel2 = document.getElementById("addContact_Tel2").value;
	var tel3 = document.getElementById("addContact_Tel3").value;
	var ring = document.getElementById("addContact_Ring").value;
	var grps = "";
	var boxs = document.getElementsByName("grpboxs");
	var len = boxs.length;
	
	for(var i=0; i<len; i++)
	{
		if(boxs[i].checked)
		{
			if(grps.length > 0)	grps += ",";
			grps += boxs[i].className;
		}
	}
	
	var form = document.createElement("form");
	form.method = "post";
	form.action = "";
	document.body.appendChild(form);
	
	var inp_Name = document.createElement("input");
	inp_Name.type = "hidden";
	inp_Name.name = "PHB_Name";
	inp_Name.value = name;
	form.appendChild(inp_Name);
	
	var inp_Num = document.createElement("input");
	inp_Num.type = "hidden";
	inp_Num.name = "PHB_Num";
	inp_Num.value = tel1;
	form.appendChild(inp_Num);
	
	var inp_Mob = document.createElement("input");
	inp_Mob.type = "hidden";
	inp_Mob.name = "PHB_Mobile";
	inp_Mob.value = tel2;
	form.appendChild(inp_Mob);
	
	var inp_Oth = document.createElement("input");
	inp_Oth.type = "hidden";
	inp_Oth.name = "PHB_Other";
	inp_Oth.value = tel3;
	form.appendChild(inp_Oth);
	
	var inp_Ring = document.createElement("input");
	inp_Ring.type = "hidden";
	inp_Ring.name = "PHB_Ring_RW";
	inp_Ring.value = ring;
	form.appendChild(inp_Ring);
	
	var inp_Grp = document.createElement("input");
	inp_Grp.type = "hidden";
	inp_Grp.name = "PHB_SelectGroup_Sets";
	inp_Grp.value = grps;
	form.appendChild(inp_Grp);
	
	var inp_page = document.createElement("input");
	inp_page.type = "hidden";
	inp_page.name = "ReturnPage";
	inp_page.value = location.pathname.replace(/(.+)[\\/]/,"");
	form.appendChild(inp_page);
	
	var inp_submit = document.createElement("input");
	inp_submit.type = "submit";
	if(getPHBIsModify())
	{
		var inp_idx = document.createElement("input");
		inp_idx.type = "hidden";
		inp_idx.name = "PHB_Id";
		inp_idx.value = getPHBIdx();
		form.appendChild(inp_idx);
	
		inp_submit.name = "DefaultModify";
		inp_submit.value = "Modify";
	}
	else 
	{
		inp_submit.name = "DefaultAdd";
		inp_submit.value = "Add";
	}
	form.appendChild(inp_submit);
	inp_submit.click();
}

function autoProvisionNow()
{
    var form = document.createElement("form");
  form.method = "post";
  form.action = "";
  document.body.appendChild(form);
    
  var inp_Submit = document.createElement("input");
  inp_Submit.type = "submit";
  inp_Submit.name = "autoProvisionNow";
  inp_Submit.value = "autopNow";
  inp_Submit.style.opacity="0.1";
  form.appendChild(inp_Submit);
  
  inp_Submit.click();
}

function webcall()
{
	var form = document.createElement("form");
	form.method = "post";
	form.action = "";
	document.body.appendChild(form);
	
	var inp_num = document.createElement("input");
	inp_num.type = "hidden";
	inp_num.name = "PHB_AutoDialNumber";
	inp_num.value = document.getElementById("num").value;
	form.appendChild(inp_num);
	
	var inp_page = document.createElement("input");
	inp_page.type = "hidden";
	inp_page.name = "ReturnPage";
	inp_page.value = location.pathname.replace(/(.+)[\\/]/,"");
	form.appendChild(inp_page);
	
	var inp_submit = document.createElement("input");
	inp_submit.type = "submit";
	inp_submit.name = "AutoDialSubmit";
	inp_submit.value = "submit";
	form.appendChild(inp_submit);
	
	var inp_line = document.createElement("input");
	var line = "1";
	inp_line.type = "hidden";
	inp_line.name = "PHB_AutoDialLine";
	var objs = document.getElementsByName("lineGrp");
	var len = objs.length;
	for(var i=0; i<len; i++){
		if(objs[i].checked)
		{
			line = objs[i].value;
			continue;
		}
	}
	inp_line.value = line;
	form.appendChild(inp_line);
	inp_submit.click();
	ShowFrame();
}

