#!/bin/bash

# ver. 5.7
cfg_open()
{
  cfg_file=$1
  rm -f ${cfg_file}.head
  rm -f ${cfg_file}.tail
  touch ${cfg_file}.head
  touch ${cfg_file}.tail
}

cfg_write_header()
{
  echo $* >> ${cfg_file}.head
}

cfg_write()
{
  echo $* >> ${cfg_file}.tail
}

cfg_close()
{
  cat ${cfg_file}.head ${cfg_file}.tail > ${cfg_file}
  rm ${cfg_file}.head
  rm ${cfg_file}.tail
}

cfg_uio()
{
    switch=$1
    uio=$1

    cfg_write api.platform.config.switch.${switch}.uioDevName text /dev/uio${uio}
}

#=============================================================================#
# Ethernet mode for the the given switch port
# Optional configuration. Default is DISABLED or specified by port.default.
#
# EPL ports defaulted to 10G
# FIXME: need to lookup partnum for SR vs LR etc
cfg_ethernetMode()
{
    switch=$1
    nic_type=$2

    if [ "$nic_type" = "4x10g" ]; then      
	cfg_write api.platform.config.switch.${switch}.port.default.ethernetMode text DISABLED
#==========David: why only 10g in this one? ============ FIXME

	cfg_write api.platform.config.switch.${switch}.portIndex.1.ethernetMode text 10GBase-SR
	cfg_write api.platform.config.switch.${switch}.portIndex.2.ethernetMode text 10GBase-SR
	cfg_write api.platform.config.switch.${switch}.portIndex.3.ethernetMode text 10GBase-SR
	cfg_write api.platform.config.switch.${switch}.portIndex.4.ethernetMode text 10GBase-SR
	
    elif [ "$nic_type" = "4x10gt" ]; then

	cfg_write api.platform.config.switch.${switch}.portIndex.1.ethernetMode text AN-73
	cfg_write api.platform.config.switch.${switch}.portIndex.2.ethernetMode text AN-73
	cfg_write api.platform.config.switch.${switch}.portIndex.3.ethernetMode text AN-73
	cfg_write api.platform.config.switch.${switch}.portIndex.4.ethernetMode text AN-73
        
    elif [ "$nic_type" = "2x100gb" ]; then

        cfg_write api.platform.config.switch.${switch}.portIndex.1.ethernetMode text 100GBASE-SR4
        cfg_write api.platform.config.switch.${switch}.portIndex.2.ethernetMode text 100GBASE-SR4
        
    elif [ "$nic_type" = "2x100g" ]; then

        cfg_write api.platform.config.switch.${switch}.portIndex.1.ethernetMode text AUTODETECT
        cfg_write api.platform.config.switch.${switch}.portIndex.2.ethernetMode text AUTODETECT
        
    elif [ "$nic_type" = "2x100gl" ]; then

        cfg_write api.platform.config.switch.${switch}.portIndex.1.ethernetMode text AUTODETECT
        cfg_write api.platform.config.switch.${switch}.portIndex.2.ethernetMode text AUTODETECT
        
    elif [ "$nic_type" = "2x100gm" ]; then

        cfg_write api.platform.config.switch.${switch}.portIndex.1.ethernetMode text AUTODETECT
        cfg_write api.platform.config.switch.${switch}.portIndex.2.ethernetMode text AUTODETECT
        
    elif [ "$nic_type" = "2x100g8" ]; then

        cfg_write api.platform.config.switch.${switch}.portIndex.1.ethernetMode text AUTODETECT
        cfg_write api.platform.config.switch.${switch}.portIndex.2.ethernetMode text AUTODETECT
        
    elif [ "$nic_type" = "2x25g" ]; then

        cfg_write api.platform.config.switch.${switch}.portIndex.1.ethernetMode text 25GBase-SR
        cfg_write api.platform.config.switch.${switch}.portIndex.2.ethernetMode text 25GBase-SR        
        
    elif [ "$nic_type" = "2x40g" ]; then
	cfg_write api.platform.config.switch.${switch}.portIndex.1.ethernetMode text 40GBASE-SR4
	cfg_write api.platform.config.switch.${switch}.portIndex.2.ethernetMode text 40GBASE-SR4
    fi
}

cfg_hwResource_4x10g()
{
    ((hwResourceId=FM10K_hwResourceId_base))
    ((pcaMux=FM10K_pcaMux_base+2))
    ((pcaIo_0=FM10K_pcaIo_base+0))
    ((pcaIo_1=FM10K_pcaIo_base+1))

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text SFPP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  1

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int  ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  0
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modAbs.pin     int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.rxLos.pin      int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txDisable.pin  int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txFault.pin    int  3

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int  ${pcaIo_1}

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.pin         int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.usage       text LINK,TRAFFIC,1G,10G

    ((hwResourceId++))
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text SFPP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  0x2

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int  ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  8
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modAbs.pin     int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.rxLos.pin      int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txDisable.pin  int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txFault.pin    int  3    

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int  ${pcaIo_1}

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.pin         int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.usage       text LINK,TRAFFIC,1G,10G

    ((hwResourceId++))
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text SFPP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  0x4

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int  ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  16
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modAbs.pin     int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.rxLos.pin      int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txDisable.pin  int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txFault.pin    int  3


    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int  ${pcaIo_1}

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.pin         int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.usage       text LINK,TRAFFIC,1G,10G

    ((hwResourceId++))
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text SFPP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  0x8

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int  ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  24
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modAbs.pin     int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.rxLos.pin      int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txDisable.pin  int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txFault.pin    int  3


    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int  ${pcaIo_1}

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.pin         int  6
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.usage       text LINK,TRAFFIC,1G,10G

}

cfg_hwResource_2x40g()
{
    ((hwResourceId=FM10K_hwResourceId_base))
    ((pcaMux=FM10K_pcaMux_base+1))
    ((pcaIo_0=FM10K_pcaIo_base+0))
    ((pcaIo_1=FM10K_pcaIo_base+1))

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  0x4

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  0
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    #cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  0     

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int ${pcaIo_1}

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.pin         int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.usage       text LINK,TRAFFIC,40G,100G

    ((hwResourceId++))
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  0x8

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  8
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    #cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  0     

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int ${pcaIo_1}

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.pin         int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.usage       text LINK,TRAFFIC,40G,100G
}

cfg_hwResource_2x100gb()
{
    ((hwResourceId=FM10K_hwResourceId_base))
    ((pcaMux=FM10K_pcaMux_base+1))
    ((pcaIo_0=FM10K_pcaIo_base+0))
    ((pcaIo_1=FM10K_pcaIo_base+1))

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  0x4

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  0
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    #cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  0    

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int ${pcaIo_1}

   
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin         int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage       text LINK,TRAFFIC,40G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin         int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage       text LINK,TRAFFIC,100G    

    ((hwResourceId++))
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  0x8

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  8
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    #cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  0    

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int ${pcaIo_1}

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin         int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage       text LINK,TRAFFIC,40G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin         int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage       text LINK,TRAFFIC,100G
    
}

cfg_hwResource_2x100g()
{
    ((hwResourceId=FM10K_hwResourceId_base))
    ((pcaMux=FM10K_pcaMux_base+0))
    ((pcaIo_0=FM10K_pcaIo_base+0))
    ((pcaIo_1=FM10K_pcaIo_base+1))
    ((pcaIo_2=FM10K_pcaIo_base+2))

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  2

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  0
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  0    

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int ${pcaIo_1}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin         int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin         int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage       text LINK,TRAFFIC,25G
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.pin         int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.usage       text LINK,TRAFFIC,40G
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.pin         int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.usage       text LINK,TRAFFIC,100G
    
     
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.pcaIo.index         int ${pcaIo_1}
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.pin         int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.pin         int  5
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.usage       text LINK,TRAFFIC,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.pcaIo.index         int  ${pcaIo_1}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.pin         int  6
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.pin         int  7
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.usage       text LINK,TRAFFIC,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.pcaIo.index         int  ${pcaIo_1}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.pin         int  8
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.pin         int  9
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.usage       text LINK,TRAFFIC,25G       
    
    
       

    ((hwResourceId++))
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  0x04

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int  ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  8
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  0    

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int  ${pcaIo_2}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin         int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin         int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage       text LINK,TRAFFIC,25G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.pin         int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.usage       text LINK,TRAFFIC,40G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.pin         int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.usage       text LINK,TRAFFIC,100G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.pcaIo.index         int  ${pcaIo_2}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.pin         int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.pin         int  5
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.usage       text LINK,TRAFFIC,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.pcaIo.index         int  ${pcaIo_2}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.pin         int  6
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.pin         int  7
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.usage       text LINK,TRAFFIC,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.pcaIo.index         int  ${pcaIo_2}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.pin         int  8
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.pin         int  9
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.usage       text LINK,TRAFFIC,25G
    
}

cfg_hwResource_2x100gl()
{
    ((hwResourceId=FM10K_hwResourceId_base))
    ((pcaMux=FM10K_pcaMux_base+0))
    ((pcaIo_0=FM10K_pcaIo_base+0))
    ((pcaIo_1=FM10K_pcaIo_base+1))
    ((pcaIo_2=FM10K_pcaIo_base+2))

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  1

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int  ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  0
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  5    



    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int  ${pcaIo_2}


    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin           int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage         text LINK,40G,10G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin           int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage         text LINK,100G,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.pin           int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.usage         text LINK,TRAFFIC,100G,40G,25G,10G
    
    ((hwResourceId++))

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  2

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int  ${pcaIo_1}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  0
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  5     

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int  ${pcaIo_2}

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin           int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage         text LINK,10G,40G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin           int  5
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage         text LINK,100G,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.pin           int  6
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.usage         text LINK,TRAFFIC,100G,40G,25G,10G
    
}


cfg_hwResource_2x100gm()
{
    ((hwResourceId=FM10K_hwResourceId_base))
    ((pcaMux=FM10K_pcaMux_base+0))
    ((pcaIo_0=FM10K_pcaIo_base+0))
    ((pcaIo_1=FM10K_pcaIo_base+1))
    ((pcaIo_2=FM10K_pcaIo_base+2))
    ((pcaIo_3=FM10K_pcaIo_base+3))
    ((pcaIo_4=FM10K_pcaIo_base+4))
    ((pcaIo_5=FM10K_pcaIo_base+5))
    
    
    bus=$1

# zQSFP0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                    text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType               text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index             int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value             int  1

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index            int  ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin          int  0
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  5

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                	text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         	int  ${pcaIo_2}


    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin            int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage          text LINK,10G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin            int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage          text LINK,40G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.pin            int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.usage          text LINK,25G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.pin            int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.usage          text LINK,100G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.type                	text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.pcaIo.index         	int  ${pcaIo_2}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.pin            int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.usage          text LINK,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.pin            int  5
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.usage          text LINK,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.type                	text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.pcaIo.index         	int  ${pcaIo_2}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.pin            int  6
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.usage          text LINK,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.pin            int  7
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.usage          text LINK,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.type                	text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.pcaIo.index         	int  ${pcaIo_4}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.pin            int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.usage          text LINK,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.pin            int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.usage          text LINK,25G

#==================================================================================================================================

# zQSFP1
((hwResourceId++))
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 	text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            	text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          	int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          	int  2

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         	int  ${pcaIo_1}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       	int  0 
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  5

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                	text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         	int  ${pcaIo_5}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin           	int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage          text LINK,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin           	int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage         	text LINK,40G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.pin           	int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.usage          text LINK,25G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.pin           	int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.usage          text LINK,100G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.type                	text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.pcaIo.index         	int  ${pcaIo_5}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.pin            int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.usage          text LINK,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.pin            int  5
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.usage          text LINK,25G


    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.type                	text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.pcaIo.index         	int  ${pcaIo_5}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.pin            int  6
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.usage          text LINK,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.pin            int  7
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.usage          text LINK,25G


    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.type                	text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.pcaIo.index         	int  ${pcaIo_4}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.pin            int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.usage          text LINK,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.pin            int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.usage          text LINK,25G

((hwResourceId++))

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.type                          text VRM
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.busSelType                text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.bus                       int  ${bus}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.model                     text IR
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.addr                      int  0x08
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.pcaMux.index              int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.pcaMux.value              int  0x04
    #api.platform.lib.config.hwResourceId.2.vrm.delta		     int 5

    cfg_write api.platform.config.switch.${bus}.VDDS.hwResourceId int ${hwResourceId}

((hwResourceId++))

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.type                          text VRM
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.busSelType                text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.bus                       int  ${bus}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.model                     text IR
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.addr                      int  0x08
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.pcaMux.index              int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.vrm.pcaMux.value              int  0x04
#api.platform.lib.config.hwResourceId.3.vrm.delta		     int 6
    ((vddf=(1<<8)+(hwResourceId)))
    cfg_write api.platform.config.switch.${bus}.VDDF.hwResourceId int ${vddf}     
    
}

cfg_hwResource_2x100g8()
{
    ((hwResourceId=FM10K_hwResourceId_base))
    ((pcaMux=FM10K_pcaMux_base+0))
    ((pcaIo_0=FM10K_pcaIo_base+0))
    ((pcaIo_1=FM10K_pcaIo_base+1))
    ((pcaIo_2=FM10K_pcaIo_base+2))

# zQSFP0
# zQSFP0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  2

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int  ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  0
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  0
    

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int  ${pcaIo_1}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin         int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G


    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin         int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage       text LINK,TRAFFIC,25G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.pin         int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.usage       text LINK,TRAFFIC,40G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.pin         int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.usage       text LINK,TRAFFIC,100G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.pcaIo.index         int  ${pcaIo_1}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.pin         int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.pin         int  5
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.usage       text LINK,TRAFFIC,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.pcaIo.index         int  ${pcaIo_1}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.pin         int  6
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.pin         int  7
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.usage       text LINK,TRAFFIC,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.pcaIo.index         int  ${pcaIo_1}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.pin         int  8
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.pin         int  9
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.usage       text LINK,TRAFFIC,25G
    
((hwResourceId++))    


# Note: HW resource config for the 2x100G, port-1
# zQSFP1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text QSFP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  0x04

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int  ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  8
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modPrsL.pin       int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.intL.pin          int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.resetL.pin        int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.lpMode.pin        int  0
    

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int  ${pcaIo_2}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin         int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin         int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage       text LINK,TRAFFIC,25G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.pin         int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.usage       text LINK,TRAFFIC,40G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.pin         int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.usage       text LINK,TRAFFIC,100G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.pcaIo.index         int  ${pcaIo_2}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.pin         int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.pin         int  5
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.1.1.pcaIo.usage       text LINK,TRAFFIC,25G


    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.pcaIo.index         int  ${pcaIo_2}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.pin         int  6
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.pin         int  7
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.2.1.pcaIo.usage       text LINK,TRAFFIC,25G


    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.pcaIo.index         int  ${pcaIo_2}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.pin         int  8
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.0.pcaIo.usage       text LINK,TRAFFIC,1G,2.5G,10G
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.pin         int  9
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.3.1.pcaIo.usage       text LINK,TRAFFIC,25G    
}

cfg_hwResource_2x25g()
{
    ((hwResourceId=FM10K_hwResourceId_base))
    ((pcaMux=FM10K_pcaMux_base+0))
    ((pcaIo_0=FM10K_pcaIo_base+0))
    ((pcaIo_1=FM10K_pcaIo_base+1))
    ((pcaIo_2=FM10K_pcaIo_base+2))

# zQSFP0
# zQSFP0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text SFPP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  1

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int  ${pcaIo_0}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  0
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modAbs.pin     int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.rxLos.pin      int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txDisable.pin  int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txFault.pin    int  3    



    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int  ${pcaIo_2}


    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin           int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage         text LINK,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin           int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage         text LINK,10G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.pin           int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.usage         text LINK,1G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.pin           int  3
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.usage         text TRAFFIC
    
((hwResourceId++))    



    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.interfaceType                 text SFPP
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.busSelType            text PCAMUX
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.index          int  ${pcaMux}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrI2C.pcaMux.value          int  0x2

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.index         int  ${pcaIo_1}
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.basePin       int  0
    
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.modAbs.pin     int  0
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.rxLos.pin      int  1
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txDisable.pin  int  2
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.xcvrState.pcaIo.txFault.pin    int  3    

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.type                text PCA
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.pcaIo.index         int  ${pcaIo_2}

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.pin           int  4
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.0.pcaIo.usage         text LINK,25G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.pin           int  5
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.1.pcaIo.usage         text LINK,10G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.pin           int  6
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.2.pcaIo.usage         text LINK,1G

    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.pin           int  7
    cfg_write api.platform.lib.config.hwResourceId.${hwResourceId}.portLed.0.3.pcaIo.usage         text TRAFFIC
}







#=============================================================================#
# Unique 32-bit value associated with a port for the shared library
# If not specified then this value is default to port.default.hwResourceId
#
# Select a hwResourceId per port (zero base)
#
cfg_hwResource()
{
    switch=$1
    nic_type=$2
    
    #echo "$1 $2 $FM10K_hwResourceId_base" 

    port_count=0

    if [ "$nic_type" = "4x10g" ]||[ "$nic_type" = "4x10gt" ]; then 
	port_count=4
    elif [ "$nic_type" = "2x40g" ]||[ "$nic_type" = "2x100gb" ]||[ "$nic_type" = "2x100g" ]||[ "$nic_type" = "2x100gl" ]||[ "$nic_type" = "2x100gm" ]||[ "$nic_type" = "2x100g8" ]||[ "$nic_type" = "2x25g" ]; then 
	port_count=2
    fi

    cfg_pcaMux $switch $nic_type
    cfg_pcaIo $switch $nic_type

    ((id=FM10K_hwResourceId_base))
    for port in $(seq 1 ${port_count}); do
	cfg_write api.platform.config.switch.${switch}.portIndex.${port}.hwResourceId int ${id}
        ((id++))
    done

    if [ "$nic_type" = "4x10g" ]; then
	cfg_hwResource_4x10g
	((FM10K_pcaMux_base+=3))
	((FM10K_pcaIo_base+=2))
	((FM10K_hwResourceId_base+=port_count))
    elif [ "$nic_type" = "2x40g" ]; then 
	cfg_hwResource_2x40g
	((FM10K_pcaMux_base+=2))
	((FM10K_pcaIo_base+=2))
	((FM10K_hwResourceId_base+=port_count))
    elif [ "$nic_type" = "2x100gb" ]; then 
	cfg_hwResource_2x100gb
	((FM10K_pcaMux_base+=2))
	((FM10K_pcaIo_base+=2))
	((FM10K_hwResourceId_base+=port_count))
    elif [ "$nic_type" = "2x100g" ]; then 
	cfg_hwResource_2x100g
	((FM10K_pcaMux_base+=2))
	((FM10K_pcaIo_base+=3))
	((FM10K_hwResourceId_base+=port_count))
    elif [ "$nic_type" = "2x100gl" ]; then 
	cfg_hwResource_2x100gl
	((FM10K_pcaMux_base+=1))
	((FM10K_pcaIo_base+=5))
	((FM10K_hwResourceId_base+=port_count)) 
    elif [ "$nic_type" = "2x100gm" ]; then 
	cfg_hwResource_2x100gm $switch
	((FM10K_pcaMux_base+=1))
	((FM10K_pcaIo_base+=6))
	((FM10K_hwResourceId_base+=port_count))
        ((FM10K_hwResourceId_base+=2))
    elif [ "$nic_type" = "2x100g8" ]; then 
	cfg_hwResource_2x100g8
	((FM10K_pcaMux_base+=2))
	((FM10K_pcaIo_base+=3))
	((FM10K_hwResourceId_base+=port_count))                               
    elif [ "$nic_type" = "4x10gt" ]; then
	((FM10K_pcaMux_base++))
        ((FM10K_hwResourceId_base+=port_count))
    elif [ "$nic_type" = "2x25g" ]; then
	cfg_hwResource_2x25g
	((FM10K_pcaMux_base++))
        ((FM10K_pcaIo_base+=5))
        ((FM10K_hwResourceId_base+=port_count))            
    fi

}

#=============================================================================#
# PCA mux configuration
#
# bus# = switch#
cfg_pcaMux()
{
    bus=$1
    nic_type=$2

    ((pcaMux=FM10K_pcaMux_base))
    
    if [ "$nic_type" = "4x10gt" ]; then    
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x58
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
	((pcaMux++))
    

    elif [ "$nic_type" = "4x10g" ]; then
# MUX 0 - 9541 going to QSFP i2c branch
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9546
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x75
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
	((parent=pcaMux))
	((pcaMux++))

#to the PCA905 (SFPP sideband); 9635 LED driver
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9546
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x71
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.index   int  ${parent}
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.value   int  0x8
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
	((parent=pcaMux))
	((pcaMux++))

# MUX 2 - connected to SFPP's EEPROM
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9546
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x72
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.index   int  ${parent}
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.value   int  0x8
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
        
    elif [ "$nic_type" = "2x100gb" ]; then 
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x70
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
	((parent=pcaMux))
	((pcaMux++))

	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x71
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.index   int  ${parent}
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.value   int  0x8
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
        
    elif [ "$nic_type" = "2x100g" ]; then 
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x70
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
	((parent=pcaMux))
	((pcaMux++))

	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x71
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.index   int  ${parent}
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.value   int  0x8
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
        
    elif [ "$nic_type" = "2x100gl" ]; then
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x58
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
        
    elif [ "$nic_type" = "2x100gm" ]; then
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x58
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
        
    elif [ "$nic_type" = "2x100g8" ]; then
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x70
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
	((parent=pcaMux))
	((pcaMux++))    
        
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x71
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.index   int  ${parent}
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.value   int  0x8
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
        
    elif [ "$nic_type" = "2x25g" ]; then
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x58
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}                           
        

    elif [ "$nic_type" = "2x40g" ]; then 
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x70
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}
	((parent=pcaMux))
	((pcaMux++))

	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.model          text PCA9545
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.addr           int  0x71
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.index   int  ${parent}
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.parent.value   int  0x8
	cfg_write api.platform.lib.config.pcaMux.${pcaMux}.bus            int  ${bus}

    fi
}

cfg_pcaIo()
{
    bus=$1
    nic_type=$2

    ((pcaIo=FM10K_pcaIo_base))

    if [ "$nic_type" = "4x10g" ]; then
	((parent=FM10K_pcaMux_base+1))
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9505
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x25
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  2
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus     int  ${bus}
	((pcaIo++))

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9635
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x15
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  1
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
	((pcaIo++))
        
    elif [ "$nic_type" = "2x100gb" ]; then 
	((parent=FM10K_pcaMux_base))
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9505
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x20
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  0x4
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus     int  ${bus}
	((pcaIo++))

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9635
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x6a
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  0x4
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
	((pcaIo++))
        
    elif [ "$nic_type" = "2x100g" ]; then 
	((parent=FM10K_pcaMux_base))
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9505
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x20
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  0x1
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus     int  ${bus}
	((pcaIo++))

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9635
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x6a
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  0x1
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
	((pcaIo++))
        
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9635
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x69
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  1
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
        ((pcaIo++))  
        
    elif [ "$nic_type" = "2x100gl" ]; then 
	((parent=FM10K_pcaMux_base))
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x60
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    	 int  ${bus}
        ((pcaIo++))
        
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x61
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
        ((pcaIo++))
        
        
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x62
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
        ((pcaIo++))

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x63
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
        ((pcaIo++))

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x64
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int     ${bus}
        ((pcaIo++))
        
    elif [ "$nic_type" = "2x100gm" ]; then 
	((parent=FM10K_pcaMux_base))
# zQSFP Port0 

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus  int ${bus}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr int 0x60
        ((pcaIo++))

# zQSFP Port1 and PCIe Cable Present
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus   int ${bus}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr  int 0x61
        ((pcaIo++))

# LED Speed/Activity for zQSFP0


	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus   int ${bus}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr  int 0x62
        ((pcaIo++))

# GPIO 0-7 RRC 
#api.platform.lib.config.pcaIo.3.model text PCA9538
#api.platform.lib.config.pcaIo.3.bus   int 0
#api.platform.lib.config.pcaIo.3.addr  int 0x63

# CPLD Rev / Power good / Temp Alert / Temp Thermal 
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus   int ${bus}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr  int 0x64
        ((pcaIo++))

# GPIO 9-11 RRC and LED Speed/Activity for zQSFP Ports
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus   int ${bus}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr  int 0x65
        ((pcaIo++))

# LED Speed/Activity for zQSFP1
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus   int ${bus}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr  int 0x66
        ((pcaIo++))
        
    elif [ "$nic_type" = "2x100g8" ]; then 
	((parent=FM10K_pcaMux_base))
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9505
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x20
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  1
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    	int  ${bus}
        ((pcaIo++))

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9635
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x6a
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  1
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
        ((pcaIo++))

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9635
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x69
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  1
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
        ((pcaIo++))
        
    elif [ "$nic_type" = "2x25g" ]; then 
	((parent=FM10K_pcaMux_base))
        
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x60
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    	      int  ${bus}
        ((pcaIo++))        

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x61
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
        ((pcaIo++))        



	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x62
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
        ((pcaIo++))        

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x63
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
        ((pcaIo++))        

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9538
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x64
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
        ((pcaIo++))
    
    elif [ "$nic_type" = "2x40g" ]; then 
	((parent=FM10K_pcaMux_base))
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9505
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x20
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  0x4
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus     int  ${bus}
	((pcaIo++))

	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.model           text PCA9635
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.addr            int  0x6a
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.index    int  ${parent}
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.parent.value    int  0x4
	cfg_write api.platform.lib.config.pcaIo.${pcaIo}.bus    int  ${bus}
	((pcaIo++))
    fi
}

cfg_switch_2x40g()
{
    switch=$1

    # Note: this is for the 2nd product 2x40G, GPIO definition
    cfg_write api.platform.config.switch.${switch}.portIntrGpio int 6
    cfg_write api.platform.config.switch.${switch}.i2cResetGpio int 5

    # this is for the 2x40, has 2 external ports, 2 internal and one CPU port -> 5
    cfg_write api.platform.config.switch.${switch}.numPorts int 5

    cfg_write api.platform.config.switch.${switch}.cpuPort int 4
    cfg_write api.platform.config.switch.${switch}.bootCfg.mgmtPep int 2
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.mode bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.8.enable bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.bar4Allowed bool 1
    
    cfg_write api.platform.config.switch.${switch}.portIndex.0.portMapping text \"LOG=0 PCIE=8\"

# QSFP0
# Note: QSFP Port-0 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.0.portMapping text \"LOG=1 EPL=0 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.1.portMapping text \"LOG=1 EPL=0 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.2.portMapping text \"LOG=1 EPL=0 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.3.portMapping text \"LOG=1 EPL=0 LANE=3\"

# Note: QSFP Port-1 configuration for the 2nd product 2x40G
# QSFP1 (with different lane ordering)
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.0.portMapping text \"LOG=2 EPL=6 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.1.portMapping text \"LOG=2 EPL=6 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.2.portMapping text \"LOG=2 EPL=6 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.3.portMapping text \"LOG=2 EPL=6 LANE=3\"

# Note: PCIe Ports 3,4 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.3.portMapping text \"LOG=3 PCIE=0\"

    cfg_write api.platform.config.switch.${switch}.portIndex.4.portMapping text \"LOG=4 PCIE=2\"

# Note: Port Interface definition for the 2nd 2x40G - QSFP interface
    cfg_write api.platform.config.switch.${switch}.portIndex.1.interfaceType text QSFP_LANE0
    cfg_write api.platform.config.switch.${switch}.portIndex.2.interfaceType text QSFP_LANE0

#=============================================================================#
# The maximum port speed at which the port will be operated. This is used
# to allocate scheduler bandwidth to the ports.
#
# Optional configuration. Default is automatically selected per port type
#   EPL      -> 2.5G
#   PCIE_X1  -> 10G
#   PCIE_X4  -> 50G
#   PCIE_X8  -> 50G
#   TE       -> 100G
#   LOOPBACK -> 25G
#
    cfg_write api.platform.config.switch.${switch}.portIndex.0.speed  int 10000

# QSFP0
    cfg_write api.platform.config.switch.${switch}.portIndex.1.speed  int 100000
    cfg_write api.platform.config.switch.${switch}.portIndex.2.speed  int 100000

#=============================================================================#
# Port capability for the the given switch port
# Optional configuration. Default is NONE or specified by port.default.
# NONE, LAG, ROUTE, 10M, 100M, 1G, 2PT5G, 10G, 25G, 40G, 100G, SW_LED
# Use comma delimited for multiple entries, no spaces.

    cfg_write api.platform.config.switch.${switch}.portIndex.1.capability text LAG,ROUTE,10G,40G,100G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.2.capability text LAG,ROUTE,10G,40G,100G,SW_LED
}


cfg_switch_2x100gb()
{
    switch=$1

    # Note: this is for the 2nd product 2x40G, GPIO definition
    cfg_write api.platform.config.switch.${switch}.portIntrGpio int 6
    cfg_write api.platform.config.switch.${switch}.i2cResetGpio int 5

    # this is for the 2x40, has 2 external ports, 2 internal and one CPU port -> 5
    cfg_write api.platform.config.switch.${switch}.numPorts int 5

    cfg_write api.platform.config.switch.${switch}.cpuPort int 4
    cfg_write api.platform.config.switch.${switch}.bootCfg.mgmtPep int 2
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.mode bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.8.enable bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.bar4Allowed bool 1
    
    cfg_write api.platform.config.switch.${switch}.portIndex.0.portMapping text \"LOG=0 PCIE=8\"

# QSFP0
# Note: QSFP Port-0 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.0.portMapping text \"LOG=1 EPL=0 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.1.portMapping text \"LOG=1 EPL=0 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.2.portMapping text \"LOG=1 EPL=0 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.3.portMapping text \"LOG=1 EPL=0 LANE=3\"

# Note: QSFP Port-1 configuration for the 2nd product 2x40G
# QSFP1 (with different lane ordering)
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.0.portMapping text \"LOG=2 EPL=6 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.1.portMapping text \"LOG=2 EPL=6 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.2.portMapping text \"LOG=2 EPL=6 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.3.portMapping text \"LOG=2 EPL=6 LANE=3\"

# Note: PCIe Ports 3,4 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.3.portMapping text \"LOG=3 PCIE=0\"

    cfg_write api.platform.config.switch.${switch}.portIndex.4.portMapping text \"LOG=4 PCIE=2\"

# Note: Port Interface definition for the 2nd 2x40G - QSFP interface
    cfg_write api.platform.config.switch.${switch}.portIndex.1.interfaceType text QSFP_LANE0
    cfg_write api.platform.config.switch.${switch}.portIndex.2.interfaceType text QSFP_LANE0

#=============================================================================#
# The maximum port speed at which the port will be operated. This is used
# to allocate scheduler bandwidth to the ports.
#
# Optional configuration. Default is automatically selected per port type
#   EPL      -> 2.5G
#   PCIE_X1  -> 10G
#   PCIE_X4  -> 50G
#   PCIE_X8  -> 50G
#   TE       -> 100G
#   LOOPBACK -> 25G
#
    cfg_write api.platform.config.switch.${switch}.portIndex.0.speed  int 10000

# QSFP0
    cfg_write api.platform.config.switch.${switch}.portIndex.1.speed  int 100000
    cfg_write api.platform.config.switch.${switch}.portIndex.2.speed  int 100000

#=============================================================================#
# Port capability for the the given switch port
# Optional configuration. Default is NONE or specified by port.default.
# NONE, LAG, ROUTE, 10M, 100M, 1G, 2PT5G, 10G, 25G, 40G, 100G, SW_LED
# Use comma delimited for multiple entries, no spaces.

    cfg_write api.platform.config.switch.${switch}.portIndex.1.capability text LAG,ROUTE,10G,40G,100G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.2.capability text LAG,ROUTE,10G,40G,100G,SW_LED
}

cfg_switch_2x100g()
{
    switch=$1

    # Note: this is for the 2nd product 2x40G, GPIO definition
    #cfg_write api.platform.config.switch.${switch}.portIntrGpio int 6
    #cfg_write api.platform.config.switch.${switch}.i2cResetGpio int 5

    # this is for the 2x40, has 2 external ports, 2 internal and one CPU port -> 5
    cfg_write api.platform.config.switch.${switch}.numPorts int 5

    cfg_write api.platform.config.switch.${switch}.cpuPort int 4
    cfg_write api.platform.config.switch.${switch}.bootCfg.mgmtPep int 2
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.mode bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.8.enable bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.bar4Allowed bool 1
    
    cfg_write api.platform.config.switch.${switch}.portIndex.0.portMapping text \"LOG=0 PCIE=8\"

# QSFP0
# Note: QSFP Port-0 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.0.portMapping text \"LOG=1 EPL=1 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.1.portMapping text \"LOG=1 EPL=1 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.2.portMapping text \"LOG=1 EPL=1 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.3.portMapping text \"LOG=1 EPL=1 LANE=3\"

# Note: QSFP Port-1 configuration for the 2nd product 2x40G
# QSFP1 (with different lane ordering)
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.0.portMapping text \"LOG=2 EPL=6 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.1.portMapping text \"LOG=2 EPL=6 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.2.portMapping text \"LOG=2 EPL=6 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.3.portMapping text \"LOG=2 EPL=6 LANE=3\"

# Note: PCIe Ports 3,4 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.3.portMapping text \"LOG=3 PCIE=0\"

    cfg_write api.platform.config.switch.${switch}.portIndex.4.portMapping text \"LOG=4 PCIE=2\"

# Note: Port Interface definition for the 2nd 2x40G - QSFP interface
    cfg_write api.platform.config.switch.${switch}.portIndex.1.interfaceType text QSFP_LANE0
    cfg_write api.platform.config.switch.${switch}.portIndex.2.interfaceType text QSFP_LANE0

#=============================================================================#
# The maximum port speed at which the port will be operated. This is used
# to allocate scheduler bandwidth to the ports.
#
# Optional configuration. Default is automatically selected per port type
#   EPL      -> 2.5G
#   PCIE_X1  -> 10G
#   PCIE_X4  -> 50G
#   PCIE_X8  -> 50G
#   TE       -> 100G
#   LOOPBACK -> 25G
#
    cfg_write api.platform.config.switch.${switch}.portIndex.0.speed  int 10000

# QSFP0
    cfg_write api.platform.config.switch.${switch}.portIndex.1.speed  int 100000
    cfg_write api.platform.config.switch.${switch}.portIndex.2.speed  int 100000

#=============================================================================#
# Port capability for the the given switch port
# Optional configuration. Default is NONE or specified by port.default.
# NONE, LAG, ROUTE, 10M, 100M, 1G, 2PT5G, 10G, 25G, 40G, 100G, SW_LED
# Use comma delimited for multiple entries, no spaces.

    cfg_write api.platform.config.switch.${switch}.portIndex.1.capability text LAG,ROUTE,10G,40G,100G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.2.capability text LAG,ROUTE,10G,40G,100G,SW_LED
}


cfg_switch_2x100gl()
{
    switch=$1

    # Note: this is for the 2nd product 2x40G, GPIO definition
    #cfg_write api.platform.config.switch.${switch}.portIntrGpio int 6
    #cfg_write api.platform.config.switch.${switch}.i2cResetGpio int 5

    # this is for the 2x40, has 2 external ports, 2 internal and one CPU port -> 5
    cfg_write api.platform.config.switch.${switch}.numPorts int 5

    cfg_write api.platform.config.switch.${switch}.cpuPort int 4
    cfg_write api.platform.config.switch.${switch}.bootCfg.mgmtPep int 2
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.mode bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.8.enable bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.bar4Allowed bool 1
    
    cfg_write api.platform.config.switch.${switch}.portIndex.0.portMapping text \"LOG=0 PCIE=8\"

# QSFP0
# Note: QSFP Port-0 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.0.portMapping text \"LOG=1 EPL=1 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.1.portMapping text \"LOG=1 EPL=1 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.2.portMapping text \"LOG=1 EPL=1 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.3.portMapping text \"LOG=1 EPL=1 LANE=3\"

# Note: QSFP Port-1 configuration for the 2nd product 2x40G
# QSFP1 (with different lane ordering)
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.0.portMapping text \"LOG=2 EPL=7 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.1.portMapping text \"LOG=2 EPL=7 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.2.portMapping text \"LOG=2 EPL=7 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.3.portMapping text \"LOG=2 EPL=7 LANE=3\"

# Note: PCIe Ports 3,4 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.3.portMapping text \"LOG=3 PCIE=0\"

    cfg_write api.platform.config.switch.${switch}.portIndex.4.portMapping text \"LOG=4 PCIE=2\"

# Note: Port Interface definition for the 2nd 2x40G - QSFP interface
    cfg_write api.platform.config.switch.${switch}.portIndex.1.interfaceType text QSFP_LANE0
    cfg_write api.platform.config.switch.${switch}.portIndex.2.interfaceType text QSFP_LANE0

#=============================================================================#
# The maximum port speed at which the port will be operated. This is used
# to allocate scheduler bandwidth to the ports.
#
# Optional configuration. Default is automatically selected per port type
#   EPL      -> 2.5G
#   PCIE_X1  -> 10G
#   PCIE_X4  -> 50G
#   PCIE_X8  -> 50G
#   TE       -> 100G
#   LOOPBACK -> 25G
#
    cfg_write api.platform.config.switch.${switch}.portIndex.0.speed  int 10000

# QSFP0
    cfg_write api.platform.config.switch.${switch}.portIndex.1.speed  int 100000
    cfg_write api.platform.config.switch.${switch}.portIndex.2.speed  int 100000

#=============================================================================#
# Port capability for the the given switch port
# Optional configuration. Default is NONE or specified by port.default.
# NONE, LAG, ROUTE, 10M, 100M, 1G, 2PT5G, 10G, 25G, 40G, 100G, SW_LED
# Use comma delimited for multiple entries, no spaces.

    cfg_write api.platform.config.switch.${switch}.portIndex.1.capability text LAG,ROUTE,10G,25G,40G,100G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.2.capability text LAG,ROUTE,10G,25G,40G,100G,SW_LED
}

cfg_switch_2x100gm()
{
    switch=$1

    # Note: this is for the 2nd product 2x40G, GPIO definition
    #cfg_write api.platform.config.switch.${switch}.portIntrGpio int 6
    cfg_write api.platform.config.switch.${switch}.i2cResetGpio int 5
    cfg_write api.platform.config.switch.${switch}.xcvrPollPeriodMsec int 1000

    # this is for the 2x40, has 2 external ports, 2 internal and one CPU port -> 5
    cfg_write api.platform.config.switch.${switch}.numPorts int 7

    cfg_write api.platform.config.switch.${switch}.cpuPort int 6
    cfg_write api.platform.config.switch.${switch}.bootCfg.mgmtPep int 6
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.mode bool 0
    
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.8.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.bar4Allowed bool 1    

    
    cfg_write api.platform.config.switch.${switch}.portIndex.0.portMapping text \"LOG=0 PCIE=8\"

# QSFP0
# Note: QSFP Port-0 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.0.portMapping text \"LOG=1 EPL=1 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.1.portMapping text \"LOG=1 EPL=1 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.2.portMapping text \"LOG=1 EPL=1 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.3.portMapping text \"LOG=1 EPL=1 LANE=3\"

# Note: QSFP Port-1 configuration for the 2nd product 2x40G
# QSFP1 (with different lane ordering)
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.0.portMapping text \"LOG=2 EPL=7 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.1.portMapping text \"LOG=2 EPL=7 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.2.portMapping text \"LOG=2 EPL=7 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.3.portMapping text \"LOG=2 EPL=7 LANE=3\"

# Note: PCIe Ports 3,4 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.3.portMapping text \"LOG=3 PCIE=0\"

    cfg_write api.platform.config.switch.${switch}.portIndex.4.portMapping text \"LOG=4 PCIE=2\"
    
    cfg_write api.platform.config.switch.${switch}.portIndex.5.portMapping text \"LOG=5 PCIE=4\"
    cfg_write api.platform.config.switch.${switch}.portIndex.6.portMapping text \"LOG=6 PCIE=6\"    

# Note: Port Interface definition for the 2nd 2x40G - QSFP interface
    cfg_write api.platform.config.switch.${switch}.port.default.interfaceType text NONE
    cfg_write api.platform.config.switch.${switch}.portIndex.1.interfaceType text QSFP_LANE0
    cfg_write api.platform.config.switch.${switch}.portIndex.2.interfaceType text QSFP_LANE0

    

#=============================================================================#
# The maximum port speed at which the port will be operated. This is used
# to allocate scheduler bandwidth to the ports.
#
# Optional configuration. Default is automatically selected per port type
#   EPL      -> 2.5G
#   PCIE_X1  -> 10G
#   PCIE_X4  -> 50G
#   PCIE_X8  -> 50G
#   TE       -> 100G
#   LOOPBACK -> 25G
#
    cfg_write api.platform.config.switch.${switch}.portIndex.0.speed  int 10000

# QSFP0
    cfg_write api.platform.config.switch.${switch}.portIndex.1.speed  int 100000
    cfg_write api.platform.config.switch.${switch}.portIndex.2.speed  int 100000
    
    cfg_write api.platform.config.switch.${switch}.portIndex.3.speed int 50000
    cfg_write api.platform.config.switch.${switch}.portIndex.4.speed int 50000

#=============================================================================#
# Port capability for the the given switch port
# Optional configuration. Default is NONE or specified by port.default.
# NONE, LAG, ROUTE, 10M, 100M, 1G, 2PT5G, 10G, 25G, 40G, 100G, SW_LED
# Use comma delimited for multiple entries, no spaces.

    cfg_write api.platform.config.switch.${switch}.portIndex.1.capability text LAG,ROUTE,10G,25G,40G,100G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.2.capability text LAG,ROUTE,10G,25G,40G,100G,SW_LED
}


cfg_switch_2x100g8()
{
    switch=$1

    # Note: this is for the 2nd product 2x40G, GPIO definition
    #cfg_write api.platform.config.switch.${switch}.portIntrGpio int 6
    #cfg_write api.platform.config.switch.${switch}.i2cResetGpio int 5

    # this is for the 2x40, has 2 external ports, 2 internal and one CPU port -> 5
    cfg_write api.platform.config.switch.${switch}.numPorts int 6

    cfg_write api.platform.config.switch.${switch}.cpuPort int 5
    cfg_write api.platform.config.switch.${switch}.bootCfg.mgmtPep int 6
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.mode bool 0
    
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.8.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.bar4Allowed bool 1    

    
    cfg_write api.platform.config.switch.${switch}.portIndex.0.portMapping text \"LOG=0 PCIE=8\"

# QSFP0
# Note: QSFP Port-0 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.0.portMapping text \"LOG=1 EPL=1 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.1.portMapping text \"LOG=1 EPL=1 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.2.portMapping text \"LOG=1 EPL=1 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.1.lane.3.portMapping text \"LOG=1 EPL=1 LANE=3\"

# Note: QSFP Port-1 configuration for the 2nd product 2x40G
# QSFP1 (with different lane ordering)
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.0.portMapping text \"LOG=2 EPL=6 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.1.portMapping text \"LOG=2 EPL=6 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.2.portMapping text \"LOG=2 EPL=6 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.lane.3.portMapping text \"LOG=2 EPL=6 LANE=3\"

# Note: PCIe Ports 3,4 configuration for the 2nd product 2x40G
    cfg_write api.platform.config.switch.${switch}.portIndex.3.portMapping text \"LOG=3 PCIE=0\"

    cfg_write api.platform.config.switch.${switch}.portIndex.4.portMapping text \"LOG=4 PCIE=2\"
    
    cfg_write api.platform.config.switch.${switch}.portIndex.5.portMapping text \"LOG=5 PCIE=6\"    

# Note: Port Interface definition for the 2nd 2x40G - QSFP interface
    cfg_write api.platform.config.switch.${switch}.port.default.interfaceType text NONE
    cfg_write api.platform.config.switch.${switch}.portIndex.1.interfaceType text QSFP_LANE0
    cfg_write api.platform.config.switch.${switch}.portIndex.2.interfaceType text QSFP_LANE0

    

#=============================================================================#
# The maximum port speed at which the port will be operated. This is used
# to allocate scheduler bandwidth to the ports.
#
# Optional configuration. Default is automatically selected per port type
#   EPL      -> 2.5G
#   PCIE_X1  -> 10G
#   PCIE_X4  -> 50G
#   PCIE_X8  -> 50G
#   TE       -> 100G
#   LOOPBACK -> 25G
#
    cfg_write api.platform.config.switch.${switch}.portIndex.0.speed  int 10000

# QSFP0
    cfg_write api.platform.config.switch.${switch}.portIndex.1.speed  int 100000
    cfg_write api.platform.config.switch.${switch}.portIndex.2.speed  int 100000
    
    cfg_write api.platform.config.switch.${switch}.portIndex.3.speed int 50000
    cfg_write api.platform.config.switch.${switch}.portIndex.4.speed int 50000
    cfg_write api.platform.config.switch.${switch}.portIndex.5.speed int 50000

#=============================================================================#
# Port capability for the the given switch port
# Optional configuration. Default is NONE or specified by port.default.
# NONE, LAG, ROUTE, 10M, 100M, 1G, 2PT5G, 10G, 25G, 40G, 100G, SW_LED
# Use comma delimited for multiple entries, no spaces.

    cfg_write api.platform.config.switch.${switch}.portIndex.1.capability text LAG,ROUTE,10G,25G,40G,100G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.2.capability text LAG,ROUTE,10G,25G,40G,100G,SW_LED
}

cfg_switch_2x25g()
{
    switch=$1

    # Note: this is for the 2nd product 2x40G, GPIO definition
    #cfg_write api.platform.config.switch.${switch}.portIntrGpio int 6
    #cfg_write api.platform.config.switch.${switch}.i2cResetGpio int 5

    # this is for the 2x40, has 2 external ports, 2 internal and one CPU port -> 5
    cfg_write api.platform.config.switch.${switch}.numPorts int 4

    cfg_write api.platform.config.switch.${switch}.cpuPort int 3
    cfg_write api.platform.config.switch.${switch}.bootCfg.mgmtPep int 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.mode bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.8.enable bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.bar4Allowed bool 1
    
    cfg_write api.platform.config.switch.${switch}.portIndex.0.portMapping text \"LOG=0 PCIE=8\"

    cfg_write api.platform.config.switch.${switch}.portIndex.1.portMapping text "LOG=1 EPL=1 LANE=2"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.portMapping text "LOG=2 EPL=7 LANE=1"
    cfg_write api.platform.config.switch.${switch}.portIndex.3.portMapping text "LOG=3 PCIE=0"

# Note: Port Interface definition for the 2nd 2x40G - QSFP interface
    cfg_write api.platform.config.switch.${switch}.portIndex.1.interfaceType text SFPP
    cfg_write api.platform.config.switch.${switch}.portIndex.2.interfaceType text SFPP

#=============================================================================#
# The maximum port speed at which the port will be operated. This is used
# to allocate scheduler bandwidth to the ports.
#
# Optional configuration. Default is automatically selected per port type
#   EPL      -> 2.5G
#   PCIE_X1  -> 10G
#   PCIE_X4  -> 50G
#   PCIE_X8  -> 50G
#   TE       -> 100G
#   LOOPBACK -> 25G
#
    cfg_write api.platform.config.switch.${switch}.portIndex.0.speed  int 10000

# QSFP0
    cfg_write api.platform.config.switch.${switch}.portIndex.1.speed  int 25000
    cfg_write api.platform.config.switch.${switch}.portIndex.2.speed  int 25000

#=============================================================================#
# Port capability for the the given switch port
# Optional configuration. Default is NONE or specified by port.default.
# NONE, LAG, ROUTE, 10M, 100M, 1G, 2PT5G, 10G, 25G, 40G, 100G, SW_LED
# Use comma delimited for multiple entries, no spaces.

# Backplane ports get default value
    cfg_write api.platform.config.switch.${switch}.port.default.capability text NONE

# SFPP ports
    cfg_write api.platform.config.switch.${switch}.portIndex.1.capability text LAG,ROUTE,10M,100M,1G,10G,25G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.2.capability text LAG,ROUTE,10M,100M,1G,10G,25G,SW_LED

}


                                                      

cfg_switch_4x10g()
{
    switch=$1

# this is for the 4x10, has 4 external ports, 1 internal and one CPU port -> 6
    #cfg_write api.platform.config.switch.${switch}.i2cResetGpio int 5
    cfg_write api.platform.config.switch.${switch}.numPorts int 6
    
    cfg_write api.platform.config.switch.${switch}.portIndex.0.portMapping text \"LOG=0 PCIE=8\"

    cfg_write api.platform.config.switch.${switch}.cpuPort int 5
    cfg_write api.platform.config.switch.${switch}.bootCfg.mgmtPep int 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.mode bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.8.enable bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.bar4Allowed bool 1

# SFPP
# Note: SFP+ configuration for the first 4x10G External ports 1-4, PCIe port 5
    cfg_write api.platform.config.switch.${switch}.portIndex.1.portMapping text \"LOG=1 EPL=0 LANE=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.portMapping text \"LOG=2 EPL=0 LANE=1\"
    cfg_write api.platform.config.switch.${switch}.portIndex.3.portMapping text \"LOG=3 EPL=0 LANE=2\"
    cfg_write api.platform.config.switch.${switch}.portIndex.4.portMapping text \"LOG=4 EPL=0 LANE=3\"
    cfg_write api.platform.config.switch.${switch}.portIndex.5.portMapping text \"LOG=5 PCIE=0\"

# Note: Port Interface definition for the first 4x10G - SFP+ interface
    cfg_write api.platform.config.switch.${switch}.portIndex.1.interfaceType text SFPP
    cfg_write api.platform.config.switch.${switch}.portIndex.2.interfaceType text SFPP
    cfg_write api.platform.config.switch.${switch}.portIndex.3.interfaceType text SFPP
    cfg_write api.platform.config.switch.${switch}.portIndex.4.interfaceType text SFPP

#=============================================================================#
# The maximum port speed at which the port will be operated. This is used
# to allocate scheduler bandwidth to the ports.
#
# Optional configuration. Default is automatically selected per port type
#   EPL      -> 2.5G
#   PCIE_X1  -> 10G
#   PCIE_X4  -> 50G
#   PCIE_X8  -> 50G
#   TE       -> 100G
#   LOOPBACK -> 25G
#
    cfg_write api.platform.config.switch.${switch}.portIndex.0.speed  int 10000

# QSFP0
    cfg_write api.platform.config.switch.${switch}.portIndex.1.speed  int 10000
    cfg_write api.platform.config.switch.${switch}.portIndex.2.speed  int 10000
    cfg_write api.platform.config.switch.${switch}.portIndex.3.speed  int 10000
    cfg_write api.platform.config.switch.${switch}.portIndex.4.speed  int 10000

#=============================================================================#
# Port capability for the the given switch port
# Optional configuration. Default is NONE or specified by port.default.
# NONE, LAG, ROUTE, 10M, 100M, 1G, 2PT5G, 10G, 25G, 40G, 100G, SW_LED
# Use comma delimited for multiple entries, no spaces.

# Backplane ports get default value
    cfg_write api.platform.config.switch.${switch}.port.default.capability text NONE

# SFPP ports
    cfg_write api.platform.config.switch.${switch}.portIndex.1.capability text LAG,ROUTE,10M,100M,1G,10G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.2.capability text LAG,ROUTE,10M,100M,1G,10G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.3.capability text LAG,ROUTE,10M,100M,1G,10G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.4.capability text LAG,ROUTE,10M,100M,1G,10G,SW_LED

#=============================================================================#
# SERDES Cursor value for DA cables for the the given switch port
# Optional configuration. Default is 0 or specified by port.default.
    cfg_write api.platform.config.switch.${switch}.port.default.cursorCopper int 0

#=============================================================================#
# SERDES postCursor value for DA cables for the the given switch port
# Optional configuration. Default is 0 or specified by port.default.
    cfg_write api.platform.config.switch.0.port.default.postCursorCopper int 0

#=============================================================================#
# SERDES preCursor value for optical modules for the the given switch port
# Optional configuration. Default is 0 or specified by port.default.
    cfg_write api.platform.config.switch.0.port.default.preCursorOptical int 0

#=============================================================================#
# SERDES Cursor value for optical modules for the the given switch port
# Optional configuration. Default is 0 or specified by port.default.
    cfg_write api.platform.config.switch.0.port.default.cursorOptical int 0

#=============================================================================#
# SERDES postCursor value for optical modules for the the given switch port
# Optional configuration. Default is 0 or specified by port.default.
    cfg_write api.platform.config.switch.0.port.default.postCursorOptical int 0

}


cfg_switch_4x10gt()
{
    switch=$1
    phy_idx=${switch}
    phy_addr=0

# this is for the 4x10, has 4 external ports, 1 internal and one CPU port -> 6
    # cfg_write api.platform.config.switch.${switch}.i2cResetGpio int 5
    
    cfg_write api.platform.config.switch.${switch}.numPorts int 6
    cfg_write api.platform.config.switch.${switch}.xcvrPollPeriodMsec int 1000
    
    cfg_write api.platform.config.switch.${switch}.numPhys int 4
    ((phy_idx<<=8))
    cfg_write api.platform.config.switch.${switch}.phy.0.model text X557
    cfg_write api.platform.config.switch.${switch}.phy.1.model text X557
    cfg_write api.platform.config.switch.${switch}.phy.2.model text X557
    cfg_write api.platform.config.switch.${switch}.phy.3.model text X557
    
    ((phy_addr=phy_idx))
    cfg_write api.platform.config.switch.${switch}.phy.0.addr int ${phy_addr}
    ((phy_addr++))
    cfg_write api.platform.config.switch.${switch}.phy.1.addr int ${phy_addr}
    ((phy_addr++))
    cfg_write api.platform.config.switch.${switch}.phy.2.addr int ${phy_addr}
    ((phy_addr++))
    cfg_write api.platform.config.switch.${switch}.phy.3.addr int ${phy_addr}    
    
    cfg_write api.platform.config.switch.${switch}.portIndex.0.portMapping text \"LOG=0 PCIE=8\"

    cfg_write api.platform.config.switch.${switch}.cpuPort int 5
    cfg_write api.platform.config.switch.${switch}.bootCfg.mgmtPep int 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.mode bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.mode bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.enable bool 1
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.2.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.4.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.6.enable bool 0
    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.8.enable bool 0

    cfg_write api.platform.config.switch.${switch}.bootCfg.pep.0.bar4Allowed bool 1

# SFPP
# Note: SFP+ configuration for the first 4x10G External ports 1-4, PCIe port 5
    cfg_write api.platform.config.switch.${switch}.portIndex.1.portMapping text \"LOG=1 EPL=5 LANE=0 PHY=0 PORT=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.2.portMapping text \"LOG=2 EPL=5 LANE=1 PHY=1 PORT=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.3.portMapping text \"LOG=3 EPL=6 LANE=0 PHY=2 PORT=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.4.portMapping text \"LOG=4 EPL=6 LANE=1 PHY=3 PORT=0\"
    cfg_write api.platform.config.switch.${switch}.portIndex.5.portMapping text \"LOG=5 PCIE=0\"
    

# Note: Port Interface definition for the first 4x10G - SFP+ interface
    cfg_write api.platform.config.switch.${switch}.portIndex.1.interfaceType text NONE
    cfg_write api.platform.config.switch.${switch}.portIndex.2.interfaceType text NONE
    cfg_write api.platform.config.switch.${switch}.portIndex.3.interfaceType text NONE
    cfg_write api.platform.config.switch.${switch}.portIndex.4.interfaceType text NONE
    

#=============================================================================#
# The maximum port speed at which the port will be operated. This is used
# to allocate scheduler bandwidth to the ports.
#
# Optional configuration. Default is automatically selected per port type
#   EPL      -> 2.5G
#   PCIE_X1  -> 10G
#   PCIE_X4  -> 50G
#   PCIE_X8  -> 50G
#   TE       -> 100G
#   LOOPBACK -> 25G
#
    cfg_write api.platform.config.switch.${switch}.portIndex.0.speed  int 10000

# QSFP0
    cfg_write api.platform.config.switch.${switch}.portIndex.1.speed  int 10000
    cfg_write api.platform.config.switch.${switch}.portIndex.2.speed  int 10000
    cfg_write api.platform.config.switch.${switch}.portIndex.3.speed  int 10000
    cfg_write api.platform.config.switch.${switch}.portIndex.4.speed  int 10000


#=============================================================================#
# Port capability for the the given switch port
# Optional configuration. Default is NONE or specified by port.default.
# NONE, LAG, ROUTE, 10M, 100M, 1G, 2PT5G, 10G, 25G, 40G, 100G, SW_LED
# Use comma delimited for multiple entries, no spaces.

# Backplane ports get default value
    cfg_write api.platform.config.switch.${switch}.port.default.capability text NONE

# SFPP ports
    cfg_write api.platform.config.switch.${switch}.portIndex.1.capability text LAG,ROUTE,10M,100M,1G,10G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.2.capability text LAG,ROUTE,10M,100M,1G,10G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.3.capability text LAG,ROUTE,10M,100M,1G,10G,SW_LED
    cfg_write api.platform.config.switch.${switch}.portIndex.4.capability text LAG,ROUTE,10M,100M,1G,10G,SW_LED

#=============================================================================#
# SERDES Cursor value for DA cables for the the given switch port
# Optional configuration. Default is 0 or specified by port.default.
    cfg_write api.platform.config.switch.${switch}.port.default.cursorCopper int 0

#=============================================================================#
# SERDES postCursor value for DA cables for the the given switch port
# Optional configuration. Default is 0 or specified by port.default.
    cfg_write api.platform.config.switch.0.port.default.postCursorCopper int 0

#=============================================================================#
# SERDES preCursor value for optical modules for the the given switch port
# Optional configuration. Default is 0 or specified by port.default.
    cfg_write api.platform.config.switch.0.port.default.preCursorOptical int 0

#=============================================================================#
# SERDES Cursor value for optical modules for the the given switch port
# Optional configuration. Default is 0 or specified by port.default.
    cfg_write api.platform.config.switch.0.port.default.cursorOptical int 0

#=============================================================================#
# SERDES postCursor value for optical modules for the the given switch port
# Optional configuration. Default is 0 or specified by port.default.
    cfg_write api.platform.config.switch.0.port.default.postCursorOptical int 0

}



cfg_switch()
{
    switch=$1
    nic_type=$2
    
    cfg_write api.platform.config.switch.${switch}.switchNumber int ${switch}
    cfg_write api.platform.config.switch.${switch}.msiEnabled bool true
# LED
    cfg_write api.platform.config.switch.${switch}.ledPollPeriodMsec int 200
    cfg_write api.platform.config.switch.${switch}.ledBlinkMode text HW_ASSISTED
    
    # i2c clock 100Khz
    cfg_write api.platform.config.switch.${switch}.i2cClkDivider int 52

# CPU port (PEP #8 --> PCIE x1)
   # cfg_write api.platform.config.switch.${switch}.portIndex.0.portMapping text \"LOG=0 PCIE=8\"

#=============================================================================#
# Shared library name to load switch management function interfaces
# Optional, all switch management features are disabled if not set.
    cfg_write api.platform.config.switch.${switch}.sharedLibraryName text libLTStdPlatform.so

#=============================================================================#
# Disable loading function interfaces
# Optional, all function interfaces will be loaded if not set.
# NONE, fmPlatformLibInitSwitch, fmPlatformLibResetSwitch, fmPlatformLibI2cWriteRead,
# fmPlatformLibSelectBus, fmPlatformLibGetPortXcvrState, fmPlatformLibSetPortXcvrState,
# fmPlatformLibSetPortLed, fmPlatformLibEnablePortIntr, fmPlatformLibGetPortIntrPending
# Use comma delimited for multiple entries, no spaces.
    cfg_write api.platform.config.switch.${switch}.sharedLibrary.disable text GetPortIntrPending,EnablePortIntr

    if [ "$nic_type" = "4x10g" ]; then
	cfg_switch_4x10g $switch
    elif [ "$nic_type" = "2x100gb" ]; then 
	cfg_switch_2x100gb $switch
    elif [ "$nic_type" = "2x100g" ]; then 
	cfg_switch_2x100g $switch
    elif [ "$nic_type" = "2x100gl" ]; then 
	cfg_switch_2x100gl $switch
    elif [ "$nic_type" = "2x100gm" ]; then 
	cfg_switch_2x100gm $switch 
    elif [ "$nic_type" = "2x100g8" ]; then 
	cfg_switch_2x100g8 $switch               
    elif [ "$nic_type" = "2x40g" ]; then 
	cfg_switch_2x40g $switch
    elif [ "$nic_type" = "2x25g" ]; then 
	cfg_switch_2x25g $switch        
    elif [ "$nic_type" = "4x10gt" ]; then 
	cfg_switch_4x10gt $switch	
    fi
    
  #  cfg_write api.platform.config.switch.${switch}.portIndex.0.portMapping text \"LOG=0 PCIE=8\"

#=============================================================================#
# Lane polarity for the the given switch port
# Optional configuration. Default is INVERT_NONE or specified by port.default.
# INVERT_NONE, INVERT_RX, INVERT_TX, INVERT_RX_TX
    cfg_write api.platform.config.switch.${switch}.port.default.lanePolarity text INVERT_NONE

#=============================================================================#
# SERDES preCursor value for DA cables for the the given switch port
# Optional configuration. Default is 0 or specified by port.default.
    cfg_write api.platform.config.switch.${switch}.port.default.preCursorCopper int 0

#=============================================================================#
# Specifies what interface is used as I2C master to access
# the port logic devices.
# FIXME bus# == switch#?
    cfg_write api.platform.lib.config.bus${switch}.i2cDevName text switchI2C

}

# config filename 4x10g 2x40g ...
cfg_main()
{
    cfg_open $1
    shift

    numSwitches=$#

    cfg_write_header \#
    cfg_write_header \# global config : $*
    cfg_write_header \#
    cfg_write_header api.platform.config.platformName text rubyRapid
    cfg_write_header api.platform.config.numSwitches int $numSwitches

    FM10K_hwResourceId_base=0
    FM10K_pcaMux_base=0
    FM10K_pcaIo_base=0

    for switch in $(seq 0 $((numSwitches-1))); do
	nic_type=$1
        cfg_write \#
        cfg_write \# nic config : switch.${switch} ${nic_type}
        cfg_write \#
	shift
	cfg_uio $switch $switch
        cfg_switch $switch $nic_type
	cfg_hwResource $switch $nic_type
	cfg_ethernetMode $switch $nic_type
    done

    cfg_write_header api.platform.lib.config.hwResourceId.count int ${FM10K_hwResourceId_base}

    cfg_write_header api.platform.lib.config.pcaMux.count int ${FM10K_pcaMux_base}
    cfg_write_header api.platform.lib.config.pcaIo.count int ${FM10K_pcaIo_base}
    
    
    
    
    if [ "$nic_type" = "4x10g" ]||[ "$nic_type" = "2x25g" ]; then 
	port_count=4
    elif [ "$nic_type" = "2x40g" ]||[ "$nic_type" = "2x100gb" ]||[ "$nic_type" = "2x100g" ]||[ "$nic_type" = "2x100gl" ]||[ "$nic_type" = "2x100g8" ]; then 
	port_count=2
    fi
    
    
    


    cfg_close
}

dest_folder=`pwd`  #/home #/etc/rdi
file_name=fm_platform_attributes.cfg

uio_cards=`ls /sys/class/uio`
if [ -n "$1" ]; then
card_name_all=$*
else
subdev_all=`cat /sys/class/uio/*/device/uevent |grep SUBSYS |cut -d ":" -f 2`

for i in $subdev_all
do
 card_name=$*
 case $i in
 01B0)		      card_name=4x10gt ;;
 01B1|01B2|01B3|01B4) card_name=4x10g ;;
 01B8|01B9|01BA)      card_name=2x40g ;;
 01C8)                card_name=2x25g ;;
 01BC)                card_name=2x100gb ;;
 01C0)                card_name=2x100g ;;
 01C1)                card_name=2x100gl ;;
 01C2)                card_name=2x100gm ;;
 01C5)                card_name=2x100g8 ;;
 *) echo; echo -e "\033[31m unknown 0x$i subdevice found!\033[0m"; echo ;;
 esac
 card_name_all="${card_name_all} ${card_name}"
done
fi
cfg_main $dest_folder/$file_name $card_name_all

echo $card_name_all


