/**
 * get_bypass_caps_vm - get second port participate in the Bypass pair
 * @if_index: network device index
 *
 * Output:
 * flags word on success;flag word is a 32-bit mask word with each bit defines different 
 * capability as described bellow.
 * Value of 1 for supporting this feature. 0 for not supporting this feature.
 * -1 - on failure (if the device is not capable of the operation or not a Bypass device)
 * Bit	feature	                description
 * 
 * 0	BP_CAP	                The interface is Bypass capable in general
 * 
 * 1	BP_STATUS_CAP	        The interface can report of the current Bypass mode
 * 
 * 2	BP_STATUS_CHANGE_CAP	The interface can report on a change to bypass mode from 
 *                              the last time the mode was defined
 * 
 * 3	SW_CTL_CAP	            The interface is Software controlled capable for bypass/non bypass modes.
 * 
 * 4	BP_DIS_CAP	            The interface is capable of disabling the Bypass mode at all times. 
 *                              This mode will retain its mode even during power loss and also after 
 *                              power recovery. This will overcome on any bypass operation due to 
 *                              watchdog timeout or set bypass command.
 * 
 * 5	BP_DIS_STATUS_CAP	    The interface can report of the current DIS_BP_CAP
 * 
 * 6	STD_NIC_CAP	            The interface is capable to be configured to operate as standard, non Bypass, 
 *                              NIC interface (have direct connection to interfaces at all power modes)
 * 
 * 7	BP_PWOFF_NO_CAP	        The interface can be in Bypass mode at power off state
 * 
 * 8	BP_PWOFF_OFF_CAP	    The interface can disconnect the Bypass mode at power off state without 
 *                              effecting all the other states of operation
 * 
 * 9	BP_PWOFF_CTL_CAP	    The behavior of the Bypass mode at Power-off state can be controlled by 
 *                              software without effecting any other state
 * 
 *10    BP_PWUP_ON_CAP	        The interface can be in Bypass mode when power is turned on 
 *                              (until the system take control of the bypass functionality)
 * 
 *11	BP_PWUP_OFF_CAP	        The interface can disconnect from Bypass mode when power is turned on 
 *                              (until the system take control of the bypass functionality)
 * 
 *12	BP_PWUP_CTL_CAP	        The behavior of the Bypass mode at Power-up can be controlled by software
 * 
 *13	WD_CTL_CAP	            The interface has watchdog capabilities to turn to Bypass mode when not reset 
 *                              for defined period of time.
 * 
 *14	WD_STATUS_CAP	        The interface can report on the watchdog status (Active/inactive)
 * 
 *15	WD_TIMEOUT_CAP	        The interface can report the time left till watchdog triggers to Bypass mode.
 * 
 *16-31 RESERVED	
 *
 * **/
int get_bypass_caps_rd_fn(int dev, int port);

/**
 * get_wd_set_caps - Obtain watchdog timer setting capabilities
 * @if_index: network device index
 *
 * Output:
 * 
 * Set of numbers defining the various parameters of the watchdog capable 
 * to be set to as described bellow.
 * -1 - on failure (device not support Bypass or it's a slave device)
 * 
 * Bit	feature	        description
 * 
 * 0-3	WD_MIN_TIME	    The interface WD minimal time period  in 100mS units
 * 
 * 4	WD_STEP_TIME	The steps of the WD timer in 
 *                      0 - for linear steps (WD_MIN_TIME * X)
 *                      1 - for multiply by 2 from previous step (WD_MIN_TIME * 2^X)
 * 
 * 5-8	WD_STEP_COUNT	Number of steps the WD timer supports in 2^X 
 *                      (X bit available for defining the value)
 * 
 * 
 * 
 **/
int get_wd_set_caps_rd_fn(int dev, int port);

/**
 * set_bypass - set Bypass state
 * @if_index: network device index of the controlling device
 * @bypass_mode:  bypass mode (1=on, 0=off) 
 * Output:
 *  0 - on success
 * -1 - on failure (device not support Bypass or it's a slave device) 
 **/
int set_bypass_rd_fn(int dev, int port, int bypass_mode);

int set_tpl_rd_fn(int dev, int port, int tpl_mode);
int set_tx_rd_fn(int dev, int port, int tx_mode);
int set_reset_rd_fn(int dev, int port, int mode);
int set_bp_wait_at_pwup_rd_fn(int dev, int port, int bp_wait_at_pwup);




/**
 * set_disc - set Disconnect state
 * @if_index: network device index of the controlling device
 * @disc_mode:  disc mode (1=on, 0=off) 
 * Output:
 *  0 - on success
 * -1 - on failure (device not support Bypass or it's a slave device) 
 **/
int set_disc_rd_fn(int dev, int port, int disc_mode);


/**
 * get_bypass - Get Bypass mode state
 * Output:
 *  0/1 - (off/on) on success
 * -1 - on failure (device not support Bypass or it's a slave device) 
 **/
int get_bypass_rd_fn(int dev, int port);
int get_tpl_rd_fn(int dev, int port);
int get_bypass_rd_fn(int dev, int port);
int get_tx_rd_fn(int dev, int port);
int set_bp_hw_reset_rd_fn(int dev, int port, int bp_hw_reset);
int get_bp_hw_reset_rd_fn(int dev, int port);
int get_bp_wait_at_pwup_rd_fn(int dev, int port);
int is_bypass_rd_fn(int dev, int port);
int get_bypass_slave_rd_fn(int dev, int port, int *s_port);


/**
 * get_disc - Get Disconnect mode state
 * Output:
 *  0/1 - (off/on) on success
 * -1 - on failure (device not support Bypass or it's a slave device) 
 **/
int get_disc_rd_fn(int dev, int port);


/**
 * get_bypass_change - Get change of Bypass mode state from last status check
 * Output:
 *  0/1 - (off/on) on success
 * -1 - on failure (device not support Bypass or it's a slave device) 
 **/
int get_bypass_change_rd_fn(int dev, int port);

/**
 * get_disc_change - Get change of Disconnect mode state from last status check
 * Output:
 *  0/1 - (off/on) on success
 * -1 - on failure (device not support Bypass or it's a slave device) 
 **/
int get_disc_change_rd_fn(int dev, int port);



/**
 * set_bypass_pwoff - Set Bypass mode at power-off state
 * @if_index: network device index of the controlling device
 * @bypass_mode: bypass mode setting at power off state (1=BP en, 0=BP Dis)
 * Output:
 *  0 - on success 
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int set_bypass_pwoff_rd_fn(int dev, int port, int bypass_mode);


/**
 * get_bypass_pwoff - Get Bypass mode state at power-off state
 * @if_index: network device index of the controlling device
 * Output:
 *  0/1 - on success (Disable bypass at power off state / normal Bypass mode)
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int get_bypass_pwoff_rd_fn(int dev, int port);

/**
 * set_bypass_pwup - Set Bypass mode at power-up state
 * @if_index: network device index of the controlling device
 * @bypass_mode: bypass mode setting at power up state (1=BP en, 0=BP Dis)
 * Output:
 *  0 - on success 
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int set_bypass_pwup_rd_fn(int dev, int port, int bypass_mode);

/**
 * set_disc_pwup - Set Disconnect mode at power-up state
 * @disc_mode: disc mode setting at power up state (1=BP en, 0=BP Dis)
 * Output:
 *  0 - on success 
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int set_disc_pwup_rd_fn(int dev, int port, int disc_mode);


/**
 * get_bypass_pwup - Get Bypass mode state at power-up state
 * @if_index: network device index of the controlling device
 * Output:
 *  0/1 - on success (Disable bypass at power up state / normal Bypass mode)
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int get_bypass_pwup_rd_fn(int dev, int port);


/**
 * get_disc_pwup - Get Disconnect mode state at power-up state
 * Output:
 *  0/1 - on success 
 *  * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int get_disc_pwup_rd_fn(int dev, int port);

int set_bypass_wd_rd_fn(int dev, int port, int timeout);

/**
 * get_bypass_wd - Get watchdog state
 * @if_index: network device index of the controlling device
 * @ms_timeout (output): WDT timeout (in ms units), 
 *                       -1 for unknown wdt status
 *                        0 if WDT is disabled
 * Output:
 * 0  - on success
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int get_bypass_wd_rd_fn(int dev, int port, int *ms_timeout_set);

/**
 * get_wd_expire_time - Get watchdog expire
 * @if_index: network device index of the controlling device
 * @ms_time_left (output): time left till watchdog time expire, 
 *                       -1 if WDT has expired
 *                       0  if WDT is disabled
 * Output:
 * 0  - on success
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device or unknown wdt status) 
 **/
int get_wd_expire_time_rd_fn(int dev, int port, int *ms_time_left);

int get_wd_expire_rd_fn(int dev, int port);

/**
 * reset_bypass_wd_timer - Reset watchdog timer
 * @if_index: network device index of the controlling device
 * 
 * Output:
 * 1  - on success
 * 0 - watchdog is not configured
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device or unknown wdt status) 
 **/
int reset_bypass_wd_timer_rd_fn(int dev, int port);

/**
 * set_std_nic - Standard NIC mode of operation
 * @if_index: network device index of the controlling device
 * @nic_mode: 0/1 (Default Bypass mode / Standard NIC mode)
 * 
 * Output:
 * 0  - on success
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int set_std_nic_rd_fn(int dev, int port, int nic_mode);

/**
 * get_std_nic - Get Standard NIC mode setting
 * @if_index: network device index of the controlling device
 * 
 * Output:
 * 0/1 (Default Bypass mode / Standard NIC mode) on success
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int get_std_nic_rd_fn(int dev, int port);


/**
 * set_wd_exp_mode - Set adapter state when WDT expired.
 * @if_index: network device index of the controlling device
 * @bypass_mode:  adapter mode (0/1/2 mode) 
 * Output:
 *  0 - on success
 * -1 - on failure (device not support Bypass or it's a slave device) 
 **/
int set_wd_exp_mode_rd_fn(int dev, int port, int mode);

/**
 * get_wd_exp_mode - Get adapter state when WDT expired.
 * @if_index: network device index of the controlling device
 * Output:
 *  0/1/2 - (bypass/tap) on success
 * -1 - on failure (device not support Bypass or it's a slave device) 
 **/
int get_wd_exp_mode_rd_fn(int dev, int port);

int get_bypass_info_rd_fn(int dev, int port, char *dev_name, unsigned char *add_param);

int set_bp_manuf_rd_fn(int dev, int port);


/**
 * set_dis_bypass - Set Disable Bypass mode
 * @if_index: network device index of the controlling device
 * @dis_bypass: disable bypass(1=dis, 0=en)
 * Output:
 *  0 - on success
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int set_dis_bypass_rd_fn(int dev, int port, int dis_bypass);

/**
 * set_dis_disc - Set Disable Disconnect mode
 * @dis_bypass: disable disc(1=dis, 0=en)
 * Output:
 *  0 - on success
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int set_dis_disc_rd_fn(int dev, int port, int dis_disc);

 
/**
 * get_dis_bypass - Get Disable Bypass mode state
 * @if_index: network device index of the controlling device
 * Output:
 *  0/1 - on success (normal Bypass mode/ Disable Bypass)
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int get_dis_bypass_rd_fn(int dev, int port);

/**
 * get_dis_disc - Get Disable Disconnect mode state
 * @if_index: network device index of the controlling device
 * Output:
 *  0/1 - on success (normal Disc mode/ Disable Disc)
 * -1 - on failure (device is not capable of the operation ordevice not support Bypass 
 *                  or it's a slave device) 
 **/
int get_dis_disc_rd_fn(int dev, int port);

int set_bp_blink_rd_fn(int dev, int port, int ms_timeout);







#define BP_CAP                   0x01    //BIT_0
#define BP_STATUS_CAP            0x02    //BIT_1
#define BP_STATUS_CHANGE_CAP     0x04    //BIT_2
#define SW_CTL_CAP               0x08    //BIT_3
#define BP_DIS_CAP               0x10    //BIT_4
#define BP_DIS_STATUS_CAP        0x20    //BIT_5
#define STD_NIC_CAP              0x40    //BIT_6
#define BP_PWOFF_ON_CAP          0x80    //BIT_7
#define BP_PWOFF_OFF_CAP         0x0100  //BIT_8
#define BP_PWOFF_CTL_CAP         0x0200  //BIT_9
#define BP_PWUP_ON_CAP           0x0400  //BIT_10
#define BP_PWUP_OFF_CAP          0x0800  //BIT_11
#define BP_PWUP_CTL_CAP          0x1000  //BIT_12
#define WD_CTL_CAP               0x2000  //BIT_13
#define WD_STATUS_CAP            0x4000  //BIT_14
#define WD_TIMEOUT_CAP           0x8000  //BIT_15
#define TX_CTL_CAP               0x10000 //BIT_16  
#define TX_STATUS_CAP            0x20000 //BIT_17  
#define TAP_CAP                  0x40000   //BIT_18 
#define TAP_STATUS_CAP           0x80000   //BIT_19 
#define TAP_STATUS_CHANGE_CAP    0x100000  //BIT_20 
#define TAP_DIS_CAP              0x200000 //BIT_21
#define TAP_DIS_STATUS_CAP       0x400000 //BIT_22
#define TAP_PWUP_ON_CAP          0x800000 //BIT_23
#define TAP_PWUP_OFF_CAP         0x1000000 //BIT 24
#define TAP_PWUP_CTL_CAP         0x2000000 //BIT 25
#define NIC_CAP_NEG              0x4000000 //BIT 26
#define TPL_CAP                  0x8000000 //BIT 27
#define DISC_CAP                 0x10000000 //BIT 28
#define DISC_DIS_CAP          	 0x20000000 //BIT 29
#define DISC_PWUP_CTL_CAP        0x40000000 //BIT 30



#define WD_MIN_TIME_GET(desc)   (desc & 0xf)
#define WD_STEP_COUNT_GET(desc) (desc>>5) & 0xf
#define WDT_STEP_TIME           0x10



