#include "libbprd.h"

#include "bplib.h"
#include "bp_cmd.h"
#include "librdi.h"
#include "bypass.h" 

static int bp_cmd_request(int dev, bp_cmd_t *bp_cmd_buf, bp_cmd_rsp_t *bp_rsp_buf);

static int bp_cmd_request(int dev, bp_cmd_t *bp_cmd_buf, bp_cmd_rsp_t *bp_rsp_buf) {
    int ret_val;
	int try_num = 10;
	rdi_bp_query_data_t rdi_bp_query_data;


   /* atomic_set(&pbpctl_dev->wdt_busy,1); */
	/*
	 * Send command
	 */
     while (try_num--) {
		memset(bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
		memset(&rdi_bp_query_data, 0, sizeof(rdi_bp_query_data_t));
		
		rdi_bp_query_data.data.num = sizeof(bp_cmd_t);

    	memcpy(&rdi_bp_query_data.data.list[0], bp_cmd_buf, sizeof(bp_cmd_t));
		usleep(CMND_INTERVAL);


		if ((ret_val = rdi_bp_write(dev, 0x57,  &rdi_bp_query_data, RDI_FLCM_DEV)<0)) {
		    printf("bp_cmd_request(write): Not supported!\n"); 
		    continue;
		   // return 0;
		}


		usleep(CMND_INTERVAL);
#if 1
  	/*
	 * Receive replay
	 */
		memset(&rdi_bp_query_data, 0, sizeof(rdi_bp_query_data_t));

		rdi_bp_query_data.data.num=sizeof(bp_cmd_rsp_t);
		if ((ret_val = rdi_bp_read(dev, 0x57, &rdi_bp_query_data, RDI_FLCM_DEV))<0) {
			printf("bp_cmd_request(read): Not supported!\n");
			continue;
			//return 0;	
		}
#endif

	   // if (bp_rsp_buf->rsp.rsp_id != BP_ERR_OK)
		//	continue;
      memcpy(bp_rsp_buf, &rdi_bp_query_data.data.list[0], sizeof(bp_cmd_rsp_t));
	  if (bp_rsp_buf->rsp.rsp_id != BP_ERR_OK)
			continue;

#if 1 
	if (bp_rsp_buf->rsp.rsp_id != BP_ERR_OK) 
		printf("bp_cmd_request(got err code or corrupted data!) (%x %x %x %x %x %x)\n",
			               bp_rsp_buf->cmd_bytes[0],bp_rsp_buf->cmd_bytes[1],bp_rsp_buf->cmd_bytes[2],
			               bp_rsp_buf->cmd_bytes[3],bp_rsp_buf->cmd_bytes[4],bp_rsp_buf->cmd_bytes[5]);
		
#endif
		
		break;
	}
	/*atomic_set(&pbpctl_dev->wdt_busy,0);*/

    if(!try_num)
  		return 0;
	return 1;
}


int is_bypass_port_rd_fn(int dev, int port){
		
    return(((port == 1)||(port == 3)) ? 1:0);
}

int is_bypass_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret=-1;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_BYPASS;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if(!is_bypass_port_rd_fn(dev, port))
			return 0;
		return 1;	
	}
	return -1;
}


int set_bypass_rd_fn (int dev, int port, int bypass_mode){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret=-1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;
	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num= (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id=CMD_SET_BYPASS;
	bp_cmd_buf.cmd.cmd_data.bypass_mode=bypass_mode?1:0;
    
	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=0;
		}
	}
	usleep(LATCH_DELAY*1000);	 
	return ret;

}

 
int get_wd_expire_rd_fn (int dev, int port){

	int ret=-1, gpio = 0;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	gpio = (port==1)?9:10;

	if ((rdi_set_gpio_dir(dev, gpio, 0, 0, RDI_FLCM_DEV))<0) {
	  	printf("Fail\n");
           fflush(stdout);
           return -1;
    }
	   
	if ((ret = rdi_get_gpio(dev, gpio, RDI_FLCM_DEV))<0) {
           printf("Fail\n");
           fflush(stdout);
          return -1;
    }
	return (ret==0?0:1);
}

int get_bypass_rd_fn (int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret=-1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_BYPASS;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			if (bp_rsp_buf.rsp.rsp_data.bypass_pwoff == BYPASS_PWOFF_EN)
				ret = 1;
			else if (bp_rsp_buf.rsp.rsp_data.bypass_pwoff == BYPASS_PWOFF_DIS)
				ret = 0;
		}
	}
	return ret;
}


int get_bypass_change_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;;

	bp_cmd_buf.cmd.cmd_id = CMD_GET_BYPASS_CHANGE;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
        if (bp_rsp_buf.rsp.rsp_data.bypass_change == BYPASS_CHANGED)
            ret = 1;
        else if (bp_rsp_buf.rsp.rsp_data.bypass_change == BYPASS_NOT_CHANGED)
            ret = 0;
	}
	return ret;
}


int set_dis_bypass_rd_fn(int dev, int port, int dis_bypass){

	bp_cmd_t bp_cmd_buf;
    bp_cmd_rsp_t bp_rsp_buf;
    int ret=-1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

    memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
    memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
    bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
    bp_cmd_buf.cmd.cmd_id = CMD_SET_DIS_BYPASS;
    bp_cmd_buf.cmd.cmd_data.dis_bypass = 
			dis_bypass?DIS_BYPASS_DISABLE:DIS_BYPASS_ENABLE;

    if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=0;
		}
	}
    usleep(BYPASS_CAP_DELAY*1000);
    return ret;
}


int get_dis_bypass_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret=-1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_DIS_BYPASS;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
        if (bp_rsp_buf.rsp.rsp_data.dis_bypass==DIS_BYPASS_DISABLE)
            ret=1;
        else if (bp_rsp_buf.rsp.rsp_data.dis_bypass==DIS_BYPASS_ENABLE)
            ret=0;
	}
	return ret;
}


int set_bypass_pwoff_rd_fn (int dev, int port, int bypass_mode){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_SET_BYPASS_PWOFF;
	bp_cmd_buf.cmd.cmd_data.bypass_pwoff = 
			bypass_mode?BYPASS_PWOFF_EN:BYPASS_PWOFF_DIS;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
				ret=0;
		}
	}
	usleep(EEPROM_WR_DELAY*1000);
	return ret;
}


int get_bypass_pwoff_rd_fn(int dev, int port){

    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_BYPASS_PWOFF;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			if (bp_rsp_buf.rsp.rsp_data.bypass_pwoff == BYPASS_PWOFF_EN)
				ret = 1;
			else if (bp_rsp_buf.rsp.rsp_data.bypass_pwoff == BYPASS_PWOFF_DIS)
				ret = 0;
		}
	}

	return ret;
}


int set_bypass_pwup_rd_fn(int dev, int port, int bypass_mode){

    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_SET_BYPASS_PWUP;
	bp_cmd_buf.cmd.cmd_data.bypass_pwup = 
			bypass_mode?BYPASS_PWUP_EN:BYPASS_PWUP_DIS;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
				ret=0;
		}
	}
	usleep(EEPROM_WR_DELAY*1000);
	return ret;
}


int get_bypass_pwup_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_BYPASS_PWUP;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			if (bp_rsp_buf.rsp.rsp_data.bypass_pwup == BYPASS_PWUP_EN)
				ret=1;
			else if (bp_rsp_buf.rsp.rsp_data.bypass_pwup == BYPASS_PWUP_DIS)
				ret=0;
		}
	}
	return ret;
}


int set_bypass_wd_rd_fn(int dev, int port, int timeout){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_SET_BYPASS_WD;
	bp_cmd_buf.cmd.cmd_data.timeout = htonl(timeout);


	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
				ret = ntohl(bp_rsp_buf.rsp.rsp_data.timeout_set);
		}
	}
	return ret;
}


int get_bypass_wd_rd_fn(int dev, int port, int *timeout){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));	   
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_BYPASS_WD;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			*timeout = ntohl(bp_rsp_buf.rsp.rsp_data.timeout_set);
			ret = 0;
		}
	}
	return ret;
}


int get_wd_expire_time_rd_fn(int dev, int port, int *time_left){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret=-1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id=CMD_GET_WD_EXPIRE_TIME;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			*time_left = ntohl(bp_rsp_buf.rsp.rsp_data.time_left);
			if (*time_left == 0)
				ret = 0;
			else ret = 1;
		}
	}
	return ret;
}


int reset_bypass_wd_timer_rd_fn(int dev, int port){

	
	int ret=-1, gpio = 0;
	unsigned int val;
    unsigned int subdevice;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	if ((ret = rdi_get_reg(dev, 0x12000b, (unsigned int *)&val, RDI_FLCM_DEV))<0) {
		printf("Fail\n");
        fflush(stdout);
        return -1;
    }
	subdevice = (val >> 16) & 0xffff;

	if(subdevice == 0)
		gpio = (port==1)?10:11; 
	else
	    gpio = (port==1)?9:10;

	if ((rdi_set_gpio_dir(dev, gpio, 1, 1 , RDI_FLCM_DEV))<0) {
	  	printf("Fail\n");
        fflush(stdout);
        return -1;
    }
    
	if ((rdi_set_gpio_dir(dev, gpio, 1, 0 , RDI_FLCM_DEV))<0) {
	  	printf("Fail\n");
        fflush(stdout);
        return -1;
    }

	usleep(WDT_INTERVAL);

	if ((rdi_set_gpio_dir(dev, gpio, 1, 1 , RDI_FLCM_DEV))<0) {
	  	printf("Fail\n");
        fflush(stdout);
        return -1;
    }

	return 1;
}


int get_wd_set_caps_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret=-1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_WD_SET_CAPS;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK)
				ret=ntohl(bp_rsp_buf.rsp.rsp_data.wd_set_caps);

		}
	}
	return ret;

}

int set_std_nic_rd_fn(int dev, int port, int nic_mode){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id=CMD_SET_STD_NIC;
	bp_cmd_buf.cmd.cmd_data.std_nic = 
			nic_mode?STD_NIC_EN:STD_NIC_DIS;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=0;
		}
	}
	usleep(BYPASS_CAP_DELAY*1000);
	return ret;
}


int get_std_nic_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret=-1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_STD_NIC;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			if (bp_rsp_buf.rsp.rsp_data.std_nic==STD_NIC_EN)
				ret=1;
			else if (bp_rsp_buf.rsp.rsp_data.std_nic==STD_NIC_DIS)
				ret=0;
		}
	}
	return ret;
}


int set_disc_rd_fn (int dev, int port, int disc_mode){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret=-1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_SET_DISC;
	bp_cmd_buf.cmd.cmd_data.disc_mode=disc_mode?1:0;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=0;
		}
	}
	usleep(LATCH_DELAY*1000);
	return ret;
}


int get_disc_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_DISC;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			if (bp_rsp_buf.rsp.rsp_data.disc_mode==1)
				ret=1;
			else if (bp_rsp_buf.rsp.rsp_data.disc_mode==0)
				ret=0;
		}
	}
	return ret;
}


int set_disc_pwup_rd_fn(int dev, int port, int disc_mode){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret=-1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_SET_DISC_PWUP;
	bp_cmd_buf.cmd.cmd_data.disc_pwup = 
		disc_mode?DISC_PWUP_EN:DISC_PWUP_DIS;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=0;
		}
	}
	usleep(EEPROM_WR_DELAY*1000);
	return ret;
}


int get_disc_pwup_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_DISC_PWUP;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			if (bp_rsp_buf.rsp.rsp_data.disc_pwup==DISC_PWUP_EN)
				ret=1;
			else if (bp_rsp_buf.rsp.rsp_data.disc_pwup==DISC_PWUP_DIS)
				ret=0;
		}
	}
	return ret;
}


int get_disc_change_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_DISC_CHANGE;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			if (bp_rsp_buf.rsp.rsp_data.disc_change==DISC_CHANGED)
				ret=1;
			else if (bp_rsp_buf.rsp.rsp_data.disc_change==DISC_NOT_CHANGED)
				ret=0;
		}
	}
	return ret;
}


int set_dis_disc_rd_fn(int dev, int port, int dis_param){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_SET_DIS_DISC;
	bp_cmd_buf.cmd.cmd_data.dis_disc = 
		dis_param?DIS_DISC_DISABLE:DIS_DISC_ENABLE;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=0;
		}
	}
	usleep(BYPASS_CAP_DELAY*1000);
	return ret;
}

 
int get_dis_disc_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_DIS_DISC;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			if (bp_rsp_buf.rsp.rsp_data.dis_disc == DIS_DISC_DISABLE)
				ret=1;
			else if (bp_rsp_buf.rsp.rsp_data.dis_disc == DIS_DISC_ENABLE)
				ret=0;
		}
	}
	return ret;
}


int get_wd_exp_mode_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;
	
	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_WD_EXP_MODE;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=bp_rsp_buf.rsp.rsp_data.wd_exp_mode;
		}
	}
	return ret;
}

  
int set_wd_exp_mode_rd_fn(int dev, int port, int param){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
    int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_SET_WD_EXP_MODE;
	bp_cmd_buf.cmd.cmd_data.wd_exp_mode = param;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=0;
		}
	}
	usleep(BYPASS_CAP_DELAY*1000);
	return ret;
}


int set_tx_rd_fn(int dev, int port, int tx_state){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));

	if ((!port) || (port > 4))
		return -1;

	if(is_bypass_port_rd_fn(dev, port)) {
		bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
		bp_cmd_buf.cmd.cmd_data.tx_dis.port_num = 0;
	}
	else {
		bp_cmd_buf.cmd.cmd_dev_num = (port == 2)? 0:1;
		bp_cmd_buf.cmd.cmd_data.tx_dis.port_num = 1; 
	}
	bp_cmd_buf.cmd.cmd_id = CMD_SET_TX;
	bp_cmd_buf.cmd.cmd_data.tx_dis.mode = tx_state?TX_OFF:TX_ON;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=0;
		}
	}
	return ret;
}


int get_tx_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));

	if ((!port) || (port > 4))
		return -1;

	if(is_bypass_port_rd_fn(dev, port)) {
		bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
		bp_cmd_buf.cmd.cmd_data.tx_dis.port_num = 0;
	}
	else {
		bp_cmd_buf.cmd.cmd_dev_num = (port == 2)? 0:1;
		bp_cmd_buf.cmd.cmd_data.tx_dis.port_num = 1; 
	}

	bp_cmd_buf.cmd.cmd_id = CMD_GET_TX;
	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) { 
			if (bp_rsp_buf.rsp.rsp_data.tx_dis.mode==TX_ON)
				ret=0;
			else if (bp_rsp_buf.rsp.rsp_data.tx_dis.mode==TX_OFF)
				ret=1;
		}
		else return -1;
	}
	return ret;
}

   
int get_bypass_caps_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;
    
	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));

	if ((!port) || (port > 4))
		return -1;

	if(is_bypass_port_rd_fn(dev, port)) {
		bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	}
	else {
		bp_cmd_buf.cmd.cmd_dev_num = (port == 2)? 0:1;
	}

	bp_cmd_buf.cmd.cmd_id = CMD_GET_BYPASS_CAPS;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=(ntohl(bp_rsp_buf.rsp.rsp_data.bypass_caps));
			if(!(is_bypass_port_rd_fn(dev, port))){
				int ret1 = 0;
				if(ret&TX_CTL_CAP)
						ret1 = (TX_CTL_CAP|TX_STATUS_CAP);
				return ret1;
				
			}
		}
	}

	return ret;
}


int get_bypass_caps_ex_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_BYPASS_CAPS_EX;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=ntohl(bp_rsp_buf.rsp.rsp_data.bypass_caps);
		}
	}
	return ret;
}


int get_bypass_slave_rd_fn(int dev, int port, int *s_port) {

	int ret = -1;

	if ((!port) || (port > 4))
		return -1;
	ret = is_bypass_rd_fn(dev, port);
	if(ret < 0)
		return -1;
	if(ret) 
		*s_port = (port == 1)? 2:4;
	else
		*s_port = port;
		
	return ret;
}


int set_tpl_rd_fn(int dev, int port, int tpl_mode){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_SET_TPL;
	bp_cmd_buf.cmd.cmd_data.tpl_mode = tpl_mode?TPL_ON:TPL_OFF;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret = 0;
		}
	}
	return ret;
}


int get_tpl_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;
	
	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_TPL;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
        if (bp_rsp_buf.rsp.rsp_data.tpl_mode == TPL_ON)
            ret = 1;
        else if (bp_rsp_buf.rsp.rsp_data.tpl_mode == TPL_OFF)
            ret = 0;
	}
	return ret;
}


int set_bp_wait_at_pwup_rd_fn(int dev, int port, int bp_wait_at_pwup){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_SET_BP_WAIT_AT_PWUP;
	bp_cmd_buf.cmd.cmd_data.bp_wait_at_pwup = bp_wait_at_pwup?1:0;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=0;
		}
	}
	usleep(EEPROM_WR_DELAY*1000);
	return ret;
}

int get_bp_wait_at_pwup_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_BP_WAIT_AT_PWUP;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
        if (bp_rsp_buf.rsp.rsp_data.bp_wait_at_pwup == 1)
            ret = 1;
        else if (bp_rsp_buf.rsp.rsp_data.bp_wait_at_pwup == 0)
            ret = 0;
	}
	return ret;
}
 


int set_bp_hw_reset_rd_fn(int dev, int port, int bp_hw_reset){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;
    
	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_SET_BP_HW_RESET;
	bp_cmd_buf.cmd.cmd_data.bp_hw_reset = bp_hw_reset?1:0;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=0;
		}
	}
	usleep(EEPROM_WR_DELAY*1000);
	return ret;
}


int get_bp_hw_reset_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;
    
	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_BP_HW_RESET;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
        if (bp_rsp_buf.rsp.rsp_data.bp_hw_reset == 1)
            ret = 1;
        else if (bp_rsp_buf.rsp.rsp_data.bp_hw_reset == 0)
            ret = 0;
	}
	return ret;
}

typedef struct _bpmod_info_t {
    unsigned int vendor;
    unsigned int device;
    unsigned int subvendor;
    unsigned int subdevice;
    unsigned int index;
    char *bp_name;

} bpmod_info_t;


#define SILICOM_SVID 0x1374

static bpmod_info_t tx_ctl_pci_tbl[] = {
    {0x8086, 0x15A4, SILICOM_SVID, 0x01B0, 0, "PE310G4DBiR-T"},
	{0x8086, 0x15A4, 0x1B2E, 0x01B0, 0, "PE310G4DBiR-T-RB2"},

    {0x8086, 0x15A4, 0x8086, 0x000, 0, "PE310G4DBiR"},
    {0x8086, 0x15A4, SILICOM_SVID, 0x01B1, 0, "PE310G4DBiR-SRD"},
    {0x8086, 0x15A4, 0x1B2E, 0x01B1, 0, "PE310G4DBiR-SRD-RB2"},

    {0x8086, 0x15A4, SILICOM_SVID, 0x01B2, 0, "PE310G4DBiR-LRD"},
    {0x8086, 0x15A4, 0x1B2E, 0x01B2, 0, "PE310G4DBiR-LRD-RB2"},

    {0x8086, 0x15A4, SILICOM_SVID, 0x01B3, 0, "PE310G4DBiR-ERD"},
    {0x8086, 0x15A4, 0x1B2E, 0x01B3, 0, "PE310G4DBiR-ERD-RB2"},

    {0x8086, 0x15A4, SILICOM_SVID, 0x01B4, 0, "PE310G4DBiR-DA"},
    {0x8086, 0x15A4, 0x1B2E, 0x01B4, 0, "PE310G4DBiR-DA-RB2"},

    {0x8086, 0x15A4, SILICOM_SVID, 0x01B8, 0, "PE340G2DBIR-QS41"},
	{0x8086, 0x15A4, 0x1B2E, 0x01B8, 0, "PE340G2DBIR-QS41-RB2"},

    {0x8086, 0x15A4, SILICOM_SVID, 0x01B9, 0, "PE340G2DBIR-QS43"},
	{0x8086, 0x15A4, 0x1B2E, 0x01B9, 0, "PE340G2DBIR-QS43-RB2"},

    {0x8086, 0x15A4, SILICOM_SVID, 0x01BA, 0, "PE340G2DBIR-QL4"},
	{0x8086, 0x15A4, 0x1B2E, 0x01BA, 0, "PE340G2DBIR-QL4-RB2"},
	
    {0x8086, 0x15A4, SILICOM_SVID, 0x01C0, 0, "PE3100G2DQIR-QX4/QS4/QL4"},
    {0x8086, 0x15A4, SILICOM_SVID, 0x01C1, 0, "PE3100G2DQIRL-QX4/QS4/QL4"},
    {0x8086, 0x15A4, SILICOM_SVID, 0x01C2, 0, "PE3100G2DQIRM-QX4/QS4/QL4"},
    {0x8086, 0x15A4, SILICOM_SVID, 0x01C8, 0, "PE325G2DSIR"},

    /* required last entry */
    {0,}
};



int get_bypass_info_rd_fn(int dev, int port, char *dev_name, unsigned char *add_param){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1, idx = 0;
    unsigned int val, vendor, device, subvendor;
    unsigned int subdevice;

	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	if ((ret = rdi_get_reg(dev, 0x120000, (unsigned int *)&val, RDI_FLCM_DEV))<0) {
		printf("Fail\n");
        fflush(stdout);
        return -1;
    }
	vendor = val & 0xffff;
	device = (val >> 16) & 0xffff;

	if ((ret = rdi_get_reg(dev, 0x12000b, (unsigned int *)&val, RDI_FLCM_DEV))<0) {
		printf("Fail\n");
        fflush(stdout);
        return -1;
    }
	subvendor = val & 0xffff;
	subdevice = (val >> 16) & 0xffff;
    
    for (idx = 0; tx_ctl_pci_tbl[idx].vendor; idx++) {
		if((tx_ctl_pci_tbl[idx].vendor == vendor) &&
		   (tx_ctl_pci_tbl[idx].device == device) &&
			(tx_ctl_pci_tbl[idx].subvendor == subvendor) &&
			(tx_ctl_pci_tbl[idx].subdevice == subdevice))
				break;
    }

	if(!tx_ctl_pci_tbl[idx].vendor)
		return -1;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_GET_BYPASS_INFO;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
			strcpy(dev_name, tx_ctl_pci_tbl[idx].bp_name);
			/**add_param = bp_rsp_buf.rsp.rsp_data.bypass_info.fw_ver;*/
			memcpy(add_param,(char *)&(bp_rsp_buf.rsp.rsp_data.bypass_info.fw_ver), 1);
			ret=0;
	}
	return ret;
}


int set_bp_manuf_rd_fn(int dev, int port){
    bp_cmd_t bp_cmd_buf;
	bp_cmd_rsp_t bp_rsp_buf;
	int ret = -1;
    
	if(!is_bypass_port_rd_fn(dev, port))
		return ret;

	memset(&bp_cmd_buf, 0, sizeof(bp_cmd_buf));
	memset(&bp_rsp_buf, 0, sizeof(bp_cmd_rsp_t));
	bp_cmd_buf.cmd.cmd_dev_num = (port == 1)? 0:1;
	bp_cmd_buf.cmd.cmd_id = CMD_SET_BP_MANUF;

	if(bp_cmd_request(dev, &bp_cmd_buf, &bp_rsp_buf)) {
		if (bp_rsp_buf.rsp.rsp_id == BP_ERR_OK) {
			ret=0;
		}
	} 
    usleep(BYPASS_CAP_DELAY*1000);
	return ret;
	
}
