/*************************************************
Copyright (C), 2000-2010, Sumavision Tech. Co., Ltd.
File name: 		card_common.js  
Author:			wangyuqi, xiayuxiao
Version:		v1.0
Date: 			2013/02/26
Description:  	主千兆卡页面公用js代码模块
History: 
1. Date: Author: Modification:
2. ...
*************************************************/
var INPUT = 0;
var OUTPUT = 1;
var IN_AND_OUT = 2;

var ONE_LICENSE = 0;  //1+1备份授权
var TWO_LICENSE = 1;  //2+2备份授权

var MONITOR = 0;
var ARP = 12;
//type value
var CARD_MONITOR = 1;
var CARD_CONFIG = 2;
var CARD_IN_BACKUP = 3;
var CARD_OUT_BACKUP = 4;
var GBE_IN_MONITOR = 5;
var GBE_OUT_MONITOR = 6;
var GBE_IN_CONFIG = 7;
var GBE_OUT_CONFIG = 8;
var GBE_ARP_MONITOR = 9;
var GBE_ARP_CONFIG = 10;
var GBE_PORT_BACKUP = 11;
var GBE_IN_PID_DETAIL = 13;
var GBE_OUT_PID_DETAIL = 14;
var GET_PARAM_STR = 15;

var identifyData;

var errorEn = ["",
			   "Some service has been set to muxing in input port!",
			   "Some service has been set to pass-through in input port!",
			   "Some service has been set to muxing in output port!",
			   "Some service has been set to pass-through in output port!",
			   "Port backup exists in input port!",
			   "Service backup exists in input port!",
			   "Service backup exists in output port!",
			   "You can not set the port with the same receiving IP and UDP port in one GbE port!",
			   "You can not set the port with the same destination IP and UDP port in one GbE port!",
			   "The max number of input UDP ports is 256 in one GbE port!",
			   "The max number of output UDP ports is 256 in one GbE port!",
			   "The parameter value is illegal!",
			   "The port is invalid",
			   "The backup UDP port can not equal to destination port!",
			   "Receive IP and receive UDP port can not conflict with GbE IP and backup UDP port!",
			   "If current protocol is RTP, the destination UDP port of main GbE and backup GbE must be even!",
			   "The sum of all the port total bitrate shouldn’t be greater than 900000000bps!",
			   "The count of output port in same backup group shouldn't be more than 32 in one GbE!",
			   "Don’t allow the same target IP in static ARP list in one GbE port!",
			   "Don’t allow the same target MAC in static ARP list in one GbE port!",
			   "Some program has been set to pass-through in output port in main GbE port!",
			   "Beyond the authorization,you can not add a new port!",
			   "You can not set the port with the same receiving IP and UDP port in one GbE(backup GbE) port!",
			   "You can not set the port with the same destination IP and UDP port in one GbE(backup GbE) port!",
			   "Buffer is not enough!",
			   "DDR capacity is not enough!"];

var errorCn = ["",
			   "输入端口下有节目被复用！",
			   "输入端口下有节目被透传！",
			   "输出端口下有节目被复用！",
			   "输出端口下有节目被透传！",
			   "输入端口存在端口备份！",
			   "输入端口存在节目备份！",
			   "输出端口存在节目备份！",
			   "一个网口下不能有接收IP和接收UDP端口完全相同的端口！",
			   "一个网口下不能有目的IP和目的UDP端口完全相同的端口！",
			   "一个网口下最多可添加256个输入UDP端口！",
			   "一个网口下最多可添加256个输出UDP端口！",
			   "非法参数值！",
			   "非有效端口！",
			   "备份UDP端口不能和目的UDP端口相等！",
			   "接收IP和接收UDP端口号不能与本卡IP和输出端口备份的备份UDP端口号冲突！",
			   "在RTP协议下主网口和备份网口的目的UDP端口号必须为偶数！",
			   "所有端口的系统码率之和不得大于900000000bps！",
			   "网口工作在输出端口备份非正常模式下,一个组里的端口数量不能超过32个！",
			   "一个网口下的静态ARP列表不能有两个完全相同的目的IP！",
			   "一个网口下的静态ARP列表不能有两个完全相同的目的MAC！",
			   "对应的主网口输出端口下有节目被透传！",
			   "授权不足添加新端口！",
			   "一个网口(备份网口)下不能有接收IP和接收UDP端口完全相同的端口！",
			   "一个网口(备份网口)下不能有目的IP和目的UDP端口完全相同的端口！",
			   "缓冲区不足！",
			   "DDR容量不足！"];
			   
var returnError = [errorEn, errorCn];

//Gbe3 and Gbe4 的横向菜单根据备份工作模式确定
function displayMenu()
{
	var args = GetArgs();
	var portNo = parseInt(args["portNo"], 10);
	if((portNo == 2) || (portNo == 3))
	{
		var curGbeEna = parent.selectNode.phyena;
		if(curGbeEna == INPUT)  //input
		{			
			$("#transmitMenu").css("display", "none");
			$("#arpMenu").css("display", "none");
			$("#backupMenu").css("display", "none");
			if(webPageName == GBE_IN_CONFIG)
			{
				$("#monitorMenu").attr("class", "selected_follow");
			}
		}
		else if(curGbeEna == OUTPUT)  //output
		{
			$("#receiveMenu").css("display", "none");
			//$("#backupMenu").css("display", "none");
			if(webPageName == GBE_OUT_CONFIG)
			{
				$("#transmitMenu").attr("class", "first_selected");
			}
			else if(webPageName == ARP)
			{
				//$("#monitorMenu").attr("class", "selected_follow");
				$("#transmitMenu").attr("class", "first_no_selected");
			}
			else if((webPageName == MONITOR) || (webPageName == GBE_PORT_BACKUP))
			{
				$("#transmitMenu").attr("class", "first_no_selected");
			}			
		}
		else if(curGbeEna == IN_AND_OUT)  //input and output
		{
			/*$("#backupMenu").css("display", "none");
			if(webPageName == ARP)
			{
				$("#monitorMenu").attr("class", "selected_follow");
			}*/
		}
	}	
}

/*************************************************
Function: 		pageJump
Description: 	横向菜单的切换
Input: 			type: page type
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function pageJump(type)
{	
	switch(type)
	{
		case CARD_CONFIG:
			self.location.replace("card_config" + pageLanguage[language] + "?slotNo=" + slotNo);			
			break;
		case CARD_IN_BACKUP:
			self.location.replace("card_in_backup" + pageLanguage[language] + "?slotNo=" + slotNo);		
			break;
		case CARD_OUT_BACKUP:
			self.location.replace("card_out_backup" + pageLanguage[language] + "?slotNo=" + slotNo);			
			break;
		case CARD_MONITOR:
			self.location.replace("card" + pageLanguage[language] + "?slotNo=" + slotNo);
			break;
		case GBE_IN_CONFIG:
			self.location.replace("gbe_in_config" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);		
			break;
		case GBE_OUT_CONFIG:
			if(language == ENGLISH){
				self.location.replace("gbe_out_config_en.html?slotNo=" + slotNo + "&portNo=" + portNo);
			}
			else{
				self.location.replace("gbe_out_config_cn.html?slotNo=" + slotNo + "&portNo=" + portNo);
			}
			break;
		case GBE_ARP_MONITOR:
			self.location.replace("gbe_arp_monitor" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);
			break;
		case GBE_ARP_CONFIG:
			self.location.replace("gbe_arp_config" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);			
			break;
		case GBE_PORT_BACKUP:
			self.location.replace("gbe_port_backup" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);	
			break;
		case GBE_IN_MONITOR:
			self.location.replace("gbe_in" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);			
			break;
		case GBE_OUT_MONITOR:
			self.location.replace("gbe_out" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);	
			break;
		case MONITOR:
			if((portNo == 2) || (portNo == 3))
			{
				var curGbeEna = parent.selectNode.phyena;
				if(curGbeEna == OUTPUT)
				{
					self.location.replace("gbe_out" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);
				}
				else
				{
					self.location.replace("gbe_in" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);
				}
			}
			else
			{
				self.location.replace("gbe_in" + pageLanguage[language] + "?slotNo=" + slotNo + "&portNo=" + portNo);
			}				
			break;
		default:
			break;
	}
}

