﻿var objIdArray = ["linkState", "speedState", "inWorkStatus", "outWorkStatus", "inTotalRate", "setOutTotalRate", "actualOutTotalRate", "inEffectiveRate", "setOutEffectiveRate", "actualOutEffectiveRate", "inputCrcError"];
var COL_NUM = 11;
var ROW_NUM = 4;
var linkStatusArrayEn = ["Link Down", "Link Up"];
var linkStatusArrayCn = ["未连接", "连接"];
var speedStatusArrayEn = ["10Mbps", "100Mbps", "1Gbps", "Unknown"];
var speedStatusArrayCn = ["10Mbps", "100Mbps", "1Gbps", "未知"];
var workStatusArrayEn = ["Inactive", "Active"];
var workStatusArrayCn = ["未工作", "工作中"];
var statusArrayEn = [linkStatusArrayEn, speedStatusArrayEn, workStatusArrayEn, workStatusArrayEn];
var statusArrayCn = [linkStatusArrayCn, speedStatusArrayCn, workStatusArrayCn, workStatusArrayCn];

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	$("#gbe2").hide();
	$("#gbe4").hide();
	for(var i = 0; i < COL_NUM; i++)
	{
		$("#" + objIdArray[i] + 2).hide();
		$("#" + objIdArray[i] + 4).hide();
	}
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);	
	funcUpdateDisplay();
	setInterval("displayParam();", 10000);
});

function funcUpdateDisplay() 
{	 
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var rowData;
	var data;
	var length;
	var response;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formEMR30?type=" + CARD_MONITOR + "&cmd=" + GET + "&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				length = data.length;
				identifyData = parseInt(data[length - 2], 10);
				//displayGbe();
				var netIdentifier = data[data.length - 1];
				if(netIdentifier == 1){ //1
					$("#contentDiv").attr("class", "content_div_small");
					$(".net1").css("width", "300px");
					$(".net1").show()
					$(".net2").hide();
					$(".net3").hide();
					$(".net4").hide();
					$("#inBackup").hide();
					$("#outBackup").hide();
				}
				else if(netIdentifier == 3){ //12
					$("#contentDiv").attr("class", "content_div_small");
					$(".net1").show().css("width", "170px");
					$(".net2").show().css("width", "170px");
					$(".net3").hide();
					$(".net4").hide();
					$("#inBackup").hide();
					$("#outBackup").hide();
				}
				else if(netIdentifier == 5){ //13
					$("#contentDiv").attr("class", "content_div_small");
					$(".net1").show().css("width", "170px");
					$(".net2").hide();
					$(".net3").show().css("width", "170px");
					$(".net4").hide();
					$("#inBackup").show();
					$("#outBackup").show();
				}
				else if(netIdentifier == 15){ //1234
					$("#contentDiv").attr("class", "content_div_full");
					$(".net1").show().css("width", "140px");
					$(".net2").show().css("width", "140px");
					$(".net3").show().css("width", "140px");
					$(".net4").show().css("width", "140px");
					$("#inBackup").show();
					$("#outBackup").show();
				}
				for(var i = 0; i < ROW_NUM; i++)
				{
					rowData = data[i].split(SECOND_DELIMITER);
					for(var j = 0; j < COL_NUM; j++)
					{
						if(j < 4)
						{
							if(language == ENGLISH)
							{
								$("#" + objIdArray[j] + (i + 1)).html(statusArrayEn[j][rowData[j]]);
							}
							else
							{
								$("#" + objIdArray[j] + (i + 1)).html(statusArrayCn[j][rowData[j]]);	
							}
						}
						else
						{
							$("#" + objIdArray[j] + (i + 1)).html(rowData[j]);
						}
					}		
				}				
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

/*************************************************
Function: 		displayGbe
Description: 	用于网口2和网口4参数的动态隐藏显示
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function displayGbe()
{
	if(identifyData == ONE_LICENSE)
	{
		$("#contentDiv").attr("class", "content_div_small");
		for(var i = 1; i < 5; i ++)
		{
			$("#gbe" + i).css("width", "170px");
		}
		$("#gbe2").hide();
		$("#gbe4").hide();
		for(var i = 0; i < COL_NUM; i++)
		{
			$("#" + objIdArray[i] + 2).hide();
			$("#" + objIdArray[i] + 4).hide();
		}
	}
	else
	{
		$("#contentDiv").attr("class", "content_div_full");
		for(var i = 1; i < 5; i ++)
		{
			$("#gbe" + i).css("width", "140px");
		}
		$("#gbe2").show();
		$("#gbe4").show();
		for(var i = 0; i < COL_NUM; i++)
		{
			$("#" + objIdArray[i] + 2).show();
			$("#" + objIdArray[i] + 4).show();
		}
	}
}