﻿var objIdArray = ["gbe3OutCtrlSwitch", "gbe4OutCtrlSwitch"];
var ROW_NUM = 2;

var gbe3BackupSwitch;
var gbe4BackupSwitch;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);	
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var sectionData;
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + CARD_OUT_BACKUP + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				gbe3BackupSwitch = data[0];
				gbe4BackupSwitch = data[1];
				identifyData = parseInt(data[2], 10);
				displayCtrlSwitch();
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);	
}

function pageApply()
{
	var switchOffFlag = 0;
	var confirmPrompt;
	if(((parseInt($("#gbe3OutCtrlSwitch").val(), 10) != gbe3BackupSwitch) && (gbe3BackupSwitch == ON))|| ((parseInt($("#gbe4OutCtrlSwitch").val(), 10) != gbe4BackupSwitch) && (gbe4BackupSwitch == ON)))
	{
		switchOffFlag = 1;
	}
	if(switchOffFlag == 1)//备份开关由打开到关闭
	{
		if(language == ENGLISH)
		{
			var confirmPrompt = "Note:Outport Backup Function will be uneffective if you shutdown Output Backup Switch!";
		}
		else if(language == CHINESE)
		{
			var confirmPrompt = "注意：关闭后备份网口的输出端口备份功能将会失效!";
		}
		if(window.confirm(confirmPrompt))
		{
			pageApplySubmit();
		}
	}
	else
	{
		pageApplySubmit();
	}
}

function pageApplySubmit()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	data = "type=" + CARD_OUT_BACKUP + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag,TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			changeBackupSwitch();
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val()
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val()
		}
	}
	return data;
}

function sendRequest(url)
{
	var tId = parent.curTree.getSelectedNodes()[0].tId;
	var selectNode;
	var xmlHttp = GetHTTPObject();
	xmlHttp.open("GET", url, true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			ExecuteScript(xmlHttp.responseText);
			selectNode = parent.curTree.getNodeByTId(tId);
			parent.curTree.selectNode(parent.curTree.getNodeByTId(tId));
		}
	}
	xmlHttp.send(null);
}

/*************************************************
Function: 		displayCtrlSwitch
Description: 	用于输出备份页面网口4的输出控制开关的动态
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function displayCtrlSwitch()
{	
	if(identifyData == ONE_LICENSE)  //1+1备份
	{
		$("#gbe4").css("display", "none");
	}
	else
	{
		$("#gbe4").css("display", "");
	}	
}
/*************************************************
Function: 		changeBackupSwitch
Description: 	用于备份开关改变时重新加载左边树
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function changeBackupSwitch()
{	
	if((parseInt($("#gbe3OutCtrlSwitch").val(), 10) != gbe3BackupSwitch) || (parseInt($("#gbe4OutCtrlSwitch").val(), 10) != gbe4BackupSwitch))
	{
		sendRequest("../frame" + pageLanguage[language] + "?ran=" + Math.random());
	}
}