﻿var tabIdArray = ["basic", "rate", "igmp"];
var TAB_NUM = 3;

var objIdArray = ["", "", "name", "ip", "port", "protocol", "alarmSwitch", "bufferSize", "refSwitch", "refRate", "recMode", "srcIpOne", "srcIpTwo"];
var COL_NUM = 13;
var INFO = 0;
var PORT_NO = 1;
var NAME = 2;
var IP = 3;
var PORT = 4;
var PROTOCOL = 5;
var ALARM_SWITCH = 6;
var BUFFER_SIZE = 7;
var REF_SWITCH = 8;
var REF_RATE = 9;
var RECEIVE_MODE = 10;
var SOURCE_IP_1 = 11;
var SOURCE_IP_2 = 12;

var dataArray = [];

var CHECK = 0;
var CHANGE = 1;

var NORMAL_STRING = "N";
var CHECK_STRING = "C";
var CHANGE_STRING = "M";

var BASIC = 0;
var BITRATE = 1;
var IGMP = 2;
var charNumOfRowId = [12, 11, 11];
var curTab = BASIC;

var RTP = 1;

var curRespRowNum;
var rowNum = 0;
var initRow = true;
var rowIndex;
var invalidIPFlag = false;
window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	displayMenu();
	funcUpdateDisplay();
	
	for(var i = 0; i < TAB_NUM; i++)
	{
		AddTabMouseAction(tabIdArray[i]);
	}
	
});

function funcUpdateDisplay() 
{
	invalidIPFlag = false;
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	DisableButton("addBtn");
	DisableButton("deleteBtn");
	DisableButton("deleteAllBtn");
	DisableButton("modifyBtn");
	$("input[type=checkbox]").attr("disabled", true);
	PageLoadStatus(true);
	dataArray = [];
	displayParam();
	
	ResetColor();
	PageLoadStatus(false);
	
	$("input[type=checkbox]").prop("checked", false);
}

function changeRowChecked(obj)
{
	var rowIndex;
	var flag;
	
	if(parent.groupAccess != USER)
	{
		EnableButton("deleteBtn");
		EnableButton("modifyBtn");
	}
		
	rowIndex = GetIndexFromId(obj, charNumOfRowId[curTab]) - 1;
	flag = obj.prop("checked");
	changeRowInfo(rowIndex, flag);
}

function changeRowInfo(rowIndex, flag)
{
	var rowData = dataArray[rowIndex].split(SECOND_DELIMITER);
	var rowInfo = rowData[INFO].split(",");
	var newRowInfo;
	var newString;
	
	if(flag == true)
	{
		rowInfo[CHECK] = CHECK_STRING;
	}
	else
	{
		rowInfo[CHECK] = NORMAL_STRING;
	}
	newRowInfo = rowInfo[CHECK] + "," + rowInfo[CHANGE];
	newString = newRowInfo;
	for(var i = PORT_NO; i < COL_NUM; i++)
	{
		newString += SECOND_DELIMITER + rowData[i];
	}
	dataArray[rowIndex] = newString;
}

function checkAll(type)
{
	var flag = $("#" + tabIdArray[type] + "CheckAll").prop("checked");
	for(var i = 0; i < rowNum; i++)
	{
		$("#" + tabIdArray[type] + "Check" + (i + 1)).prop("checked", flag);
		changeRowInfo(i, flag);
	}
	
	if(parent.groupAccess != USER)
	{
		EnableButton("deleteBtn");
		EnableButton("modifyBtn");
	}
}

function displayParam() 
{
	var data;
	var i;
	var response;
	var indexInfo;
	var curRowNum;
	var rowData;
	var xmlHttp = GetHTTPObject();

	if(initRow)
	{
		rowIndex = 0;
	}
	xmlHttp.open("GET", "/goform/formEMR30?type=" + GBE_IN_CONFIG + "&cmd=" + GET + "&rowIndex=" + rowIndex +  
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				var timeObj = new Date();
				startRefreshTime = timeObj.getTime();
				initRow = false;
				data = response.split(FIRST_DELIMITER);
				curRespRowNum = data.length - 2;
				indexInfo = data[curRespRowNum].split(SECOND_DELIMITER);
				rowIndex = parseInt(indexInfo[0], 10);
				rowNum = parseInt(indexInfo[1], 10);
				identifyData = data[curRespRowNum + 1];
				curRowNum = $("#basicTable" + " tr").filter(".basicCaseRow").length;
				if((curRowNum < rowNum) && (curRowNum < rowIndex))
				{
					for(i = 0; i < TAB_NUM; i++)
					{
						DrawTableRow((tabIdArray[i] + "Table"), (tabIdArray[i] + "DataRow"), (tabIdArray[i] + "CaseRow"), rowIndex);
					}
				}
				else if(curRowNum > rowNum)
				{
					for(i = 0; i < TAB_NUM; i++)
					{
						DrawTableRow((tabIdArray[i] + "Table"), (tabIdArray[i] + "DataRow"), (tabIdArray[i] + "CaseRow"), rowNum);
					}
				}
				if(curRespRowNum != 0)
				{
					var saveString = "";
					for(i = 0; i < curRespRowNum; i++)
					{
						saveString = NORMAL_STRING + "," + NORMAL_STRING + SECOND_DELIMITER + data[i];
						dataArray.push(saveString);
					}
					for(i = (rowIndex - curRespRowNum); i < rowIndex; i++)
					{
						rowData = dataArray[i].split(SECOND_DELIMITER);
						for(var j = PORT_NO; j < COL_NUM; j++)
						{
							if(j == PORT_NO)
							{
								for(var k = 0; k < TAB_NUM; k++)
								{
									$("#" + tabIdArray[k] + "Port" + (i + 1)).html(rowData[j]);
								}
							}
							else
							{
								$("#" + objIdArray[j] + (i + 1)).val(rowData[j]);
							}
						}
						if((portNo == 2) || (portNo == 3)) //备份网口时,缓冲区大小参数置灰
						{
							$("#" + objIdArray[BUFFER_SIZE] + (i + 1)).attr("disabled", true);						
						}
						else
						{
							$("#" + objIdArray[BUFFER_SIZE] + (i + 1)).attr("disabled", false);
						}
					}
				}
				if(rowIndex < rowNum)
				{
					setTimeout("displayParam()", 5);
				}
				else if(rowIndex == rowNum)
				{
					EnableButton("refreshBtn");
					if(parent.groupAccess != USER)
					{
						EnableButton("addBtn");
						EnableButton("deleteAllBtn");
					}
					$("input[type=checkbox]").attr("disabled", false);
					initRow = true;
					refreshFlag = true;
				}
			}
		}
	}
	xmlHttp.send(null);
}

function updateTableData()
{
	var rowData;
	
	for(var i = 0; i < rowNum; i++)
	{
		rowData = dataArray[i].split(SECOND_DELIMITER);
		for(var j = PORT_NO; j < COL_NUM; j++)
		{
			if(j == PORT_NO)
			{
				for(var k = 0; k < TAB_NUM; k++)
				{
					$("#" + tabIdArray[k] + "Port" + (i + 1)).html(rowData[j]);
				}
			}
			else
			{
				$("#" + objIdArray[j] + (i + 1)).val(rowData[j]);
			}
		}
	}
}

function disableAddAndDel(flag)
{
	if(flag == true)
	{
		$("#addBtn").css("display", "none");
		$("#deleteBtn").css("display", "none");
		$("#deleteAllBtn").css("display", "none");
		$("#buttonArea").css("width", "234px");
	}
	else
	{
		$("#addBtn").css("display", "");
		$("#deleteBtn").css("display", "");
		$("#deleteAllBtn").css("display", "");
		$("#buttonArea").css("width", "468px");
	}
}

//标签切换跳转
function tableChange(type)
{
	var $curTable;
	var $curTab;
	
	if(type == curTab)
	{
		return;
	}
	
	if(type == BASIC)
	{
		disableAddAndDel(false);
	}
	else
	{
		disableAddAndDel(true);
	}
	
	$("#" + tabIdArray[curTab] + "Table").css("display", "none");
	$("#" + tabIdArray[curTab] + "ModifyTable").css("display", "none");
	$("#" + tabIdArray[curTab]).attr("class", "table_header_normal");
	
	curTab = type;
	$("#" + tabIdArray[curTab] + "Table").css("display", "");
	$("#" + tabIdArray[curTab] + "ModifyTable").css("display", "");
	$("#" + tabIdArray[curTab]).attr("class", "table_header_select");
}

function pageApply()
{
	var data = "type=" + GBE_IN_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	var editNum = 0;
	var rowData;
	var newString;
	var rowInfo;
	var xmlHttp = GetHTTPObject();
	var response;
	
	for(var i = 0; i < rowNum; i++)
	{
		rowData = dataArray[i].split(SECOND_DELIMITER);
		rowInfo = rowData[INFO].split(",");
		if(rowInfo[CHANGE] == CHANGE_STRING)
		{
			if(validateBeforeApply(i) == false)
			{
				return;
			}
			for(var j = PORT_NO; j < COL_NUM; j++)
			{
				if(j == PORT_NO)
				{
					newString = rowData[j];
				}
				else
				{
					newString += SECOND_DELIMITER + rowData[j].replace(/\+/g, "%2B").replace(/\&/g, "%26");
				}
			}
			if(editNum == 0)
			{
				data += newString;
			}
			else
			{
				data += FIRST_DELIMITER + newString;
			}
			editNum++;
		}
	}
	if(invalidIPFlag)
	{
		if(language == ENGLISH)
		{
			var confirmPrompt = "The <Receive IP Address> is a standard reserved address, which may affect the service!";
		}
		else if(language == CHINESE)
		{
			var confirmPrompt = "接收地址为标准保留地址，强制使用可能会影响到业务！";
		}
	}
	if((!invalidIPFlag) || (window.confirm(confirmPrompt))){
		if(editNum == 0)
		{
			funcUpdateDisplay();
			return;
		}
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					applyFlag = true;
				}
				else
				{
					alert(returnError[language][response]);
				}
				GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
				applyFlag = false;  //设置标识符恢复为false
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}	
}

function changeCellValue(obj)
{
	var id = obj.attr("id");
	var rowIndex = GetIndexFromId(obj, charNumOfRowId[curTab]) - 1;
	var fieldIndex;
	var rowData = dataArray[rowIndex].split(SECOND_DELIMITER);
	var rowInfo = rowData[INFO].split(",");
	var newRowInfo;
	var newString;

	for(var i = NAME; i < COL_NUM; i++)
	{
		if(id.indexOf(objIdArray[i]) != -1)
		{
			fieldIndex = i;
			break;
		}
	}
	rowData[fieldIndex] = obj.val();
	rowInfo[CHANGE] = CHANGE_STRING;
	newRowInfo = rowInfo[CHECK] + "," + rowInfo[CHANGE];
	newString = newRowInfo;
	for(var i = PORT_NO; i < COL_NUM; i++)
	{
		newString += SECOND_DELIMITER + rowData[i];
	}
	dataArray[rowIndex] = newString;
}

function validateBeforeApply(rowIndex)
{
 	var returnFlag;
	var index = rowIndex + 1;
	
	returnFlag = ValidateParam($("#" + objIdArray[NAME] + index), "LENGTH", 1, 31, "<Name>", "<名称>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateName($("#" + objIdArray[NAME] + index), language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateIP($("#" + objIdArray[IP] + index) , "IP_ADDR", "<Receive IP Address>", "<接收IP地址>", language);
	if(returnFlag == false)
	{
		return false;
	}
	var revIpInt = IP2Num($("#" + objIdArray[IP] + index).val());
	if(((revIpInt >= IP2Num("224.0.0.0")) && (revIpInt < IP2Num("224.1.0.0")))
		||((revIpInt >= IP2Num("224.3.0.0")) && (revIpInt <= IP2Num("224.4.255.255")))
		|| ((revIpInt >= IP2Num("233.252.0.0")) && (revIpInt <= IP2Num("233.255.255.255")))) 
	{
		invalidIPFlag = true;
		/*if(language == ENGLISH)
		{
			//alert("<Receive IP Address> is invalid!");
		}
		else if(language == CHINESE)
		{
			//alert("<接收IP地址>是不合法的！");
		}
		//setTimeout(function () {$("#" + objIdArray[IP] + index).focus()}, 0);
		//setTimeout(function () {$("#" + objIdArray[IP] + index).select()}, 0);
		//return false;*/
	}
	returnFlag = ValidateParam($("#" + objIdArray[PORT] + index), "INT_DEC", 1, 65535, "<Receive UDP Port>", "<接收UDP端口>", language);
	if(returnFlag == false)
	{
		return false;
	}
	/*if(parseInt($("#protocol" + index).val(), 10) == RTP)
	{
		if((parseInt($("#" + objIdArray[PORT] + index).val(), 10) % 2) != 0)
		{
			if(language == ENGLISH)
			{
				alert("If current protocol is RTP, UDP port should be even!");
			}
			else if(language == CHINESE)
			{
				alert("网络传输协议为RTP时，UDP端口号必须为偶数！");
			}
			return false;
		}
	}*/
	returnFlag = ValidateParam($("#" + objIdArray[REF_RATE] + index), "INT_DEC", 0, 200000000, "<Reference Bitrate(bps)>", "<基准码率(bps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateIP($("#" + objIdArray[SOURCE_IP_1] + index), "SOURCE_IP", "<Source IP Address 1>", "<源IP地址1>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateIP($("#" + objIdArray[SOURCE_IP_2] + index), "SOURCE_IP", "<Source IP Address 2>", "<源IP地址2>", language);
	if(returnFlag == false)
	{
		return false;
	}
	return true;
}

function deletePort()
{
	var data;
	var rowData;
	var rowInfo;
	var confirmPrompt;
	var xmlHttp = GetHTTPObject();
	var response;
	var deletePort = "";
	var deleteNum = 0;
	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete the selected ports?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除选中端口吗？";
	}
	
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + GBE_IN_CONFIG + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
		
		for(var i = 0; i < rowNum; i++)
		{
			rowData = dataArray[i].split(SECOND_DELIMITER);
			rowInfo = rowData[INFO].split(",");
			if(rowInfo[CHECK] == CHECK_STRING)
			{
				if(deleteNum == 0)
				{
					deletePort = rowData[PORT_NO];
				}
				else
				{
					deletePort += FIRST_DELIMITER + rowData[PORT_NO];
				}
				deleteNum++;
			}
		}
		if(deleteNum == 0)
		{
			if(language == ENGLISH)
			{
				alert("Please select one port at least!");
			}
			else
			{
				alert("请至少选中一个端口！");
			}
			return;
		}
		data += deletePort;
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("The selected ports are deleted successfully!");
					}
					else if(language == CHINESE)
					{
						alert("选中端口删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function deleteAll()
{
	var confirmPrompt;
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(rowNum == 0)
	{
		if(language == ENGLISH)
		{
			alert("The port number is 0!");
		}
		else if(language == CHINESE)
		{
			alert("端口个数是0！");
		}
		return;
	}
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete all the ports?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除全部端口吗？";
	}
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + GBE_IN_CONFIG + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=0xffff";
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("All the ports are deleted successfully!");
					}
					else if(language == CHINESE)
					{
						alert("所有端口删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function addPort()
{
	$("#addPortNum").val("1");
	$("#addIpStart").val(identifyData);
	$("#addIpStep").val("0");
	$("#addPortStart").val("1234");
	$("#addPortStep").val("1");
	$("#addProtocol").val("0");
	$("#addAlarmSwitch").val("1");
	
	$("#addPort").modal();
}

function modifyPort()
{
	if(curTab == BASIC)
	{
		$("#modifyIpStart").val(identifyData);
		$("#modifyIpCheck").prop("checked", false);
		$("#modifyIpStep").val("0");
		$("#modifyUdpPort").val("1234");
		$("#modifyPortCheck").prop("checked", false);
		$("#modifyProtocol").val("0");
		$("#modifyProtocolCheck").prop("checked", false);
		$("#modifyAlarmSwitch").val("1");
		$("#modifyAlarmSwitchCheck").prop("checked", false);
		$("#modifyBufferSize").val("1");
		$("#modifyBufferSizeCheck").prop("checked", false);
	}
	else if(curTab == BITRATE)
	{
		$("#modifyRefSwitch").val("0");
		$("#modifyRefSwitchCheck").prop("checked", false);
		$("#modifyRefRate").val("0");
		$("#modifyRefRateCheck").prop("checked", false);
	}
	else if(curTab == IGMP)
	{
		$("#modifyRecMode").val("1");
		$("#modifyRecModeCheck").prop("checked", false);
		$("#modifySrcIp1").val("0.0.0.0");
		$("#modifySrcIp1Check").prop("checked", false);
		$("#modifySrcIp2").val("0.0.0.0");
		$("#modifySrcIp2Check").prop("checked", false);
	}
	
	$("#modifyPort").modal();
}

function addPortApply()
{
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(validateBeforeAddApply() == false)
	{
		return;
	}
	if(invalidIPFlag)
	{
		if(language == ENGLISH)
		{
			var confirmPrompt = "The <Receive IP Address> is a standard reserved address, which may affect the service!";
		}
		else if(language == CHINESE)
		{
			var confirmPrompt = "接收地址为标准保留地址，强制使用可能会影响到业务！";
		}	
	}
	if((!invalidIPFlag) || (window.confirm(confirmPrompt))){
		data = "type=" + GBE_IN_CONFIG + "&cmd=" + ADD + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	
		data += $("#addPortNum").val() + FIRST_DELIMITER + $("#addIpStart").val() + FIRST_DELIMITER + $("#addIpStep").val() + FIRST_DELIMITER + $("#addPortStart").val() + FIRST_DELIMITER + $("#addPortStep").val() + FIRST_DELIMITER + $("#addProtocol").val() + FIRST_DELIMITER + $("#addAlarmSwitch").val();
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				$.modal.close();
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("The ports are added successfully!");
					}
					else if(language == CHINESE)
					{
						alert("端口添加成功！")
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function validateBeforeAddApply()
{
 	var returnFlag;
	var addPortNum = parseInt($("#addPortNum").val(), 10);
	var addIpStart = $("#addIpStart").val();
	var addIpStartFeilds = addIpStart.split(".");
	var addIpStartHost = parseInt(addIpStartFeilds[3], 10);
	var addIpStep = parseInt($("#addIpStep").val(), 10);
	var addPortStart = parseInt($("#addPortStart").val(), 10);
	var addPortStep = parseInt($("#addPortStep").val(), 10);
	var addProtocol = parseInt($("#addProtocol").val(), 10);
	var maxAddIpHost = addIpStartHost + addIpStep * (addPortNum - 1);
	var maxAddPort = addPortStart + addPortStep * (addPortNum - 1);
	
	if(rowNum == 256)
	{
		if(language == ENGLISH)
		{
			alert("The port number is 256, can't add a new port!");
		}
		else if(language == CHINESE)
		{
			alert("端口个数已经是最大值256个，不能再添加新的端口！");
		}
		return false;
	}
	else
	{
		returnFlag = ValidateParam($("#addPortNum"), "INT_DEC", 1, (256 - rowNum), "<Add Port Number>", "<添加端口个数>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	
	returnFlag = ValidateIP($("#addIpStart"), "IP_ADDR", "<Receive IP Address>", "<接收IP地址>", language);
	if(returnFlag == false)
	{
		return false;
	}
	var revIpInt = IP2Num($("#addIpStart").val());
	if(((revIpInt >= IP2Num("224.0.0.0")) && (revIpInt < IP2Num("224.1.0.0")))
		||((revIpInt >= IP2Num("224.3.0.0")) && (revIpInt <= IP2Num("224.4.255.255")))
		|| ((revIpInt >= IP2Num("233.252.0.0")) && (revIpInt <= IP2Num("233.255.255.255")))) 
	{
		invalidIPFlag = true;
	}
	if(addIpStartFeilds[0] < 224)
	{
		if(addPortNum != 1)
		{
			if(parseInt($("#addIpStep").val(), 10) != 0)
			{
				if(language == ENGLISH)
				{
					alert("If receive ip address is a unicast address,the ip step value must be 0!");
					return false;
				}
				else
				{
					alert("接收IP为单播地址，IP步进值只能为0！");
					return false;
				}
			}
		}
	}
	returnFlag = ValidateParam($("#addIpStep"), "INT_DEC", 0, 255, "<IP Address Step Value>", "<IP地址步进值>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	if((maxAddIpHost < 0) || (maxAddIpHost > 255))
	{
		if(language == ENGLISH)
		{
			alert("IP address should be valid!");
		}
		else if(language == CHINESE)
		{
			alert("添加端口后，必须保证IP地址为合法地址！");
		}
		return false;
	}
	returnFlag = ValidateParam($("#addPortStart"), "INT_DEC", 1, 65535, "<Receive UDP Port>", "<接收UDP端口>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#addPortStep"), "INT_DEC", 0, 65534, "<UDP Port Step Value>", "<UDP端口步进值>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	if((maxAddPort < 1) || (maxAddPort > 65535))
	{
		if(language == ENGLISH)
		{
			alert("All Receive Ports should be between 1 and 65535!");
		}
		else if(language == CHINESE)
		{
			alert("添加端口后，UDP端口号必须在1~65535之间！");
		}
		return false;
	}
	
	/*if(addProtocol == RTP)
	{
		if(((addPortStart % 2) != 0) || ((addPortNum != 1) && ((addPortStep % 2) != 0)))
		{
			if(language == ENGLISH)
			{
				alert("If current protocol is RTP, UDP port should be even!");
			}
			else if(language == CHINESE)
			{
				alert("网络传输协议为RTP时，UDP端口号必须为偶数！");
			}
			return false;
		}
	}*/
	if((addPortNum != 1) && (addIpStep == 0) && (addPortStep == 0))
	{
		if(language == ENGLISH)
		{
			alert("Cannot add the same receive IP and UDP port to different ports!");
		}
		else
		{
			alert("不能添加接收IP和UDP端口相同的端口！");
		}
		return false;
	}
	return true;
}

function cancelAdd()
{
	$.modal.close();
}

function modifyPortApply()
{
 	var returnFlag;
	var rowData;
	var rowInfo;
	
	var modifyIpStart = $("#modifyIpStart").val();
	var modifyIpStartFeilds = modifyIpStart.split(".");
	var modifyIpStartHost = parseInt(modifyIpStartFeilds[3], 10);
	var modifyIpCheck = $("#modifyIpCheck").prop("checked");
	var modifyIpStep = parseInt($("#modifyIpStep").val(), 10);
	var maxModifyIpHost;
	
	var modifyPortStart = parseInt($("#modifyUdpPort").val(), 10);
	var modifyPortCheck = $("#modifyPortCheck").prop("checked");
	var modifyPortStep = parseInt($("#modifyPortStep").val(), 10);
	var maxModifyPort;
	
	var modifyProtocol = parseInt($("#modifyProtocol").val(), 10);
	var modifyProtocolCheck = $("#modifyProtocolCheck").prop("checked");
	
	var modifyAlarmSwitch = parseInt($("#modifyAlarmSwitch").val(), 10);
	var modifyAlarmSwitchCheck = $("#modifyAlarmSwitchCheck").prop("checked");
	
	var modifyBufferSize = parseInt($("#modifyBufferSize").val(), 10);
	var modifyBufferSizeCheck = $("#modifyBufferSizeCheck").prop("checked");
	
	var modifyRefSwitch = parseInt($("#modifyRefSwitch").val(), 10);
	var modifyRefSwitchCheck = $("#modifyRefSwitchCheck").prop("checked");
	
	var modifyRefRate = parseInt($("#modifyRefRate").val(), 10);
	var modifyRefRateCheck = $("#modifyRefRateCheck").prop("checked");
	
	var modifyRecMode = parseInt($("#modifyRecMode").val(), 10);
	var modifyRecModeCheck = $("#modifyRecModeCheck").prop("checked");
	
	var modifySrcIp1 = $("#modifySrcIp1").val();
	var modifySrcIp1Check = $("#modifySrcIp1Check").prop("checked");
	
	var modifySrcIp2 = $("#modifySrcIp2").val();
	var modifySrcIp2Check = $("#modifySrcIp2Check").prop("checked");
	
	var checkedIndex = 0;
	var checkedRowNum = 0;
	var modifyIpHost;
	var modifyIp;
	var modifyPort;
	
	var i;
	
	var newRowInfo;
	var newString;
	
	for(i = 0; i < rowNum; i++)
	{
		rowData = dataArray[i].split(SECOND_DELIMITER);
		rowInfo = rowData[INFO].split(",");
		if(rowInfo[CHECK] == CHECK_STRING)
		{
			checkedRowNum++;
		}
	}
	
	maxModifyIpHost = modifyIpStartHost + modifyIpStep * (checkedRowNum - 1);
	maxModifyPort = modifyPortStart + modifyPortStep * (checkedRowNum - 1);
	
	if(curTab == BASIC)
	{
		if(modifyIpCheck)
		{
			returnFlag = ValidateIP($("#modifyIpStart"), "IP_ADDR", "<Receive IP Address>", "<接收IP地址>", language);
			if(returnFlag == false)
			{
				return false;
			}
			/*var revIpInt = IP2Num($("#modifyIpStart").val());
			if(((revIpInt >= IP2Num("224.0.0.0")) && (revIpInt < IP2Num("224.1.0.0")))
				||((revIpInt >= IP2Num("224.3.0.0")) && (revIpInt <= IP2Num("224.4.255.255")))
				|| ((revIpInt >= IP2Num("233.252.0.0")) && (revIpInt <= IP2Num("233.255.255.255")))) 
			{
				if(language == ENGLISH)
				{
					alert("<Receive IP Address> is invalid!");
				}
				else if(language == CHINESE)
				{
					alert("<接收IP地址>是不合法的！");
				}
				setTimeout(function () {$("#modifyIpStart").focus()}, 0);
				setTimeout(function () {$("#modifyIpStart").select()}, 0);
				return false;
			}*/
			if(modifyIpStartFeilds[0] < 224)
			{
				if(checkedRowNum > 1)
				{
					if(parseInt($("#modifyIpStep").val(), 10) != 0)
					{
						if(language == ENGLISH)
						{
							alert("If receive ip address is a unicast address,the ip step value must be 0!");
							return false;
						}
						else
						{
							alert("接收IP为单播地址，IP步进值只能为0！");
							return false;
						}
					}
				}
			}
			returnFlag = ValidateParam($("#modifyIpStep"), "INT_DEC", 0, 255, "<IP Address Step Value>", "<IP地址步进值>", language);
			if(returnFlag == false)
			{
				return false;
			}
			if((maxModifyIpHost < 0) || (maxModifyIpHost > 255))
			{
				if(language == ENGLISH)
				{
					alert("IP address should be valid!");
				}
				else if(language == CHINESE)
				{
					alert("修改端口后，必须保证IP地址为合法地址！");
				}
				return false;
			}
		}
		if(modifyPortCheck)
		{
			returnFlag = ValidateParam($("#modifyUdpPort"), "INT_DEC", 1, 65535, "<Receive UDP Port>", "<接收UDP端口>", language);
			if(returnFlag == false)
			{
				return false;
			}
			if((maxModifyPort < 1) || (maxModifyPort > 65535))
			{
				if(language == ENGLISH)
				{
					alert("UDP port should be valid!");
				}
				else if(language == CHINESE)
				{
					alert("修改端口后，必须保证UDP端口号合法！");
				}
				return false;
			}
			if((modifyProtocolCheck) && (modifyProtocol == RTP))
			{
				/*if((modifyPortStart % 2) != 0)
				{
					if(language == ENGLISH)
					{
						alert("If current protocol is RTP, UDP port should be even!");
					}
					else if(language == CHINESE)
					{
						alert("网络传输协议为RTP时，UDP端口号必须为偶数！");
					}
					return false;
				}
				else
				{
					if(checkedRowNum > 1)
					{
						if((modifyPortStep % 2) != 0)
						{
							if(language == ENGLISH)
							{
								alert("If current protocol is RTP, UDP port should be even!");
							}
							else if(language == CHINESE)
							{
								alert("网络传输协议为RTP时，UDP端口号必须为偶数！");
							}
							return false;
						}
					}
				}*/
			}
		}
		if(modifyIpCheck && modifyPortCheck && (modifyIpStep == 0) && (modifyPortStep == 0))
		{
			if(checkedRowNum > 1)
			{
				if(language == ENGLISH)
				{
					alert("Cannot add the same receive IP and UDP port to different ports!");
				}
				else
				{
					alert("不能添加接收IP和UDP端口相同的端口！");
				}
				return false;
			}			
		}
	}
	else if(curTab == BITRATE)
	{
		if(modifyRefRateCheck)
		{
			returnFlag = ValidateParam($("#modifyRefRate"), "INT_DEC", 0, 200000000, "<Reference Bitrate(bps)>", "<端口基准码率(bps)>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
	}
	else if(curTab == IGMP)
	{
		if(modifySrcIp1Check)
		{
			returnFlag = ValidateIP($("#modifySrcIp1"), "SOURCE_IP", "<Source IP Address 1>", "<源IP地址1>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
		if(modifySrcIp2Check)
		{
			returnFlag = ValidateIP($("#modifySrcIp2"), "SOURCE_IP", "<Source IP Address 2>", "<源IP地址2>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
	}
	
	for(i = 0; i < rowNum; i++)
	{
		rowData = dataArray[i].split(SECOND_DELIMITER);
		rowInfo = rowData[INFO].split(",");
		if(rowInfo[CHECK] == CHECK_STRING)
		{
			checkedIndex++;
			if(curTab == BASIC)
			{

				if(modifyIpCheck)
				{
					modifyIpHost = modifyIpStartHost + modifyIpStep * (checkedIndex - 1);
					modifyIpStartFeilds[3] = modifyIpHost;
					modifyIp = modifyIpStartFeilds.join(".");
					rowData[IP] = modifyIp;
				}
				if(modifyPortCheck)
				{
					modifyPort = modifyPortStart + modifyPortStep * (checkedIndex - 1);
					rowData[PORT] = modifyPort;
				}
				if(modifyProtocolCheck)
				{
					rowData[PROTOCOL] = modifyProtocol;
				}
				if(modifyAlarmSwitchCheck)
				{
					rowData[ALARM_SWITCH] = modifyAlarmSwitch;
				}
				if(modifyBufferSizeCheck)
				{
					rowData[BUFFER_SIZE] = modifyBufferSize;
				}
			}
			else if(curTab == BITRATE)
			{
				if(modifyRefSwitchCheck)
				{
					rowData[REF_SWITCH] = modifyRefSwitch;
				}
				if(modifyRefRateCheck)
				{
					rowData[REF_RATE] = modifyRefRate;
				}
			}
			else if(curTab == IGMP)
			{
				if(modifyRecModeCheck)
				{
					rowData[RECEIVE_MODE] = modifyRecMode;
				}
				if(modifySrcIp1Check)
				{
					rowData[SOURCE_IP_1] = modifySrcIp1;
				}
				if(modifySrcIp2Check)
				{
					rowData[SOURCE_IP_2] = modifySrcIp2;
				}
			}
			rowInfo[CHANGE] = CHANGE_STRING;
			newRowInfo = rowInfo[CHECK] + "," + rowInfo[CHANGE];
			newString = newRowInfo;
			for(var j = PORT_NO; j < COL_NUM; j++)
			{
				newString += SECOND_DELIMITER + rowData[j];
			}
			dataArray[i] = newString;
		}
	}
	
	$.modal.close();
	updateTableData();
	EnableButton("applyBtn");
	return true;
}

function cancelModify()
{
	$.modal.close();
}