﻿var tabIdArray = ["basic", "ip", "backup", "vlan","other"];
var TAB_NUM = 5;

var objIdArray = ["", "", "name", "ip", "port", "sourceIp", "rateMode", "sysRate", "pktFormat", "protocol", "alarmSwitch", "outputSwitch", "TTL", "TOS", "pktNum", "group", "minRate", "maxRate", "vlanSwitch", "vlanPriority", "vlanId","noBitrateThreshold"];
var COL_NUM = 22;
var INFO = 0;
var PORT_NO = 1;
var NAME = 2;
var IP = 3;
var PORT = 4;
var SOURCE_IP = 5;
var RATE_MODE = 6;
var SYSTEM_RATE = 7;
var PKT_FORMAT = 8;
var PROTOCOL = 9;
var ALARM_SWITCH = 10;
var OUT_SWITCH = 11;
var TTL = 12;
var TOS = 13;
var PKT_NUM = 14;
var GROUP = 15;
var MIN_RATE = 16;
var MAX_RATE = 17;
var VLAN_SWITCH = 18;
var PRIORITY = 19;
var VLAN_ID = 20;
var NO_BITRATE_THRESHOLD = 21;

var dataArray = [];

var CHECK = 0;
var CHANGE = 1;

var NORMAL_STRING = "N";
var CHECK_STRING = "C";
var CHANGE_STRING = "M";

var BASIC = 0;
var IP_PKT = 1;
var TAB_PORT_BACKUP = 2;
var TAB_VLAN = 3;
var TAB_OTHER = 4;
var charNumOfRowId = [12, 9, 13, 11,12];
var curTab = BASIC;

var RTP = 1;

var NO_PORT_BACKUP = 0;
var PORT_BACKUP = 1;

var CBR = 0;
var VBR = 1;
var OFF = 0;
var ON = 1;

var curRespRowNum;
var rowNum = 0;
var initRow = true;
var rowIndex;
var curGbeIpAddress;
var sourceIpFlag; //0:使用网口IP(源IP全部置灰)；1：使用端口的源IP
var GBE_IP = 0;
var invalidIPFlag = false;
window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	displayMenu();
	funcUpdateDisplay();
	
	for(var i = 0; i < TAB_NUM; i++)
	{
		AddTabMouseAction(tabIdArray[i]);
	}
});

function funcUpdateDisplay() 
{
	invalidIPFlag = false;	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	DisableButton("addBtn");
	DisableButton("deleteBtn");
	DisableButton("deleteAllBtn");
	DisableButton("modifyBtn");
	$("input[type=checkbox]").attr("disabled", true);
	PageLoadStatus(true);
	dataArray = [];
	
	displayParam();
	
	ResetColor();
	PageLoadStatus(false);
	
	$("input[type=checkbox]").prop("checked", false);
	
}

function changeRateStatus(obj)
{
	var index = GetIndexFromId(obj, charNumOfRowId[curTab]);
	if(parseInt(obj.val(), 10) == CBR)
	{
		$("#sysRate" + index).attr("disabled", false);
	}
	else
	{
		$("#sysRate" + index).attr("disabled", true);
	}
}

function changeVlanParamStatus(obj)
{
	var index = GetIndexFromId(obj, charNumOfRowId[TAB_VLAN]);
	if(parseInt(obj.val(), 10) == ON)
	{
		$("#vlanPriority" + index).attr("disabled", false);
		$("#vlanId" + index).attr("disabled", false);
	}
	else
	{
		$("#vlanPriority" + index).attr("disabled", true);
		$("#vlanId" + index).attr("disabled", true);
	}
}

function changeRowChecked(obj)
{
	var rowIndex;
	var flag;
	
	if(parent.groupAccess != USER)
	{
		EnableButton("deleteBtn");
		if(((portNo != 2) && (portNo != 3)) || (curTab != IP_PKT))//备份网口时，IP_PKT标签下的参数均不可设，置灰Modify按钮
		{
			EnableButton("modifyBtn");
		}
	}
	
	rowIndex = GetIndexFromId(obj, charNumOfRowId[curTab]) - 1;
	flag = obj.prop("checked");
	changeRowInfo(rowIndex, flag);
}

function changeRowInfo(rowIndex, flag)
{
	var rowData = dataArray[rowIndex].split(SECOND_DELIMITER);
	var rowInfo = rowData[INFO].split(",");
	var newRowInfo;
	var newString;
	
	if(flag == true)
	{
		rowInfo[CHECK] = CHECK_STRING;
	}
	else
	{
		rowInfo[CHECK] = NORMAL_STRING;
	}
	newRowInfo = rowInfo[CHECK] + "," + rowInfo[CHANGE];
	newString = newRowInfo;
	for(var i = PORT_NO; i < COL_NUM; i++)
	{
		newString += SECOND_DELIMITER + rowData[i];
	}
	dataArray[rowIndex] = newString;
}

function checkAll()
{
	var flag = $("#" + tabIdArray[curTab] + "CheckAll").prop("checked");
	for(var i = 0; i < rowNum; i++)
	{
		$("#" + tabIdArray[curTab] + "Check" + (i + 1)).prop("checked", flag);
		changeRowInfo(i, flag);
	}
	if(parent.groupAccess != USER)
	{
		EnableButton("deleteBtn");
		if(((portNo != 2) && (portNo != 3)) || (curTab != IP_PKT))//备份网口时，IP_PKT标签下的参数均不可设，置灰Modify按钮
		{
			EnableButton("modifyBtn");
		}
	}
}

function displayParam() 
{
	var data;
	var i;
	var response;
	var indexInfo;
	var curRowNum;
	var rowData;
	var xmlHttp = GetHTTPObject();

	if(initRow)
	{
		rowIndex = 0;
	}
	xmlHttp.open("GET", "/goform/formEMR30?type=" + GBE_OUT_CONFIG + "&cmd=" + GET + "&rowIndex=" + rowIndex +
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				var timeObj = new Date();
				startRefreshTime = timeObj.getTime();
				initRow = false;
				data = response.split(FIRST_DELIMITER);
				curRespRowNum = data.length - 4;
				indexInfo = data[curRespRowNum].split(SECOND_DELIMITER);
				rowIndex = parseInt(indexInfo[0], 10);
				rowNum = parseInt(indexInfo[1], 10);
				identifyData = data[curRespRowNum + 1];
				curGbeIpAddress = data[curRespRowNum + 2];
				sourceIpFlag = data[curRespRowNum + 3];
				curRowNum = $("#basicTable" + " tr").filter(".basicCaseRow").length;
				if(identifyData == NO_PORT_BACKUP)
				{
					$("#backup").css("display", "none");
				}
				else
				{
					$("#backup").css("display", "");
				}
				if((curRowNum < rowNum) && (curRowNum < rowIndex))
				{
					for(i = 0; i < TAB_NUM; i++)
					{
						DrawTableRow((tabIdArray[i] + "Table"), (tabIdArray[i] + "DataRow"), (tabIdArray[i] + "CaseRow"), rowIndex);
					}
				}
				else if(curRowNum > rowNum)
				{
					for(i = 0; i < TAB_NUM; i++)
					{
						DrawTableRow((tabIdArray[i] + "Table"), (tabIdArray[i] + "DataRow"), (tabIdArray[i] + "CaseRow"), rowNum);
					}
				}
				if(curRespRowNum != 0)
				{
					var saveString = "";
					for(i = 0; i < curRespRowNum; i++)
					{
						saveString = NORMAL_STRING + "," + NORMAL_STRING + SECOND_DELIMITER + data[i];
						dataArray.push(saveString);
					}
					for(i = (rowIndex - curRespRowNum); i < rowIndex; i++)
					{
						rowData = dataArray[i].split(SECOND_DELIMITER);
						for(var j = PORT_NO; j < COL_NUM; j++)
						{
							if(j == PORT_NO)
							{
								for(var k = 0; k < TAB_NUM; k++)
								{
									$("#" + tabIdArray[k] + "Port" + (i + 1)).html(rowData[j]);
								}
							}
							else
							{
								$("#" + objIdArray[j] + (i + 1)).val(rowData[j]);
							}
						}
						changeVlanParamStatus($("#vlanSwitch" + (i + 1)));
						if((portNo == 2) || (portNo == 3)) //备份网口时，码率模式、系统码率、协议、输出包长、TTL、服务类型、TS包个数均置灰不可设
						{
							$("#" + objIdArray[SOURCE_IP] + (i + 1)).attr("disabled", false);
							$("#" + objIdArray[RATE_MODE] + (i + 1)).attr("disabled", true);
							$("#" + objIdArray[SYSTEM_RATE] + (i + 1)).attr("disabled", true);
							$("#" + objIdArray[PKT_FORMAT] + (i + 1)).attr("disabled", true);
							$("#" + objIdArray[PROTOCOL] + (i + 1)).attr("disabled", true);
							$("#" + objIdArray[TTL] + (i + 1)).attr("disabled", true);
							$("#" + objIdArray[TOS] + (i + 1)).attr("disabled", true);
							$("#" + objIdArray[PKT_NUM] + (i + 1)).attr("disabled", true);							
						}
						else
						{
							$("#" + objIdArray[SOURCE_IP] + (i + 1)).attr("disabled", false);
							$("#" + objIdArray[RATE_MODE] + (i + 1)).attr("disabled", false);
							changeRateStatus($("#rateMode" + (i + 1)));
							$("#" + objIdArray[PKT_FORMAT] + (i + 1)).attr("disabled", false);
							$("#" + objIdArray[PROTOCOL] + (i + 1)).attr("disabled", false);
							$("#" + objIdArray[TTL] + (i + 1)).attr("disabled", false);
							$("#" + objIdArray[TOS] + (i + 1)).attr("disabled", false);
							$("#" + objIdArray[PKT_NUM] + (i + 1)).attr("disabled", false);
						}
						if(sourceIpFlag == GBE_IP)
						{
							$("#" + objIdArray[SOURCE_IP] + (i + 1)).attr("disabled", true);
						}
						else
						{
							$("#" + objIdArray[SOURCE_IP] + (i + 1)).attr("disabled", false);
						}
					}
				}
				if(rowIndex < rowNum)
				{
					setTimeout("displayParam()", 5);
				}
				else if(rowIndex == rowNum)
				{
					EnableButton("refreshBtn");
					if(parent.groupAccess != USER)
					{
						EnableButton("addBtn");
						EnableButton("deleteAllBtn");
					}
					$("input[type=checkbox]").attr("disabled", false);
					initRow = true;
					refreshFlag = true;
				}
			}
		}
	}
	xmlHttp.send(null);
}

function updateTableData()
{
	var rowData;
	
	for(var i = 0; i < rowNum; i++)
	{
		rowData = dataArray[i].split(SECOND_DELIMITER);
		for(var j = PORT_NO; j < COL_NUM; j++)
		{
			if(j == PORT_NO)
			{
				for(var k = 0; k < TAB_NUM; k++)
				{
					$("#" + tabIdArray[k] + "Port" + (i + 1)).html(rowData[j]);
				}
			}
			else
			{
				$("#" + objIdArray[j] + (i + 1)).val(rowData[j]);
			}
		}
	}
}

function disableAddAndDel(flag)
{
	if(flag == true)
	{
		$("#addBtn").css("display", "none");
		$("#deleteBtn").css("display", "none");
		$("#deleteAllBtn").css("display", "none");
		$("#buttonArea").css("width", "234px");
	}
	else
	{
		$("#addBtn").css("display", "");
		$("#deleteBtn").css("display", "");
		$("#deleteAllBtn").css("display", "");
		$("#buttonArea").css("width", "468px");
	}
}
//标签切换跳转
function tableChange(type)
{
	if(type == curTab)
	{
		return;
	}
	
	if(type == BASIC)
	{
		disableAddAndDel(false);
	}
	else
	{
		disableAddAndDel(true);
	}
	
	if(((portNo == 2) || (portNo == 3)) &&(type == IP_PKT))//备份网口时，IP_PKT标签下的参数均不可设，置灰Modify按钮 
	{
		DisableButton("modifyBtn");
	}
	
	$("#" + tabIdArray[curTab] + "Table").css("display", "none");
	$("#" + tabIdArray[curTab] + "ModifyTable").css("display", "none");
	$("#" + tabIdArray[curTab]).attr("class", "table_header_normal");
	
	curTab = type;
	$("#" + tabIdArray[curTab] + "Table").css("display", "");
	$("#" + tabIdArray[curTab] + "ModifyTable").css("display", "");
	$("#" + tabIdArray[curTab]).attr("class", "table_header_select");
}

function pageApply()
{
	var data = "type=" + GBE_OUT_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	var editNum = 0;
	var rowData;
	var newString;
	var rowInfo;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(identifyData == PORT_BACKUP)
	{
		if(validatePortNum() == false)
		{
			return;
		}
	}
	if(validateBitrate() == false)
	{
		return;
	}
	for(var i = 0; i < rowNum; i++)
	{
		rowData = dataArray[i].split(SECOND_DELIMITER);
		rowInfo = rowData[INFO].split(",");
		if(rowInfo[CHANGE] == CHANGE_STRING)
		{
			if(validateBeforeApply(i) == false)
			{
				return;
			}
			for(var j = PORT_NO; j < COL_NUM; j++)
			{
				if(j == PORT_NO)
				{
					newString = rowData[j];
				}
				else
				{
					newString += SECOND_DELIMITER + rowData[j].replace(/\+/g, "%2B").replace(/\&/g, "%26");
				}
			}
			if(editNum == 0)
			{
				data += newString;
			}
			else
			{
				data += FIRST_DELIMITER + newString;
			}
			editNum++;
		}
	}
	if(invalidIPFlag)
	{
		if(language == ENGLISH)
		{
			var confirmPrompt = "The <Destination IP Address> is a standard reserved address, which may affect the service!";
		}
		else
		{
			var confirmPrompt = "目的IP地址为标准保留地址，强制使用可能会影响到业务！";
		}
	}
	if((!invalidIPFlag) || (window.confirm(confirmPrompt))){
		if(editNum == 0)
		{
			funcUpdateDisplay();
			return;
		}
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					applyFlag = true;
				}
				else
				{
					alert(returnError[language][response]);
				}
				GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
				applyFlag = false;  //设置标识符恢复为false
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function validatePortNum()
{
	var backupGroup = [0, 0, 0, 0, 0, 0, 0, 0];
	for(var i = 0; i < rowNum; i++)
	{
		backupGroup[parseInt($("#" + objIdArray[GROUP] + (i + 1)).val(), 10)]++;
	}
	for(var i = 0; i < 8; i++)
	{
		if(backupGroup[i] > 32)
		{
			if(language == ENGLISH)
			{
				alert("The output port number of backup group " + (i + 1) + " is more than 32!");
			}
			else
			{
				alert("端口备份组" + (i + 1) + "的输出端口个数超过了32个！");
			}
			return false;
		}
	}
	return true;
}

function validateBitrate()
{
	var totalRate = 0;
	
	for(var i = 0; i < rowNum; i++)
	{
		totalRate += parseInt($("#sysRate" + (i + 1)).val(), 10);
	}
	if(totalRate > 900000000)
	{
		if(language == ENGLISH)
		{
			alert("The summary of all total bitrate cann't be larger than 900Mbps!");
		}
		else
		{
			alert("所有端口的系统码率和不得大于900Mbps!");
		}
		return false;	
	}
	return true;
}

function changeCellValue(obj)
{
	var id = obj.attr("id");
	var rowIndex = GetIndexFromId(obj, charNumOfRowId[curTab]) - 1;
	var fieldIndex;
	var rowData = dataArray[rowIndex].split(SECOND_DELIMITER);
	var rowInfo = rowData[INFO].split(",");
	var newRowInfo;
	var newString;

	for(var i = NAME; i < COL_NUM; i++)
	{
		if(id.indexOf(objIdArray[i]) != -1)
		{
			fieldIndex = i;
			break;
		}
	}
	rowData[fieldIndex] = obj.val();
	rowInfo[CHANGE] = CHANGE_STRING;
	newRowInfo = rowInfo[CHECK] + "," + rowInfo[CHANGE];
	newString = newRowInfo;
	for(var i = PORT_NO; i < COL_NUM; i++)
	{
		newString += SECOND_DELIMITER + rowData[i];
	}
	dataArray[rowIndex] = newString;
}

function validateBeforeApply(rowIndex)
{
 	var returnFlag;
	var index = rowIndex + 1;
	
	returnFlag = ValidateParam($("#" + objIdArray[NAME] + index), "LENGTH", 1, 31, "<Name>", "<名称>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateName($("#" + objIdArray[NAME] + index), language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateIP($("#" + objIdArray[IP] + index) , "IP_ADDR", "<Destination IP>", "<目的IP>", language);
	if(returnFlag == false)
	{
		return false;
	}
	var revIpInt = IP2Num($("#" + objIdArray[IP] + index).val());
	if(((revIpInt >= IP2Num("224.0.0.0")) && (revIpInt < IP2Num("224.1.0.0")))
		||((revIpInt >= IP2Num("224.3.0.0")) && (revIpInt <= IP2Num("224.4.255.255")))
		|| ((revIpInt >= IP2Num("233.252.0.0")) && (revIpInt <= IP2Num("233.255.255.255")))) 
	{
		invalidIPFlag = true;
	}
	returnFlag = ValidateParam($("#" + objIdArray[PORT] + index), "INT_DEC", 1, 65535, "<Destination UDP Port>", "<目的UDP端口>", language);
	if(returnFlag == false)
	{
		return false;
	}
	/*if(parseInt($("#protocol" + index).val(), 10) == RTP)
	{
		if((parseInt($("#" + objIdArray[PORT] + index).val(), 10) % 2) != 0)
		{
			if(language == ENGLISH)
			{
				alert("If current protocol is RTP, UDP port should be even!");
			}
			else if(language == CHINESE)
			{
				alert("网络传输协议为RTP时，UDP端口号必须为偶数！");
			}
			return false;
		}
	}*/
		returnFlag = ValidateIP($("#" + objIdArray[SOURCE_IP] + index) , "UNICAST_IP_ADDR", "<Source IP Address>", "<源IP地址>", language);
		if(returnFlag == false)
		{
			return false;
		}
	returnFlag = ValidateParam($("#" + objIdArray[SYSTEM_RATE] + index), "INT_DEC", 0, 200000000, "<Total Bitrate(bps)>", "<系统码率(bps)>", language);
	if(returnFlag == false)
	{
		return false;
	}

	returnFlag = ValidateParam($("#" + objIdArray[TTL] + index), "INT_DEC", 1, 255, "<Port TTL>", "<端口生存时间>", language);
	if(returnFlag == false)
	{
		return false;
	}

	returnFlag = ValidateParam($("#" + objIdArray[MIN_RATE] + index), "INT_DEC", 0, 200000000, "<Minrate Threshold(bps)>", "<最小码率阈值(bps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#" + objIdArray[MAX_RATE] + index), "INT_DEC", 0, 200000000, "<Maxrate Threshold(bps)>", "<最大码率阈值(bps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	if(parseInt($("#" + objIdArray[MIN_RATE] + index).val(), 10) > parseInt($("#" + objIdArray[MAX_RATE] + index).val(), 10))
	{
		if(language == ENGLISH)
		{
			alert("The minrate threshold is bigger than the maxrate threshold!");
		}
		else
		{
			alert("最小码率阈值不能大于最大码率阈值！");
		}
		return false;
	}
	returnFlag = ValidateParam($("#" + objIdArray[VLAN_ID] + index), "INT_DEC", 1, 4094, "<VLAN ID>", "<VLAN ID>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#" + objIdArray[NO_BITRATE_THRESHOLD] + index), "INT_DEC", 1, 200000, "<No Effective Bitrate Alarm Threshold (Kbps)>", "<无有效码率告警阈值(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	/*if(parseInt($("#" + objIdArray[NO_BITRATE_THRESHOLD] + index).val()) == 0){
		if(language == ENGLISH)
		{
			alert("No Effective Bitrate Alarm Threshold can not be 0!");
		}
		else
		{
			alert("无有效码率告警阈值不能为0！");
		}
		return false;
	}*/
	return true;
}

function deletePort()
{
	var data;
	var rowData;
	var rowInfo;
	var confirmPrompt;
	var xmlHttp = GetHTTPObject();
	var response;
	var deletePort = "";
	var deleteNum = 0;
	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete the selected ports?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除选中端口吗？";
	}
	
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + GBE_OUT_CONFIG + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
		
		for(var i = 0; i < rowNum; i++)
		{
			rowData = dataArray[i].split(SECOND_DELIMITER);
			rowInfo = rowData[INFO].split(",");
			if(rowInfo[CHECK] == CHECK_STRING)
			{
				if(deleteNum == 0)
				{
					deletePort = rowData[PORT_NO];
				}
				else
				{
					deletePort += FIRST_DELIMITER + rowData[PORT_NO];
				}
				deleteNum++;
			}
		}
		if(deleteNum == 0)
		{
			if(language == ENGLISH)
			{
				alert("Please select one port at least!");
			}
			else
			{
				alert("请至少选中一个端口！");
			}
			return;
		}
		data += deletePort;
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("The selected ports are deleted successfully!");
					}
					else if(language == CHINESE)
					{
						alert("选中端口删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function deleteAll()
{
	var confirmPrompt;
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(rowNum == 0)
	{
		if(language == ENGLISH)
		{
			alert("The port number is 0!");
		}
		else if(language == CHINESE)
		{
			alert("端口个数是0！");
		}
		return;
	}
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete all the ports?";
	}
	else if(language == CHINESE)
	{
		confirmPrompt = "确定要删除全部端口吗？";
	}
	if(window.confirm(confirmPrompt))
	{
		data = "type=" + GBE_OUT_CONFIG + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=0xffff";
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("All the ports are deleted successfully!");
					}
					else if(language == CHINESE)
					{
						alert("所有端口删除成功！");
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function addPort()
{
	$("#addPortNum").val("1");
	$("#addIpStart").val("192.168.1.101");
	$("#addIpStep").val("0");
	$("#addPortStart").val("1234");
	$("#addPortStep").val("1");
	$("#addSourceIp").val(curGbeIpAddress);
	$("#addSourceIpStep").val("0");
	if(sourceIpFlag == GBE_IP)
	{
		$("#addSourceIp").attr("disabled", true);
		$("#addSourceIpStep").attr("disabled", true);
	}
	else
	{
		$("#addSourceIp").attr("disabled", false);
		$("#addSourceIpStep").attr("disabled", false);
	}
	$("#addRateMode").val("0");
	$("#addSysRate").val("0");
	$("#addProtocol").val("0");
	$("#addAlarmSwitch").val("1");
	$("#addOutputSwitch").val("1");
	
	$("#addPort").modal();
}

function modifyPort()
{
	if(curTab == BASIC)
	{
		if((portNo == 2) || (portNo == 3))	//备份网口时，BASIC标签下的码率模式、系统码率、协议3个参数不可设，Modify时隐藏
		{
			$("#modifyRateModeTr").css("display", "none");
			$("#modifySysRateTr").css("display", "none");
			$("#modifyProtocolTr").css("display", "none");						
		}
		else
		{
			$("#modifyRateModeTr").css("display", "");
			$("#modifySysRateTr").css("display", "");
			$("#modifyProtocolTr").css("display", "");						
		}
		$("#modifyIpStart").val("192.168.1.101");
		$("#modifyIpCheck").prop("checked", false);
		$("#modifyIpStep").val("0");
		$("#modifyUdpPort").val("1234");
		$("#modifyPortCheck").prop("checked", false);
		$("#modifySourceIp").val(curGbeIpAddress);
		$("#modifySourceIpCheck").prop("checked", false);
		$("#modifySourceIpStep").val("0");
		if(sourceIpFlag == GBE_IP)
		{
			$("#modifySourceIp").attr("disabled", true);
			$("#modifySourceIpCheck").attr("disabled", true);
			$("#modifySourceIpStep").attr("disabled", true);
		}
		else
		{
			$("#modifySourceIp").attr("disabled", false);
			$("#modifySourceIpCheck").attr("disabled", false);
			$("#modifySourceIpStep").attr("disabled", false);
		}
		$("#modifyRateMode").val("0");
		$("#modifyRateModeCheck").prop("checked", false);
		$("#modifySysRate").val("0");
		$("#modifySysRateCheck").prop("checked", false);
		$("#modifyProtocol").val("0");
		$("#modifyProtocolCheck").prop("checked", false);
		$("#modifyAlarmSwitch").val("1");
		$("#modifyAlarmSwitchCheck").prop("checked", false);
		$("#modifyOutputSwitch").val("1");
		$("#modifyOutputSwitchCheck").prop("checked", false);
	}
	else if(curTab == IP_PKT)
	{
		$("#modifyPktFormat").val("0");
		$("#modifyPktFormatCheck").prop("checked", false);
		$("#modifyTTL").val("255");
		$("#modifyTTLCheck").prop("checked", false);
		$("#modifyTOS").val("0");
		$("#modifyTOSCheck").prop("checked", false);
		$("#modifyPktNum").val("7");
		$("#modifyPktNumCheck").prop("checked", false);
	}
	else if(curTab == TAB_PORT_BACKUP)
	{
		$("#modifyGroup").val("0");
		$("#modifyGroupCheck").prop("checked", false);
		$("#modifyMinRate").val("0");
		$("#modifyMinRateCheck").prop("checked", false);
		$("#modifyMaxRate").val("0");
		$("#modifyMaxRateCheck").prop("checked", false);
	}
	else if(curTab == TAB_VLAN)
	{
		$("#modifyVlanSwitch").val("0");
		$("#modifyVlanSwitchCheck").prop("checked", false);
		$("#modifyPriority").val("0");
		$("#modifyPriorityCheck").prop("checked", false);
		$("#modifyVlanId").val("0");
		$("#modifyVlanIdCheck").prop("checked", false);
	}
	else if(curTab == TAB_OTHER)
	{
		$("#modifyNoBitrateThreshold").val("100");
		$("#modifyNoBitrateThresholdCheck").prop("checked", false);
	}
	
	$("#modifyPort").modal();
}

function addPortApply()
{
	var data;
	var xmlHttp = GetHTTPObject();
	var response;
	
	if(validateBeforeAddApply() == false)
	{
		return;
	}
	if(invalidIPFlag)
	{
		if(language == ENGLISH)
		{
			var confirmPrompt = "The <Destination IP Address> is a standard reserved address, which may affect the service!";
		}
		else
		{
			var confirmPrompt = "目的IP地址为标准保留地址，强制使用可能会影响到业务！";
		}
	}
	if((!invalidIPFlag) || (window.confirm(confirmPrompt))){
		data = "type=" + GBE_OUT_CONFIG + "&cmd=" + ADD + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	
		data += $("#addPortNum").val() + FIRST_DELIMITER + $("#addIpStart").val() + FIRST_DELIMITER + $("#addIpStep").val() + FIRST_DELIMITER + $("#addPortStart").val() + FIRST_DELIMITER + $("#addPortStep").val() + FIRST_DELIMITER + $("#addSourceIp").val() + FIRST_DELIMITER + $("#addSourceIpStep").val() + FIRST_DELIMITER + $("#addRateMode").val() + FIRST_DELIMITER + $("#addSysRate").val() + FIRST_DELIMITER + $("#addProtocol").val() + FIRST_DELIMITER + $("#addAlarmSwitch").val() + FIRST_DELIMITER + $("#addOutputSwitch").val();
		
		xmlHttp.open("POST", "/goform/formEMR30", true)
		xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xmlHttp.setRequestHeader("Content-length", data.length);
	
		xmlHttp.onreadystatechange = function()
		{
			if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
			{
				$.modal.close();
				response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
				if(response == RETURN_OK)
				{
					if(language == ENGLISH)
					{
						alert("The ports are added successfully!");
					}
					else if(language == CHINESE)
					{
						alert("端口添加成功！")
					}
				}
				else
				{
					alert(returnError[language][response]);
				}
				funcUpdateDisplay();
			}
		}
		xmlHttp.send(data);
	}
}

function validateBeforeAddApply()
{
 	var returnFlag;
	var addPortNum = parseInt($("#addPortNum").val(), 10);
	var addIpStart = $("#addIpStart").val();
	var addIpStartFeilds = addIpStart.split(".");
	var addIpStartHost = parseInt(addIpStartFeilds[3], 10);
	var addIpStep = parseInt($("#addIpStep").val(), 10);
	var addPortStart = parseInt($("#addPortStart").val(), 10);
	var addPortStep = parseInt($("#addPortStep").val(), 10);
	var addSourceIpStart = $("#addSourceIp").val();
	var addSourceIpStartFeilds = addSourceIpStart.split(".");
	var addSourceIpStartHost = parseInt(addSourceIpStartFeilds[3], 10);
	var addSourceIpStep = parseInt($("#addSourceIpStep").val(), 10);
	var addProtocol = parseInt($("#addProtocol").val(), 10);
	var maxAddIpHost = addIpStartHost + addIpStep * (addPortNum - 1);
	var maxAddPort = addPortStart + addPortStep * (addPortNum - 1);
	var maxAddSourceIpHost = addSourceIpStartHost + addSourceIpStep * (addPortNum - 1);
	var curTotalRate = 0;
	var newTotalRate = 0;
	
	if(rowNum == 256)
	{
		if(language == ENGLISH)
		{
			alert("The port number is 256, can't add a new port!");
		}
		else if(language == CHINESE)
		{
			alert("端口个数已经是最大值256个，不能再添加新的端口！");
		}
		return false;
	}
	else
	{
		returnFlag = ValidateParam($("#addPortNum"), "INT_DEC", 1, (256 - rowNum), "<Add Port Number>", "<添加端口数>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	returnFlag = ValidateIP($("#addIpStart"), "IP_ADDR", "<Destination IP Address>", "<目的IP地址>", language);
	if(returnFlag == false)
	{
		return false;
	}
	var revIpInt = IP2Num($("#addIpStart").val());
	if(((revIpInt >= IP2Num("224.0.0.0")) && (revIpInt < IP2Num("224.1.0.0")))
		||((revIpInt >= IP2Num("224.3.0.0")) && (revIpInt <= IP2Num("224.4.255.255")))
		|| ((revIpInt >= IP2Num("233.252.0.0")) && (revIpInt <= IP2Num("233.255.255.255")))) 
	{
		invalidIPFlag = true;
	}
	returnFlag = ValidateParam($("#addIpStep"), "INT_DEC", 0, 255, "<IP Step Value>", "<IP地址步进值>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	if((maxAddIpHost < 0) || (maxAddIpHost > 255))
	{
		if(language == ENGLISH)
		{
			alert("IP address should be valid!");
		}
		else if(language == CHINESE)
		{
			alert("添加端口后，必须保证IP地址为合法地址！");
		}
		return false;
	}
	returnFlag = ValidateParam($("#addPortStart"), "INT_DEC", 1, 65535, "<Destination UDP Port", "<目的UDP端口>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#addPortStep"), "INT_DEC", 0, 65534, "<Port Step Value>", "<端口号步进值>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	if((maxAddPort < 1) || (maxAddPort > 65535))
	{
		if(language == ENGLISH)
		{
			alert("All Destination UDP Ports should be between 1 and 65535!");
		}
		else if(language == CHINESE)
		{
			alert("添加端口后，UDP端口号必须在1~65535之间！");
		}
		return false;
	}
	returnFlag = ValidateIP($("#addSourceIp"), "UNICAST_IP_ADDR", "<Source IP Address>", "<源IP地址>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#addSourceIpStep"), "INT_DEC", 0, 255, "<Source IP Step Value>", "<源IP地址步进值>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	if((maxAddSourceIpHost < 0) || (maxAddSourceIpHost > 255))
	{
		if(language == ENGLISH)
		{
			alert(" Source IP address should be valid!");
		}
		else if(language == CHINESE)
		{
			alert("添加端口后，必须保证源IP地址为合法地址！");
		}
		return false;
	}
	/*if(addProtocol == RTP)
	{
		if(((addPortStart % 2) != 0) || ((addPortNum != 1) && ((addPortStep % 2) != 0)))
		{
			if(language == ENGLISH)
			{
				alert("If current protocol is RTP, UDP port should be even!");
			}
			else if(language == CHINESE)
			{
				alert("网络传输协议为RTP时，UDP端口号必须为偶数！");
			}
			return false;
		}
	}*/
	if((addPortNum != 1) && (addIpStep == 0) && (addPortStep == 0))
	{
		if(language == ENGLISH)
		{
			alert("Cannot add the same destination IP and UDP port to different ports!");
		}
		else
		{
			alert("不能添加目的IP和UDP端口相同的端口！");
		}
		return false;
	}
	returnFlag = ValidateParam($("#addSysRate"), "INT_DEC", 0, 200000000, "<Total Bitrate(bps)>", "<系统码率(bps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	for(var i = 0; i < rowNum; i++)
	{
		curTotalRate += parseInt($("#sysRate" + (i + 1)).val(), 10);		
	}
	
	newTotalRate = curTotalRate + (parseInt($("#addSysRate").val(), 10)) * addPortNum;
	
	if(newTotalRate > 900000000)
	{
		if(language == ENGLISH)
		{
			alert("There have been " + curTotalRate + "bps total bitrate! After adding new ports, the sum of all total bitrate cann't be larger than 900Mbps!");
		}
		else
		{
			alert("已有端口总码率为" + curTotalRate + "bps，添加端口后所有端口的系统码率和不得大于900Mbps!");
		}
		return false;
	}

	return true;
}

function cancelAdd()
{
	$.modal.close();
}

function modifyPortApply()
{
 	var returnFlag;
	var rowData;
	var rowInfo;
	
	var modifyIpStart = $("#modifyIpStart").val();
	var modifyIpStartFeilds = modifyIpStart.split(".");
	var modifyIpStartHost = parseInt(modifyIpStartFeilds[3], 10);
	var modifyIpCheck = $("#modifyIpCheck").prop("checked");
	var modifyIpStep = parseInt($("#modifyIpStep").val(), 10);
	var maxModifyIpHost;
	
	var modifyPortStart = parseInt($("#modifyUdpPort").val(), 10);
	var modifyPortCheck = $("#modifyPortCheck").prop("checked");
	var modifyPortStep = parseInt($("#modifyPortStep").val(), 10);
	var maxModifyPort;
	
	var modifySourceIpStart = $("#modifySourceIp").val();
	var modifySourceIpStartFeilds = modifySourceIpStart.split(".");
	var modifySourceIpStartHost = parseInt(modifySourceIpStartFeilds[3], 10);
	var modifySourceIpCheck = $("#modifySourceIpCheck").prop("checked");
	var modifySourceIpStep = parseInt($("#modifySourceIpStep").val(), 10);
	var maxModifySourceIpHost;
	
	var modifyRateMode = parseInt($("#modifyRateMode").val(), 10);
	var modifyRateModeCheck = $("#modifyRateModeCheck").prop("checked");
	
	var modifySysRate = parseInt($("#modifySysRate").val(), 10);
	var modifySysRateCheck = $("#modifySysRateCheck").prop("checked");
	
	var modifyProtocol = parseInt($("#modifyProtocol").val(), 10);
	var modifyProtocolCheck = $("#modifyProtocolCheck").prop("checked");
	
	var modifyAlarmSwitch = parseInt($("#modifyAlarmSwitch").val(), 10);
	var modifyAlarmSwitchCheck = $("#modifyAlarmSwitchCheck").prop("checked");
	
	var modifyOutputSwitch = parseInt($("#modifyOutputSwitch").val(), 10);
	var modifyOutputSwitchCheck = $("#modifyOutputSwitchCheck").prop("checked");
	
	var modifyPktFormat = parseInt($("#modifyPktFormat").val(), 10);
	var modifyPktFormatCheck = $("#modifyPktFormatCheck").prop("checked");
	
	var modifyTTL = parseInt($("#modifyTTL").val(), 10);
	var modifyTTLCheck = $("#modifyTTLCheck").prop("checked");
	
	var modifyTOS = parseInt($("#modifyTOS").val(), 10);
	var modifyTOSCheck = $("#modifyTOSCheck").prop("checked");
	
	var modifyPktNum = parseInt($("#modifyPktNum").val(), 10);
	var modifyPktNumCheck = $("#modifyPktNumCheck").prop("checked");
	
	var modifyGroup = parseInt($("#modifyGroup").val(), 10);
	var modifyGroupCheck = $("#modifyGroupCheck").prop("checked");
	
	var modifyMinRate = parseInt($("#modifyMinRate").val(), 10);
	var modifyMinRateCheck = $("#modifyMinRateCheck").prop("checked");
	
	var modifyMaxRate = parseInt($("#modifyMaxRate").val(), 10);
	var modifyMaxRateCheck = $("#modifyMaxRateCheck").prop("checked");
	
	var modifyVlanSwitch = parseInt($("#modifyVlanSwitch").val(), 10);
	var modifyVlanSwitchCheck = $("#modifyVlanSwitchCheck").prop("checked");
	
	var modifyVlanId = parseInt($("#modifyVlanId").val(), 10);
	var modifyVlanIdCheck = $("#modifyVlanIdCheck").prop("checked");
	
	var modifyNoBitrateThreshold = parseInt($("#modifyNoBitrateThreshold").val(), 10);
	var modifyNoBitrateThresholdCheck = $("#modifyNoBitrateThresholdCheck").prop("checked");
	
	var modifyPriority = parseInt($("#modifyPriority").val(), 10);
	var modifyPriorityCheck = $("#modifyPriorityCheck").prop("checked");
		
	var checkedIndex = 0;
	var checkedRowNum = 0;
	var modifyIpHost;
	var modifyIp;
	var modifyPort;
	var modifySourceIpValue;
	
	var i;
	
	var newRowInfo;
	var newString;
	
	for(i = 0; i < rowNum; i++)
	{
		rowData = dataArray[i].split(SECOND_DELIMITER);
		rowInfo = rowData[INFO].split(",");
		if(rowInfo[CHECK] == CHECK_STRING)
		{
			checkedRowNum++;
		}
	}
	
	maxModifyIpHost = modifyIpStartHost + modifyIpStep * (checkedRowNum - 1);
	maxModifyPort = modifyPortStart + modifyPortStep * (checkedRowNum - 1);
	maxModifySourceIpHost = modifySourceIpStartHost + modifySourceIpStep * (checkedRowNum - 1);
	
	if(curTab == BASIC)
	{
		if(modifyIpCheck)
		{
			returnFlag = ValidateIP($("#modifyIpStart"), "IP_ADDR", "<Destination IP Address>", "<目的IP地址>", language);
			if(returnFlag == false)
			{
				return false;
			}
			/*var revIpInt = IP2Num($("#modifyIpStart").val());
			if(((revIpInt >= IP2Num("224.0.0.0")) && (revIpInt < IP2Num("224.1.0.0")))
				||((revIpInt >= IP2Num("224.3.0.0")) && (revIpInt <= IP2Num("224.4.255.255")))
				|| ((revIpInt >= IP2Num("233.252.0.0")) && (revIpInt <= IP2Num("233.255.255.255")))) 
			{
				if(language == ENGLISH)
				{
					alert("<Destination IP> is invalid!");
				}
				else if(language == CHINESE)
				{
					alert("<目的IP地址>是不合法的！");
				}
				setTimeout(function () {$("#modifyIpStart").focus()}, 0);
				setTimeout(function () {$("#modifyIpStart").select()}, 0);
				return false;
			}*/
			returnFlag = ValidateParam($("#modifyIpStep"), "INT_DEC", 0, 255, "<IP Step Value>", "<IP地址步进值>", language);
			if(returnFlag == false)
			{
				return false;
			}
			if((maxModifyIpHost < 0) || (maxModifyIpHost > 255))
			{
				if(language == ENGLISH)
				{
					alert("IP address should be valid!");
				}
				else if(language == CHINESE)
				{
					alert("修改端口后，必须保证IP地址为合法地址！");
				}
				return false;
			}
		}
		if(modifyPortCheck)
		{
			returnFlag = ValidateParam($("#modifyUdpPort"), "INT_DEC", 1, 65535, "<Destination UDP Port>", "<目的UDP端口>", language);
			if(returnFlag == false)
			{
				return false;
			}
			if((maxModifyPort < 1) || (maxModifyPort > 65535))
			{
				if(language == ENGLISH)
				{
					alert("UDP port should be valid!");
				}
				else if(language == CHINESE)
				{
					alert("修改端口后，必须保证UDP端口号合法！");
				}
				return false;
			}
			if((modifyProtocolCheck) && (modifyProtocol == RTP))
			{
				/*if((modifyPortStart % 2) != 0)
				{
					if(language == ENGLISH)
					{
						alert("If current protocol is RTP, UDP port should be even!");
					}
					else if(language == CHINESE)
					{
						alert("网络传输协议为RTP时，UDP端口号必须为偶数！");
					}
					return false;
				}
				else
				{
					if(checkedRowNum > 1)
					{
						if((modifyPortStep % 2) != 0)
						{
							if(language == ENGLISH)
							{
								alert("If current protocol is RTP, UDP port should be even!");
							}
							else if(language == CHINESE)
							{
								alert("网络传输协议为RTP时，UDP端口号必须为偶数！");
							}
							return false;
						}
					}
				}*/
			}
		}
		if(modifyIpCheck && modifyPortCheck && (modifyIpStep == 0) && (modifyPortStep == 0))
		{
			if(checkedRowNum > 1)
			{
				if(language == ENGLISH)
				{
					alert("Cannot add the same destination IP and UDP port to different ports!");
				}
				else
				{
					alert("不能添加目的IP和UDP端口相同的端口！");
				}
			}
			return false;
		}
		if(modifySourceIpCheck)
		{
			returnFlag = ValidateIP($("#modifySourceIp"), "UNICAST_IP_ADDR", "<Source IP Address>", "<源IP地址>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#modifySourceIpStep"), "INT_DEC", 0, 255, "<Source IP Step Value>", "<源IP地址步进值>", language);
			if(returnFlag == false)
			{
				return false;
			}
			if((maxModifySourceIpHost < 0) || (maxModifySourceIpHost > 255))
			{
				if(language == ENGLISH)
				{
					alert("Source IP address should be valid!");
				}
				else if(language == CHINESE)
				{
					alert("修改端口后，必须保证源IP地址为合法地址！");
				}
				return false;
			}
		}
		if(modifySysRateCheck)
		{
			returnFlag = ValidateParam($("#modifySysRate"), "INT_DEC", 0, 200000000, "<Total Bitrate(bps)>", "<系统码率(bps)>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
	}
	else if(curTab == IP_PKT)
	{
		if(modifyTTLCheck)
		{
			returnFlag = ValidateParam($("#modifyTTL"), "INT_DEC", 1, 255, "<Port TTL>", "<端口TTL>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
	}
	else if(curTab == TAB_PORT_BACKUP)
	{
		if(modifyMinRateCheck)
		{
			returnFlag = ValidateParam($("#modifyMinRate"), "INT_DEC", 0, 200000000, "<Minrate Threshold(bps)>", "<最小码率阈值(bps)>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
		if(modifyMaxRateCheck)
		{
			returnFlag = ValidateParam($("#modifyMaxRate"), "INT_DEC", 0, 200000000, "<Maxrate Threshold(bps)>", "<最大码率阈值(bps)>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
		if(modifyMinRateCheck && modifyMaxRateCheck)
		{
			if(parseInt($("#modifyMinRate").val(), 10) > parseInt($("#modifyMaxRate").val(), 10))
			{
				if(language == ENGLISH)
				{
					alert("The minrate threshold is bigger than the maxrate threshold!");
				}
				else
				{
					alert("最小码率阈值不能大于最大码率阈值！");
				}
				return false;
			}
		}
	}
	else if(curTab == TAB_VLAN)
	{
		if(modifyVlanIdCheck)
		{
			returnFlag = ValidateParam($("#modifyVlanId"), "INT_DEC", 1, 4094, "<VLAN ID>", "<VLAN ID>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
	}
	else if(curTab == TAB_OTHER)
	{
		if(modifyNoBitrateThresholdCheck)
		{
			returnFlag = ValidateParam($("#modifyNoBitrateThreshold"), "INT_DEC", 1, 200000, "<No Effective Bitrate Alarm Threshold (Kbps)>", "<无有效码率告警阈值(Kbps)>", language);
			if(returnFlag == false)
			{
				return false;
			}
			/*if(parseInt($("#modifyNoBitrateThreshold").val()) == 0){
				if(language == ENGLISH)
				{
					alert("No Effective Bitrate Alarm Threshold can not be 0!");
				}
				else
				{
					alert("无有效码率告警阈值不能为0！");
				}
				return false;
			}*/
		}
	}
	for(i = 0; i < rowNum; i++)
	{
		rowData = dataArray[i].split(SECOND_DELIMITER);
		rowInfo = rowData[INFO].split(",");
		if(rowInfo[CHECK] == CHECK_STRING)
		{
			checkedIndex++;
			if(curTab == BASIC)
			{

				if(modifyIpCheck)
				{
					modifyIpHost = modifyIpStartHost + modifyIpStep * (checkedIndex - 1);
					modifyIpStartFeilds[3] = modifyIpHost;
					modifyIp = modifyIpStartFeilds.join(".");
					rowData[IP] = modifyIp;
				}
				if(modifyPortCheck)
				{
					modifyPort = modifyPortStart + modifyPortStep * (checkedIndex - 1);
					rowData[PORT] = modifyPort;
				}
				if(modifySourceIpCheck)
				{
					modifySourceIpHost = modifySourceIpStartHost + modifySourceIpStep * (checkedIndex - 1);
					modifySourceIpStartFeilds[3] = modifySourceIpHost;
					modifySourceIpValue = modifySourceIpStartFeilds.join(".");
					rowData[SOURCE_IP] = modifySourceIpValue;
				}
				if(modifyRateModeCheck)
				{
					rowData[RATE_MODE] = modifyRateMode;
				}
				if(modifySysRateCheck)
				{
					rowData[SYSTEM_RATE] = modifySysRate;
				}
				if(modifyProtocolCheck)
				{
					rowData[PROTOCOL] = modifyProtocol;
				}
				if(modifyAlarmSwitchCheck)
				{
					rowData[ALARM_SWITCH] = modifyAlarmSwitch;
				}
				if(modifyOutputSwitchCheck)
				{
					rowData[OUT_SWITCH] = modifyOutputSwitch;
				}
				
			}
			else if(curTab == IP_PKT)
			{
				if(modifyPktFormatCheck)
				{
					rowData[PKT_FORMAT] = modifyPktFormat;
				}
				if(modifyTTLCheck)
				{
					rowData[TTL] = modifyTTL;
				}
				if(modifyTOSCheck)
				{
					rowData[TOS] = modifyTOS;
				}
				if(modifyPktNumCheck)
				{
					rowData[PKT_NUM] = modifyPktNum;
				}
			}
			else if(curTab == TAB_PORT_BACKUP)
			{
				if(modifyGroupCheck)
				{
					rowData[GROUP] = modifyGroup;
				}
				if(modifyMinRateCheck)
				{
					rowData[MIN_RATE] = modifyMinRate;
				}
				if(modifyMaxRateCheck)
				{
					rowData[MAX_RATE] = modifyMaxRate;
				}
			}
			else if(curTab == TAB_VLAN)
			{
				if(modifyVlanSwitchCheck)
				{
					rowData[VLAN_SWITCH] = modifyVlanSwitch;
				}				
				if(modifyPriorityCheck)
				{
					rowData[PRIORITY] = modifyPriority;
				}
				if(modifyVlanIdCheck)
				{
					rowData[VLAN_ID] = modifyVlanId;
				}
			}
			else if(curTab == TAB_OTHER)
			{
				if(modifyNoBitrateThresholdCheck)
				{
					rowData[NO_BITRATE_THRESHOLD] = modifyNoBitrateThreshold;
				}						
			}
			rowInfo[CHANGE] = CHANGE_STRING;
			newRowInfo = rowInfo[CHECK] + "," + rowInfo[CHANGE];
			newString = newRowInfo;
			for(var j = PORT_NO; j < COL_NUM; j++)
			{
				newString += SECOND_DELIMITER + rowData[j];
			}
			dataArray[i] = newString;
		}
	}
	
	$.modal.close();
	updateTableData();
	EnableButton("applyBtn");
	return true;
}

function cancelModify()
{
	$.modal.close();
}