﻿var objIdArray = ["workMode", "backupMode", "ip", "port", "comTimeout", "delayTime"];
var COL_NUM = 6;
var ROW_NUM = 8;

var NO_BACKUP = 0;
var BACKUP_DEVICE = 2;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{	
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	displayMenu();
	funcUpdateDisplay();
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		$("#workMode" + (i + 1)).bind("change", function()
		{
			changeBackupStatus($(this));
		});
	}
});

function funcUpdateDisplay() 
{		
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function changeBackupStatus(obj)
{
	var index = parseInt(obj.attr("id").slice(8), 10);
	if(parseInt(obj.val(), 10) == NO_BACKUP)
	{
		$("#backupMode" + index).attr("disabled", true);
		$("#ip" + index).attr("disabled", true);
		$("#port" + index).attr("disabled", true);
		$("#comTimeout" + index).attr("disabled", true);
		$("#delayTime" + index).attr("disabled", true);
	}
	else 
	{
		if(parseInt(obj.val(), 10) == BACKUP_DEVICE)
		{
			$("#backupMode" + index).attr("disabled", true);
		}
		else
		{
			$("#backupMode" + index).attr("disabled", false);
		}
		$("#ip" + index).attr("disabled", false);
		$("#port" + index).attr("disabled", false);
		$("#comTimeout" + index).attr("disabled", false);
		$("#delayTime" + index).attr("disabled", false);
	}
}

function displayParam() 
{
	var data;
	var otherData;
	var rowData;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + GBE_PORT_BACKUP + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					rowData = data[i].split(SECOND_DELIMITER);
					for(var j = 0; j < COL_NUM; j++)
					{
						$("#" + objIdArray[j] + (i + 1)).val(rowData[j]);
					}
				}
				for(var i = 0; i < ROW_NUM; i++)
				{
					changeBackupStatus($("#workMode" + (i + 1)));
				}
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + GBE_PORT_BACKUP + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(parseInt($("#workMode" + (i + 1)).val(), 10) != NO_BACKUP)
		{
			returnFlag = ValidateIP($("#ip" + (i + 1)), "IP_ADDR", "<Backup IP Address>", "<备份IP地址>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#port" + (i + 1)), "INT_DEC", 1, 65535, "<Backup UDP Port>", "<备份UDP端口>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#comTimeout" + (i + 1)), "INT_DEC", 100, 65535, "<Communication Timeout(ms)>", "<通信超时(ms)>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#delayTime" + (i + 1)), "INT_DEC", 0, 65535, "<Group Delay Time(ms)>", "<组间延时(ms)>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
	}	
	return true;
}

function generateData()
{
	var data;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		for(var j = 0; j < COL_NUM; j++)
		{
			if((i == 0) && (j == 0))
			{
				data = $("#" + objIdArray[j] + (i + 1)).val();
			}
			else if((i != 0) && (j == 0))
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[j] + (i + 1)).val();
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[j] + (i + 1)).val();
			}
		}
	}
	
	return data;
}