﻿//全局变量（复用页面用）
var inSlotNo = 0;
var outSlotNo = 0;

var slotNo = 0xff;
var CARD_NUM = 8;

var menuNameArray = ["Cards", "Multiplexing", "Output", "Backup", "General"];
var listEn = ["Card List", "Multiplexing List", "Output List", "Backup List", "General List"];
var listCn = ["板卡列表", "复用列表", "输出列表", "备份列表", "系统列表"];
var menuList = [listEn, listCn];
var MENU_NUM = 5;

var treeUserName = ["Permission", "用户管理"];
var treeAlarmName = ["Alarm", "告警"];
var treeParamName = ["Configuration", "参数管理"];

var FRAME_CONFIG = 0;
var REBOOT_CONFIG = 17;  //对应系统共用js文件的宏定义
var ALARM_STATUS = 18;

var NO_LOCK = 0;
var REBOOT_LOCK = 1;
var CONNECTION_LOCK = 2;
var DEFAULT_LOCK = 3;
var lockType = NO_LOCK;
var UPDATE = 1;
var firstOpenPageFlag = 0;
var FIRST = 0;
var NOT_FIRST = 1;

var resetDefaultFlag = 0;

var GREEN = 0;
var RED = 1;
var GRAY = 2;

var iframeHeight; //iframe实际高度

var breadCrunmsValue = "";  //面包屑菜单显示的text

//zTree相关
var g_Tabs = new Array();
var trees = new Array();
//var muxSelectNode = null;
//var muxServiceId;
var selectNode = null;
var curTree = null;
var curTabId = "systemLink";

var mainMenu = ["Multiplexing", "复用"];
var treeMenu = ["Service Multiplexing", "节目复用"];
var rightMenu = ["PSI/SI Edit", "PSI/SI表编辑"];
var cardArray = ["Card", "卡"];
var gbeArray = ["GbE", "网口"];
var portArray = ["Port", "端口"];

$(document).ready(function()
{
	getIframeHeight();
	startConnectionMonitor();
	selectMenu("systemLink");
	$("#curUser").html(curUser);
	if(BackUpEna == DEVICE_BACKUP)
	{
		$("#backupDisplay").css("display", "");
	}
	else
	{
		$("#backupDisplay").css("display", "none");
	}
});

window.onresize = function()
{
	getIframeHeight();
}

/*************************************************
Function: 		specialNodesInit
Description: 	根据需求对对特殊节点所做的处理
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function specialNodesInit()
{
	var treeObj;
	var allNodes;
	var allLength;
	var node;
	
	treeObj = $.fn.zTree.getZTreeObj("Cards");
	allNodes = treeObj.getNodesByParam("noClick", true, null);
	allLength = allNodes.length;
	for(var i = 0; i < allLength; i++)
	{
		if(typeof(allNodes[i].title) != "undefined")
		{
			$("#" + allNodes[i].tId + "_a").attr("title", allNodes[i].title);
			$("#" + allNodes[i].tId + "_span").css("color", "#666666");
		}
	}
	
	treeObj = $.fn.zTree.getZTreeObj("General");
	if(groupAccess != ADMINISTRATOR)
	{
		node = treeObj.getNodeByParam("name", treeUserName[language], null);
		treeObj.hideNode(node);
		if(groupAccess == USER)
		{
			node = treeObj.getNodeByParam("name", treeParamName[language], null);
			treeObj.hideNode(node);
			$("#reboot").css("display", "none");
			$(".top_set").css("width", "140px");
		}
	}
}

var IFRAME_EXCUDE_HEIGHT = 200;
/*************************************************
Function: 		getIframeHeight
Description: 	用于获取iframe的当前实际高度，赋值给左右两部分
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function getIframeHeight()
{
	var currentHeight = 0;
	if(document.body.clientHeight - IFRAME_EXCUDE_HEIGHT > 0)
	{
		currentHeight = document.body.clientHeight - IFRAME_EXCUDE_HEIGHT;  //the actual height of the iframe
	}
	iframeHeight = currentHeight;
	document.getElementById("mainFrame").style.height = currentHeight + "px";
	document.getElementById("leftContent").style.height = (currentHeight + 23) + "px";
	document.getElementById("tree").style.height = currentHeight + "px";
}

/*************************************************
Description: 	告警灯定义
*************************************************/
var green = "<img border=0 src=style/images/green.png title='Working Well' style='cursor:default;' >";
var red0 = "<img border=0 src=style/images/red.png onclick=viewAlarmDetail(255) title='Click here for details' style='cursor:pointer;'>";
var red1 = "<img border=0 src=style/images/red.png onClick=viewAlarmDetail(1) title='Click here for details' style='cursor:pointer;'>";
var red2 = "<img border=0 src=style/images/red.png onclick=viewAlarmDetail(2) title='Click here for details' style='cursor:pointer;'>";
var red3 = "<img border=0 src=style/images/red.png onClick=viewAlarmDetail(3) title='Click here for details' style='cursor:pointer;'>";
var red4 = "<img border=0 src=style/images/red.png onclick=viewAlarmDetail(4) title='Click here for details' style='cursor:pointer;'>";
var red5 = "<img border=0 src=style/images/red.png onClick=viewAlarmDetail(5) title='Click here for details' style='cursor:pointer;'>";
var red6 = "<img border=0 src=style/images/red.png onClick=viewAlarmDetail(6) title='Click here for details' style='cursor:pointer;'>";
var red7 = "<img border=0 src=style/images/red.png onClick=viewAlarmDetail(7) title='Click here for details' style='cursor:pointer;'>";
var red = [red0, red1, red2, red3, red4, red5, red6, red7];
var disconnect = "<img border=0 src=style/images/gray.png title='No Card' style='cursor:default;'>";

/*************************************************
Description: 	树菜单定义
*************************************************/
var zNodesSystemEn = [
{name:"Network",noR:true,open:true,href:"system/network_config_en.asp",target:"mainFrame"}
,{name:"Clock",noR:true,open:true,href:"system/clock_config_en.asp",target:"mainFrame"}
,{name:"TDT/TOT",noR:true,open:true,href:"system/table_config_en.asp",target:"mainFrame"}
,{name:"PSI/SI",noR:true,open:true,href:"system/psi_refresh_en.asp",target:"mainFrame"}
,{name:"Alarm",noR:true,open:true,href:"system/alarm_monitor_en.asp",target:"mainFrame"}
,{name:"Log",noR:true,open:true,href:"system/system_log_en.asp",target:"mainFrame"}
,{name:"License",noR:true,open:true,href:"system/license_config_en.asp",target:"mainFrame"}
,{name:"Version",noR:true,open:true,href:"system/version_monitor_en.asp",target:"mainFrame"}
,{name:"Misc",noR:true,open:true,href:"system/device_config_en.asp",target:"mainFrame"}
,{name:"Permission",noR:true,open:true,href:"system/user_config_en.asp",target:"mainFrame"}
,{name:"Configuration",noR:true,open:true,href:"system/param_config_en.asp",target:"mainFrame"}
];
var zNodesSystemCn = [
{name:"网络",noR:true,open:true,href:"system/network_config_cn.asp",target:"mainFrame"}
,{name:"时钟",noR:true,open:true,href:"system/clock_config_cn.asp",target:"mainFrame"}
,{name:"TDT/TOT",noR:true,open:true,href:"system/table_config_cn.asp",target:"mainFrame"}
,{name:"PSI/SI",noR:true,open:true,href:"system/psi_refresh_cn.asp",target:"mainFrame"}
,{name:"告警",noR:true,open:true,href:"system/alarm_monitor_cn.asp",target:"mainFrame"}
,{name:"日志",noR:true,open:true,href:"system/system_log_cn.asp",target:"mainFrame"}
,{name:"授权",noR:true,open:true,href:"system/license_config_cn.asp",target:"mainFrame"}
,{name:"版本",noR:true,open:true,href:"system/version_monitor_cn.asp",target:"mainFrame"}
,{name:"其它",noR:true,open:true,href:"system/device_config_cn.asp",target:"mainFrame"}
,{name:"用户管理",noR:true,open:true,href:"system/user_config_cn.asp",target:"mainFrame"}
,{name:"参数管理",noR:true,open:true,href:"system/param_config_cn.asp",target:"mainFrame"}
];
var zNodesMuxEn = [ 
{name:"Service Multiplexing",open:true,noR:true,href:"mux/mux_config_en.asp",target:"mainFrame"},
{name:"PID Map ",open:true,noR:true,href:"system/pid_map_en.asp",target:"mainFrame"}
];
var zNodesMuxCn = [ 
{name:"节目复用",open:true,noR:true,href:"mux/mux_config_cn.asp",target:"mainFrame"},
{name:"PID映射 ",open:true,noR:true,href:"system/pid_map_cn.asp",target:"mainFrame"}
];

/*************************************************
Function: 		logout
Description: 	用户注销
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function logout()
{
	var confirmPrompt;
	if(language == ENGLISH)
	{
		var confirmPrompt = "Are you sure to cancel the current login?";
	}
	else if(language == CHINESE)
	{
		var confirmPrompt = "确定要注销当前登录?";
	}
	if(window.confirm(confirmPrompt))
	{
		try
		{
			var xmlHttp = GetHTTPObject();
			xmlHttp.open("GET","asp/frame.asp",false," "," ");
			xmlHttp.send(null);
			xmlHttp.abort();
		} 
		catch(e)
		{
			alert("Error");
			return false;
		}
		if(language == ENGLISH)
		{
			window.location.href = "frame_en.asp";
		}
		else if(language == CHINESE)
		{
			window.location.href = "frame_cn.asp";
		}   
	}
}

/*************************************************
Function: 		reboot
Description: 	重启设备
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function reboot()
{
	$.ajax(
    {
        url : "system/no_card_cn.asp",
        cache : false,
        async : false,
        type : "GET",
        contentType : "application/x-www-form-urlencoded",
        success : function(responseData)
		{
			var confirmPrompt;
			if(language == ENGLISH)
			{
				confirmPrompt = "All Services will be interrupted. All unsaved configurations and connections to the device will be lost.\r\nProceed?";
			}
			else if(language == CHINESE)
			{
				confirmPrompt = "所有服务将被中断，一切未保存的操作和连接将会丢失，确定重启系统吗？";
			}	
			if(window.confirm(confirmPrompt))
			{
				var xmlHttp = GetHTTPObject();
				data = "type=" + REBOOT_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo;
				xmlHttp.open("POST", "/goform/formEMR30", true);
				xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
				xmlHttp.setRequestHeader("Content-length", data.length);
				
				xmlHttp.onreadystatechange = function()
				{
					if((xmlHttp.readyState == 4) &&(xmlHttp.status == 200))
					{
						response =  parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
						if(response == RETURN_OK)
						{
							lockType = REBOOT_LOCK;
							lockUI(lockType);
						}
						else
						{
							if(language == ENGLISH)
							{
								alert("Reboot operation is not allowed. Some other critical operation is in progress.");
							}
							else
							{
								alert("系统重启失败，其他重要操作正在进行中。");
							}
						}
					}
				}
				xmlHttp.send(data);
			}
			else
			{
				return false;
			}		
		}
	});
}

function startConnectionMonitor()
{
	for(var i = 0; i < TIMEOUT; i++)
	{
		xmlhttp_objects[i] = GetHTTPObject();
	}
	getDeviceStatus();
	setInterval(function(){getDeviceStatus()}, 3000);
}
/*************************************************
Function: 		getDeviceStatus
Description: 	实时监测设备工作状态
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
var TIMEOUT = 3;
var xmlhttp_objects = new Array(); // Array of TIMEOUT objects
function getDeviceStatus()
{
	// Link Loss Detection = TIMEOUT seconds; Link Up Detection = 1s + n/w roundtrip delay
	// Send out a status request through one of the available objects
	var i = 0;
	for(i = 0; i < TIMEOUT; i++)
	{
		var xmlhttpobj = xmlhttp_objects[i];
		if((xmlhttpobj.readyState == 0) || (xmlhttpobj.readyState == 4))
		{
			xmlhttpobj.open("GET", "/goform/formEMR30?type=" + FRAME_CONFIG + "&ID=" + i + "&cmd=" + GET + "&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
			setReadyStateChange(i);
			xmlhttpobj.send(null);
			break;
		}
	}
	if(i == TIMEOUT)
	{
		disConnect();
	}
}

function setReadyStateChange(i)
{
	xmlhttp_objects[i].onreadystatechange = function ()
	{
		processEMRState(i);
	}	
}

function processEMRState(i)
{
	var data;
	var alarmData;
	var obj = xmlhttp_objects[i];
	var newLockType;
	if((obj.readyState == 4) && (obj.status == 200))
	{
		response = AjaxStrDeal(obj.responseText);
		if(response != "")
		{
			data = response.split(FIRST_DELIMITER);
			document.title = data[1];
			if(data[0] == RETURN_OK)
			{				
				if(lockType != NO_LOCK)
				{
					unlockUI();
					if(data[2] == UPDATE)
					{
						if(firstOpenPageFlag == NOT_FIRST)
						{
							if(language == ENGLISH)
							{
								self.location.replace("frame_en.asp");
							}
							else
							{
								self.location.replace("frame_cn.asp");
							}
						}												
					}
				}
				alarmData = data[3].split(SECOND_DELIMITER);
				for(var i = 0; i < CARD_NUM; i++)
				{
					if(parseInt(alarmData[i], 10) == GREEN)
					{
						$("#card" + i).html(green);
					}
					else if(parseInt(alarmData[i], 0) == RED)
					{
						$("#card" + i).html(red[i]);
					}
					else
					{
						$("#card" + i).html(disconnect);
					}
				}
			}
		}
		else
		{
			disConnect();
		}
		if(firstOpenPageFlag == FIRST)
		{
			firstOpenPageFlag = NOT_FIRST;
		}
	}
}
/*************************************************
Function: 		disConnect
Description: 	通信失败，中断请求，断开连接
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function disConnect()
{
	abortStatusRequests();
	if(resetDefaultFlag == 1)
	{
		lockType = DEFAULT_LOCK;
		lockUI(lockType);
		resetDefaultFlag = 0;
	}
	else if(lockType == NO_LOCK) // connection lost not due to reboot
	{
		lockType = CONNECTION_LOCK;
		lockUI(lockType);
	}
}

function unlockUI()
{
	$.modal.close();
	lockType = NO_LOCK;
}

function abortStatusRequests()
{
	for(var i = 0; i < TIMEOUT; i++)
	{
		xmlhttp_objects[i].abort();
	}
}
function lockUI(lock)
{	
	if(lock == REBOOT_LOCK)
	{
		if(language == ENGLISH)
		{
			document.getElementById("promptInfo").innerHTML = "Rebooting";
		}
		else if(language == CHINESE)
		{
			document.getElementById("promptInfo").innerHTML = "重启中";
		}
	}
	else if(lock == CONNECTION_LOCK)
	{		
		if(language == ENGLISH)
		{
			document.getElementById("promptInfo").innerHTML = "Connection Lost";
		}
		else if(language == CHINESE)
		{
			document.getElementById("promptInfo").innerHTML = "连接失败";
		}		
	}
	else if(lock == DEFAULT_LOCK)
	{
		if(language == ENGLISH)
		{
			document.getElementById("promptInfo").innerHTML = "Resetting to Factory Defaults";
		}
		else if(language == CHINESE)
		{
			document.getElementById("promptInfo").innerHTML = "恢复出厂设置";
		}
	}
	$("#lockPrompt").modal();
}

/*************************************************
Function: 		viewAlarmDetail
Description: 	查看详细告警信息
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function viewAlarmDetail(slotNo)
{
	changeTab("systemLink");
	selectNode = curTree.getNodeByParam("name", treeAlarmName[language]);
	curTree.selectNode(selectNode, false);
	
	if(language == ENGLISH)
	{
		top.mainFrame.location.replace("system/alarm_monitor_en.asp?slotNo=" + slotNo);
	}
	else
	{
		top.mainFrame.location.replace("system/alarm_monitor_cn.asp?slotNo=" + slotNo);
	}	
	getBreadCrumbs(curTree.setting.treeId, selectNode);
}

/*************************************************
Function: 		treeClose
Description: 	收起左侧树菜单
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function treeClose()
{
	$("#leftContent").css("display", "none");
	$("#unfold").css("display", "");
	$("#breadCrumbs").css("width", "1024px");
	$("#mainFrame").css("width", "1024px");
}

/*************************************************
Function: 		treeOpen
Description: 	展开左侧树菜单
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function treeOpen()
{
	$("#leftContent").css("display", "");
	$("#unfold").css("display", "none");
	$("#breadCrumbs").css("width", "809px");
	$("#mainFrame").css("width", "809px");
}

/************************************************
Description: 	zTree setting配置
*************************************************/
var setting = {
		edit: { 
				enable: false,
				drag: {
						isCopy: false,
						isMove: false
					  },
				showRenameBtn: false,
				showRemoveBtn: false
			  },

		data: {
				key: {
						children: "nodes"
					 }
				},
				
		view: {
					fontCss: setFontCss,
					showLine: true,
					showTitle:false,
					showIcon:false,
					selectedMulti: false
				},
		callback: {
				  	onClick: treeOnClick,
					beforeClick: zTreeBeforeClick
			  }
	};	

function setFontCss(treeId, treeNode)
{
	return treeNode.noClick == true ? {cursor:"auto","text-decoration": "none"} : {};
};

function zTreeBeforeClick(treeId, treeNode, clickFlag)
{
	if(treeNode.noClick == true)
	{
		return false;
	}
	else
	{
		return true;
	} 
};

/*************************************************
Function: 		treeOnClick
Description: 	单击树节点事件函数
Input: 			event -- js event对象 标准js event对象
				treeId -- String  对应zTree的treeId,便于用户操控
				treeNode -- JSON  被点击的节点JSON数据对象
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function treeOnClick(event, treeId, treeNode) 
{
	self.frames[0].location.replace(treeNode.href);
	selectNode = treeNode;
	getBreadCrumbs(treeId, treeNode);
}

/*************************************************
Function: 		createzTree
Description: 	树菜单的初始化，默认选中的节点
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function createzTree()
{
	if(language == ENGLISH)
	{
		var General = $.fn.zTree.init($("#General"), setting, zNodesSystemEn);
		var Multiplexing = $.fn.zTree.init($("#Multiplexing"), setting, zNodesMuxEn);
	}
	else
	{
		var General = $.fn.zTree.init($("#General"), setting, zNodesSystemCn);
		var Multiplexing = $.fn.zTree.init($("#Multiplexing"), setting, zNodesMuxCn);
	}	
	addTree("General", General);
	General.selectNode(General.getNodeByParam("level", 0));
	addTree("Multiplexing", Multiplexing);
	Multiplexing.selectNode(Multiplexing.getNodeByParam("level", 0));
	
	var Cards = $.fn.zTree.init($("#Cards"), setting, zNodesCards);
	addTree("Cards", Cards);
	if(typeof(Cards.getNodeByParam("level", 0).href) == "undefined")
	{
		Cards.selectNode(Cards.getNodeByParam("level", 1));
	}
	else
	{
		Cards.selectNode(Cards.getNodeByParam("level", 0));
	}
	
	var Output = $.fn.zTree.init($("#Output"), setting, zNodesOutput);
	addTree("Output", Output);
	Output.selectNode(Output.getNodeByParam("level", 0));
	
	var Backup = $.fn.zTree.init($("#Backup"), setting, zNodesBackup);
	addTree("Backup", Backup);
	Backup.selectNode(Backup.getNodeByParam("level", 1));
	
	specialNodesInit();
}

/*************************************************
Function: 		addPage
Description: 	把横向菜单、左侧树 、对应的url做关联
Input: 			tabId -- 横向菜单对应的id
				treeId -- 左侧树的id
				href -- 横向菜单链接的url(没有左侧树的才有此参数)
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function addPage(tabId, treeId, href)
{
	g_Tabs.push(new Tab(tabId, treeId, href));
}
function Tab(tabId, treeId, href)
{
	this.tabId = tabId;
	this.treeId = treeId;
	this.href = href;
}

/*************************************************
Function: 		addTree
Description: 	用一个数组来存放每个树的treeId和tree
Input: 			treeId -- 左侧树的ul的id
				tree -- 实际的JSON数据树
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function addTree(treeId, tree)
{
	var tr = new Object();
	tr.treeId = treeId;
	tr.tree = tree;
	trees.push(tr);
}

/*************************************************
Function: 		addTree
Description: 	每个树JSON数据tree添加到类中，和树对应的其他属性关联
Input: 			treeId -- 左侧树的ul的id
				tree -- 实际的JSON数据树
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function setTree(treeId, tree)
{
	for(var i = 0; i < g_Tabs.length; i++)
	{
		if(g_Tabs[i].treeId == treeId)
		{
			g_Tabs[i].tree = tree;
		}
	}
}

/*************************************************
Function: 		displayTreeList
Description: 	左侧树上方标签文字显示
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function displayTreeList()
{
	for(var i = 0; i < MENU_NUM; i++)
	{
		if(curTree.setting.treeId == menuNameArray[i])
		{
			$("#treeMenu").html(menuList[language][i]);
		}
	}
}

/*************************************************
Function: 		getBreadCrumbs
Description: 	面包屑菜单跟随主菜单和左边树菜单的联动变化
Input: 			treeId -- menu name of curTree
				treeNode -- the selected treeNode of curTree
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function getBreadCrumbs(treeId, treeNode)
{
	if(language == ENGLISH)
	{
		breadCrunmsValue = (" > " + treeId);
	}
	else if(language == CHINESE)
	{
		breadCrunmsValue = (" > " + getTreeIdCn(treeId));
	}	
	if(treeNode.level == 0)
	{
		breadCrunmsValue += (" > " + treeNode.name);
	}
	else
	{
		var parentNode = treeNode.getParentNode();
		breadCrunmsValue += (" > " + parentNode.name + " > " + treeNode.name);
	}	
	$("#menuBar").html(breadCrunmsValue);
}

function getTreeIdCn(treeId)
{
	var treeIdCn = "";
	switch(treeId)
	{
		case "Cards":
			treeIdCn = "板卡";
			break;
		case "Multiplexing":
			treeIdCn = "复用";
			break;
		case "Output":
			treeIdCn = "输出";
			break;
		case "Backup":
			treeIdCn = "备份";
			break;
		case "General":
			treeIdCn = "常规";
			break;
		default:
			break;
	}
	return treeIdCn;
}
/*************************************************
Function: 		selectMenu
Description: 	框架横向导航菜单切换
Input: 			tabId -- id of selected menu
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function selectMenu(tabId)
{
	var tab = null;
	for(var i = 0; i < g_Tabs.length; i++)
	{
		if(g_Tabs[i].tabId == tabId)
		{
			tab = g_Tabs[i];
			break;
		}
	}
	if(tab == null)
	{
		return;
	}	
	if((curTree != null) && (curTree != tab.tree))
	{
		$("#" + curTree.setting.treeId).css("display", "none");
	}	
	if(tab.tree != null)
	{
		curTree = tab.tree;	
		treeOpen();  //show tree		
		$("#" + curTree.setting.treeId).css("display", "");
		displayTreeList();
		if(curTree.getSelectedNodes()[0] == null)
		{
			selectNode = curTree.getNodeByParam("level", 0);
			curTree.selectNode(selectNode, false);
		}
		self.frames[0].location.replace(curTree.getSelectedNodes()[0].href);
		getBreadCrumbs(curTree.setting.treeId, curTree.getSelectedNodes()[0]);
	}
}

function changeTab(tabId)
{
	if(curTabId == tabId)
	{
		return;
	}
	$("#" + curTabId).attr("class", "normal");
	$("#" + tabId).attr("class", "selected");
	selectMenu(tabId);
	curTabId = tabId;
}

/*************************************************
Function: 		psiTableJump
Description: 	面包屑菜单的链接跳转函数
Input: 			
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function psiTableJump()
{
	var ONE_GBE_PORT_NUM = 256;
	var GBE_ONE = 1;
	var GBE_TWO = 2;
	var id;
	var psiId;
	var portInfo;
	var url = top.mainFrame.location.href;
	var intPos = url.indexOf("="); 
	id = url.substr(intPos + 1);
	var str = id.split("_");
	var psiIdArray = [str[0], str[1], str[2]];
	psiId = psiIdArray.join("_");
	if(language == ENGLISH)
	{
		self.frames[0].location.replace("mux/psi_edit_en.asp?ID=" + psiId);
	}
	else
	{		
		self.frames[0].location.replace("mux/psi_edit_cn.asp?ID=" + psiId);
	}
	if(parseInt(str[1], 10) - 1 == MAIN_GBE_CARD)
	{
		if(parseInt(str[2], 10) > ONE_GBE_PORT_NUM)
		{
			var curPortNo = parseInt(str[2], 10) - ONE_GBE_PORT_NUM;
			portInfo = "(" + cardArray[language] + str[1] + "-" + gbeArray[language] + GBE_TWO + portArray[language] + curPortNo + ")";
		}
		else
		{
			portInfo = "(" + cardArray[language] + str[1] + "-" + gbeArray[language] + GBE_ONE + portArray[language] + str[2] + ")";
		}
	}
	else
	{
		portInfo = "(" + cardArray[language] + str[1] + "-" + portArray[language] + str[2] + ")";
	}
	$("#menuBar").html("> " + mainMenu[language] + "> " + treeMenu[language] + "> " + rightMenu[language] + "(" + portInfo + ")");
}
