//多页面通用的全局变量
var objIdArray = [];
var validatParamArray = [];
var readParamStrObj = {};
var identifierArray = [];
var identifierData;

//需要校验的参数信息的存储顺序
var PARAM_ID = 0;
var PARAM_TYPE = 1;
var PARAM_EN_NAME = 2;
var PARAM_CH_NAME = 3;
var RANGE_START = 4; //普通参数
var RANGE_END = 5; //针对普通参数

var RELATE_IP = 4; //针对子网掩码和网关
var RELATE_MASK = 5; //针对网关参数

var DEFAULT = 6; //针对一些特殊的密钥参数，显示的时候只显示*****，但是不同的参数可能"*"的长度不一致，比较好的方式是在xml中规定想要显示的字符串。

//控件类型定义
var SELECT = 0;
var INPUT_TEXT_NORMAL = 1;
var INPUT_TEXT_LONG = 2;
var INPUT_PSD = 3;
var IMG = 4;

//参数合法校验类型枚举
var INT_DEC_N_HEX = 0;
var INT_HEX = 1;
var FLOATING = 2;
var LENGTH = 3;
var NAME = 4;
var KEY = 5;
var IP_ADDR = 6;
var UNICAST_IP_ADDR = 7;
var MULTICAST = 8;
var SUBNET_MASK = 9;
var GATEWAY = 10;
var paramTypeStr = ["INT_DEC_N_HEX", "INT_HEX", "FLOATING", "LENGTH", "NAME", "KEY",
					"IP_ADDR", "UNICAST_IP_ADDR", "MULTICAST", "SUBNET_MASK", "GATEWAY"];
var languageSuffix = ["_en", "_ch"];
/*************************************************
Function: 		InitFunctionMenu
Description: 	点击树节点后对应的横向菜单的初始化
Input: 			menuArray: 详细的菜单个数和内容；menuIndex:当前页面对应的菜单索引;
				pageType: 每个菜单对应的页面类型，用于链接跳转
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function InitFunctionMenu(menuArray, menuIndex, pageType)
{
	var menuStr = '<ul>';
	if(menuArray.length == 0)
	{
		$(".tab").remove();
		return;
	}
	for(var i = 0; i < menuArray.length; i++)
	{
		if(i == 0)
		{
			if(menuIndex == 0)
			{
				menuStr += '<li class="first_selected" onclick="pageJump(' + pageType[i] + ');">' + menuArray[i] + '</li>';
			}
			else
			{
				menuStr += '<li class="first_no_selected" onclick="pageJump(' + pageType[i] + ');">' + menuArray[i] + '</li>';
			}
		}
		else if(menuIndex == i)
		{				
			menuStr += '<li class="middle_selected" onclick="pageJump(' + pageType[i] + ');">' + menuArray[i] + '</li>';
		}
		else if(menuIndex + 1 == i)
		{
			menuStr += '<li class="selected_follow" onclick="pageJump(' + pageType[i] + ');">' + menuArray[i] + '</li>';
		}
		else
		{
			menuStr += '<li class="middle_no_selected" onclick="pageJump(' + pageType[i] + ');">' + menuArray[i] + '</li>';
		}
	}
	if(menuArray.length - 1 == menuIndex)
	{
		menuStr += '<li class="last_selected"></li>';
	}
	else
	{
		menuStr += '<li class="last_no_selected"></li>';		
	}	
	menuStr += '</ul>';
	$(".tab").append(menuStr);
}
/*************************************************
Function: 		InitParam
Description: 	根据参数表生成对应的asp和js代码，页面不再关心具体的参数是什么
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function InitParam(fileName)
{
	var sectionLength = 0;
	var sectionId;
	var paramId;
	var specialSectionFlag = false;
	var displaySectionNum = 0;
	$.ajax
	({  
		url: fileName,
		type: 'GET',
		dataType: 'xml',
		success: function(xml)
		{
			$(xml).find('section').each(function(sctionNo, sectionEl)
			{
				var sDisplayValue = $(sectionEl).find("display").first().text();
				sectionId = $(sectionEl).attr("id");
				if(sDisplayValue == "ON")
				{
					displaySectionNum++;
				}
				var fullFlag = false;
				specialSectionFlag = false;
				var specialParamCount = 0;
				objIdArray.push([]);
				var sectionDiv;
				if(sDisplayValue == "ON") 
				{
					if(displaySectionNum == 1) //第一个显示的段
					{
						sectionDiv = '<div class="mainframe_bar_first" id="' + sectionId + 'Bar">';
					}
					else
					{
						sectionDiv = '<div class="mainframe_bar" id="' + sectionId + 'Bar">';
					}					
				}
				else
				{
					sectionDiv = '<div class="mainframe_bar" style="display: none;" id="' + sectionId + 'Bar">';
				}
				sectionDiv += '<div class="mainframe_bar_text">' + $(sectionEl).find("name" + languageSuffix[language]).first().text() +'</div></div>';
				$(sectionEl).find("widget").each(function(widgetNo, widgetEl)
				{
					if($(widgetEl).text() == INPUT_TEXT_LONG)
					{
						specialSectionFlag = true;
						specialParamCount++;
					}
				});				
				var normalParamLength = $(sectionEl).find("param").find("display:contains('ON')").length - specialParamCount;
				var lineNum;
				if(normalParamLength == 0) //所有参数都为长参数
				{
					lineNum = normalParamLength;
				}
				else
				{
					if(normalParamLength%2 === 0)
					{
						lineNum = normalParamLength/2;					
					}
					else
					{
						lineNum = (normalParamLength + 1)/2;
					}
				}
				var divHeight = (45 + (lineNum - 1 + specialParamCount)*25) + "px";
				if(sDisplayValue == "ON") 
				{
					sectionDiv += '<div class="mainframe_ul_w" style="height:' + divHeight + '" id="' + sectionId + 'Content">';
				}
				else
				{
					sectionDiv += '<div class="mainframe_ul_w" style="height:' + divHeight + ';display: none;" id="' + sectionId + 'Content"">';
				}	
				if(normalParamLength != 0)
				{
					if(specialSectionFlag === false)
					{					
						sectionDiv += '<div class="mainframe_div"><ul class="mainframe_ul1">';
					}
					else
					{
						sectionDiv += '<div class="mainframe_div"><ul class="mainframe_ul1" style="padding-bottom: 0px;">';
					}
				}
				var colDisplayCnt = 0;
				$(sectionEl).find("param").each(function(paramNo, paramEl)
				{					
					var displayAttr = $(paramEl).find("display").text();
					if(displayAttr != "OFF"){
						colDisplayCnt++;
					}
					if(typeof $(paramEl).attr("id") == "undefined"){
                        paramId = "param" + sctionNo + "_" + paramNo;
					}
					else{
                        paramId = $(paramEl).attr("id");
					}
					var widgetType = $(paramEl).find("widget").text();
					objIdArray[sctionNo].push(paramId);
					if(normalParamLength != 0)
					{
						if(colDisplayCnt > lineNum)
						{
							colDisplayCnt = 0;
							sectionDiv += '</ul></div>';
							if(specialSectionFlag === false)
							{
								sectionDiv += '<div class="mainframe_div"><ul class="mainframe_ul2">';	
							}
							else
							{
								sectionDiv += '<div class="mainframe_div"><ul class="mainframe_ul2" style="padding-bottom: 0px;">';
							}
						}
					}
					if(widgetType == INPUT_TEXT_LONG)
					{
						if(fullFlag == false)
						{
							if(normalParamLength != 0)
							{
								sectionDiv += '</ul></div>';
							}							
							sectionDiv += '<div class="mainframe_div_full"><ul class="mainframe_ul_full">';
							fullFlag = true;
						}						
					}
					if($(paramEl).find("display").text() == "OFF")
					{
						sectionDiv += '<li id="' + paramId + 'Li" style="display: none;">' + $(paramEl).find("name" + languageSuffix[language]).text() + ':&nbsp;';
					}
					else
					{
						sectionDiv += '<li id="' + paramId + 'Li">' + $(paramEl).find("name" + languageSuffix[language]).text() + ':&nbsp;';						
					}										
					if(widgetType == SELECT) //下拉框
					{
						if($(paramEl).find("write").text() === "R")
						{
							sectionDiv += '<select id="' + paramId + '" disabled="disbaled">';
						}
						else
						{
							sectionDiv += '<select id="' + paramId + '">';
						}						
						$(paramEl).find("option").each(function()
						{
							sectionDiv += '<option value="' + $(this).attr("value") + '">' +  $(this).attr("name" + languageSuffix[language]) + '</option>';
						});
						sectionDiv += '</select>';
					}
					else if((widgetType == INPUT_TEXT_NORMAL) || (widgetType == INPUT_PSD) || (widgetType == INPUT_TEXT_LONG)) //输入框
					{
						if($(paramEl).find("write").text() === "R")
						{
							if((widgetType == INPUT_TEXT_NORMAL) || (widgetType == INPUT_TEXT_LONG))
							{
								sectionDiv += '<input type="text" id="' + paramId + '" readonly="readonly" />';								
								readParamStrObj[paramId] = {};
								$(paramEl).find("option").each(function()
								{
									readParamStrObj[paramId]["value_" + $(this).attr("value")] = $(this).attr("name" + languageSuffix[language]);
								});
							}
							else
							{
								sectionDiv += '<input type="password" id="' + paramId + '" readonly="readonly" />';
							}
						}
						else
						{
							if((widgetType == INPUT_TEXT_NORMAL) || (widgetType == INPUT_TEXT_LONG))
							{
								sectionDiv += '<input type="text" id="' + paramId + '" />';
							}
							else
							{
								sectionDiv += '<input type="password" id="' + paramId + '" />';
							}
							var typeDefined = $(paramEl).find("type").text();
							var typeList = typeDefined.split(",");		
							var paramType;
							for(var num = 0; num < typeList.length; num++)
							{
								paramType = paramTypeStr[typeList[num]];
								var paramDetail = [];
								paramDetail.push(paramId);								
								paramDetail.push(paramType);
								paramDetail.push($(paramEl).find("name_en").text());
								paramDetail.push($(paramEl).find("name_ch").text());
								if(typeList[num] < IP_ADDR)
								{
									paramDetail.push($(paramEl).find("range").attr("start"));
									paramDetail.push($(paramEl).find("range").attr("end"));
									paramDetail.push($(paramEl).find("display_str").text());
								}
								else if(typeList[num] == SUBNET_MASK)
								{
									paramDetail.push($(paramEl).find("relate").attr("ip"));
								}
								else if(typeList[num] == GATEWAY)
								{
									paramDetail.push($(paramEl).find("relate").attr("ip"));
									paramDetail.push($(paramEl).find("relate").attr("mask"));
								}							
								validatParamArray.push(paramDetail);
							}							
						}
					}
					else if(widgetType == IMG) //图片时，控件类型为span
					{
						sectionDiv += '<span id="' + paramId + '"></span>';
						readParamStrObj[paramId] = {};
						$(paramEl).find("option").each(function()
						{
							readParamStrObj[paramId]["value_" + $(this).attr("value")] = $(this).attr("name" + languageSuffix[language]);
						});
					}
					sectionDiv += '</li>';
				});
				sectionDiv += '</ul></div>';
				if(normalParamLength == 1)
				{
					sectionDiv += '<div class="mainframe_div"><ul class="mainframe_ul2"></ul></div>';					
				}				
				sectionDiv += '</div>';
				$(".mainframe_foot_bar").before(sectionDiv);
				$("input[readonly=readonly]").css("border", "0");
				sectionLength++;	
			});
			$(xml).find('identifier').each(function()
			{
				identifierArray.push("");
			});
			funcUpdateDisplay();
    	}
	});
}
function paramCheck()
{
	for(var i = 0; i < validatParamArray.length; i++)
	{
		var paramTemp = validatParamArray[i];
        var $obj = $("#" + paramTemp[PARAM_ID]);
        if($obj.is(":hidden")){
            continue;
        }
		if(eval(paramTemp[PARAM_TYPE]) > KEY)
		{
			returnFlag = ValidateIP($("#" + paramTemp[PARAM_ID]),  paramTemp[PARAM_TYPE], "<" + paramTemp[PARAM_EN_NAME] + ">", "<" + paramTemp[PARAM_CH_NAME] + ">", language);
			if(returnFlag === false)
			{
				return false;
			}
			if(paramTemp[PARAM_TYPE] == "SUBNET_MASK")
			{
				returnFlag = ValidateSubnetMaskRelation($("#" + paramTemp[RELATE_IP]).val(), $("#" + paramTemp[PARAM_ID]), "<" + paramTemp[PARAM_EN_NAME] + ">", "<" + paramTemp[PARAM_CH_NAME] + ">", language);
				if(returnFlag === false)
				{
					return false;
				}
			}
			if(paramTemp[PARAM_TYPE] == "GATEWAY")
			{
				returnFlag = ValidateGatewayRelation($("#" + paramTemp[RELATE_IP]).val(), $("#" + paramTemp[RELATE_MASK]).val(), $("#" + paramTemp[PARAM_ID]), "<" + paramTemp[PARAM_EN_NAME] + ">", "<" + paramTemp[PARAM_CH_NAME] + ">", language);
				if(returnFlag === false)
				{
					return false;
				}
			}
		}
		else
		{
        	if(Number(paramTemp[RANGE_START]) < 0 || Number(paramTemp[RANGE_END]) < 0){
                returnFlag = ValidateParam($("#" + paramTemp[PARAM_ID]),  "INT_DEC", Number(paramTemp[RANGE_START]), Number(paramTemp[RANGE_END]), "<" + paramTemp[PARAM_EN_NAME] + ">", "<" + paramTemp[PARAM_CH_NAME] + ">", language, paramTemp[DEFAULT]);
			}
			else{
                returnFlag = ValidateParam($("#" + paramTemp[PARAM_ID]),  paramTemp[PARAM_TYPE], Number(paramTemp[RANGE_START]), Number(paramTemp[RANGE_END]), "<" + paramTemp[PARAM_EN_NAME] + ">", "<" + paramTemp[PARAM_CH_NAME] + ">", language, paramTemp[DEFAULT]);
            }
			if(returnFlag === false)
			{
				return false;
			}
		}
	}
	return true;
}

function generateData()
{
	var data;
	var length;
	
	for(var i = 0; i < objIdArray.length; i++)
	{
		length = objIdArray[i].length;
		for(var j = 0; j < length; j++)
		{
			if((i === 0) && (j === 0))
			{
				data = $("#" + objIdArray[i][j]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
			}
			else if((i !== 0) && (j === 0))
			{
				data += FIRST_DELIMITER + $("#" + objIdArray[i][j]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
			}
			else
			{
				data += SECOND_DELIMITER + $("#" + objIdArray[i][j]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
			}
		}
	}	
	return data;
}