<div class="content_div_small">
  <div class="table_tab_div">
    <div class="table_tab_left"></div>
    <div class="table_tab">卫星传送系统描述符</div>
    <div class="table_tab_right"></div>
  </div>
  <table>
    <tr>
      <th>频率(GHz)</th>
      <td class="header">
        <input type="text" id="frequency" value="0.00000" />
      </td>
    </tr>
    <tr>
      <th>轨道位置(度)</th>
      <td>
        <input type="text" id="orbitalPosition" value="0.0" />
      </td>
    </tr>
    <tr>
      <th>东西部标志</th>
      <td>
        <select id="westEastFlag">
          <option value="0">西部</option>
          <option value="1">东部</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>极化方式</th>
      <td>
        <select id="polarization">
          <option value="0">水平极化</option>
          <option value="1">垂直极化</option>
          <option value="2">左旋圆极化</option>
          <option value="3">右旋圆极化</option>
        </select>
      </td>
    </tr>
    <tr id="rollOffTr" style="display: none;">
      <th>滚降系数</th>
      <td>
        <select id="rollOff">
          <option value="0">α=0.35</option>
          <option value="1">α=0.25</option>
          <option value="2">α=0.20</option>
          <option value="3">Reserved</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>标准</th>
      <td>
        <select id="descStandard" onchange="changeModulation();">
          <option value="0">DVB-S</option>
          <option value="1">DVB-S2</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>调制方式</th>
      <td>
        <select id="modulation">
			<option value="0">自动</option>
            <option value="1">QPSK</option>
            <option value="2">8PSK</option>
            <option value="3">16QAM</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>符号率(Msymbol/s)</th>
      <td>
        <input type="text" id="symbolrate" value="0.0000" />
      </td>
    </tr>
    <tr>
      <th>前向纠错内码</th>
      <td>
        <select id="fecInner">
          <option value="0">未定义</option>
          <option value="1">卷积码率1/2</option>
          <option value="2">卷积码率2/3</option>
          <option value="3">卷积码率3/4</option>
          <option value="4">卷积码率5/6</option>
          <option value="5">卷积码率7/8</option>
          <option value="15">无卷积编码</option>
        </select>
      </td>
    </tr>
  </table>
  <div class="bottom_button_div">
    <input type="button" id="descApplyBtn" value="确 定" class="input_normal" onclick="descPageApply();" />
    <input type="button" id="descCancelBtn" value="取 消" class="input_normal" onclick="cancelEdit();" />
  </div>
</div>
<script>
var objIdArray = ["frequency", "orbitalPosition", "westEastFlag", "polarization", "rollOff", "descStandard", "modulation", "symbolrate", "fecInner"];
var OBJ_NUM = 9;
var DESC_STANDARD = 5;
var DVB_S = 0;
var hiddenRowFlag = true;
function changeModulation()
{
	var standardValue = $("#descStandard").val();
	var $modulation = $("#modulation");
	$modulation.empty();
	if(standardValue == DVB_S)
	{
		$("#rollOffTr").hide();
		if(hiddenRowFlag == false)
		{				
			$("#simplemodal-container").css("height", function(index, value)
			{
				height = $(this).height();
				return ((height - ROW_HEIGHT) + "px");			
			});
			hiddenRowFlag = true;
		}
		if(language == ENGLISH)
		{
			$modulation.append('<option value="0">Auto</option>');
		}
		else
		{
			$modulation.append('<option value="0">自动</option>');
		}
		$modulation.append('<option value="1">QPSK</option>');
		$modulation.append('<option value="2">8PSK</option>');
		$modulation.append('<option value="3">16QAM</option>');
	}
	else
	{
		$("#rollOffTr").show();
		if(hiddenRowFlag == true)
		{
			$("#simplemodal-container").css("height", function(index, value)
			{
				height = $(this).height();
				return ((height + ROW_HEIGHT) + "px");
			});
			hiddenRowFlag = false;
		}
		if(language == ENGLISH)
		{
			$modulation.append('<option value="0">Auto</option>');
		}
		else
		{
			$modulation.append('<option value="0">自动</option>');
		}
		$modulation.append('<option value="1">QPSK</option>');
		$modulation.append('<option value="2">8PSK</option>');
	}
}
</script>