<div class="content_div_small">
  <div class="table_tab_div">
    <div class="table_tab_left"></div>
    <div class="table_tab">Satellite Delivery System Descriptor</div>
    <div class="table_tab_right"></div>
  </div>
  <table>
    <tr>
      <th>Frequency(GHz)</th>
      <td class="header">
        <input type="text" id="frequency" value="0.00000" />
      </td>
    </tr>
    <tr>
      <th>Orbital Position(Degree)</th>
      <td>
        <input type="text" id="orbitalPosition" value="0.0" />
      </td>
    </tr>
    <tr>
      <th>East West Flag</th>
      <td>
        <select id="westEastFlag">
          <option value="0">West</option>
          <option value="1">East</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Polarization</th>
      <td>
        <select id="polarization">
          <option value="0">Horizontal polarization</option>
          <option value="1">Vertical polarization</option>
          <option value="2">LHCP</option>
          <option value="3">RHCP</option>
        </select>
      </td>
    </tr>
    <tr id="rollOffTr" style="display: none;">
      <th>Rolloff Factor</th>
      <td>
        <select id="rollOff">
          <option value="0">α=0.35</option>
          <option value="1">α=0.25</option>
          <option value="2">α=0.20</option>
          <option value="3">Reserved</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Standard</th>
      <td>
        <select id="descStandard" onchange="changeModulation();">
          <option value="0">DVB-S</option>
          <option value="1">DVB-S2</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Modulation</th>
      <td>
        <select id="modulation">
          <option value="0">Auto</option>
          <option value="1">QPSK</option>
          <option value="2">8PSK</option>
          <option value="3">16QAM</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Symbol Rate(Msymbol/s)</th>
      <td>
        <input type="text" id="symbolrate" value="0.0000" />
      </td>
    </tr>
    <tr>
      <th>FEC-inner</th>
      <td>
        <select id="fecInner">
          <option value="0">Undefined</option>
          <option value="1">Convolution code rate 1/2</option>
          <option value="2">Convolution code rate 2/3</option>
          <option value="3">Convolution code rate 3/4</option>
          <option value="4">Convolution code rate 5/6</option>
          <option value="5">Convolution code rate 7/8</option>
          <option value="15">No convolutional coding</option>
        </select>
      </td>
    </tr>
  </table>
  <div class="bottom_button_div">
    <input type="button" id="descApplyBtn" value="OK" class="input_normal" onclick="descPageApply();" />
    <input type="button" id="descCancelBtn" value="Cancel" class="input_normal" onclick="cancelEdit();" />
  </div>
</div>
<script>
var objIdArray = ["frequency", "orbitalPosition", "westEastFlag", "polarization", "rollOff", "descStandard", "modulation", "symbolrate", "fecInner"];
var OBJ_NUM = 9;
var DESC_STANDARD = 5;
var DVB_S = 0;
var hiddenRowFlag = true;
function changeModulation()
{
	var standardValue = $("#descStandard").val();
	var $modulation = $("#modulation");
	$modulation.empty();
	if(standardValue == DVB_S)
	{
		$("#rollOffTr").hide();
		if(hiddenRowFlag == false)
		{				
			$("#simplemodal-container").css("height", function(index, value)
			{
				height = $(this).height();
				return ((height - ROW_HEIGHT) + "px");			
			});
			hiddenRowFlag = true;
		}
		if(language == ENGLISH)
		{
			$modulation.append('<option value="0">Auto</option>');
		}
		else
		{
			$modulation.append('<option value="0">自动</option>');
		}
		$modulation.append('<option value="1">QPSK</option>');
		$modulation.append('<option value="2">8PSK</option>');
		$modulation.append('<option value="3">16QAM</option>');
	}
	else
	{
		$("#rollOffTr").show();
		if(hiddenRowFlag == true)
		{
			$("#simplemodal-container").css("height", function(index, value)
			{
				height = $(this).height();
				return ((height + ROW_HEIGHT) + "px");
			});
			hiddenRowFlag = false;
		}
		if(language == ENGLISH)
		{
			$modulation.append('<option value="0">Auto</option>');
		}
		else
		{
			$modulation.append('<option value="0">自动</option>');
		}
		$modulation.append('<option value="1">QPSK</option>');
		$modulation.append('<option value="2">8PSK</option>');
	}
}
</script>