﻿var slotNo = 0xff;
var BUTTON_TAB_BLANK_HEIGHT = 69;
var id;
var actionType;

var psiIdSection;

var MENU_TABLE_INFO = 0;
var MENU_DESC = 5;

var operation;
var OPER_APPLY = 1;
var OPER_TABLE = 2;
var OPER_PROG = 3;
var OPER_ELEMENT = 4;
var OPER_STREAM = 5;
var OPER_FIRST_DESC = 6;
var OPER_SECOND_DESC = 7;

var elementType;
var VIDEO = 0;
var AUDIO = 1;

var nodeIndex;
var posIndex;
var parentIndex;
var descTag = 0;
var descId;
var curMenuId = null;

var PSI_NUM = 10;//共9种表，包括PAT、PMT、SDTA、SDTO、NITA、NITO MGT  9种,由于page type不连续，为了初始化树时的方便数量定义为10
var psiType;
var newPsiId;
var newPsiIdString = [];
var idString;

//page Type
var PAT = 26;
var PMT = 27;
var SDTA = 28;
var SDTO = 29;
var NITA = 30;
var NITO = 31;
var BAT = 32;
var CAT = 33;
var MGT = 35;
var psiNodes = ["PAT", "PMT", "SDTA", "SDTO", "NITA", "NITO", "BAT", "CAT", "", "MGT"];

var CHECKED = 1;
var NO_CHECKED = 0;

var CUSTOM = 17;
var CUSTOM_LINK_TYPE = 9;

var descData = [];
var rowNum = 0;

var descPageDef = {
    "2": "video_stream_desc",
    "3": "audio_stream_desc",
    "5": "regist_desc",
    "6": "data_stream_align_desc",
    "9": "ca_desc",
    "10": "ISO_639_desc",
    "11": "sys_clock_desc",
    "12": "multi_buffer_desc",
    "14": "max_bitrate_desc",
    "15": "private_indicate_desc",
    "16": "smooth_buffer_desc",
    "40": "avc_video_desc",
    "42": "avc_timing_hrd_desc",
    "64": "net_name_desc",
    "65": "service_list_desc",
    "66": "stuff_desc",
    "67":"satellite_delivery_desc",
    "68": "cable_delivery_desc",
    "71": "bouquet_name_desc",
    "72": "service_desc",
    "73": "available_country_desc",
    "74": "link_desc",
    "81": "mosaic_desc",
    "82": "stream_identifier_desc",
    "83": "ca_identifier_desc",
    "84": "content_desc",
    "86": "teletext_desc",
    "87": "telephone_desc",
    "89": "subtitle_desc",
    "90": "terrestrial_desc",
    "91": "multi_net_name_desc",
    "92": "multi_bouq_name_desc",
    "93": "multi_serv_name_desc",
    "95": "private_data_desc",
    "98": "freq_list_desc",
    "100": "data_broadcast_desc",
    "106": "ac3_desc",
    "122": "ac3_desc",
    "131": "lcn_desc",
    "192": "Hierarchical trans_desc",
    "193": "digital_copy_ctrl_desc",
    "200": "video_decode_ctrl_desc",
    "222": "content_available_desc",
    "252": "emergency_info_desc",
    "253": "data_component_desc"
};

var zTree;
var setting =
    {
        editable: false,//参数设置为true便可使用拖拽功能
        edit_renameBtn: false,
        edit_removeBtn: false,
        dragCopy: true,
        dragMove: false,
        data: {
            key: {
                children: "nodes"
            },
            simpleData: {
                enable: false,
                idKey: "id",
                pIdKey: "pId",
                rootPId: null
            }
        },
        view: {
            showLine: true,
            showTitle: false,
            showIcon: false,
            selectedMulti: false
        },
        callback: {
            onRightClick: zTreeRightClick,
            onExpand: zTreeOnExpand
        }
    };

var serviceCustomFlag = false;  // tag = 72
var serviceListCustomFlag = false;  //tag = 65;
var linkTypeCustomFlag = false;  //tag = 74;

window.onresize = function () {
    GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
    $("#treeContent").css("height", function (index, value) {
        return ((parent.iframeHeight - BUTTON_TAB_BLANK_HEIGHT) + "px");
    });
}

$(document).ready(function () {
    if (applyFlag == 0) {
        $(".tip_img").css("visibility", "hidden");
    }
    else {
        $(".tip_img").css("visibility", "visible");
    }
    if (curMenuId != null) {
        hideRightMenu(curMenuId);
    }
    document.body.onclick = function () {
        if (curMenuId != null) {
            hideRightMenu(curMenuId);
        }
    }
    document.oncontextmenu = function () {
        if (curMenuId != null) {
            hideRightMenu(curMenuId);
        }
    }
    $("#descApplyBtn, #descCancelBtn, #addBtn").live("mouseover", function () {
        inButtonClassChange($(this).attr("class"), $(this).attr("id"));
    });
    $("#descApplyBtn, #descCancelBtn, #addBtn").live("mouseout", function () {
        outButtonClassChange($(this).attr("class"), $(this).attr("id"));
    });

    GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
    $("#treeContent").css("height", function (index, value) {
        return ((parent.iframeHeight - BUTTON_TAB_BLANK_HEIGHT) + "px");
    });

    var args = GetArgs();
    id = args["psiId"];
    idString = id.split("_");
    funcUpdateDisplay();
});

function funcUpdateDisplay() {
    DisableButton("applyBtn");
    DisableButton("refreshBtn");
    PageLoadStatus(true);

    reloadTree();

    ResetColor();
    if (parent.groupAccess != USER) {
        EnableButton("applyBtn");
    }
    EnableButton("refreshBtn");
    PageLoadStatus(false);
}

/*************************************************
 Function:        reloadTree
 Description:    树的初始化
 Input:            无
 Output:            无
 Return:        无
 Others:        无
 *************************************************/
function reloadTree() {
    for (var i = 0; i < PSI_NUM; i++) {
        if (psiType == i + PAT) {
            zTree = $.fn.zTree.init($("#treeDemo"), setting, eval(psiNodes[i] + "Nodes"));
        }
    }
    specialNodesInit();
}

function specialNodesInit() {
    var treeObj;
    var allNodes;

    treeObj = $.fn.zTree.getZTreeObj("treeDemo");
    var allNodes = treeObj.transformToArray(treeObj.getNodes());
    for (var i = 0, len = allNodes.length; i < len; i++) {
        if (!allNodes[i].noR) {
            $("#" + allNodes[i].tId + "_span").css("font-weight", "bold");
        }
    }
}
/*************************************************
 Function:        zTreeOnExpand
 Description:    展开节点的回调函数，未展开的节点初始化的时候解析不到
 Input:            event:事件对象;
 treeId:当前树的treeId;
 treeNode:当前操作的树结点
 Output:        无
 Return:        无
 Others:        无
 *************************************************/
function zTreeOnExpand(event, treeId, treeNode) {
    var treeObj;
    var allNodes;
    treeObj = $.fn.zTree.getZTreeObj("treeDemo");
    var allNodes = treeObj.transformToArray(treeNode.nodes);
    for (var i = 0, len = allNodes.length; i < len; i++) {
        if (!allNodes[i].noR) {
            $("#" + allNodes[i].tId + "_span").css("font-weight", "bold");
        }
    }
}
/*************************************************
 Function:        zTreeRightClick
 Description:    树的右键操作
 Input:            event:事件对象;
 treeId:当前树的treeId;
 treeNode:当前操作的树结点
 Output:        无
 Return:        无
 Others:        无
 *************************************************/
function zTreeRightClick(event, treeId, treeNode) {
    var menuIndex;
    var descNodeId;
    var parentNode;

    if (!treeNode) {
        zTree.cancelSelectedNode();
        hideRightMenu();
    }
    else if (treeNode && (!treeNode.noR)) {
        /*
         if (event.target.tagName != "a" && $(event.target).parents("a").length == 0)
         {
         zTree.cancelSelectedNode();
         hideRightMenu();
         }
         */
        if (treeId == "treeDemo") {
            zTree.selectNode(treeNode);
            nodeIndex = zTree.getNodeIndex(treeNode);
            menuIndex = treeNode.menuType;
            changeRightMenu(menuIdArray[menuIndex], event);
            switch (psiType) {
                case PAT:
                    break;
                case PMT:
                    if ((menuIndex == MENU_ADD_PROG_DESC) || (menuIndex == MENU_VIDEO_ELEMENT) || (menuIndex == MENU_AUDIO_ELEMENT))//添加一级或二级描述符
                    {
                        descId = treeNode.ID;
                        if (menuIndex == MENU_VIDEO_ELEMENT) {
                            elementType = VIDEO;
                        }
                        else if (menuIndex == MENU_AUDIO_ELEMENT) {
                            elementType = AUDIO;
                        }
                    }
                    else if (menuIndex == MENU_DESC) {
                        descTag = parseInt(treeNode.tag, 10);
                        parentNode = treeNode.getParentNode();
                        parentIndex = zTree.getNodeIndex(parentNode);
                        descNodeId = parentNode.ID;
                        posIndex = treeNode.pos;
                        descId = descNodeId.concat("_", posIndex);
                        if (treeNode.level == 2) {
                            operation = OPER_FIRST_DESC;
                        }
                        else {
                            operation = OPER_SECOND_DESC;
                            if (parentNode.menuType == MENU_VIDEO_ELEMENT) //音频和视频下的数据流对准描述符是两个页面，但是对应的是一种描述符
                            {
                                elementType = VIDEO;
                            }
                            else {
                                elementType = AUDIO;
                            }
                        }
                    }
                    break;
                case SDTA:
                    if (menuIndex == MENU_PROG_DESC)//添加二级描述符
                    {
                        descId = treeNode.ID;
                    }
                    else if (menuIndex == MENU_DESC) {
                        operation = OPER_SECOND_DESC;
                        descTag = parseInt(treeNode.tag, 10);
                        descNodeId = treeNode.getParentNode().ID;
                        parentIndex = zTree.getNodeIndex(treeNode.getParentNode());
                        posIndex = treeNode.pos;
                        descId = descNodeId.concat("_", posIndex);
                    }
                    break;
                case SDTO:
                    if (menuIndex == MENU_PROG)  //添加二级描述符
                    {
                        descId = treeNode.ID;
                    }
                    else if (menuIndex == MENU_DESC)  //Modify and delete descriptor
                    {
                        operation = OPER_SECOND_DESC;
                        descTag = parseInt(treeNode.tag, 10);
                        parentNode = treeNode.getParentNode();
                        parentIndex = zTree.getNodeIndex(parentNode);
                        descNodeId = parentNode.ID;
                        posIndex = treeNode.pos;
                        descId = descNodeId.concat("_", posIndex);
                    }
                    break;
                case CAT:
                    if (menuIndex == MENU_ADD_CAT_DESC)  //Add CAT descriptor
                    {
                        descId = treeNode.ID;
                    }
                    else if (menuIndex == MENU_DESC)  //Modify and delete descriptor
                    {
                        operation = OPER_FIRST_DESC;
                        descTag = parseInt(treeNode.tag, 10);
                        descNodeId = treeNode.getParentNode().ID;
                        posIndex = treeNode.pos;
                        descId = descNodeId.concat("_", posIndex);
                    }
                    break;
                case BAT:
                case NITA:
                case NITO:
                    if ((menuIndex == MENU_ADD_FIRST_DESC) || (menuIndex == MENU_STREAM))//添加一级二级描述符
                    {
                        descId = treeNode.ID;
                    }
                    else if (menuIndex == MENU_DESC)  //Modify and delete descriptor
                    {
                        descTag = parseInt(treeNode.tag, 10);
                        parentNode = treeNode.getParentNode();
                        parentIndex = zTree.getNodeIndex(parentNode);
                        descNodeId = parentNode.ID;
                        posIndex = treeNode.pos;
                        descId = descNodeId.concat("_", posIndex);
                        if (treeNode.level == 2) {
                            operation = OPER_FIRST_DESC;
                        }
                        else {
                            operation = OPER_SECOND_DESC;
                        }
                    }
                    break;
                case MGT:
                    if (menuIndex == MENU_TABLE) // delete table
                    {
                        operation = OPER_APPLY; //暂时无实际意义， 临时赋值为1
                        //下面的代码是针对这个表的特殊处理
                        var nodeId = treeNode.ID.split("_");
                        nodeIndex = nodeId[nodeId.length - 1];
                    }
                    break;
                default:
                    break;
            }
        }
    }
}

/*************************************************
 Function:        changeMenu
 Description:    改变右键菜单
 Input:            menuId:对应的菜单id;
 event:事件对象
 Output:        无
 Return:        无
 Others:        无
 *************************************************/
function changeRightMenu(menuId, event) {
    var curBottomHeight;
    var curMenuHeight;
    if (curMenuId != null) {
        hideRightMenu(curMenuId);
    }
    if (parent.groupAccess != USER) {
        curBottomHeight = $("#mainContent").height() - event.clientY;
        curMenuHeight = $("#" + menuId).height();
        if (curBottomHeight < curMenuHeight) {
            $("#" + menuId).css({
                "top": event.clientY - (curMenuHeight - curBottomHeight) + "px",
                "left": (event.clientX + 10) + "px",
                "display": ""
            });
        }
        else {
            $("#" + menuId).css({"top": event.clientY + "px", "left": (event.clientX + 10) + "px", "display": ""});
        }
    }

    curMenuId = menuId;
}

/*************************************************
 Function:        hideRightMenu
 Description:    隐藏右键菜单
 Input:            menuId:对应的菜单id
 Output:        无
 Return:        无
 Others:        无
 *************************************************/
function hideRightMenu(menuId) {
    $("#" + menuId).css("display", "none");
}
/*************************************************
 Function:        deleteDesc
 Description:    用于描述符的删除
 Input:            无
 Output:        无
 Return:        无
 Others:        无
 *************************************************/
function deleteDesc() {
    if (language == ENGLISH) {
        var confirmPrompt = "Are you sure to delete the descriptor?";
    }
    else {
        var confirmPrompt = "确定要删除当前描述符吗？";
    }
    if (window.confirm(confirmPrompt)) {
        deleteApply();
    }
}

function deleteApply() {
    var data;
    var index;
    var response;
    var xmlHttp = GetHTTPObject();

    data = "type=" + psiType + "&cmd=" + DELETE + "&language=" + language + "&slotNo=" + slotNo + "&id=" + id + "&operation=" + operation + "&setString=";
    if (operation == OPER_FIRST_DESC) {
        index = posIndex;
    }
    else if (operation == OPER_SECOND_DESC) {
        index = parentIndex + FIRST_DELIMITER + posIndex;
    }
    else {
        index = nodeIndex;
    }
    data += index;

    xmlHttp.open("POST", "/goform/formEMR30", true)
    xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xmlHttp.setRequestHeader("Content-length", data.length);

    xmlHttp.onreadystatechange = function () {
        if ((xmlHttp.readyState == 4) && (xmlHttp.status == 200)) {
            response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
            if (response == RETURN_OK) {
                if (language == ENGLISH) {
                    alert('Delete successfully! Click the "Apply" button for the settings to take effect!');
                }
                else {
                    alert("删除成功，请点击应用使之生效！");
                }
            }
            else {
                alert(returnError[language][response]);
            }
            self.location.reload(true);
        }
    }
    xmlHttp.send(data);
}

function pageApply() {
    var data;
    var response;
    var xmlHttp = GetHTTPObject();

    data = "type=" + psiType + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&id=" + id + "&operation=" + OPER_APPLY

    xmlHttp.open("POST", "/goform/formEMR30", true)
    xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xmlHttp.setRequestHeader("Content-length", data.length);

    xmlHttp.onreadystatechange = function () {
        if ((xmlHttp.readyState == 4) && (xmlHttp.status == 200)) {
            response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
            if (response == RETURN_OK) {
                if (language == ENGLISH) {
                    alert("Apply Successfully!");
                }
                else {
                    alert("应用成功！");
                }
            }
            else {
                alert(returnError[language][response]);
            }
            if ((psiType == NITO) || (psiType == NITA) || (psiType == SDTO) || (psiType == BAT)) {
                var treeObj = zTree.getNodes();
                var getNodesAttr = treeObj[0].nodes[0].psiId;
                psiIdSection = parseInt(getNodesAttr, 10);
                newPsIidString = [idString[0], idString[1], idString[2], psiIdSection, idString[4]];
                newPsiId = newPsIidString.join("_");
                self.location.replace("?psiId=" + newPsiId + "");
            }
            else {
                self.location.reload(true);
            }
        }
    }
    xmlHttp.send(data);
}

/*************************************************
 Function:        cancelEdit
 Description:    弹出的编辑框取消编辑
 Input:            无
 Output:        无
 Return:        无
 Others:        无
 *************************************************/
function cancelEdit() {
    $.modal.close();
    descData = [];
    rowNum = 0;
    serviceCustomFlag = false;
    serviceListCustomFlag = false;
    linkTypeCustomFlag = false;
}

/*************************************************
 Function:        addDesc
 Description:    用于描述符的添加
 Input:            tag:描述符类型
 operation:操作类型0:add;1:modify
 Output:        无
 Return:        无
 Others:        无
 *************************************************/
function addDesc(tag, level) {
    actionType = ADD;
    operation = level;
    descTag = tag;
    sendRequest();
}

/*************************************************
 Function:        modifyDesc
 Description:    用于描述符的修改
 Input:            无
 Output:        无
 Return:        无
 Others:        无
 *************************************************/
function modifyDesc() {
    actionType = SET;
    sendRequest();
}

/*************************************************
 Function:        sendRequest
 Description:    用于描述符页面的添加和修改
 Input:            无
 Output:        无
 Return:        无
 Others:        无
 *************************************************/
function sendRequest() {
    var descFlag = 0;
    $.ajaxSetup({cache: false});
    for (var i in descPageDef) {
        if (descTag == Number(i)) {
            $.get("desc/" + descPageDef[i] + pageLanguage[language], null, function (data, textStatus) {
                $("#descInfo").html(data);
                if (descTag == 6) {
                    if (elementType == VIDEO) {
                        $("#videoTable").css("display", "");
                        $("#audioTable").css("display", "none");
                    }
                    else {
                        $("#videoTable").css("display", "none");
                        $("#audioTable").css("display", "");
                    }
                }
                if (actionType == SET) {
                    if ((descTag == 106) || (descTag == 122)) {
                        $("#descEnhanced").attr("disabled", true);
                    }
                    getDescInfo();
                }
                else {
                    if ((descTag == 106) || (descTag == 122)) {
                        $("#descEnhanced").attr("disabled", false);
                    }								                  
					if(descTag == 193){
						$("#descInfo").modal({containerCss:{width:$(window).width() - 50}});
					}
					else{
						$("#descInfo").modal({containerCss:{width:"580px"}});
					}	
                }
            });
            descFlag = 1;
        }
    }
    if (descFlag == 0) {
        $.get("desc/custom_desc" + pageLanguage[language], null, function (data, textStatus) {
            $("#descInfo").html(data);
            if (actionType == SET) {
                $("#customDescTag").attr("disabled", true);
                getDescInfo();
            }
            else {
                $("#customDescTag").attr("disabled", false);
				$("#descInfo").modal({containerCss:{width:"580px"}});

            }
        });
    }
}

function getDescInfo() {
    var data;
    var response;
    var xmlHttp = GetHTTPObject();

    data = "type=" + psiType + "&cmd=" + GET + "&language=" + language + "&slotNo=" + slotNo + "&operation=" + operation + "&descId=" + descId + "&descTag=" + descTag;

    xmlHttp.open("POST", "/goform/formEMR30", true)
    xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xmlHttp.setRequestHeader("Content-length", data.length);

    xmlHttp.onreadystatechange = function () {
        if ((xmlHttp.readyState == 4) && (xmlHttp.status == 200)) {
            response = AjaxStrDeal(xmlHttp.responseText);
            if (response != "") {
                var responseData = response.split(FIRST_DELIMITER);
                displayDesc(responseData);
                if(descTag == 193){
					$("#descInfo").modal({containerCss:{width:$(window).width() - 50}});
				}
				else{
					$("#descInfo").modal({containerCss:{width:"580px"}});
				}
            }
        }
    }
    xmlHttp.send(data);
}

function changeValue(obj) {
    var height;
    switch (descTag) {
        case 2:
            if (obj.prop("checked") == true) {
                for (i = 5; i < OBJ_NUM; i++) {
                    $("#" + objIdArray[i]).attr("disabled", false);
                }
            }
            else {
                for (i = 5; i < OBJ_NUM; i++) {
                    $("#" + objIdArray[i]).attr("disabled", true);
                }
            }
            break;
        case 12:
            if (obj.prop("checked") == true) {
                $("#" + objIdArray[1]).attr("disabled", false);
            }
            else {
                $("#" + objIdArray[1]).attr("disabled", true);
            }
            break;
        case 65:
            if (obj.val() == CUSTOM) {
                $("#descCustomTypeTr").css("display", "");
                if (serviceListCustomFlag == false) {
                    $("#simplemodal-container").css("height", function (index, value) {
                        height = $(this).height();
                        return ((height + ROW_HEIGHT) + "px");
                    });
                    serviceListCustomFlag = true;
                }
            }
            else {
                $("#descCustomTypeTr").css("display", "none");
                if (serviceListCustomFlag == true) {
                    $("#simplemodal-container").css("height", function (index, value) {
                        height = $(this).height();
                        return ((height - ROW_HEIGHT) + "px");
                    });
                    serviceListCustomFlag = false;
                }
            }
        case 72:
            if (obj.val() == CUSTOM) {
                $("#descCustomTypeTr").css("display", "");
                if (serviceCustomFlag == false) {
                    $("#simplemodal-container").css("height", function (index, value) {
                        height = $(this).height();
                        return ((height + ROW_HEIGHT) + "px");
                    });
                    serviceCustomFlag = true;
                }
            }
            else {
                $("#descCustomTypeTr").css("display", "none");
                if (serviceCustomFlag == true) {
                    $("#simplemodal-container").css("height", function (index, value) {
                        height = $(this).height();
                        return ((height - ROW_HEIGHT) + "px");
                    });
                    serviceCustomFlag = false;
                }
            }
            break;
        case 74:
            if (obj.val() == CUSTOM_LINK_TYPE) {
                $("#descCustomTypeTr").css("display", "");
                if (linkTypeCustomFlag == false) {
                    $("#simplemodal-container").css("height", function (index, value) {
                        height = $(this).height();
                        return ((height + ROW_HEIGHT) + "px");
                    });
                    linkTypeCustomFlag = true;
                }
            }
            else {
                $("#descCustomTypeTr").css("display", "none");
                if (linkTypeCustomFlag == true) {
                    $("#simplemodal-container").css("height", function (index, value) {
                        height = $(this).height();
                        return ((height - ROW_HEIGHT) + "px");
                    });
                    linkTypeCustomFlag = false;
                }
            }
            break;
        default:
            break;
    }
}
//40,42,192,200,222,253 default
function displayDesc(data) {
    var i;
    var j;
    var length;
    var sectionData;

    switch (descTag) {
        case 2:
            for (i = 0; i < OBJ_NUM; i++) {
                if ((i == 1) || (i == 5) || (i == 6) || (i == 7)) {
                    $("#" + objIdArray[i]).val(data[i]);
                }
                else {
                    if (parseInt(data[i], 10) == CHECKED) {
                        $("#" + objIdArray[i]).prop("checked", true);
                    }
                    else {
                        $("#" + objIdArray[i]).prop("checked", false);
                    }
                }
            }
            changeValue($("#" + objIdArray[2]));
            break;
        case 3:
        case 11:
        case 12:
        case 87:
            for (i = 0; i < OBJ_NUM; i++) {
                if (i == 0) {
                    if (parseInt(data[i], 10) == CHECKED) {
                        $("#" + objIdArray[i]).prop("checked", true);
                    }
                    else {
                        $("#" + objIdArray[i]).prop("checked", false);
                    }
                }
                else {
                    $("#" + objIdArray[i]).val(data[i]);
                }
            }
            if (descTag == 12) {
                changeValue($("#" + objIdArray[0]));
            }
            break;
        case 6:
            $("#" + objIdArray[elementType]).val(data[0]);
            break;
        case 9:
        case 14:
        case 15:
        case 16:
        case 64:
        case 66:
        case 67:
        case 68:
        case 71:
        case 72:
        case 74:
        case 82:
        case 90:
        case 95:
        case 100:
            if (descTag != 74) {
                for (i = 0; i < OBJ_NUM; i++) {
                    if ((descTag == 90) && (i == 0)) {
                        $("#" + objIdArray[i]).val(data[i] / 100000);
                    }
                    else {
                        $("#" + objIdArray[i]).val(data[i]);
                    }
                    if ((descTag == 67) && (i == DESC_STANDARD)) {
                        changeModulation();
                    }
                }
                if (descTag == 72) {
                    if (parseInt($("#descServiceType").val(), 10) == CUSTOM) {
                        $("#descCustomTypeTr").css("display", "");
                        serviceCustomFlag = true;
                    }
                    else {
                        $("#descCustomTypeTr").css("display", "none");
                        serviceCustomFlag = false;
                    }
                }
            }
            else {
                for (i = 0; i < OBJ_NUM; i++) {
                    if (i != LINK_TYPE) {
                        $("#" + objIdArray[i]).val(data[i]);
                    }
                    else {
                        if (data[i] < 9) {
                            $("#" + objIdArray[i]).val(data[i]);
                            $("#descCustomTypeTr").css("display", "none");
                            linkTypeCustomFlag = false;
                        }
                        else {
                            $("#" + objIdArray[i]).val(CUSTOM_LINK_TYPE);
                            $("#descCustomType").val(data[i]);
                            $("#descCustomTypeTr").css("display", "");
                            linkTypeCustomFlag = true;
                        }
                    }
                }
            }
            break;
        case 65:
        case 83:
        case 84:
        case 86:
        case 89:
        case 91:
        case 92:
        case 93:
        case 131:
        case 252:
            rowNum = data.length;
            if (rowNum != 0) {
                for (i = 0; i < rowNum; i++) {
                    descData.push(data[i]);
                }
                DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
                updateTableData();
            }
            break;
        case 10:
        case 73:
        case 98:
            $("#" + firstId).val(data[0]);
            if (data.length != 1) {
                descData = data[1].split(SECOND_DELIMITER);
                rowNum = descData.length;
                DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
                for (var i = 0; i < rowNum; i++) {
                    $("#" + objIdArray[0] + (i + 1)).html(descData[i]);
                }
                if ((descTag == 98) && (rowNum != 0)) {
                    $("#codingType").attr("disabled", true);
                }
            }
            break;
        case 81:
            changeCellLink();
            $("#descMosaic").val(data[0]);
            $("#descHorCell").val(data[1]);
            $("#descVerCell").val(data[2]);
            if (data.length > 3) {
                for (var i = 3, len = data.length; i < len; i++) {
                    descData.push(data[i]);
                }
                rowNum = data.length - 3;
                DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
                updateTableData();
            }
            break;
        case 106:
            $("#descEnhanced").prop("checked", false);	
            for (var i = 0,l = normalInfoIdArray.length; i < l; i++) {
				if(i < 4){
					if (parseInt(data[i], 10) == CHECKED) {
						$("#" + normalInfoIdArray[i]).prop("checked", true);
					}
					else {
						$("#" + normalInfoIdArray[i]).prop("checked", false);
					}
				}
				else{
					$("#" + normalInfoIdArray[i]).val(data[i]);					
					if(i != l -1){
						changeCheck(normalInfoIdArray[i].slice(0,-5));
					}
					
				}
                
            }
            break;
        case 122:
            $("#descEnhanced").prop("checked", true);
			changeEnhance($("#descEnhanced"));
            for (var i = 0,l = enhanceInfoIdArray.length; i < l; i++) {
				if(i < 8){
					if (parseInt(data[i], 10) == CHECKED) {
						$("#" + enhanceInfoIdArray[i]).prop("checked", true);
					}
					else {
						$("#" + enhanceInfoIdArray[i]).prop("checked", false);
					}
				}
				else{
					$("#" + enhanceInfoIdArray[i]).val(data[i]);
					if(i != l -1){
						changeCheck(enhanceInfoIdArray[i].slice(0,-5));
					}
				}            
            }
            break;
		case 193:
			var _cellData;
			for(var i = 0;i < fixIdArray.length; i++){
				$("#" + fixIdArray[i]).val(data[i]);
			}
			if(data[5] != ""){
				descData = data[5].split(SECOND_DELIMITER);
			}
			else{
				descData = [];
			}
           	rowNum = descData.length;
			DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
			for (var i = 0; i < rowNum; i++) {
				_cellData = descData[i].split(THIRD_DELIMITER);
				for(var j = 0; j < objIdArray.length; j++){
					$("#" + objIdArray[j] + (i + 1)).html(_cellData[j]);	
				}				
			}
			handleParam("maxBitrateFlag");
			handleParam("subMaxBitrateFlag");
			handleParam("comCtrlFlag");
            break;
        default:
            for (i = 0; i < OBJ_NUM; i++) {
                $("#" + objIdArray[i]).val(data[i]);
            }
			if(descTag == 42){
				handleParam("90KhzFlag");
				handleParam("picTimeInfoPresent");
			}
            break;
    }
}

function descPageApply() {
    var data;
    var response;
    var xmlHttp = GetHTTPObject();

    var matchFlag = false;
    for(var i in descPageDef){
        if (descTag == i) {
            matchFlag = true;
            break;
        }
    }
    if (!matchFlag) {
        descTag = 255;
    }

    if (descParamCheck() == false) {
        return;
    }

    data = "type=" + psiType + "&cmd=" + actionType + "&language=" + language + "&slotNo=" + slotNo + "&operation=" + operation + "&descId=" + descId + "&descTag=" + descTag + "&setString=";

    data += descGenerateData();
    //alert(data);
    //return;

    xmlHttp.open("POST", "/goform/formEMR30", true)
    xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xmlHttp.setRequestHeader("Content-length", data.length);

    xmlHttp.onreadystatechange = function () {
        if ((xmlHttp.readyState == 4) && (xmlHttp.status == 200)) {
            response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
            if (response == RETURN_OK) {
                if (actionType == ADD) {
                    if (language == ENGLISH) {
                        alert('Add Successfully! Click the "Apply" button for the settings to take effect!');
                    }
                    else {
                        alert("添加成功，请点击应用使之生效！");
                    }
                    self.location.reload(true);
                }
                else if (actionType == SET) {
                    if (language == ENGLISH) {
                        alert('Set Successfully! Click the "Apply" button for the settings to take effect!');
                    }
                    else {
                        alert("设置成功，请点击应用使之生效！");
                    }
                }
                self.location.reload(true);
            }
            else {
                alert(returnError[language][response]);
            }
        }
    }
    xmlHttp.send(data);
}

function descParamCheck() {
    var returnFlag;

    switch (descTag) {
        case 2:
        case 3:
        case 6:
        case 10:
        case 73:
        case 81:
        case 98:
		case 222:
            break;
        case 65:
        case 83:
        case 84:
        case 86:
        case 89:
        case 91:
        case 92:
        case 93:
        case 131:
		case 252:
            if (rowNum == 0) {
                if (language == ENGLISH) {
                    alert("The number of adding data can't be 0!");
                }
                else {
                    alert("添加的行数不能为0！");
                }
                return false;
            }
            break;
        case 9:
            returnFlag = ValidateParam($("#caSystemId"), "INT_DEC_HEX", 1, 65535, "<CA System ID>", "<CA 系统ID>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#caPid"), "INT_DEC_HEX", 32, 8191, "<CA PID>", "<CA PID>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#privateData"), "INT_HEX_NULL", 0, 0, "<Private Data>", "<私有数据>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#privateData"), "LENGTH", 0, 502, "<Private Data>", "<私有数据>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 11:
            returnFlag = ValidateParam($("#accuracyInteger"), "INT_DEC", 0, 63, "<Clock Accuracy Integer>", "<时钟精确度整数>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#accuracyExponent"), "INT_DEC", 0, 7, "<Clock Accuracy Exponent>", "<时钟精确度指数>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 12:
            if ($("#mdvValidFlag").prop("checked") == true) {
                returnFlag = ValidateParam($("#multiDelayVatiation"), "INT_DEC", 0, 32767, "<Multiplex Delay Variation>", "<复用延时变量>", language);
                if (returnFlag == false) {
                    return false;
                }
            }
            break;
        case 14:
            returnFlag = ValidateParam($("#maxBitrate"), "INT_DEC", 0, 4194303, "<Maximum Bitrate>", "<最大比特率>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 15:
            returnFlag = ValidateParam($("#privateDataIndicator"), "INT_DEC_HEX", 0, 4294967295, "<Private Data Indicator>", "<私用数据指示器>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 16:
            returnFlag = ValidateParam($("#leakRate"), "INT_DEC", 0, 4194303, "<Leak Rate>", "<泄露码率>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#size"), "INT_DEC", 0, 4194303, "<Size>", "<长度>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 40:
            returnFlag = ValidateParam($("#profileIdc"), "INT_DEC", 0, 255, "<profile_idc>", "<profile_idc>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#avcCompatiableFlags"), "INT_DEC", 0, 31, "<AVC_compatible_flags>", "<AVC_compatible_flags>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#levelIdc"), "INT_DEC", 0, 255, "<level_idc>", "<level_idc>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 42:
            returnFlag = ValidateParam($("#nVlaue"), "INT_DEC", 0, 4294967295, "<N>", "<N>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#kValue"), "INT_DEC", 0, 4294967295, "<K>", "<K>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#numUnitsInTick"), "INT_DEC", 0, 4294967295, "<num_units_in_tick>", "<num_units_in_tick>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 64:
            returnFlag = ValidateParam($("#networkName"), "LENGTH", 0, 31, "<Network Name>", "<网络名称>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#networkName"), language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 66:
            returnFlag = ValidateParam($("#stuffLength"), "INT_DEC_HEX", 1, 255, "<Stuffing Length>", "<填充长度>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#stuffByte"), "INT_HEX", 0, 0, "<Stuffing Bytes>", "<填充字节>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#stuffByte"), "LENGTH", 2, 2, "<Stuffing Bytes>", "<填充字节>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 67:
            returnFlag = ValidateParam($("#frequency"), "FLOATING", 0, 999.99999, "<Frequency>", "<频率>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#orbitalPosition"), "FLOATING", 0, 179.9, "<Orbital Position>", "<轨道位置>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#symbolrate"), "FLOATING", 0, 999.9999, "<Symbol Rate>", "<符号率>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 68:
            returnFlag = ValidateParam($("#frequency"), "FLOATING", 0, 9999.9999, "<Frequency>", "<频率>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#symbolrate"), "FLOATING", 0, 999.9999, "<Symbol Rate>", "<符号率>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 71:
            returnFlag = ValidateParam($("#bouquetName"), "LENGTH", 0, 31, "<Bouquet Name>", "<业务群名称>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#bouquetName"), language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 72:
            returnFlag = ValidateParam($("#descServiceName"), "LENGTH", 0, 31, "<Service Name>", "<业务名称>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#descServiceName"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#descProviderName"), "LENGTH", 0, 31, "<Provider Name>", "<业务提供商>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#descProviderName"), language);
            if (returnFlag == false) {
                return false;
            }
            if (parseInt($("#descServiceType").val(), 10) == CUSTOM) {
                returnFlag = ValidateParam($("#descCustomType"), "INT_DEC_HEX", 17, 255, "<Custom Type>", "<自定义类型>", language);
                if (returnFlag == false) {
                    return false;
                }
            }
            break;
        case 74:
            returnFlag = ValidateParam($("#transStreamId"), "INT_DEC_HEX", 0, 65535, "<Transport Stream ID>", "<传送流ID>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#descOriginalNetId"), "INT_DEC_HEX", 0, 65535, "<Original Network ID>", "<原始网络ID>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#descServiceId"), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#privateData"), "INT_HEX_NULL", 0, 0, "<Private Data>", "<私有数据>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#privateData"), "LENGTH", 0, 496, "<Private Data>", "<私有数据>", language);
            if (returnFlag == false) {
                return false;
            }
            if (parseInt($("#descLinkType").val(), 10) == CUSTOM_LINK_TYPE) {
                returnFlag = ValidateParam($("#descCustomType"), "INT_DEC_HEX", 9, 254, "<Custom Type>", "<自定义类型>", language);
                if (returnFlag == false) {
                    return false;
                }
                $("#descLinkType option[value=9]").val($("#descCustomType").val());
            }
            break;
        case 82:
            returnFlag = ValidateParam($("#componentTag"), "INT_DEC_HEX", 0, 255, "<Component Tag>", "<组件标签>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 87:
            returnFlag = ValidateParam($("#connectionType"), "INT_DEC_HEX", 0, 31, "<Connection Type>", "<连接类型>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#countryPrefixChar"), "LENGTH", 0, 3, "<Country Prefix>", "<国家前缀字符>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#countryPrefixChar"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#internationalAreaCodeChar"), "LENGTH", 0, 7, "<International Area Code>", "<国际区域代码字符>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#internationalAreaCodeChar"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#operatorCodeChar"), "LENGTH", 0, 3, "<Operator Code>", "<接线员代码字符>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#operatorCodeChar"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#nationalAreaCodeChar"), "LENGTH", 0, 7, "<National Area Code>", "<国内区域代码字符>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#nationalAreaCodeChar"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#coreNumberChar"), "LENGTH", 0, 15, "<Core Number>", "<中心号码字符>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#coreNumberChar"), language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 90:
            returnFlag = ValidateParam($("#frequency"), "FLOATING", 1, 42949, "<Centre Frequency>", "<中心频率>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 95:
            returnFlag = ValidateParam($("#privateDataSpecifier"), "INT_DEC_HEX", 0, 4294967295, "<Private Data Specifier>", "<专用数据说明符>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 100:
            returnFlag = ValidateParam($("#dataBroadcastId"), "INT_DEC_HEX", 1, 65535, "<Data Broadcast Identifier>", "<数据广播标识符>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#componentTag"), "INT_DEC_HEX", 0, 255, "<Component Tag>", "<组件标签>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#languageCode"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#selector"), "INT_HEX_NULL", 0, 0, "<Selector>", "<选数器>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#textChar"), language);
            if (returnFlag == false) {
                return false;
            }
            var tempselector = $("#selector").val();
            var temptextchar = $("#textChar").val();
            if (tempselector.length + temptextchar.length * 2 > 494) {
                alert("The length of descriptor cannot exceed 255!");
                return false;
            }
            break;
        case 106:
        case 122:
			returnFlag = ValidateParam($("#componentInput"), "INT_DEC_HEX", 0, 255, "<Component_type>", "<Component_type>", language);
			if (returnFlag == false) {
				return false;
			}
			returnFlag = ValidateParam($("#bsIdInput"), "INT_DEC_HEX", 0, 31, "<Bsid>", "<Bsid>", language);
			if (returnFlag == false) {
				return false;
			}
			returnFlag = ValidateParam($("#mianIdInput"), "INT_DEC_HEX", 0, 7, "<Mainid>", "<Mainid>", language);
			if (returnFlag == false) {
				return false;
			}
			returnFlag = ValidateParam($("#asvcInput"), "INT_DEC_HEX", 0, 255, "<Asvc>", "<Asvc>", language);
			if (returnFlag == false) {
				return false;
			}
            if ($("#descEnhanced").prop("checked") == true) {
                returnFlag = ValidateParam($("#subStream1Input"), "INT_DEC_HEX", 0, 255, "<Substream1>", "<Substream1>", language);
                if (returnFlag == false) {
                    return false;
                }
				returnFlag = ValidateParam($("#subStream2Input"), "INT_DEC_HEX", 0, 255, "<Substream2>", "<Substream2>", language);
                if (returnFlag == false) {
                    return false;
                }
				returnFlag = ValidateParam($("#subStream3Input"), "INT_DEC_HEX", 0, 255, "<Substream3>", "<Substream3>", language);
                if (returnFlag == false) {
                    return false;
                }
            }
            break;
        case 192:
            returnFlag = ValidateParam($("#referencePid"), "INT_DEC_HEX", 0, 8191, "<Reference_PID>", "<Reference_PID>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
		case 193:
            returnFlag = ValidateParam($("#digitalRecordCtrlData"), "INT_DEC", 0, 3, "<digital_recording_control_data>", "<digital_recording_control_data>", language);
            if (returnFlag == false) {
                return false;
            }
			returnFlag = ValidateParam($("#userDefined"), "INT_DEC", 0, 15, "<user_defined>", "<user_defined>", language);
            if (returnFlag == false) {
                return false;
            }
			returnFlag = ValidateParam($("#maximumBitrate"), "INT_DEC", 0, 255, "<maximum_bitrate(1/4Mbps)>", "<maximum_bitrate(1/4Mbps)>", language);
			if (returnFlag == false) {
                return false;
            }
            break;
        case 200:
            returnFlag = ValidateParam($("#vEncodeFormat"), "INT_DEC", 0, 15, "<video_encode_format>", "<video_encode_format>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 253:
            returnFlag = ValidateParam($("#dataComponentId"), "INT_DEC", 0, 65535, "<data_component_id>", "<data_component_id>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#additionalDataComponentInfo"), "INT_HEX_NULL", 0, 0, "<additional_data_component_info>", "<additional_data_component_info>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#additionalDataComponentInfo"), "LENGTH", 0, 506, "<additional_data_component_info>", "<additional_data_component_info>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        default:
            returnFlag = ValidateParam($("#customDescTag"), "INT_DEC_HEX", 0, 254, "<Descriptor Tag>", "<描述符标识>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#customDescData"), "INT_HEX", 0, 0, "<Descriptor Data>", "<描述符数据>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#customDescData"), "LENGTH", 0, 510, "<Descriptor Data>", "<描述符数据>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
    }
    return true;
}
//40,42,192,200,222,253 default
function descGenerateData() {
    var i;
    var j;
    var length;
    var sectionData;
    var data = "";
    var checkVal;
    var tempVal;

    switch (descTag) {
        case 2:
            for (i = 0; i < OBJ_NUM; i++) {
                if ((i == 1) || (i == 5) || (i == 6) || (i == 7)) {
                    data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
                }
                else {
                    if ($("#" + objIdArray[i]).prop("checked") == true) {
                        checkVal = CHECKED;
                    }
                    else {
                        checkVal = NO_CHECKED;
                    }
                    if (i == 0) {
                        data = checkVal;
                    }
                    else {
                        data += FIRST_DELIMITER + checkVal;
                    }
                }
            }
            break;

        case 3:
        case 11:
        case 12:
        case 87:
            for (i = 0; i < OBJ_NUM; i++) {
                if (i == 0) {
                    if ($("#" + objIdArray[i]).prop("checked") == true) {
                        data = CHECKED;
                    }
                    else {
                        data = NO_CHECKED;
                    }
                }
                else {
                    data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
                }
            }
            break;
        case 6:
            data = $("#" + objIdArray[elementType]).val();
            break;
        case 9:
        case 14:
        case 15:
        case 16:
        case 64:
        case 66:
        case 67:
        case 68:
        case 71:
        case 72:
        case 74:
        case 82:
        case 90:
        case 95:
        case 100:
            if (descTag == 67) {
                tempVal = parseFloat($("#" + objIdArray[0]).val());
                $("#" + objIdArray[0]).val(tempVal.toFixed(5));
                tempVal = parseFloat($("#" + objIdArray[1]).val());
                $("#" + objIdArray[1]).val(tempVal.toFixed(1));
                tempVal = parseFloat($("#" + objIdArray[7]).val());
                $("#" + objIdArray[7]).val(tempVal.toFixed(4));
            }
            else if (descTag == 68) {
                tempVal = parseFloat($("#" + objIdArray[0]).val());
                $("#" + objIdArray[0]).val(tempVal.toFixed(4));
                tempVal = parseFloat($("#" + objIdArray[3]).val());
                $("#" + objIdArray[3]).val(tempVal.toFixed(4));
            }
            for (i = 0; i < OBJ_NUM; i++) {
                if (i == 0) {
                    if ((descTag == 64) || (descTag == 71) || (descTag == 72)) {
                        data = $("#" + objIdArray[i]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
                    }
                    else if (descTag == 90) {
                        data = Number($("#" + objIdArray[i]).val()) * 100000;
                    }
                    else {
                        data = $("#" + objIdArray[i]).val();
                    }
                }
                else if ((i == 1) && (descTag == 72)) {
                    data += FIRST_DELIMITER + $("#" + objIdArray[i]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
                }
                else if ((i > 1) && (descTag == 87)) {
                    data += FIRST_DELIMITER + $("#" + objIdArray[i]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
                }
                else if (((i == 2) || (i == 4)) && (descTag == 100)) {
                    data += FIRST_DELIMITER + $("#" + objIdArray[i]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
                }
                else {
                    data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
                }
            }
            break;
        case 65:
        case 83:
        case 84:
        case 86:
        case 89:
        case 91:
        case 92:
        case 93:
        case 131:
        case 252:
            for (i = 0; i < rowNum; i++) {
                if (i == 0) {
                    data = descData[i].replace(/\+/g, "%2B").replace(/\&/g, "%26");
                }
                else {
                    data += FIRST_DELIMITER + descData[i].replace(/\+/g, "%2B").replace(/\&/g, "%26");
                }
            }
            break;
        case 10:
        case 73:
        case 98:
            data = $("#" + firstId).val() + FIRST_DELIMITER;
            for (i = 0; i < rowNum; i++) {
                if (i == 0) {
                    if (descTag == 98) {
                        data += parseFloat(descData[i]) * 1000000;
                    }
                    else {
                        data += descData[i].replace(/\+/g, "%2B").replace(/\&/g, "%26");
                    }
                }
                else {
                    if (descTag == 98) {
                        data += SECOND_DELIMITER + parseFloat(descData[i]) * 1000000;
                    }
                    else {
                        data += SECOND_DELIMITER + descData[i].replace(/\+/g, "%2B").replace(/\&/g, "%26");
                    }
                }
            }
            break;
        case 81:
            data = $("#descMosaic").val() + FIRST_DELIMITER + $("#descHorCell").val() + FIRST_DELIMITER + $("#descVerCell").val() + FIRST_DELIMITER;
            for (i = 0; i < rowNum; i++) {
                if (i == 0) {
                    data += descData[i];
                }
                else {
                    data += FIRST_DELIMITER + descData[i];
                }
            }
            break;
        case 106:
             for (var i = 0,l=normalInfoIdArray.length; i < l; i++) {
                if (i == 0) {
					if($("#" + normalInfoIdArray[i]).prop("checked") == true){
						data += 1;
					}
					else{
						data += 0;
					}  
                }
                else {
					if(i < 4){
						if($("#" + normalInfoIdArray[i]).prop("checked") == true){
							data += FIRST_DELIMITER + 1;
						}
						else{
							data += FIRST_DELIMITER + 0;
						}	
					}
					else{
						data += FIRST_DELIMITER + $("#" + normalInfoIdArray[i]).val();
					}   
                }
            }
            break;
        case 122:
            for (var i = 0,l=enhanceInfoIdArray.length; i < l; i++) {
                if (i == 0) {
					if($("#" + enhanceInfoIdArray[i]).prop("checked") == true){
						data += 1;
					}
					else{
						data += 0;
					}  
                }
                else {
					if(i < 8){
						if($("#" + enhanceInfoIdArray[i]).prop("checked") == true){
							data += FIRST_DELIMITER + 1;
						}
						else{
							data += FIRST_DELIMITER + 0;
						}	
					}
					else{
						data += FIRST_DELIMITER + $("#" + enhanceInfoIdArray[i]).val();
					}   
                }
            }
            break;
		case 193:
			for (var i = 0, len = fixIdArray.length; i < len; i++) {
				if (i == 0) {
					data = $("#" + fixIdArray[i]).val();
				}
				else {
					data += FIRST_DELIMITER + $("#" + fixIdArray[i]).val();
				}
			}
			if(rowNum == 0){
				data += FIRST_DELIMITER;
			}
            for (var i = 0; i < rowNum; i++) {
                if (i == 0) {
                	data += FIRST_DELIMITER + descData[i].replace(/\+/g, "%2B").replace(/\&/g, "%26");
                }
                else {
          			data += SECOND_DELIMITER + descData[i].replace(/\+/g, "%2B").replace(/\&/g, "%26");
                }
            }
            break;
        default:
            for (i = 0; i < OBJ_NUM; i++) {
                if (i == 0) {
                    data = $("#" + objIdArray[i]).val();
                }
                else {
                    data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
                }
            }
            break;
    }

    return data;
}

function updateTableData() {
    var rowData;
    var index;
    var displayStrCn_131 = ["否", "是"];
    var displayStrEn_131 = ["No", "Yes"];
    var displayStr_131 = [displayStrEn_131, displayStrCn_131];

    var displayStrCn_65 = ["", "数字电视业务", "数字音频广播业务", "图文电视业务", "NVOD参考业务", "NVOD时移业务", "马赛克业务", "PAL制编码信号", "SECAM制编码信号", "D/D2-MAC", "调频广播", "NTSC制信号", "数据广播业务", "公共接口", "RCS 映射", "RCS FLS", "DVB MHP业务", "用户自定义"];
    var displayStrEn_65 = ["", "Digital Television", "Digital Audio Broadcast", "Teletext", "NVOD Reference", "NVOD Time-shifted", "Mosaic Service", "PAL Coding Signal", "SECAM Coding Signal", "D/D2-MAC", "Frequency Modulation", "NTSC Signal", "Data Broadcasting", "Common Interface", "RCS Map", "RCS FLS", "DVB MHPService", "Custom"];
    var displayStr_65 = [displayStrEn_65, displayStrCn_65];

    var displayStrCn_89 = ["", "图文字幕", "相关的图文", "VBI数据", "DVB字幕，无宽高比限制", "DVB字幕，宽高比为4:3", "DVB字幕，宽高比为16:9", "DVB字幕，宽高比2.21:1", "DVB字幕(听力障碍者)，无宽高比限制", "DVB字幕(听力障碍者)，宽高比为4:3", "DVB 字幕(听力障碍者)，宽高比为16:9", "DVB 字幕(听力障碍者)，宽高比2.21:1"];
    var displayStrEn_89 = ["", "EBU Teletext Subtitles", "Associated Teletext", "VBI Data", "DVB, No Aspect Ratio Limit", "DVB, 4:3 Aspect Ratio", "DVB, 16:9 Aspect Ratio", "DVB, 2.21:1 Aspect Ratio", "DVB(Hearing Impaired), No Aspect Ratio Limit", "DVB(Hearing Impaired), 4:3 Aspect Ratio", "DVB(Hearing Impaired),16:9 Aspect Ratio", "DVB(Hearing Impaired),2.21:1 Aspect Ratio"];
    var displayStr_89 = [displayStrEn_89, displayStrCn_89];

    var displayStrCn_86 = ["", "初始图文电视页面", "图文电视字幕页面", "附加信息页面", "节目时间表页面", "为听力损伤的人的图副题记录"];
    var displayStrEn_86 = ["", "Initial Teletext Page", "Teletext Title Page", "Additional Info Page", "Service Schedule Page", "Teletext Subtitle For Hearing Impaired"];
    var displayStr_86 = [displayStrEn_86, displayStrCn_86];

    var charEncodingStrCn = ["默认", "ISO 8859-1", "ISO 8859-2", "ISO 8859-3", "ISO 8859-4", "ISO 8859-5(Cyrillic)", "ISO 8859-6(Arabic)", "ISO 8859-7(Greek)", "ISO 8859-8(Hebrew)", "ISO 8859-9", "ISO 8859-10", "ISO 8859-11", "", "ISO 8859-13", "ISO 8859-14(Celtic)", "ISO 8859-15", "ISO 10646(BMP)", "KSX1001-2004(Korean)", "GB-2312(Chinese)", "UTF-8", "无字符编码"];
    var charEncodingStrEn = ["Default", "ISO 8859-1", "ISO 8859-2", "ISO 8859-3", "ISO 8859-4", "ISO 8859-5(Cyrillic)", "ISO 8859-6(Arabic)", "ISO 8859-7(Greek)", "ISO 8859-8(Hebrew)", "ISO 8859-9", "ISO 8859-10", "ISO 8859-11", "", "ISO 8859-13", "ISO 8859-14(Celtic)", "ISO 8859-15", "ISO 10646(BMP)", "KSX1001-2004(Korean)", "GB-2312(Chinese)", "UTF-8", "No Charset"];
    var charEncodingStr = [charEncodingStrEn, charEncodingStrCn];

    for (var i = 0; i < rowNum; i++) {
        index = i + 1;
		if(descTag == 193){
			rowData = descData[i].split(THIRD_DELIMITER);
		}
		else{
			rowData = descData[i].split(SECOND_DELIMITER);
		}
        for (var j = 0; j < COL_NUM; j++) {
            if ((descTag == 131) && (j == 2)) {
                $("#" + objIdArray[j] + index).html(displayStr_131[language][parseInt(rowData[j], 10)]);
            }
            else if ((descTag == 89) && (j == 1)) {
                $("#" + objIdArray[j] + index).html(displayStr_89[language][parseInt(rowData[j], 10)]);
            }
            else if ((descTag == 86) && (j == 1)) {
                $("#" + objIdArray[j] + index).html(displayStr_86[language][parseInt(rowData[j], 10)]);
            }
            else if (descTag == 65) {
                if (j == 1) {
                    $("#" + objIdArray[j] + index).html(displayStr_65[language][parseInt(rowData[j], 10)]);
                }
                else if (j == 2) {
                    if (parseInt(rowData[1], 10) == CUSTOM) {
                        $("#" + objIdArray[j] + index).html(rowData[j]);
                    }
                    else {
                        $("#" + objIdArray[j] + index).html("--");
                    }
                }
                else {
                    $("#" + objIdArray[j] + index).html(rowData[j]);
                }
            }
            else if ((descTag == 91) && (j == 2)) {
                $("#" + objIdArray[j] + index).html(charEncodingStr[language][parseInt(rowData[j], 10)]);
            }
            else if ((descTag == 92) && (j == 2)) {
                $("#" + objIdArray[j] + index).html(charEncodingStr[language][parseInt(rowData[j], 10)]);
            }
            else if ((descTag == 93) && (j == 3)) {
                $("#" + objIdArray[j] + index).html(charEncodingStr[language][parseInt(rowData[j], 10)]);
            }
            else {
                $("#" + objIdArray[j] + index).html(rowData[j]);
            }
        }
    }
}

function validateBeforeAdd() {
    var returnFlag;
    var rowData;

    if (rowNum == maxRowNum) {
        if (language == ENGLISH) {
            alert("The adding number of data is no more than " + maxRowNum + "!");
        }
        else {
            alert("最多允许添加" + maxRowNum + "行数据！");
        }
        return false;
    }
    switch (descTag) {
        case 10:
            returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#languageCode"), language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 65:
            returnFlag = ValidateParam($("#descServiceId"), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
            if (returnFlag == false) {
                return false;
            }
            if (parseInt($("#descServiceType").val(), 10) == CUSTOM) {
                returnFlag = ValidateParam($("#descCustomType"), "INT_DEC", 0, 255, "<Custom Type>", "<自定义类型>", language);
                if (returnFlag == false) {
                    return false;
                }
            }
            break;
        case 73:
            returnFlag = ValidateParam($("#countryCode"), "LENGTH", 3, 3, "<Country Code>", "<国家代码>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#countryCode"), language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 81:
            returnFlag = ValidateParam($("#descLogicId"), "INT_DEC", 0, 63, "<Logical Cell ID>", "<逻辑单元标识符>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#descLogicInfo"), "INT_DEC", 0, 7, "<Logical Cell Presentation Info>", "<逻辑单元展现信息>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#descBasicCell"), "INT_HEX_NULL", 0, 0, "<Elementary Cell Field>", "<基本单元字段>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#descBasicCell"), "LENGTH", 0, 496, "<Elementary Cell Field>", "<基本单元字段>", language);
            if (returnFlag == false) {
                return false;
            }
            var subCellString = [];
            var elementCellString = $("#descBasicCell").val();
            if (elementCellString.length % 2 != 0) {
                elementCellString = "0" + elementCellString;
            }
            for (var i = 0, len = elementCellString.length; i < len; i++) {
                if (i % 2 != 0) {
                    continue;
                }
                else {
                    subCellString.push(elementCellString.slice(i, i + 2));
                }
            }
            for (var i = 0, len = subCellString.length; i < len; i++) {
                if (parseInt(subCellString[i], 16) > 63) {
                    if (language == CHINESE) {
                        alert("单元标识符应该在0x0(0)和0x3F(63)之间！");
                    }
                    else {
                        alert("ELement Identify should be between 0x0(0) and 0x3F(63)!");
                    }
                    return false;
                }
            }
            var cellLinkId = $("#descCellLinkInfo").val();
            if (cellLinkId == 1) {
                returnFlag = ValidateParam($("#descBouquetId"), "INT_DEC", 0, 65535, "<Bouquet ID>", "<业务群ID>", language);
                if (returnFlag == false) {
                    return false;
                }
            }
            else if ((cellLinkId == 2) || (cellLinkId == 3)) {
                returnFlag = ValidateParam($("#descNetworkId"), "INT_DEC", 0, 65535, "<Original Network ID>", "<原始网络ID>", language);
                if (returnFlag == false) {
                    return false;
                }
                returnFlag = ValidateParam($("#descTsId"), "INT_DEC", 0, 65535, "<Transport Stream ID>", "<传送流ID>", language);
                if (returnFlag == false) {
                    return false;
                }
                returnFlag = ValidateParam($("#descProgId"), "INT_DEC", 1, 65535, "<Service ID>", "<节目号>", language);
                if (returnFlag == false) {
                    return false;
                }
            }
            else {
                returnFlag = ValidateParam($("#descNetworkId"), "INT_DEC", 0, 65535, "<Original Network ID>", "<原始网络ID>", language);
                if (returnFlag == false) {
                    return false;
                }
                returnFlag = ValidateParam($("#descTsId"), "INT_DEC", 0, 65535, "<Transport Stream ID>", "<传送流ID>", language);
                if (returnFlag == false) {
                    return false;
                }
                returnFlag = ValidateParam($("#descProgId"), "INT_DEC", 1, 65535, "<Service ID>", "<节目号>", language);
                if (returnFlag == false) {
                    return false;
                }
                returnFlag = ValidateParam($("#descEventId"), "INT_DEC", 0, 65535, "<Event ID>", "<事件ID>", language);
                if (returnFlag == false) {
                    return false;
                }
            }
            break;
        case 83:
            returnFlag = ValidateParam($("#caSystemId"), "INT_DEC_HEX", 1, 65535, "<CA System ID>", "<CA系统标识符>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 84:
            returnFlag = ValidateParam($("#level1Content"), "INT_DEC", 0, 15, "<Content Nibble Level 1>", "<一级节目内容分类>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#level2Content"), "INT_DEC", 0, 15, "<Content Nibble Level 2>", "<二级节目内容分类>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#user1Content"), "INT_DEC", 0, 255, "<User Nibble Level 1>", "<一级用户节目内容分类>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#user2Content"), "INT_DEC", 0, 255, "<User Nibble Level 2>", "<二级用户节目内容分类>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 86:
            returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#languageCode"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#ttMagazineNum"), "INT_DEC_HEX", 0, 7, "<Teletext Magazine Number>", "<图文杂志号>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#ttPageNum"), "INT_DEC_HEX", 0, 255, "<Teletext Page Number>", "<图文页面号>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 89:
            returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#languageCode"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#compPageId"), "INT_DEC_HEX", 0, 65535, "<Composition Page ID>", "<构图页面标识>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#ancilPageId"), "INT_DEC_HEX", 0, 65535, "<Ancillary Page ID>", "<辅助页面标识>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 91:
            returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#languageCode"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#networkName"), "LENGTH", 0, 31, "<Network Name>", "<网络名称>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#networkName"), language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 92:
            returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#languageCode"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#bouquetName"), "LENGTH", 0, 31, "<Bouquet Name>", "<群名称>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#bouquetName"), language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 93:
            returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#languageCode"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#descServiceProvider"), "LENGTH", 0, 31, "<Service Provider Name>", "<业务提供商>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#descServiceProvider"), language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#descServiceName"), "LENGTH", 0, 31, "<Service Name>", "<业务名称>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateName($("#descServiceName"), language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 98:
            var codingType = parseInt($("#codingType").val(), 10);
            var minCenterFreq = [0, 0, 0, 1];
            var maxCenterFreq = [4294.967295, 999999.99, 9999.9999, 42949.67295];
            returnFlag = ValidateParam($("#centerFreq"), "FLOATING", minCenterFreq[codingType], maxCenterFreq[codingType], "<Centre Frequency>", "<中心频率>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 131:
            returnFlag = ValidateParam($("#descServiceId"), "INT_DEC", 1, 65535, "<Service ID>", "<节目号>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#logicChNum"), "INT_DEC", 0, 1023, "<Logical Channel Number>", "<逻辑频道号>", language);
            if (returnFlag == false) {
                return false;
            }
            for (var i = 0; i < rowNum; i++) {
                rowData = descData[i].split(SECOND_DELIMITER);
                if (parseInt($("#descServiceId").val(), 10) == parseInt(rowData[0], 10)) {
                    if (language == ENGLISH) {
                        alert("Service ID is repeated!");
                    }
                    else {
                        alert("节目号重复!");
                    }
                    return false;
                }
                if (parseInt($("#logicChNum").val(), 10) == parseInt(rowData[1], 10)) {
                    if (language == ENGLISH) {
                        alert("Logical Channel Number is repeated!");
                    }
                    else {
                        alert("逻辑频道号重复!");
                    }
                    return false;
                }
            }
            break;
		case 193:
            returnFlag = ValidateParam($("#subComTag"), "INT_DEC", 0, 255, "<component_tag>", "<component_tag>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#subDigitalRecordCtrlData"), "INT_DEC", 0, 3, "<digital_recording_control_data>", "<digital_recording_control_data>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#subUserDefined"), "INT_DEC", 0, 15, "<user_defined>", "<user_defined>", language);
            if (returnFlag == false) {
                return false;
            }
			returnFlag = ValidateParam($("#subMaxBitrate"), "INT_DEC", 0, 255, "<maximum_bitrate(1/4Mbps)>", "<maximum_bitrate(1/4Mbps)>", language);
            if (returnFlag == false) {
                return false;
            }
            break;
        case 252:
            returnFlag = ValidateParam($("#descServiceId"), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<Service ID>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#areaCodeData"), "INT_HEX_NULL", 0, 0, "<area_code_data>", "<area_code_data>", language);
            if (returnFlag == false) {
                return false;
            }
            returnFlag = ValidateParam($("#areaCodeData"), "LENGTH", 0, 506, "<area_code_data>", "<area_code_data>", language);
            if (returnFlag == false) {
                return false;
            }
			var _areaCodeData = $("#areaCodeData").val();
			if(_areaCodeData.length % 4 != 0){
				if (language == ENGLISH) {
                    alert("The length of <area_code_data> must be in multiples of four!");
				}
				else {
					alert("<area_code_data>的长度必须是4的倍数!");
				}
				return false;
			}
            break;
        default:
            break;
    }
}

var SELECT_PARAM = 1;
var LCN_SELECT_PARAM = 2;
var DEFAULT_SELECT_INDEX = 0;

function clearParamValue() {
    switch (descTag) {
        case 10:
        case 73:
        case 83:
        case 91:
        case 92:
        case 93:
        case 98:
            for (var i = 0; i < COL_NUM; i++) {
                $("#" + objIdArray[i]).val("");
            }
            if ((descTag == 98) && (rowNum != 0)) {
                $("#codingType").attr("disabled", true);
            }
            break;
        case 84:
            for (var i = 0; i < COL_NUM; i++) {
                $("#" + objIdArray[i]).val("0");
            }
            break;
        case 65:
        case 86:
        case 89:
            for (var i = 0; i < COL_NUM; i++) {
                if (i == SELECT_PARAM) {
                    $("#" + objIdArray[i]).get(0).selectedIndex = DEFAULT_SELECT_INDEX;
                }
                else {
                    $("#" + objIdArray[i]).val("");
                }
            }
            if (descTag == 65) {
                $("#descCustomTypeTr").css("display", "none");
                if (serviceListCustomFlag == true) {
                    $("#simplemodal-container").css("height", function (index, value) {
                        height = $(this).height();
                        return ((height - ROW_HEIGHT) + "px");
                    });
                    serviceListCustomFlag = false;
                }
            }
            break;
        case 131:
            for (var i = 0; i < COL_NUM; i++) {
                if (i == LCN_SELECT_PARAM) {
                    $("#" + objIdArray[i]).get(0).selectedIndex = DEFAULT_SELECT_INDEX;
                }
                else {
                    $("#" + objIdArray[i]).val("");
                }
            }
            break;
        default:
            break;
    }
    ResetColor();
}

var addNum = 0;
var origHeight;
var ROW_HEIGHT = 22;
var DISPLAY_ROW_NUM = 5;
var HEIGHT_OFFSET = ROW_HEIGHT * DISPLAY_ROW_NUM;
function addTableRow() {
    var rowData;
    var height;

    if (validateBeforeAdd() == false) {
        return;
    }

    for (var i = 0; i < COL_NUM; i++) {
        if (i == 0) {
            if (descTag == 98) {
                rowData = parseFloat($("#" + objIdArray[i]).val()).toFixed(6);
            }
            else {
                rowData = $("#" + objIdArray[i]).val();
            }
        }
        else {
			if (descTag == 193) {
				if(i == COL_NUM-1){
					if($("#" + objIdArray[i-1]).val() == "0"){
						rowData += THIRD_DELIMITER + 0;
					}
					else{
						rowData += THIRD_DELIMITER + $("#" + objIdArray[i]).val();
					}					
				}
				else{
					rowData += THIRD_DELIMITER + $("#" + objIdArray[i]).val();
				}				
			}
			else{
				rowData += SECOND_DELIMITER + $("#" + objIdArray[i]).val();
			}           
        }
    }
    if (descTag == 81) {
        var curLinkType = $("#descCellLinkInfo").val();
        if (curLinkType == 1) {
            rowData += SECOND_DELIMITER + $("#descBouquetId").val();
        }
        else if ((curLinkType == 2) || (curLinkType == 3)) {
            rowData += SECOND_DELIMITER + $("#descNetworkId").val() + SECOND_DELIMITER + $("#descTsId").val() + SECOND_DELIMITER + $("#descProgId").val();
        }
        else {
            rowData += SECOND_DELIMITER + $("#descNetworkId").val() + SECOND_DELIMITER + $("#descTsId").val() + SECOND_DELIMITER + $("#descProgId").val() + SECOND_DELIMITER + $("#descEventId").val();
        }
    }

    descData.push(rowData);
    rowNum++;
    clearParamValue();
    AddRow("dataTable", "dataRow", "CaseRow");
    updateTableData();

    $("#simplemodal-container").css("height", function (index, value) {
        height = $(this).height();
        if (addNum == 0) {
            origHeight = height;
        }
        if (height < 350) {
            if (height >= (origHeight + HEIGHT_OFFSET)) {
                return ((origHeight + HEIGHT_OFFSET) + "px");
            }
            else {
                return ((height + ROW_HEIGHT) + "px");
            }
        }
        else {
            return height + "px;";
        }
    });
    addNum++;
}

function deleteCurrentRow(obj)//delete row
{
    var height;
    var infoHeight;
    var index = parseInt(obj.attr("id").slice(6)) - 1;

    descData.splice(index, 1);
    rowNum--;
    if ((descTag == 98) && (rowNum == 0)) {
        $("#codingType").attr("disabled", false);
    }
    DelRow("dataTable", "dataRow", "CaseRow");
    updateTableData();
    infoHeight = ($("#descInfo").height() + 44);

    $("#simplemodal-container").css("height", function (index, value) {
        height = $(this).height();
        if (infoHeight >= height) {
            return ((origHeight + HEIGHT_OFFSET) + "px");
        }
        else {
            if (height <= origHeight) {
                return (origHeight + "px");
            }
            else {
                return ((height - ROW_HEIGHT) + "px");
            }
        }
    });
}