﻿var getIdArray = ["backupSwitch", "backupMode", "mbErrorTime", "mbRecoverTime","bmErrorTime", "bmRecoverTime", "curState", "mainCard", "mainPort", "mainServiceId", "mainServiceName", "mainCurBitrate",  "mainMinRate", "mainMaxRate", "backupCard", "backupPort", "backupServiceId", "backupServiceName", "backupCurBitrate", "backupMinRate", "backupMaxRate","syncErrorCheck", "pmtErrorCheck", "pidErrorCheck", "scrambleErrorCheck", "ccErrorCheck", "ccErrorMax", "ccErrorTime", "ccRevertTime"];
var GET_OBJ_NUM = 29;
var setIdArray = ["backupSwitch", "backupMode", "mbErrorTime", "mbRecoverTime","bmErrorTime", "bmRecoverTime", "mainMinRate", "mainMaxRate", "backupCard", "backupPort", "backupServiceId",  "backupMinRate", "backupMaxRate","syncErrorCheck", "pmtErrorCheck", "pidErrorCheck", "scrambleErrorCheck", "ccErrorCheck", "ccErrorMax", "ccErrorTime", "ccRevertTime"];
var SET_OBJ_NUM = 21;
var id;
var oldId;
var optionArray;
var CUR_STATE = 6;
var MAIN_CARD = 7;
var MAIN_PORT = 8;
var BACKUP_CARD = 14;
var BACKUP_PORT = 15;
var ERROR_CHECK_S = 21;
var ERROR_CHECK_E = 25;
var ERROR_SET_S = 13;
var ERROR_SET_E = 17;

var curStateEn = ["Invalid", "Main", "Backup"];
var curStateCn = ["无效", "主路", "备路"];
var curState = [curStateEn, curStateCn];
var ONE_GBE_PORT_NUM = 256;
var cardArray = ["Card", "卡"];
var gbeArray = ["GbE", "网口"];
var portArray = ["Port", "端口"];
var GBE_ONE = 1;
var GBE_TWO = 2;
var INVALID = 0;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	oldId = args["ID"];
	var oldIdString = oldId.split("_");
	var idString = [oldIdString[0], oldIdString[1], oldIdString[2], parseInt(oldIdString[3])];
	id = idString.join("_");
	
	GetMainContentHeight(BUTTON_BOTTOM_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	$("input:checkbox").click(function()
	{
		EnableButton("applyBtn");
	});
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	generateOption();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function generateOption()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_BACKUP_LIST + "&cmd=" + GET + 
		"&language=" + language + "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			optionArray = response.split(FIRST_DELIMITER);
			populateBackupCards();
			displayParam();
		}
	}
	xmlHttp.send(null);
}

function populateBackupCards()
{
	var backupCard;
	var backupCardInfo;
	var option;
	var cardNum = optionArray.length;
	
	backupCard = $("#backupCard");
	backupCard.empty();
	
	for(var i = 0; i < cardNum; i++) 
	{
		backupCardInfo = optionArray[i].split(SECOND_DELIMITER);
		option = $("<option>").text(backupCardInfo[0]).val(backupCardInfo[1]);
		backupCard.append(option);
	}
	option = $("<option>").text(noCardList[language]).val(NO_CARD);
	backupCard.append(option);
}

function populateBackupPorts(obj)
{
	var backupPort = $("#backupPort");
	backupPort.empty();
	var option;
	var cardNo = parseInt(obj.val(), 10);
	if(cardNo == NO_CARD)
	{
		option = $("<option>").text(noPortList[language]).val(NO_PORT);
		backupPort.append(option);
		$("#backupPortName").html("");
	}
	else
	{
		var selectIndex = obj.get(0).selectedIndex;
		var backupPortInfo = optionArray[selectIndex].split(SECOND_DELIMITER);
		var portNum = backupPortInfo.length - 2;
		var displayStr;
		
		for(var i = 0; i < portNum; i++)
		{
			var singlePortInfo = backupPortInfo[2 + i].split(THIRD_DELIMITER);
			displayStr = getPortDisplayStr(cardNo, parseInt(singlePortInfo[0], 10), language);
			option = $("<option>").text(displayStr).val(parseInt(singlePortInfo[0], 10) - 1);
			backupPort.append(option);
			if(i == 0)
			{
				$("#backupPortName").html(singlePortInfo[1]);
			}
		}
	}
	
}
function changePortName()
{
	getPortName(parseInt($("#backupCard").val(), 10), parseInt($("#backupPort").val(), 10) + 1, $("#backupPortName"));
}

function getPortName(cardValue, portValue, $obj)
{
	var cardNum = optionArray.length;
	for(var i = 0; i < cardNum; i++)
	{
		var singleCardInfo = optionArray[i].split(SECOND_DELIMITER);
		if(cardValue == singleCardInfo[1])
		{
			var portNum = singleCardInfo.length - 2;
			for(var j = 0; j < portNum; j++)
			{
				var singlePortInfo = singleCardInfo[2 + j].split(THIRD_DELIMITER);
				if(portValue == singlePortInfo[0])
				{
					$obj.html(singlePortInfo[1]);
				}
			}
		}
	}
}

function displayBackup()
{
	if(parseInt($("#backupSwitch").val(), 10) == ON)
	{
		$("#curStateTr").css("display", "");
		$("#backupModeTr").css("display", "");
		$("#mbErrorTimeTr").css("display", "");
		$("#mbRecoverTimeTr").css("display", "");
		$("#bmErrorTimeTr").css("display", "");
		$("#bmRecoverTimeTr").css("display", "");
		$("#monitorOptionsTr").css("display", "");
		$("#backupProg").css("display", "");
		$("#ccErrorMaxTr").css("display", "");
		$("#ccErrorTimeTr").css("display", "");
		$("#ccRevertTimeTr").css("display", "");
	}
	else
	{
		$("#curStateTr").css("display", "none");
		$("#backupModeTr").css("display", "none");
		$("#mbErrorTimeTr").hide();
		$("#mbRecoverTimeTr").hide();
		$("#bmErrorTimeTr").hide();
		$("#bmRecoverTimeTr").hide();
		$("#monitorOptionsTr").css("display", "none");
		$("#backupProg").css("display", "none");
		$("#ccErrorMaxTr").css("display", "none");
		$("#ccErrorTimeTr").css("display", "none");
		$("#ccRevertTimeTr").css("display", "none");
	}
}

function displayParam()
{
	var data;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();
	var infoData;
	var backupCard = $("#backupCard");
	var backupPort = $("#backupPort");
	var count = 0;

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PROGRAM_BACKUP_MUX + "&cmd=" + GET + "&id=" + id + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < GET_OBJ_NUM; i++)
				{
					if(i == CUR_STATE)
					{
						if(parseInt(data[i], 10) == INVALID)
						{
							for(var j = 0; j < SET_OBJ_NUM; j++)
							{
								$("#" + setIdArray[j]).attr("disabled", true);
							}
							$("#curState").css("color", "#777e88");
							$("#mainDataRow td").css("color", "#777e88");
							$("#backupDataRow td").css("color", "#777e88");
						}
						else
						{
							for(var j = 0; j < SET_OBJ_NUM; j++)
							{
								$("#" + setIdArray[j]).attr("disabled", false);
							}
							$("#curState").css("color", "#000");
							$("#mainDataRow td").css("color", "#000");
							$("#backupDataRow td").css("color", "#000");
						}
						$("#" + getIdArray[i]).html(curState[language][parseInt(data[i], 10)]);
					}
					else if(i == BACKUP_CARD)
					{
						if(data[i] == "") //备份开关是关闭的时候
						{
							$("#" + getIdArray[i]).val(backupCard.get(0).options[0].value);
							if($("option:last", backupCard).val() == "7")
							{
								$("option[value=7]", backupCard).remove();
							}
						}
						else
						{
							for(var j = 0, len = $("#backupCard option").length; j < len; j++)
							{
								if(data[i] != backupCard.get(0).options[j].value)
								{
									count++;
								}
								else
								{
									break;
								}
							}
							if(count == len) //无效的备份，选择无卡
							{
								$("#" + getIdArray[i]).val($("option:last", backupCard).val());
							}
							else //正常的备份，没有无卡的选项
							{
								if($("option:last", backupCard).val() == "7")
								{
									$("option[value=7]", backupCard).remove();
								}
								$("#" + getIdArray[i]).val(data[i]);								
							}
						}
						populateBackupPorts(backupCard);					
					}
					else if(i == BACKUP_PORT)
					{
						if(data[i] == "") //备份开关是关闭的时候
						{
							$("#" + getIdArray[i]).val(backupPort.get(0).options[0].value);
						}
						else
						{
							if(backupCard.val() == "7")
							{
								$("#" + getIdArray[i]).val(7);
							}
							else
							{								
								$("#" + getIdArray[i]).val(data[i]);
							}
						}
						getPortName(parseInt($("#backupCard").val()), parseInt(data[i]) + 1, $("#backupPortName"));
					}
					else if((i < CUR_STATE) || ((i > 11) && (i < 17)) || (i == 19) || (i == 20) || (i > ERROR_CHECK_E)) 
					{
						$("#" + getIdArray[i]).val(data[i]);
					}
					else if(i == MAIN_CARD)
					{
						var cardString = cardArray[language] + parseInt(data[i], 10);
						$("#" + getIdArray[i]).html(cardString);
					}
					else if(i == MAIN_PORT)
					{
						if(parseInt(data[MAIN_CARD], 10) - 1 == MAIN_GBE_CARD)
						{
							var portString;
							if(parseInt(data[i], 10) > ONE_GBE_PORT_NUM)
							{
								portString = gbeArray[language] + GBE_TWO + portArray[language] + (parseInt(data[i], 10) - ONE_GBE_PORT_NUM);
							}
							else
							{
								portString = gbeArray[language] + GBE_ONE + portArray[language] + parseInt(data[i], 10);
							}
						}
						else
						{
							portString = portArray[language] + parseInt(data[i], 10);
						}
						$("#" + getIdArray[i]).html(portString);
						getPortName(parseInt(data[MAIN_CARD], 10) - 1, data[i], $("#mainPortName"));
					}
					else if (i >= ERROR_CHECK_S && i <= ERROR_CHECK_E)
					{
						if(data[i] == 1)
						{
							$("#" + getIdArray[i]).prop("checked", true);
						}
						else
						{
							$("#" + getIdArray[i]).prop("checked", false);
						}
					}
					else
					{
						$("#" + getIdArray[i]).html(data[i]);
					}						
				}
				displayBackup();
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PROGRAM_BACKUP_MUX + "&cmd=" + SET + "&id=" + id + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;

	for(var i = 0; i < SET_OBJ_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + setIdArray[i]).val();
		}
		else if(i >= ERROR_SET_S && i <= ERROR_SET_E ) 
		{
			if($("#" + setIdArray[i]).prop("checked"))
			{
				data += FIRST_DELIMITER + 1;
			}
			else
			{
				data += FIRST_DELIMITER + 0;
			}
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + setIdArray[i]).val();
		}
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;
	
	returnFlag = ValidateParam($("#mbErrorTime"), "INT_DEC", 0, 255, "<Main Error Delay(s)>", "<主路错误延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#mbRecoverTime"), "INT_DEC", 0, 255, "<Main Revert Delay(s)>", "<主路恢复延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#bmErrorTime"), "INT_DEC", 0, 255, "<Backup Error Delay(s)>", "<备路错误延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#bmRecoverTime"), "INT_DEC", 0, 255, "<Backup Revert Delay(s)>", "<备路恢复延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}	
	returnFlag = ValidateParam($("#ccErrorMax"), "INT_DEC", 0, 1000, "<CC Error Count>", "<CC错误计数>", language);
	if(returnFlag == false)
	{
		return false;
	}	
	returnFlag = ValidateParam($("#ccErrorTime"), "INT_DEC", 0, 1000, "<CC Error Delay(s)>", "<CC错误延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}	
	returnFlag = ValidateParam($("#ccRevertTime"), "INT_DEC", 0, 1000, "<CC Revert Delay(s)>", "<CC恢复延时(s)>", language);
	if(returnFlag == false)
	{
		return false;
	}	
	returnFlag = ValidateParam($("#mainMinRate"), "INT_DEC", 0, 65535, "<Main Bitrate Lower Limit(Kbps)>", "<主路码率下限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#mainMaxRate"), "INT_DEC", 0, 65535, "<Main Bitrate Upper Limit(Kbps)>", "<主路码率上限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#backupServiceId"), "INT_DEC_HEX", 1, 65535, "<Backup Service ID>", "<备路节目号>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#backupMinRate"), "INT_DEC", 0, 65535, "<Backup Bitrate Lower Limit(Kbps)>", "<备路码率下限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#backupMaxRate"), "INT_DEC", 0, 65535, "<Backup Bitrate Upper Limit(Kbps)>", "<备路码率上限(Kbps)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	if(parseInt($("#mainMinRate").val(), 10) >= parseInt($("#mainMaxRate").val(), 10))
	{
		if(language == ENGLISH)
		{
			alert("The main bitrate lower limit should be smaller than the main bitrate upper limit!");
		}
		else
		{
			alert("主路码率下限必须小于主路码率上限！");
		}
		return false
	}
	if(parseInt($("#backupMinRate").val(), 10) >= parseInt($("#backupMaxRate").val(), 10))
	{
		if(language == ENGLISH)
		{
			alert("The backup bitrate lower limit should be smaller than the backup bitrate upper limit!");
		}
		else
		{
			alert("备路码率下限必须小于备路码率上限！");
		}
		return false
	}
	
	return true;
}
