﻿var rowNum;
var identifyData;
var DVB = 0;
var ATSC = 1;
var CUSTOM = 17;
var CUR_PID = 3;
var LOW_PRIORITY = 5;
var COL_NUM = 6;
var NORMAL = 0;
var LOW = 1;

var rowIdArray = ["srcCard", "srcPort", "srcPid", "curPid", "pidType", "lowPriority"];
var dvbIdArray = ["dvbServiceId", "dvbServiceName", "serviceProvider", "charCode", "dvbServiceType", "customType", "runStatus", "encryptStatus", "scheduleFlag", "followFlag"];
var DVB_NUM = 10;
var DVB_SERVICE_NAME = 1;
var DVB_PROVIDER_NAME = 2;
var atscIdArray = ["atscServiceId", "atscServiceName", "majorChannel", "minorChannel", "channelTsid", "atscServiceType", "modulMode", "serviceSource"];
var ATSC_NUM = 8;
var ATSC_SERVICE_NAME = 1;
var pcrIdArray = ["pcrOverrideSwitch", "newPcr"];
var curPid = [];
var id;

window.onresize = function()
{
	$("#mainContent").css("height", function(index, value)
	{
		return ((parent.rightIframeHeight - 30) + "px");
	});
}

$(document).ready(function()
{
	var args = GetArgs();
	id = args["ID"];
	
	$("#mainContent").css("height", function(index, value)
	{
		return ((parent.rightIframeHeight - 30) + "px");
	});
	$("#checkAll").click(function()
	{
		for(var i = 0; i < rowNum; i++)
		{
			$("#lowPriority" + (i + 1)).prop("checked", $(this).prop("checked"));
		}
	});
	$(document).on("click", ".sub_checkbox", function()
	{
		for(var i = 0; i < rowNum; i++)
		{
			if(($("#lowPriority" + (i + 1)).css("display") != "none") && ($("#lowPriority" + (i + 1)).prop("checked") == false))
			{
				$("#checkAll").prop("checked", false);
				return;
			}
		}
		$("#checkAll").prop("checked", true);
	});
	$(document).on("click", "input[type=checkbox]", function()
	{
		EnableButton("applyBtn");
	});
	$("#pcrOverrideSwitch").change(function()
	{
		disablePcrParam();
	});
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var data;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();
	var infoData;
	var pcrData;

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PROGRAM_DETAIL + "&cmd=" + GET + "&id=" + id + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				length = data.length;
				identifyData = parseInt(data[length - 1], 10);
				if(length < 3)
				{
					return;
				}
				rowNum = length - 3;
				DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
				if(rowNum != 0)
				{
					updateTableData(data);
				}
				infoData = data[length - 3].split(SECOND_DELIMITER);
				if(identifyData == DVB)
				{
					$("#dvbInfo").css("display", "");
					$("#atscInfo").css("display", "none");
					for(var i = 0; i < DVB_NUM; i++)
					{
						$("#" + dvbIdArray[i]).val(infoData[i]);
					}
					changeServiceType($("#dvbServiceType"));
				}
				else
				{
					$("#dvbInfo").css("display", "none");
					$("#atscInfo").css("display", "");
					for(var i = 0; i < ATSC_NUM; i++)
					{
						$("#" + atscIdArray[i]).val(infoData[i]);
					}
				}
				pcrData = data[length - 2].split(SECOND_DELIMITER);
				for(var i = 0; i < pcrIdArray.length; i++)
				{
					$("#" + pcrIdArray[i]).val(pcrData[i]);
				}
				disablePcrParam();
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function updateTableData(data)
{
	var rowData;
	var index;
	
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		rowData = data[i].split(SECOND_DELIMITER);
		for(var j = 0; j < COL_NUM; j++)
		{
			if(j == CUR_PID)
			{
				$("#" + rowIdArray[j] + index).val(rowData[j]);
				curPid.push(parseInt(rowData[j]));
			}
			else if(j == LOW_PRIORITY)
			{
				if(rowData[j] == NORMAL)
				{
					$("#" + rowIdArray[j] + index).show();
					$("#" + rowIdArray[j] + index).prop("checked", false);
				}
				else if(rowData[j] == LOW)
				{
					$("#" + rowIdArray[j] + index).show();
					$("#" + rowIdArray[j] + index).prop("checked", true);
				}
				else
				{
					$("#" + rowIdArray[j] + index).hide();					
				}
			}
			else
			{
				$("#" + rowIdArray[j] + index).html(rowData[j]);
			}
		}
	}
	for(var i = 0; i < rowNum; i++)
	{
		if(($("#lowPriority" + (i + 1)).css("display") != "none") && ($("#lowPriority" + (i + 1)).prop("checked") == false))
		{
			$("#checkAll").prop("checked", false);
			return;
		}
	}
	$("#checkAll").prop("checked", true);
}
function disablePcrParam()
{
	var pcrSwitch = $("#pcrOverrideSwitch").val();
	if(pcrSwitch == ON)
	{
		$("#newPcr").attr("disabled", false);
	}
	else
	{
		$("#newPcr").attr("disabled", true);
	}
}

function changeServiceType(obj)
{
	if(parseInt(obj.val(), 10) == CUSTOM)
	{			
		$("#customTypeTr").css("display", "");
	}
	else
	{
		$("#customTypeTr").css("display", "none");
	}
}

function checkPidValue(obj)
{
    var pos = parseInt(obj.attr("id").slice(6), 10) - 1;
	for(var i = 0; i < rowNum; i++)
    {
        if(i == pos)
        {
            continue;
        }
        else
        {
			if(parseInt($("#curPid" + (i + 1)).val()) == curPid[pos])
            {
                $("#curPid" + (i + 1)).val() = obj.val();
            }
        }
    }
}

function changeServiceId()
{
	parent.serviceIdChange = true;
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PROGRAM_DETAIL + "&cmd=" + SET + "&id=" + id + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
				if(parent.serviceIdChange == true)
				{
					if(identifyData == DVB)
					{
						parent.muxServiceId = $("#dvbServiceId").val();
					}
					else if(identifyData == ATSC)
					{
						parent.muxServiceId = $("#atscServiceId").val();
					}
					parent.displayParam();
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	var index;
	var rowData;
	var infoData;
	var pcrData;
	var priority;
	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		if(($("#lowPriority" + index).prop("checked") == false) && ($("#lowPriority" + index).css("display") != "none"))
		{
			priority = 0;
		}
		else if(($("#lowPriority" + index).prop("checked") == true) && ($("#lowPriority" + index).css("display") != "none"))
		{
			priority = 1;
		}
		else
		{
			priority = 2;
		}
		if(i == 0)
		{
			rowData = $("#curPid" + index).val() +  THIRD_DELIMITER + priority;			
		}
		else
		{
			rowData += SECOND_DELIMITER + $("#curPid" + index).val() +  THIRD_DELIMITER + priority;
		}
	}
	if(identifyData == DVB)
	{
		for(var i = 0; i < DVB_NUM; i++)
		{
			if(i == 0)
			{
				infoData = $("#" + dvbIdArray[i]).val();
			}
			else if((i == DVB_SERVICE_NAME) || (i == DVB_PROVIDER_NAME))
			{
				infoData += SECOND_DELIMITER + $("#" + dvbIdArray[i]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
			}
			else
			{
				infoData += SECOND_DELIMITER + $("#" + dvbIdArray[i]).val();
			}
		}
	}
	else
	{
		for(var i = 0; i < ATSC_NUM; i++)
		{
			if(i == 0)
			{
				infoData = $("#" + atscIdArray[i]).val();
			}
			else if(i == ATSC_SERVICE_NAME)
			{
				infoData += SECOND_DELIMITER + $("#" + atscIdArray[i]).val().replace(/\+/g, "%2B").replace(/\&/g, "%26");
			}
			else
			{
				infoData += SECOND_DELIMITER + $("#" + atscIdArray[i]).val();
			}
		}
	}
	for(var i = 0; i < pcrIdArray.length; i++)
	{
		if(i == 0)
		{
			pcrData = $("#" + pcrIdArray[i]).val();
		}
		else
		{
			pcrData += SECOND_DELIMITER + $("#" + pcrIdArray[i]).val();
		}
	}
	data = rowData + FIRST_DELIMITER + infoData + FIRST_DELIMITER + pcrData;
	return data;
}

function paramCheck()
{
 	var returnFlag;
	var char;
	for(var i = 0; i < rowNum; i++)
	{
		if(identifyData == DVB)
		{
			returnFlag = ValidateParam($("#curPid" + (i + 1)), "INT_DEC_HEX", 32, 8191, "<Current PID>", "<当前PID>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
		else
		{
			returnFlag = ValidateParam($("#curPid" + (i + 1)), "INT_DEC_HEX", 0, 8191, "<Current PID>", "<当前PID>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
	}
	if(identifyData == DVB)
	{
		returnFlag = ValidateParam($("#" + dvbIdArray[0]), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + dvbIdArray[1]), "LENGTH", 0, 31, "<Service Name>", "<节目名称>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#" + dvbIdArray[1]), language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + dvbIdArray[2]), "LENGTH", 0, 31, "<Service Provider>", "<节目提供商>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#" + dvbIdArray[2]), language);
		if(returnFlag == false)
		{
			return false;
		}
		if($("#" + dvbIdArray[5]).prop("disabled") == false)
		{
			returnFlag = ValidateParam($("#" + dvbIdArray[5]), "INT_DEC", 17, 255, "<Custom Type>", "<自定义节目类型>", language);
			if(returnFlag == false)
			{
				return false;
			}		
		}
	}
	else
	{
		returnFlag = ValidateParam($("#" + atscIdArray[0]), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + atscIdArray[1]), "LENGTH", 0, 31, "<Service Name>", "<节目名称>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#" + atscIdArray[1]), language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + atscIdArray[2]), "INT_DEC", 1, 99, "<Major Channel>", "<主频道号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + atscIdArray[3]), "INT_DEC", 0, 999, "<Minor Channel>", "<子频道号>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + atscIdArray[4]), "INT_DEC", 0, 65535, "<Channel TSID>", "<频道流ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + atscIdArray[7]), "INT_DEC", 1, 4095, "<Service Source>", "<节目源>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	if($("#pcrOverrideSwitch").val() == ON)
	{
		returnFlag = ValidateParam($("#newPcr"), "INT_DEC_HEX", 32, 8191, "<New PCR>", "<新PCR值>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}
