var objIdArray = ["networkDetection", "maxPacketPerMs", "detectionPeriod", "E2Type", "powerType"];
var SEC_NUM = 5;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_BOTTOM_NO_MENU, BUTTON_CHANGE);
}

$(document).ready(function()
{
	GetMainContentHeight(BUTTON_BOTTOM_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();	
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var curLiNum;
	var initLiNum;
	var data;
	var length;
	var sectionData;
	var sectionLength;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + DEBUG_PAGE + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{				
				data = response.split(FIRST_DELIMITER);
				length = data.length;
				for(var i = 0; i < length; i++)
				{
					sectionData = data[i].split(SECOND_DELIMITER);
					if(i == 0)
					{
						for(var j = 0; j < objIdArray.length; j++)
						{
							$("#" + objIdArray[j]).val(sectionData[j]);
							if(j==4)
							{
								if(1 == language)
								{
									if("0" == sectionData[j])
									{
										$("#" + objIdArray[j]).val("普通电源");
									}
									else if("1" == sectionData[j])
									{
										$("#" + objIdArray[j]).val("3Y 450W电源");
									}
									else if("2" == sectionData[j])
									{
										$("#" + objIdArray[j]).val("稳固得 450W电源");
									}
									else if("3" == sectionData[j])
									{
										$("#" + objIdArray[j]).val("稳固得低功率电源");
									}
									else
									{
										$("#" + objIdArray[j]).val("未知电源");
									}
								}
								else
								{
									if("0" == sectionData[j])
									{
										$("#" + objIdArray[j]).val("Normal");
									}
									else if("1" == sectionData[j])
									{
										$("#" + objIdArray[j]).val("3Y 450W");
									}
									else if("2" == sectionData[j])
									{
										$("#" + objIdArray[j]).val("WGD 450W");
									}
									else if("3" == sectionData[j])
									{
										$("#" + objIdArray[j]).val("WGD 200/300W");
									}
									else
									{
										$("#" + objIdArray[j]).val("Unknown");
									}
								}
								
							}
							$("#businessCode").val(DISPLAY_STRING);
							$("#upgradeCheckCode").val(DISPLAY_STRING);
						}

					}
					else
					{
						sectionLength = sectionData.length;
						$("#versionUlLeft" + i).empty();
						$("#versionUlRight" + i).empty();	
						initLiNum = 1;
						while(initLiNum < Math.ceil((sectionLength - 1)/2)*2)
						{
							$("#versionUlLeft" + i).append("<li id='cardVersion" + i + initLiNum +"'></li>");
							$("#versionUlRight" + i).append("<li id='cardVersion" + i + (initLiNum + 1) +"'></li>");
							initLiNum += 2;
						}
						curLiNum = Math.ceil((sectionLength - 1)/2);
						$("#versionInfo" + i).css("height", (45 + (curLiNum - 1)*25) + "px");
						for(var j = 0; j < sectionLength; j++)
						{
							$("#cardVersion" + i + j).html(sectionData[j]);	
						}						
						$("#bar" + i).css("display", "");
						$("#versionInfo" + i).css("display", "");
					}
				}
				refreshFlag = true;
				ChangeButtonLocation();
			}			
		}
	}
	xmlHttp.send(null);
}
function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	if(paramCheck() == false)
	{
		return;
	}
	data = "type=" + DEBUG_PAGE + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData() + FIRST_DELIMITER + $("#businessCode").val() + FIRST_DELIMITER + $("#upgradeCheckCode").val();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function paramCheck()
{
 	var returnFlag;
	returnFlag = ValidateParam($("#maxPacketPerMs"), "INT_DEC", 3, 30, "<Max Packet Per MS>", "<1ms内检测包数上限>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateParam($("#detectionPeriod"), "INT_DEC", 20, 200, "<Detection Period(ms)>", "<检测周期(ms)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateAuthCode($("#businessCode"), language);
	if(returnFlag == false)
	{
		return false;
	}
	returnFlag = ValidateAuthCode($("#upgradeCheckCode"), language);
	if(returnFlag == false)
	{
		return false;
	}		
	return true;	
}

function generateData()
{
	var data;
	var length;
	
	for(var i = 0; i < objIdArray.length; i++)
	{		
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
		}
		else if(i == 3 || i == 4){
			continue;
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}	
	return data;
}