﻿var ROW_NUM = 6;
var license1ArrayEn = ["Main GbE Card mode: 1+1", "Main GbE card mode: 2+2"];
var license2ArrayEn = ["Backup: no support", "Backup: support"];
var license3ArrayEn = ["Old license mode: no support", "Old license mode: support"];
var license6ArrayEn = ["FEC of Main GbE Card: no support", "FEC of Main GbE Card: support"];
var licenseArrayEn = [license1ArrayEn, license2ArrayEn, license3ArrayEn, "", "", license6ArrayEn];

var license1ArrayCn = ["主千兆卡支持1+1网口", "主千兆卡支持2+2网口"];
var license2ArrayCn = ["不支持备份功能", "支持备份功能"];
var license3ArrayCn = ["不支持子卡非加密授权", "支持子卡非加密授权"];
var license6ArrayCn = ["主千兆卡不支持FEC功能", "主千兆卡支持FEC功能"];
var licenseArrayCn = [license1ArrayCn, license2ArrayCn, license3ArrayCn, "", "", license6ArrayCn];

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
		
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var rowData;
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	var index;

	xmlHttp.open("GET", "/goform/formEMR30?type=" + LICENSE_CONFIG + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					index = i + 1;
					$("#license" + index).val(DISPLAY_STRING);
					if(i == 3)
					{
						$("#licenseStatus" + index).html(data[i]);
					}
					else if(i == 4)
					{
						if(language == ENGLISH)
						{
							$("#licenseStatus" + index).html("Number of main GbE card ports: " + data[i]  + " input/" + data[i] + " output");
						}
						else
						{
							$("#licenseStatus" + index).html("主千兆卡网口下输入输出分别支持" + data[i] + "个端口");
						}
					}
					else
					{
						if(language == ENGLISH)
						{
							$("#licenseStatus" + index).html(licenseArrayEn[i][data[i]]);
						}
						else
						{
							$("#licenseStatus" + index).html(licenseArrayCn[i][data[i]]);
						}
					}					
				}
				refreshFlag = true;	
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + LICENSE_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	var index;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		index = i + 1;
		if(i == 0)
		{
			data = $("#license" + index).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#license" + index).val();
		}
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;
	var index;
	
	for(var i = 0; i < ROW_NUM; i++)
	{
		index = i + 1;
		returnFlag = ValidateAuthCode($("#license" + index), language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}

