﻿var objIdArray = ["ipAddress", "subnetMask", "gateWay", "dhcpSwitch", "mac"];
var ROW_NUM = 4;
var DISABLE = 0;
var ENABLE = 1;
var oldIp = null;
var curIp = null;

window.onresize = function()
{
 	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	GetMainContentHeight(BUTTON_TOP_NO_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
	$("#dhcpSwitch").bind("change", function()
	{
		changeDhcp();
	});
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + NETWORK_CONFIG + "&cmd=" + GET + "&language=" + language 
		+ "&slotNo=" + slotNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
					if(i == 0)
					{
						oldIp = data[i];
					}
				}
				$("#" + objIdArray[ROW_NUM]).html(data[ROW_NUM]);
				changeDhcp();
			    refreshFlag = true;
			}			
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + NETWORK_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(ipCompare(oldIp, curIp) == false)
				{
					if(language == ENGLISH)
					{
						top.location = "http://" + curIp + "/frame_en.asp";
					}
					else
					{
						top.location = "http://" + curIp + "/frame_cn.asp";
					}
				}
				else
				{
					applyFlag = true;
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
			curIp = ipAddressFormat($("#" + objIdArray[i]).val());
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	return data;
}

function ipAddressFormat(ip)
{
	var newIpStr = [];
	var ipStr = ip.split(".");
	for(var i = 0; i < 4; i++)
	{
		newIpStr.push(parseInt(ipStr[i], 10));
	}
	var realIp = newIpStr.join(".");
	return realIp;
}

/*************************************************
Function: 		changeDhcp
Description: 	用于改变页面Ip参数变灰状态的函数
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function changeDhcp()
{
	if(parseInt($("#dhcpSwitch").val(), 10) == DISABLE)
	{
		for(var i = 0; i < 3; i++)
		{
			$("#" + objIdArray[i]).attr("disabled", false);
		}
	}
	else
	{
		for(var i = 0; i < 3; i++)
		{
			$("#" + objIdArray[i]).attr("disabled", true);
		}
	}
}

function paramCheck()
{
 	var returnFlag;
	var dhcpSwitch = parseInt($("#dhcpSwitch").val(), 10);
	if(dhcpSwitch == DISABLE)
	{
		returnFlag = ValidateIP($("#" + objIdArray[0]), "UNICAST_IP_ADDR", "<IP Address>", "<IP地址>", language);
		if(returnFlag == false)
		{
			return false;
		}
		
		returnFlag = ValidateIP($("#" + objIdArray[1]), "SUBNET_MASK", "<Subnet Mask>", "<子网掩码>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateSubnetMaskRelation($("#" + objIdArray[0]).val(), $("#" + objIdArray[1]), "<Subnet Mask>", "<子网掩码>", language);
		if(returnFlag == false)
		{
			return false;
		}
		
		returnFlag = ValidateIP($("#" + objIdArray[2]), "GATEWAY", "<Gateway>", "<网关>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateGatewayRelation($("#" + objIdArray[0]).val(), $("#" + objIdArray[1]).val(), $("#" + objIdArray[2]), "<Gateway>", "<网关>", language);
		if(returnFlag == false)
		{
			return false;
		}			
	}
	return true;	
}

function ipCompare(str1,str2)
{
	var arr1 = str1.split(".");
	var arr2 = str2.split(".");
	if((parseInt(arr1[0],10) == parseInt(arr2[0],10))&&
		(parseInt(arr1[1],10) == parseInt(arr2[1],10))&&
		(parseInt(arr1[2],10) == parseInt(arr2[2],10))&&
		(parseInt(arr1[3],10) == parseInt(arr2[3],10)))
	{
		return true;
	}
	else
	{
		return false;
	}	
}